/*
 * Decompiled with CFR 0.152.
 */
package soot.dexpler.instructions;

import org.jf.dexlib.Code.Instruction;
import org.jf.dexlib.Code.SingleRegisterInstruction;
import soot.Local;
import soot.Type;
import soot.dexpler.DexBody;
import soot.dexpler.IDalvikTyper;
import soot.dexpler.instructions.DexlibAbstractInstruction;
import soot.dexpler.instructions.RetypeableInstruction;
import soot.jimple.IdentityStmt;
import soot.jimple.Jimple;

public class MoveExceptionInstruction
extends DexlibAbstractInstruction
implements RetypeableInstruction {
    private Type realType;
    private IdentityStmt stmtToRetype;

    public MoveExceptionInstruction(Instruction instruction, int codeAdress) {
        super(instruction, codeAdress);
    }

    @Override
    public void jimplify(DexBody body) {
        int dest = ((SingleRegisterInstruction)((Object)this.instruction)).getRegisterA();
        Local l = body.getRegisterLocal(dest);
        this.stmtToRetype = Jimple.v().newIdentityStmt(l, Jimple.v().newCaughtExceptionRef());
        this.setUnit(this.stmtToRetype);
        this.tagWithLineNumber(this.stmtToRetype);
        body.add(this.stmtToRetype);
    }

    @Override
    public void setRealType(DexBody body, Type t) {
        this.realType = t;
        body.addRetype(this);
    }

    @Override
    public void retype() {
        if (this.realType == null) {
            throw new RuntimeException("Real type of this instruction has not been set or was already retyped: " + this);
        }
        Local l = (Local)this.stmtToRetype.getLeftOp();
        l.setType(this.realType);
        this.realType = null;
    }

    @Override
    boolean overridesRegister(int register) {
        SingleRegisterInstruction i = (SingleRegisterInstruction)((Object)this.instruction);
        int dest = i.getRegisterA();
        return register == dest;
    }

    @Override
    public void getConstraint(IDalvikTyper dalvikTyper) {
        dalvikTyper.setObjectType(this.stmtToRetype.getLeftOpBox());
    }
}

