/*
 * Decompiled with CFR 0.152.
 */
package soot.dexpler.instructions;

import java.util.HashSet;
import java.util.Set;
import org.jf.dexlib.Code.Format.Instruction22c;
import org.jf.dexlib.Code.Instruction;
import org.jf.dexlib.Code.InstructionWithReference;
import org.jf.dexlib.Code.TwoRegisterInstruction;
import org.jf.dexlib.TypeIdItem;
import soot.ArrayType;
import soot.Local;
import soot.Type;
import soot.dexpler.Debug;
import soot.dexpler.DexBody;
import soot.dexpler.DexType;
import soot.dexpler.IDalvikTyper;
import soot.dexpler.instructions.DexlibAbstractInstruction;
import soot.jimple.AssignStmt;
import soot.jimple.Jimple;
import soot.jimple.NewArrayExpr;

public class NewArrayInstruction
extends DexlibAbstractInstruction {
    AssignStmt assign = null;

    public NewArrayInstruction(Instruction instruction, int codeAdress) {
        super(instruction, codeAdress);
    }

    @Override
    public void jimplify(DexBody body) {
        if (!(this.instruction instanceof Instruction22c)) {
            throw new IllegalArgumentException("Expected Instruction22c but got: " + this.instruction.getClass());
        }
        Instruction22c newArray = (Instruction22c)this.instruction;
        int dest = newArray.getRegisterA();
        Local size = body.getRegisterLocal(newArray.getRegisterB());
        Type t = DexType.toSoot((TypeIdItem)newArray.getReferencedItem());
        Type arrayType = ((ArrayType)t).getElementType();
        Debug.printDbg("new array element type: " + arrayType);
        NewArrayExpr newArrayExpr = Jimple.v().newNewArrayExpr(arrayType, size);
        Local l = body.getRegisterLocal(dest);
        this.assign = Jimple.v().newAssignStmt(l, newArrayExpr);
        this.setUnit(this.assign);
        this.tagWithLineNumber(this.assign);
        body.add(this.assign);
    }

    @Override
    public void getConstraint(IDalvikTyper dalvikTyper) {
    }

    @Override
    boolean overridesRegister(int register) {
        TwoRegisterInstruction i = (TwoRegisterInstruction)((Object)this.instruction);
        int dest = i.getRegisterA();
        return register == dest;
    }

    @Override
    public Set<DexType> introducedTypes() {
        InstructionWithReference i = (InstructionWithReference)this.instruction;
        HashSet<DexType> types = new HashSet<DexType>();
        types.add(new DexType((TypeIdItem)i.getReferencedItem()));
        return types;
    }
}

