/*
 * Decompiled with CFR 0.152.
 */
package soot.dexpler.instructions;

import java.util.ArrayList;
import org.jf.dexlib.Code.Format.PackedSwitchDataPseudoInstruction;
import org.jf.dexlib.Code.Instruction;
import org.jf.dexlib.Code.OffsetInstruction;
import org.jf.dexlib.Util.ByteArrayAnnotatedOutput;
import soot.IntType;
import soot.Local;
import soot.Unit;
import soot.Value;
import soot.dexpler.DexBody;
import soot.dexpler.IDalvikTyper;
import soot.dexpler.instructions.SwitchInstruction;
import soot.jimple.Jimple;
import soot.jimple.Stmt;
import soot.jimple.TableSwitchStmt;

public class PackedSwitchInstruction
extends SwitchInstruction {
    TableSwitchStmt switchStmt = null;

    public PackedSwitchInstruction(Instruction instruction, int codeAdress) {
        super(instruction, codeAdress);
    }

    @Override
    protected Stmt switchStatement(DexBody body, Instruction targetData, Local key) {
        PackedSwitchDataPseudoInstruction i = (PackedSwitchDataPseudoInstruction)targetData;
        int[] targetAddresses = i.getTargets();
        int lowIndex = i.getFirstKey();
        int highIndex = lowIndex + targetAddresses.length - 1;
        int defaultTargetAddress = this.codeAddress + this.instruction.getSize(this.codeAddress);
        Unit defaultTarget = body.instructionAtAddress(defaultTargetAddress).getUnit();
        ArrayList<Unit> targets = new ArrayList<Unit>();
        for (int address : targetAddresses) {
            targets.add(body.instructionAtAddress(this.codeAddress + address).getUnit());
        }
        this.switchStmt = Jimple.v().newTableSwitchStmt((Value)key, lowIndex, highIndex, targets, defaultTarget);
        this.setUnit(this.switchStmt);
        return this.switchStmt;
    }

    @Override
    public void computeDataOffsets(DexBody body) {
        int offset = ((OffsetInstruction)((Object)this.instruction)).getTargetAddressOffset();
        int targetAddress = this.codeAddress + offset;
        Instruction targetData = body.instructionAtAddress((int)targetAddress).instruction;
        PackedSwitchDataPseudoInstruction psInst = (PackedSwitchDataPseudoInstruction)targetData;
        int[] targetAddresses = psInst.getTargets();
        int size = targetAddresses.length * 2;
        this.setDataFirstByte(targetAddress + 1);
        this.setDataLastByte(targetAddress + 1 + size - 1);
        this.setDataSize(size);
        ByteArrayAnnotatedOutput out = new ByteArrayAnnotatedOutput();
        psInst.write(out, targetAddress);
        byte[] outa = out.getArray();
        byte[] data = new byte[outa.length - 2];
        for (int i = 2; i < outa.length; ++i) {
            data[i - 2] = outa[i];
        }
        this.setData(data);
    }

    @Override
    public void getConstraint(IDalvikTyper dalvikTyper) {
        dalvikTyper.setType(this.switchStmt.getKeyBox(), IntType.v());
    }
}

