/*
 * Decompiled with CFR 0.152.
 */
package soot.dexpler.instructions;

import org.jf.dexlib.Code.Format.Instruction12x;
import org.jf.dexlib.Code.Instruction;
import org.jf.dexlib.Code.TwoRegisterInstruction;
import soot.Local;
import soot.Value;
import soot.dexpler.DexBody;
import soot.dexpler.IDalvikTyper;
import soot.dexpler.instructions.DexlibAbstractInstruction;
import soot.jimple.AssignStmt;
import soot.jimple.IntConstant;
import soot.jimple.Jimple;
import soot.jimple.LongConstant;

public class UnopInstruction
extends DexlibAbstractInstruction {
    AssignStmt assign = null;

    public UnopInstruction(Instruction instruction, int codeAdress) {
        super(instruction, codeAdress);
    }

    @Override
    public void jimplify(DexBody body) {
        if (!(this.instruction instanceof Instruction12x)) {
            throw new IllegalArgumentException("Expected Instruction12x but got: " + this.instruction.getClass());
        }
        Instruction12x cmpInstr = (Instruction12x)this.instruction;
        int dest = cmpInstr.getRegisterA();
        Local source = body.getRegisterLocal(cmpInstr.getRegisterB());
        Value expr = this.getExpression(source);
        this.assign = Jimple.v().newAssignStmt(body.getRegisterLocal(dest), expr);
        this.setUnit(this.assign);
        this.tagWithLineNumber(this.assign);
        body.add(this.assign);
    }

    @Override
    public void getConstraint(IDalvikTyper dalvikTyper) {
    }

    private Value getExpression(Local source) {
        switch (this.instruction.opcode) {
            case NEG_INT: 
            case NEG_LONG: 
            case NEG_FLOAT: 
            case NEG_DOUBLE: {
                return Jimple.v().newNegExpr(source);
            }
            case NOT_LONG: {
                return this.getNotLongExpr(source);
            }
            case NOT_INT: {
                return this.getNotIntExpr(source);
            }
        }
        throw new RuntimeException("Invalid Opcode: " + (Object)((Object)this.instruction.opcode));
    }

    private Value getNotIntExpr(Local source) {
        return Jimple.v().newXorExpr(source, IntConstant.v(-1));
    }

    private Value getNotLongExpr(Local source) {
        return Jimple.v().newXorExpr(source, LongConstant.v(-1L));
    }

    @Override
    boolean overridesRegister(int register) {
        TwoRegisterInstruction i = (TwoRegisterInstruction)((Object)this.instruction);
        int dest = i.getRegisterA();
        return register == dest;
    }

    @Override
    boolean isUsedAsFloatingPoint(DexBody body, int register) {
        int source = ((TwoRegisterInstruction)((Object)this.instruction)).getRegisterB();
        switch (this.instruction.opcode) {
            case NEG_FLOAT: 
            case NEG_DOUBLE: {
                return source == register;
            }
        }
        return false;
    }
}

