/*
 * Decompiled with CFR 0.152.
 */
package soot.grimp.internal;

import java.util.ArrayList;
import java.util.List;
import soot.RefType;
import soot.SootMethodRef;
import soot.Type;
import soot.UnitPrinter;
import soot.Value;
import soot.ValueBox;
import soot.grimp.Grimp;
import soot.grimp.GrimpValueSwitch;
import soot.grimp.NewInvokeExpr;
import soot.grimp.Precedence;
import soot.grimp.internal.ExprBox;
import soot.jimple.internal.AbstractInvokeExpr;
import soot.util.Switch;

public class GNewInvokeExpr
extends AbstractInvokeExpr
implements NewInvokeExpr,
Precedence {
    RefType type;

    public GNewInvokeExpr(RefType type, SootMethodRef methodRef, List args) {
        if (methodRef.isStatic()) {
            throw new RuntimeException("wrong static-ness");
        }
        this.methodRef = methodRef;
        this.argBoxes = new ExprBox[args.size()];
        this.type = type;
        for (int i = 0; i < args.size(); ++i) {
            this.argBoxes[i] = Grimp.v().newExprBox((Value)args.get(i));
        }
    }

    @Override
    public RefType getBaseType() {
        return this.type;
    }

    @Override
    public void setBaseType(RefType type) {
        this.type = type;
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public int getPrecedence() {
        return 850;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("new " + this.type.toString() + "(");
        for (int i = 0; i < this.argBoxes.length; ++i) {
            if (i != 0) {
                buffer.append(", ");
            }
            buffer.append(this.argBoxes[i].getValue().toString());
        }
        buffer.append(")");
        return buffer.toString();
    }

    @Override
    public void toString(UnitPrinter up) {
        up.literal("new");
        up.literal(" ");
        up.type(this.type);
        up.literal("(");
        for (int i = 0; i < this.argBoxes.length; ++i) {
            if (i != 0) {
                up.literal(", ");
            }
            this.argBoxes[i].toString(up);
        }
        up.literal(")");
    }

    @Override
    public List getUseBoxes() {
        ArrayList<ValueBox> list = new ArrayList<ValueBox>();
        for (ValueBox element : this.argBoxes) {
            list.addAll(element.getValue().getUseBoxes());
            list.add(element);
        }
        return list;
    }

    @Override
    public void apply(Switch sw) {
        ((GrimpValueSwitch)sw).caseNewInvokeExpr(this);
    }

    @Override
    public Object clone() {
        ArrayList<Value> clonedArgs = new ArrayList<Value>(this.getArgCount());
        for (int i = 0; i < this.getArgCount(); ++i) {
            clonedArgs.add(i, Grimp.cloneIfNecessary(this.getArg(i)));
        }
        return new GNewInvokeExpr(this.getBaseType(), this.methodRef, clonedArgs);
    }

    @Override
    public boolean equivTo(Object o) {
        if (o instanceof GNewInvokeExpr) {
            GNewInvokeExpr ie = (GNewInvokeExpr)o;
            if (!this.getMethod().equals(ie.getMethod()) || this.argBoxes.length != ie.argBoxes.length) {
                return false;
            }
            for (ValueBox element : this.argBoxes) {
                if (element.getValue().equivTo(element.getValue())) continue;
                return false;
            }
            return this.type.equals(ie.type);
        }
        return false;
    }

    @Override
    public int equivHashCode() {
        return this.getMethod().equivHashCode();
    }
}

