/*
 * Decompiled with CFR 0.152.
 */
package soot.jbco;

import java.util.Map;
import soot.Body;
import soot.BodyTransformer;
import soot.Main;
import soot.PackManager;
import soot.PatchingChain;
import soot.Transform;
import soot.Unit;
import soot.tagkit.LineNumberTag;

public class LineNumberGenerator {
    BafLineNumberer bln = new BafLineNumberer();

    public static void main(String[] argv) {
        PackManager.v().getPack("jtp").add(new Transform("jtp.lnprinter", new LineNumberGenerator().bln));
        PackManager.v().getPack("bb").add(new Transform("bb.lnprinter", new LineNumberGenerator().bln));
        Main.main(argv);
    }

    class BafLineNumberer
    extends BodyTransformer {
        BafLineNumberer() {
        }

        @Override
        protected void internalTransform(Body b, String phaseName, Map options) {
            System.out.println("Printing Line Numbers for: " + b.getMethod().getSignature());
            PatchingChain<Unit> units = b.getUnits();
            for (Unit u : units) {
                if (u.hasTag("LineNumberTag")) {
                    LineNumberTag tag = (LineNumberTag)u.getTag("LineNumberTag");
                    System.out.println(u + " has Line Number: " + tag.getLineNumber());
                    continue;
                }
                System.out.println(u + " has no Line Number");
            }
            System.out.println("\n");
        }
    }
}

