/*
 * Decompiled with CFR 0.152.
 */
package soot.jbco.bafTransformations;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import soot.Body;
import soot.BodyTransformer;
import soot.PatchingChain;
import soot.RefType;
import soot.Trap;
import soot.Unit;
import soot.baf.Baf;
import soot.baf.GotoInst;
import soot.baf.JSRInst;
import soot.baf.LookupSwitchInst;
import soot.baf.PopInst;
import soot.baf.TableSwitchInst;
import soot.baf.TargetArgInst;
import soot.jbco.IJbcoTransform;
import soot.jbco.Main;
import soot.jbco.bafTransformations.StackTypeHeightCalculator;
import soot.jbco.util.BodyBuilder;
import soot.jbco.util.Rand;

public class AddJSRs
extends BodyTransformer
implements IJbcoTransform {
    int jsrcount = 0;
    public static String[] dependancies = new String[]{"jtp.jbco_jl", "bb.jbco_cb2ji", "bb.jbco_ful", "bb.lp"};
    public static String name = "bb.jbco_cb2ji";

    @Override
    public String[] getDependancies() {
        return dependancies;
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public void outputSummary() {
        out.println("If/Gotos replaced with JSRs: " + this.jsrcount);
    }

    @Override
    protected void internalTransform(Body b, String phaseName, Map options) {
        Unit unit;
        int weight = Main.getWeight(phaseName, b.getMethod().getSignature());
        if (weight == 0) {
            return;
        }
        boolean fallsthrough = false;
        HashMap<Trap, Unit> trapsToHandler = new HashMap<Trap, Unit>();
        for (Trap t : b.getTraps()) {
            trapsToHandler.put(t, t.getHandlerUnit());
        }
        ArrayList<Unit> targets = new ArrayList<Unit>();
        ArrayList<Unit> seenUts = new ArrayList<Unit>();
        HashMap switches = new HashMap();
        HashMap<Unit, Unit> switchDefs = new HashMap<Unit, Unit>();
        HashMap<TargetArgInst, Unit> ignoreJumps = new HashMap<TargetArgInst, Unit>();
        PatchingChain<Unit> u = b.getUnits();
        Iterator<Object> it = u.snapshotIterator();
        while (it.hasNext()) {
            ArrayList targs;
            Unit unit2 = (Unit)it.next();
            if (unit2 instanceof TargetArgInst) {
                TargetArgInst ti = (TargetArgInst)unit2;
                Unit tu = ti.getTarget();
                if (Rand.getInt(10) > weight) {
                    ignoreJumps.put(ti, tu);
                } else if (!targets.contains(tu)) {
                    targets.add(tu);
                }
            }
            if (unit2 instanceof TableSwitchInst) {
                targs = new ArrayList();
                TableSwitchInst ts = (TableSwitchInst)unit2;
                targs.addAll(ts.getTargets());
                switches.put(unit2, targs);
                switchDefs.put(unit2, ts.getDefaultTarget());
            } else if (unit2 instanceof LookupSwitchInst) {
                targs = new ArrayList();
                LookupSwitchInst ls = (LookupSwitchInst)unit2;
                targs.addAll(ls.getTargets());
                switches.put(unit2, targs);
                switchDefs.put(unit2, ls.getDefaultTarget());
            }
            seenUts.add(unit2);
        }
        it = u.snapshotIterator();
        ArrayList<Unit> processedLabels = new ArrayList<Unit>();
        HashMap<Unit, JSRInst> builtJsrs = new HashMap<Unit, JSRInst>();
        HashMap<PopInst, Unit> popsBuilt = new HashMap<PopInst, Unit>();
        Unit prev = null;
        while (it.hasNext()) {
            unit = (Unit)it.next();
            if (targets.contains(unit)) {
                if (fallsthrough) {
                    JSRInst ji = Baf.v().newJSRInst(unit);
                    builtJsrs.put(unit, ji);
                    u.insertAfter(ji, prev);
                    ++this.jsrcount;
                }
                PopInst pop = Baf.v().newPopInst(RefType.v());
                u.insertBefore(pop, unit);
                processedLabels.add(unit);
                popsBuilt.put(pop, unit);
            }
            fallsthrough = unit.fallsThrough();
            prev = unit;
        }
        it = u.snapshotIterator();
        while (it.hasNext()) {
            unit = (Unit)it.next();
            if (builtJsrs.containsValue(unit) || !(unit instanceof TargetArgInst) || ignoreJumps.containsKey(unit)) continue;
            TargetArgInst ti = (TargetArgInst)unit;
            Unit tu = ti.getTarget();
            if (!popsBuilt.containsKey(tu)) {
                throw new RuntimeException("It appears a target was found that was not updated with a POP.\n\"This makes no sense,\" said the bug as it flew through the code.");
            }
            JSRInst ji = (JSRInst)builtJsrs.get(popsBuilt.get(tu));
            if (BodyBuilder.isBafIf(unit)) {
                if (Rand.getInt(10) > weight) {
                    ti.setTarget((Unit)popsBuilt.get(tu));
                    continue;
                }
                if (ji != null) {
                    ti.setTarget(ji);
                    continue;
                }
                ji = Baf.v().newJSRInst(tu);
                u.insertAfter(ji, u.getPredOf(tu));
                ti.setTarget(ji);
                builtJsrs.put((Unit)popsBuilt.get(tu), ji);
                ++this.jsrcount;
                continue;
            }
            if (!(unit instanceof GotoInst)) continue;
            if (ji != null) {
                if (Rand.getInt(10) < weight) {
                    ((GotoInst)unit).setTarget(ji);
                    continue;
                }
                ((GotoInst)unit).setTarget((Unit)popsBuilt.get(tu));
                continue;
            }
            ((GotoInst)unit).setTarget((Unit)popsBuilt.get(tu));
        }
        for (Trap t : trapsToHandler.keySet()) {
            t.setHandlerUnit((Unit)trapsToHandler.get(t));
        }
        for (TargetArgInst ti : ignoreJumps.keySet()) {
            if (!popsBuilt.containsKey(ti.getTarget())) continue;
            ti.setTarget((Unit)popsBuilt.get(ti.getTarget()));
        }
        targets.clear();
        it = u.snapshotIterator();
        while (it.hasNext()) {
            Unit targ;
            unit = (Unit)it.next();
            if (!(unit instanceof TargetArgInst) || targets.contains(targ = ((TargetArgInst)unit).getTarget())) continue;
            targets.add(targ);
        }
        for (Unit pop : popsBuilt.keySet()) {
            if (targets.contains(pop)) continue;
            u.remove(pop);
        }
        for (Unit sw : switches.keySet()) {
            List targs = (List)switches.get(sw);
            for (int i = 0; i < targs.size(); ++i) {
                Unit unit3;
                Unit ji;
                if (Rand.getInt(10) > weight || (ji = (Unit)builtJsrs.get(unit3 = (Unit)targs.get(i))) == null) continue;
                targs.set(i, ji);
            }
            Unit def = (Unit)switchDefs.get(sw);
            if (Rand.getInt(10) < weight && builtJsrs.get(def) != null) {
                def = (Unit)builtJsrs.get(def);
            }
            if (sw instanceof TableSwitchInst) {
                ((TableSwitchInst)sw).setTargets(targs);
                ((TableSwitchInst)sw).setDefaultTarget(def);
                continue;
            }
            if (!(sw instanceof LookupSwitchInst)) continue;
            ((LookupSwitchInst)sw).setTargets(targs);
            ((LookupSwitchInst)sw).setDefaultTarget(def);
        }
        if (debug) {
            StackTypeHeightCalculator.calculateStackHeights(b);
        }
    }
}

