/*
 * Decompiled with CFR 0.152.
 */
package soot.jbco.bafTransformations;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import soot.Body;
import soot.BodyTransformer;
import soot.DoubleType;
import soot.IntType;
import soot.Local;
import soot.LongType;
import soot.PatchingChain;
import soot.RefType;
import soot.Type;
import soot.Unit;
import soot.baf.Baf;
import soot.baf.DupInst;
import soot.baf.IfNonNullInst;
import soot.baf.IfNullInst;
import soot.baf.OpTypeArgInst;
import soot.baf.TargetArgInst;
import soot.baf.internal.BLoadInst;
import soot.jbco.IJbcoTransform;
import soot.jbco.Main;
import soot.jbco.bafTransformations.StackTypeHeightCalculator;
import soot.jbco.util.Rand;
import soot.toolkits.graph.BriefUnitGraph;

public class MoveLoadsAboveIfs
extends BodyTransformer
implements IJbcoTransform {
    int movedloads = 0;
    public static String[] dependancies = new String[]{"bb.jbco_rlaii", "bb.jbco_ful", "bb.lp"};
    public static String name = "bb.jbco_rlaii";

    @Override
    public String[] getDependancies() {
        return dependancies;
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public void outputSummary() {
        out.println("Moved Loads Above Ifs: " + this.movedloads);
    }

    @Override
    protected void internalTransform(Body b, String phaseName, Map options) {
        int weight = Main.getWeight(phaseName, b.getMethod().getSignature());
        if (weight == 0) {
            return;
        }
        BriefUnitGraph bug = new BriefUnitGraph(b);
        ArrayList<Unit> candidates = new ArrayList<Unit>();
        ArrayList<Unit> visited = new ArrayList<Unit>();
        ArrayList<Unit> worklist = new ArrayList<Unit>();
        worklist.addAll(bug.getHeads());
        while (worklist.size() > 0) {
            Unit u = (Unit)worklist.remove(0);
            if (visited.contains(u)) continue;
            visited.add(u);
            List<Unit> succs = bug.getSuccsOf(u);
            if (u instanceof TargetArgInst && this.checkCandidate(succs, bug)) {
                candidates.add(u);
            }
            for (int i = 0; i < succs.size(); ++i) {
                Unit o = succs.get(i);
                if (visited.contains(o)) continue;
                worklist.add(o);
            }
        }
        int orig = this.movedloads;
        boolean changed = false;
        PatchingChain<Unit> units = b.getUnits();
        for (int i = 0; i < candidates.size(); ++i) {
            Unit u = (Unit)candidates.get(i);
            List<Unit> succs = bug.getSuccsOf(u);
            BLoadInst clone = (BLoadInst)((BLoadInst)succs.get(0)).clone();
            if (u instanceof IfNonNullInst || u instanceof IfNullInst) {
                if (this.category(clone.getOpType()) == 2 || Rand.getInt(10) > weight) continue;
                units.insertBefore(clone, u);
                units.insertBefore(Baf.v().newSwapInst(RefType.v(), clone.getOpType()), u);
            } else if (u instanceof OpTypeArgInst) {
                Type t = ((OpTypeArgInst)u).getOpType();
                if (this.category(t) == 2 || Rand.getInt(10) > weight) continue;
                units.insertBefore(clone, u);
                Type t2 = clone.getOpType();
                DupInst dup = this.category(t2) == 2 ? Baf.v().newDup2_x2Inst(t2, null, t, t) : Baf.v().newDup1_x2Inst(t2, t, t);
                units.insertBefore(dup, u);
                units.insertBefore(Baf.v().newPopInst(t2), u);
            } else {
                if (this.category(clone.getOpType()) == 2 || Rand.getInt(10) > weight) continue;
                units.insertBefore(clone, u);
                units.insertBefore(Baf.v().newSwapInst(IntType.v(), clone.getOpType()), u);
            }
            ++this.movedloads;
            for (int j = 0; j < succs.size(); ++j) {
                Unit suc = succs.get(j);
                List<Unit> sucPreds = bug.getPredsOf(suc);
                if (sucPreds.size() > 1) {
                    if (suc == ((TargetArgInst)u).getTarget()) {
                        ((TargetArgInst)u).setTarget(bug.getSuccsOf(suc).get(0));
                        continue;
                    }
                    units.insertAfter(Baf.v().newGotoInst(bug.getSuccsOf(suc).get(0)), u);
                    continue;
                }
                units.remove(suc);
            }
            if (i < candidates.size() - 1) {
                bug = new BriefUnitGraph(b);
            }
            changed = true;
        }
        if (changed) {
            if (output) {
                out.println(this.movedloads - orig + " loads moved above ifs in " + b.getMethod().getSignature());
            }
            if (debug) {
                StackTypeHeightCalculator.calculateStackHeights(b);
            }
        }
    }

    private boolean checkCandidate(List succs, BriefUnitGraph bug) {
        if (succs.size() < 2) {
            return false;
        }
        Object o = succs.get(0);
        for (int i = 1; i < succs.size(); ++i) {
            if (succs.get(i).getClass() == o.getClass()) continue;
            return false;
        }
        if (o instanceof BLoadInst) {
            BLoadInst bl = (BLoadInst)o;
            Local l = bl.getLocal();
            for (int i = 1; i < succs.size(); ++i) {
                BLoadInst bld = (BLoadInst)succs.get(i);
                if (bld.getLocal() == l && bug.getPredsOf(bld).size() <= 1) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private int category(Type t) {
        return t instanceof LongType || t instanceof DoubleType ? 2 : 1;
    }
}

