/*
 * Decompiled with CFR 0.152.
 */
package soot.jbco.bafTransformations;

import java.util.Iterator;
import java.util.Map;
import soot.Body;
import soot.BodyTransformer;
import soot.PatchingChain;
import soot.SootField;
import soot.Unit;
import soot.baf.Baf;
import soot.baf.PushInst;
import soot.baf.StaticGetInst;
import soot.jbco.IJbcoTransform;
import soot.jbco.Main;
import soot.jbco.jimpleTransformations.CollectConstants;
import soot.jbco.util.BodyBuilder;
import soot.jbco.util.Rand;

public class UpdateConstantsToFields
extends BodyTransformer
implements IJbcoTransform {
    public static String[] dependancies = new String[]{"wjtp.jbco_cc", "bb.jbco_ecvf", "bb.jbco_ful", "bb.lp"};
    public static String name = "bb.jbco_ecvf";
    static int updated = 0;

    @Override
    public String[] getDependancies() {
        return dependancies;
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public void outputSummary() {
        out.println("Updated constant references: " + updated);
    }

    @Override
    protected void internalTransform(Body b, String phaseName, Map options) {
        if (b.getMethod().getName().indexOf("<clinit>") >= 0) {
            return;
        }
        int weight = Main.getWeight(phaseName, b.getMethod().getSignature());
        if (weight == 0) {
            return;
        }
        PatchingChain<Unit> units = b.getUnits();
        Iterator<Unit> iter = units.snapshotIterator();
        while (iter.hasNext()) {
            SootField f;
            Unit u = iter.next();
            if (!(u instanceof PushInst) || (f = CollectConstants.constantsToFields.get(((PushInst)u).getConstant())) == null || Rand.getInt(10) > weight) continue;
            StaticGetInst get = Baf.v().newStaticGetInst(f.makeRef());
            units.insertBefore(get, u);
            BodyBuilder.updateTraps(get, u, b.getTraps());
            units.remove(u);
            ++updated;
        }
    }
}

