/*
 * Decompiled with CFR 0.152.
 */
package soot.jbco.jimpleTransformations;

import java.util.Iterator;
import soot.Local;
import soot.Unit;
import soot.Value;
import soot.ValueBox;
import soot.jimple.DefinitionStmt;
import soot.jimple.NewExpr;
import soot.toolkits.graph.DirectedGraph;
import soot.toolkits.scalar.ArraySparseSet;
import soot.toolkits.scalar.BackwardFlowAnalysis;
import soot.toolkits.scalar.FlowSet;

public class New2InitFlowAnalysis
extends BackwardFlowAnalysis {
    FlowSet emptySet = new ArraySparseSet();

    public New2InitFlowAnalysis(DirectedGraph graph) {
        super(graph);
        this.doAnalysis();
    }

    @Override
    protected void flowThrough(Object in, Object d, Object out) {
        FlowSet inf = (FlowSet)in;
        FlowSet outf = (FlowSet)out;
        inf.copy(outf);
        if (d instanceof DefinitionStmt) {
            Value v;
            DefinitionStmt ds = (DefinitionStmt)d;
            if (ds.getRightOp() instanceof NewExpr && (v = ds.getLeftOp()) instanceof Local && inf.contains(v)) {
                outf.remove(v);
            }
        } else {
            Iterator<ValueBox> it = ((Unit)d).getUseBoxes().iterator();
            while (it.hasNext()) {
                Value v = it.next().getValue();
                if (!(v instanceof Local)) continue;
                outf.add(v);
            }
        }
    }

    @Override
    protected Object newInitialFlow() {
        return this.emptySet.clone();
    }

    @Override
    protected Object entryInitialFlow() {
        return this.emptySet.clone();
    }

    @Override
    protected void merge(Object in1, Object in2, Object out) {
        FlowSet inSet1 = (FlowSet)in1;
        FlowSet inSet2 = (FlowSet)in2;
        FlowSet outSet = (FlowSet)out;
        inSet1.union(inSet2, outSet);
    }

    @Override
    protected void copy(Object source, Object dest) {
        FlowSet sourceSet = (FlowSet)source;
        FlowSet destSet = (FlowSet)dest;
        sourceSet.copy(destSet);
    }
}

