/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import soot.Unit;
import soot.UnitBox;
import soot.UnitPrinter;
import soot.Value;
import soot.ValueBox;
import soot.baf.Baf;
import soot.baf.LookupSwitchInst;
import soot.baf.PlaceholderInst;
import soot.jimple.Constant;
import soot.jimple.ConvertToBaf;
import soot.jimple.IntConstant;
import soot.jimple.Jimple;
import soot.jimple.JimpleToBafContext;
import soot.jimple.LookupSwitchStmt;
import soot.jimple.Stmt;
import soot.jimple.StmtSwitch;
import soot.jimple.internal.AbstractStmt;
import soot.tagkit.Tag;
import soot.util.Switch;

public class JLookupSwitchStmt
extends AbstractStmt
implements LookupSwitchStmt {
    UnitBox defaultTargetBox;
    ValueBox keyBox;
    List lookupValues;
    protected UnitBox[] targetBoxes;
    List stmtBoxes;

    private static UnitBox[] getTargetBoxesArray(List targets) {
        UnitBox[] targetBoxes = new UnitBox[targets.size()];
        for (int i = 0; i < targetBoxes.length; ++i) {
            targetBoxes[i] = Jimple.v().newStmtBox((Stmt)targets.get(i));
        }
        return targetBoxes;
    }

    private static UnitBox[] unitBoxListToArray(List<Object> targets) {
        UnitBox[] targetBoxes = new UnitBox[targets.size()];
        for (int i = 0; i < targetBoxes.length; ++i) {
            targetBoxes[i] = (UnitBox)targets.get(i);
        }
        return targetBoxes;
    }

    public JLookupSwitchStmt(Value key, List lookupValues, List targets, Unit defaultTarget) {
        this(Jimple.v().newImmediateBox(key), lookupValues, JLookupSwitchStmt.getTargetBoxesArray(targets), Jimple.v().newStmtBox(defaultTarget));
    }

    public JLookupSwitchStmt(Value key, List<Object> lookupValues, List<Object> targets, UnitBox defaultTarget) {
        this(Jimple.v().newImmediateBox(key), lookupValues, JLookupSwitchStmt.unitBoxListToArray(targets), defaultTarget);
    }

    @Override
    public Object clone() {
        int lookupValueCount = this.lookupValues.size();
        ArrayList<IntConstant> clonedLookupValues = new ArrayList<IntConstant>(lookupValueCount);
        for (int i = 0; i < lookupValueCount; ++i) {
            clonedLookupValues.add(i, IntConstant.v(this.getLookupValue(i)));
        }
        return new JLookupSwitchStmt(this.getKey(), clonedLookupValues, this.getTargets(), this.getDefaultTarget());
    }

    protected JLookupSwitchStmt(ValueBox keyBox, List lookupValues, UnitBox[] targetBoxes, UnitBox defaultTargetBox) {
        this.keyBox = keyBox;
        this.defaultTargetBox = defaultTargetBox;
        this.targetBoxes = targetBoxes;
        this.lookupValues = new ArrayList();
        this.lookupValues.addAll(lookupValues);
        this.stmtBoxes = new ArrayList();
        for (UnitBox element : targetBoxes) {
            this.stmtBoxes.add(element);
        }
        this.stmtBoxes.add(defaultTargetBox);
        this.stmtBoxes = Collections.unmodifiableList(this.stmtBoxes);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        String endOfLine = " ";
        buffer.append("lookupswitch(" + this.keyBox.getValue().toString() + ")" + endOfLine);
        buffer.append("{" + endOfLine);
        for (int i = 0; i < this.lookupValues.size(); ++i) {
            buffer.append("    case " + this.lookupValues.get(i) + ": " + "goto" + " " + this.getTarget(i) + ";" + endOfLine);
        }
        buffer.append("    default: goto " + this.getDefaultTarget() + ";" + endOfLine);
        buffer.append("}");
        return buffer.toString();
    }

    @Override
    public void toString(UnitPrinter up) {
        up.literal("lookupswitch");
        up.literal("(");
        this.keyBox.toString(up);
        up.literal(")");
        up.newline();
        up.literal("{");
        up.newline();
        for (int i = 0; i < this.lookupValues.size(); ++i) {
            up.literal("    ");
            up.literal("case");
            up.literal(" ");
            up.constant((Constant)this.lookupValues.get(i));
            up.literal(": ");
            up.literal("goto");
            up.literal(" ");
            this.targetBoxes[i].toString(up);
            up.literal(";");
            up.newline();
        }
        up.literal("    ");
        up.literal("default");
        up.literal(": ");
        up.literal("goto");
        up.literal(" ");
        this.defaultTargetBox.toString(up);
        up.literal(";");
        up.newline();
        up.literal("}");
    }

    @Override
    public Unit getDefaultTarget() {
        return this.defaultTargetBox.getUnit();
    }

    @Override
    public void setDefaultTarget(Unit defaultTarget) {
        this.defaultTargetBox.setUnit(defaultTarget);
    }

    @Override
    public UnitBox getDefaultTargetBox() {
        return this.defaultTargetBox;
    }

    @Override
    public Value getKey() {
        return this.keyBox.getValue();
    }

    @Override
    public void setKey(Value key) {
        this.keyBox.setValue(key);
    }

    @Override
    public ValueBox getKeyBox() {
        return this.keyBox;
    }

    @Override
    public void setLookupValues(List lookupValues) {
        this.lookupValues = new ArrayList();
        this.lookupValues.addAll(lookupValues);
    }

    @Override
    public void setLookupValue(int index, int value) {
        this.lookupValues.set(index, IntConstant.v(value));
    }

    @Override
    public int getLookupValue(int index) {
        return ((IntConstant)this.lookupValues.get((int)index)).value;
    }

    @Override
    public List getLookupValues() {
        return Collections.unmodifiableList(this.lookupValues);
    }

    @Override
    public int getTargetCount() {
        return this.targetBoxes.length;
    }

    @Override
    public Unit getTarget(int index) {
        return this.targetBoxes[index].getUnit();
    }

    @Override
    public UnitBox getTargetBox(int index) {
        return this.targetBoxes[index];
    }

    @Override
    public void setTarget(int index, Unit target) {
        this.targetBoxes[index].setUnit(target);
    }

    @Override
    public List getTargets() {
        ArrayList<Unit> targets = new ArrayList<Unit>();
        for (UnitBox element : this.targetBoxes) {
            targets.add(element.getUnit());
        }
        return targets;
    }

    @Override
    public void setTargets(Unit[] targets) {
        for (int i = 0; i < targets.length; ++i) {
            this.targetBoxes[i].setUnit(targets[i]);
        }
    }

    @Override
    public List getUseBoxes() {
        ArrayList<ValueBox> list = new ArrayList<ValueBox>();
        list.addAll(this.keyBox.getValue().getUseBoxes());
        list.add(this.keyBox);
        return list;
    }

    @Override
    public List getUnitBoxes() {
        return this.stmtBoxes;
    }

    @Override
    public void apply(Switch sw) {
        ((StmtSwitch)sw).caseLookupSwitchStmt(this);
    }

    @Override
    public void convertToBaf(JimpleToBafContext context, List<Unit> out) {
        ArrayList<PlaceholderInst> targetPlaceholders = new ArrayList<PlaceholderInst>();
        ((ConvertToBaf)((Object)this.getKey())).convertToBaf(context, out);
        for (int i = 0; i < this.targetBoxes.length; ++i) {
            targetPlaceholders.add(Baf.v().newPlaceholderInst(this.getTarget(i)));
        }
        LookupSwitchInst u = Baf.v().newLookupSwitchInst(Baf.v().newPlaceholderInst(this.getDefaultTarget()), this.getLookupValues(), targetPlaceholders);
        out.add(u);
        JLookupSwitchStmt currentUnit = this;
        Iterator<Tag> it = currentUnit.getTags().iterator();
        while (it.hasNext()) {
            u.addTag(it.next());
        }
    }

    @Override
    public boolean fallsThrough() {
        return false;
    }

    @Override
    public boolean branches() {
        return true;
    }
}

