/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.spark.fieldrw;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import soot.Body;
import soot.BodyTransformer;
import soot.G;
import soot.MethodOrMethodContext;
import soot.PhaseOptions;
import soot.Scene;
import soot.Singletons;
import soot.SootMethod;
import soot.Value;
import soot.jimple.AssignStmt;
import soot.jimple.FieldRef;
import soot.jimple.Stmt;
import soot.jimple.spark.fieldrw.FieldReadTag;
import soot.jimple.spark.fieldrw.FieldWriteTag;
import soot.jimple.toolkits.callgraph.CallGraph;
import soot.jimple.toolkits.callgraph.TransitiveTargets;
import soot.util.HashMultiMap;

public class FieldTagger
extends BodyTransformer {
    private final HashSet<SootMethod> processedMethods = new HashSet();
    private final HashMultiMap methodToWrite = new HashMultiMap();
    private final HashMultiMap methodToRead = new HashMultiMap();

    public FieldTagger(Singletons.Global g) {
    }

    public static FieldTagger v() {
        return G.v().soot_jimple_spark_fieldrw_FieldTagger();
    }

    protected void ensureProcessed(SootMethod m) {
        if (this.processedMethods.contains(m)) {
            return;
        }
        this.processedMethods.add(m);
        if (!m.isConcrete()) {
            return;
        }
        if (m.isPhantom()) {
            return;
        }
        for (Stmt stmt : m.retrieveActiveBody().getUnits()) {
            Value r;
            if (!(stmt instanceof AssignStmt)) continue;
            AssignStmt as = (AssignStmt)stmt;
            Value l = as.getLeftOp();
            if (l instanceof FieldRef) {
                this.methodToWrite.put(m, ((FieldRef)l).getField());
            }
            if (!((r = as.getRightOp()) instanceof FieldRef)) continue;
            this.methodToRead.put(m, ((FieldRef)r).getField());
        }
    }

    @Override
    protected void internalTransform(Body body, String phaseName, Map options) {
        int threshold = PhaseOptions.getInt(options, "threshold");
        this.ensureProcessed(body.getMethod());
        CallGraph cg = Scene.v().getCallGraph();
        TransitiveTargets tt = new TransitiveTargets(cg);
        block0: for (Stmt stmt : body.getUnits()) {
            HashSet read = new HashSet();
            HashSet write = new HashSet();
            Iterator<MethodOrMethodContext> it = tt.iterator(stmt);
            while (it.hasNext()) {
                SootMethod target = (SootMethod)it.next();
                this.ensureProcessed(target);
                if (target.isNative() || target.isPhantom()) continue block0;
                read.addAll(this.methodToRead.get(target));
                write.addAll(this.methodToWrite.get(target));
                if (read.size() + write.size() <= threshold) continue;
                continue block0;
            }
            stmt.addTag(new FieldReadTag(read));
            stmt.addTag(new FieldWriteTag(write));
        }
    }
}

