/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.spark.geom.geomE;

import java.io.PrintStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import soot.RefType;
import soot.Scene;
import soot.SootClass;
import soot.SootMethod;
import soot.Type;
import soot.jimple.spark.geom.geomE.GeometricManager;
import soot.jimple.spark.geom.geomPA.Constants;
import soot.jimple.spark.geom.geomPA.GeomPointsTo;
import soot.jimple.spark.geom.geomPA.IVarAbstraction;
import soot.jimple.spark.geom.geomPA.IWorklist;
import soot.jimple.spark.geom.geomPA.PlainConstraint;
import soot.jimple.spark.geom.geomPA.RectangleNode;
import soot.jimple.spark.geom.geomPA.SegmentNode;
import soot.jimple.spark.geom.helper.PtSensVisitor;
import soot.jimple.spark.pag.AllocNode;
import soot.jimple.spark.pag.LocalVarNode;
import soot.jimple.spark.pag.Node;
import soot.jimple.spark.pag.StringConstantNode;
import soot.jimple.spark.sets.P2SetVisitor;
import soot.util.Numberable;

public class FullSensitiveNode
extends IVarAbstraction {
    public Map<FullSensitiveNode, GeometricManager> flowto;
    public Map<AllocNode, GeometricManager> pt_objs;
    public Map<AllocNode, GeometricManager> new_pts;
    public Vector<PlainConstraint> complex_cons;
    public static String[] symbols = new String[]{"/", "[]", "|", "-"};

    public FullSensitiveNode(Node thisVar) {
        this.me = thisVar;
    }

    @Override
    public void deleteAll() {
        this.flowto = null;
        this.pt_objs = null;
        this.new_pts = null;
        this.complex_cons = null;
    }

    @Override
    public void reconstruct() {
        this.flowto = new HashMap<FullSensitiveNode, GeometricManager>();
        this.pt_objs = new HashMap<AllocNode, GeometricManager>();
        this.new_pts = new HashMap<AllocNode, GeometricManager>();
        this.complex_cons = null;
        this.lrf_value = 0;
    }

    @Override
    public void keepPointsToOnly() {
        this.flowto = null;
        this.new_pts = null;
        this.complex_cons = null;
    }

    @Override
    public void do_before_propagation() {
        SootMethod func;
        this.do_pts_interval_merge();
        this.do_flow_edge_interval_merge();
        if (this.me instanceof LocalVarNode && ((LocalVarNode)this.me).isThisPtr() && !(func = ((LocalVarNode)this.me).getMethod()).isConstructor()) {
            SootClass defClass = func.getDeclaringClass();
            Iterator<AllocNode> it = this.new_pts.keySet().iterator();
            while (it.hasNext()) {
                SootClass sc;
                AllocNode obj = it.next();
                if (!(obj.getType() instanceof RefType) || defClass == (sc = ((RefType)obj.getType()).getSootClass()) || Scene.v().getActiveHierarchy().resolveConcreteDispatch(sc, func) == func) continue;
                it.remove();
                this.pt_objs.put(obj, (GeometricManager)deadManager);
            }
        }
    }

    @Override
    public void do_after_propagation() {
        if (this.new_pts.size() > 0) {
            for (GeometricManager gm : this.new_pts.values()) {
                gm.flush();
            }
        }
        this.new_pts = new HashMap<AllocNode, GeometricManager>();
    }

    @Override
    public int num_of_diff_objs() {
        return this.pt_objs.size();
    }

    @Override
    public int num_of_diff_edges() {
        return this.flowto.size();
    }

    @Override
    public boolean add_points_to_3(AllocNode obj, long I1, long I2, long L) {
        FullSensitiveNode.pres.I1 = I1;
        FullSensitiveNode.pres.I2 = I2;
        FullSensitiveNode.pres.L = L;
        return this.addPointsTo(0, obj);
    }

    @Override
    public boolean add_points_to_4(AllocNode obj, long I1, long I2, long L1, long L2) {
        FullSensitiveNode.pres.I1 = I1;
        FullSensitiveNode.pres.I2 = I2;
        FullSensitiveNode.pres.L = L1;
        FullSensitiveNode.pres.L_prime = L2;
        return this.addPointsTo(1, obj);
    }

    @Override
    public boolean add_simple_constraint_3(IVarAbstraction qv, long I1, long I2, long L) {
        FullSensitiveNode.pres.I1 = I1;
        FullSensitiveNode.pres.I2 = I2;
        FullSensitiveNode.pres.L = L;
        return this.addFlowsTo(0, qv);
    }

    @Override
    public boolean add_simple_constraint_4(IVarAbstraction qv, long I1, long I2, long L1, long L2) {
        FullSensitiveNode.pres.I1 = I1;
        FullSensitiveNode.pres.I2 = I2;
        FullSensitiveNode.pres.L = L1;
        FullSensitiveNode.pres.L_prime = L2;
        return this.addFlowsTo(1, qv);
    }

    @Override
    public void put_complex_constraint(PlainConstraint cons) {
        if (this.complex_cons == null) {
            this.complex_cons = new Vector();
        }
        this.complex_cons.add(cons);
    }

    @Override
    public void drop_duplicates() {
        for (GeometricManager gm : this.pt_objs.values()) {
            gm.removeUselessSegments();
        }
    }

    @Override
    public void propagate(GeomPointsTo ptAnalyzer, IWorklist worklist) {
        SegmentNode pts;
        int i;
        FullSensitiveNode qn;
        SegmentNode[] entry_pts;
        AllocNode obj;
        if (this.pt_objs.size() == 0) {
            return;
        }
        if (this.complex_cons != null) {
            block4: for (Map.Entry<AllocNode, GeometricManager> entry : this.new_pts.entrySet()) {
                obj = entry.getKey();
                entry_pts = entry.getValue().getFigures();
                for (PlainConstraint plainConstraint : this.complex_cons) {
                    FullSensitiveNode objn = (FullSensitiveNode)ptAnalyzer.findAndInsertInstanceField(obj, plainConstraint.f);
                    if (objn == null) {
                        this.pt_objs.put(obj, (GeometricManager)deadManager);
                        entry.setValue((GeometricManager)deadManager);
                        continue block4;
                    }
                    qn = (FullSensitiveNode)plainConstraint.otherSide;
                    for (i = 0; i < 2; ++i) {
                        pts = entry_pts[i];
                        while (pts != null && pts.is_new) {
                            switch (plainConstraint.type) {
                                case 3: {
                                    if (!this.instantiateStoreConstraint(qn, objn, pts, plainConstraint.code << 8 | i)) break;
                                    worklist.push(qn);
                                    break;
                                }
                                case 2: {
                                    if (!this.instantiateLoadConstraint(objn, qn, pts, plainConstraint.code << 8 | i)) break;
                                    worklist.push(objn);
                                    break;
                                }
                                default: {
                                    throw new RuntimeException("Wrong Complex Constraint");
                                }
                            }
                            pts = pts.next;
                        }
                    }
                }
            }
        }
        if (this.flowto.size() == 0) {
            return;
        }
        for (Map.Entry<Numberable, GeometricManager> entry : this.flowto.entrySet()) {
            SegmentNode pe;
            int j;
            GeometricManager gm2;
            boolean added = false;
            qn = (FullSensitiveNode)entry.getKey();
            GeometricManager gm1 = entry.getValue();
            SegmentNode[] entry_pe = gm1.getFigures();
            if (gm1.isThereUnprocessedFigures()) {
                for (Map.Entry entry2 : this.pt_objs.entrySet()) {
                    obj = (AllocNode)entry2.getKey();
                    gm2 = (GeometricManager)entry2.getValue();
                    if (gm2 == deadManager || !ptAnalyzer.castNeverFails(obj.getType(), qn.getType())) continue;
                    entry_pts = gm2.getFigures();
                    boolean hasNewPointsTo = gm2.isThereUnprocessedFigures();
                    for (j = 0; j < 2; ++j) {
                        pe = entry_pe[j];
                        while (pe != null && (pe.is_new || hasNewPointsTo)) {
                            for (i = 0; i < 2; ++i) {
                                pts = entry_pts[i];
                                while (pts != null && (pts.is_new || pe.is_new)) {
                                    if (this.reasonAndPropagate(qn, obj, pts, pe, i << 8 | j)) {
                                        added = true;
                                    }
                                    pts = pts.next;
                                }
                            }
                            pe = pe.next;
                        }
                    }
                }
                gm1.flush();
            } else {
                for (Map.Entry entry3 : this.new_pts.entrySet()) {
                    obj = (AllocNode)entry3.getKey();
                    gm2 = (GeometricManager)entry3.getValue();
                    if (gm2 == deadManager || !ptAnalyzer.castNeverFails(obj.getType(), qn.getType())) continue;
                    entry_pts = gm2.getFigures();
                    for (i = 0; i < 2; ++i) {
                        pts = entry_pts[i];
                        while (pts != null && pts.is_new) {
                            for (j = 0; j < 2; ++j) {
                                pe = entry_pe[j];
                                while (pe != null) {
                                    if (this.reasonAndPropagate(qn, obj, pts, pe, i << 8 | j)) {
                                        added = true;
                                    }
                                    pe = pe.next;
                                }
                            }
                            pts = pts.next;
                        }
                    }
                }
            }
            if (!added) continue;
            worklist.push(qn);
        }
    }

    @Override
    public boolean isDeadObject(AllocNode obj) {
        return this.pt_objs.get(obj) == deadManager;
    }

    @Override
    public int count_pts_intervals(AllocNode obj) {
        int ret = 0;
        SegmentNode[] int_entry = this.find_points_to(obj);
        for (int j = 0; j < 2; ++j) {
            SegmentNode p = int_entry[j];
            while (p != null) {
                ++ret;
                p = p.next;
            }
        }
        return ret;
    }

    @Override
    public int count_flow_intervals(IVarAbstraction qv) {
        int ret = 0;
        SegmentNode[] int_entry = this.find_flowto((FullSensitiveNode)qv);
        for (int j = 0; j < 2; ++j) {
            SegmentNode p = int_entry[j];
            while (p != null) {
                ++ret;
                p = p.next;
            }
        }
        return ret;
    }

    @Override
    public boolean heap_sensitive_intersection(IVarAbstraction qv) {
        FullSensitiveNode qn = (FullSensitiveNode)qv;
        for (AllocNode an : this.pt_objs.keySet()) {
            SegmentNode[] qt;
            if (an instanceof StringConstantNode || (qt = qn.find_points_to(an)) == null) continue;
            SegmentNode[] pt = this.find_points_to(an);
            for (int i = 0; i < 2; ++i) {
                SegmentNode p = pt[i];
                while (p != null) {
                    for (int j = 0; j < 2; ++j) {
                        SegmentNode q = qt[j];
                        while (q != null) {
                            if (i <= j ? this.quick_intersecting_test(p, q, i << 8 | j) : this.quick_intersecting_test(q, p, j << 8 | i)) {
                                return true;
                            }
                            q = q.next;
                        }
                    }
                    p = p.next;
                }
            }
        }
        return false;
    }

    private boolean quick_intersecting_test(SegmentNode p, SegmentNode q, int code) {
        switch (code >> 8) {
            case 0: {
                switch (code & 0xFF) {
                    case 0: {
                        if (p.I2 - p.I1 != q.I2 - q.I1 || p.I1 >= q.I1 + q.L || q.I1 >= p.I1 + p.L) break;
                        return true;
                    }
                    case 1: {
                        RectangleNode rect_q = (RectangleNode)q;
                        if (this.point_within_rectangle(p.I1, p.I2, rect_q) || this.point_within_rectangle(p.I1 + p.L - 1L, p.I2 + p.L - 1L, rect_q)) {
                            return true;
                        }
                        if (!this.diagonal_line_intersect_horizontal(p, rect_q.I1, rect_q.I2, rect_q.L) && !this.diagonal_line_intersect_horizontal(p, rect_q.I1, rect_q.I2 + rect_q.L_prime - 1L, rect_q.L) && !this.diagonal_line_intersect_vertical(p, rect_q.I1, rect_q.I2, rect_q.L_prime) && !this.diagonal_line_intersect_vertical(p, rect_q.I1 + rect_q.L - 1L, rect_q.I2, rect_q.L_prime)) break;
                        return true;
                    }
                }
                break;
            }
            case 1: {
                RectangleNode rect_p = (RectangleNode)p;
                RectangleNode rect_q = (RectangleNode)q;
                if (rect_p.I2 >= rect_q.I2 + rect_q.L_prime) {
                    return false;
                }
                if (rect_p.I2 + rect_p.L_prime <= rect_q.I2) {
                    return false;
                }
                if (rect_p.I1 + rect_p.L <= rect_q.I1) {
                    return false;
                }
                return rect_p.I1 < rect_q.I1 + rect_q.L;
            }
        }
        return false;
    }

    private boolean point_within_rectangle(long x, long y, RectangleNode rect) {
        return x >= rect.I1 && x < rect.I1 + rect.L && y >= rect.I2 && y < rect.I2 + rect.L_prime;
    }

    private boolean diagonal_line_intersect_vertical(SegmentNode p, long x, long y, long L) {
        long y_cross;
        return x >= p.I1 && x < p.I1 + p.L && (y_cross = x - p.I1 + p.I2) >= y && y_cross < y + L;
    }

    private boolean diagonal_line_intersect_horizontal(SegmentNode p, long x, long y, long L) {
        long x_cross;
        return y >= p.I2 && y < p.I2 + p.L && (x_cross = y - p.I2 + p.I1) >= x && x_cross < x + L;
    }

    @Override
    public boolean pointer_sensitive_points_to(long context, AllocNode obj) {
        SegmentNode[] int_entry = this.find_points_to(obj);
        for (int i = 0; i < 2; ++i) {
            SegmentNode p = int_entry[i];
            while (p != null) {
                if (context >= p.I1 && context < p.I1 + p.L) {
                    return true;
                }
                p = p.next;
            }
        }
        return false;
    }

    @Override
    public boolean test_points_to_has_types(Set<Type> types) {
        for (AllocNode an : this.pt_objs.keySet()) {
            if (!types.contains(an.getType())) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<AllocNode> get_all_points_to_objects() {
        return this.pt_objs.keySet();
    }

    @Override
    public void print_context_sensitive_points_to(PrintStream outPrintStream) {
        for (AllocNode obj : this.pt_objs.keySet()) {
            SegmentNode[] int_entry = this.find_points_to(obj);
            for (int j = 0; j < 2; ++j) {
                SegmentNode p = int_entry[j];
                while (p != null) {
                    outPrintStream.print("(" + obj.toString() + ", " + p.I1 + ", " + p.I2 + ", " + p.L + ", ");
                    if (p instanceof RectangleNode) {
                        outPrintStream.print(((RectangleNode)p).L_prime + ", ");
                    }
                    outPrintStream.println(symbols[j] + ")");
                    p = p.next;
                }
            }
        }
    }

    @Override
    public void injectPts() {
        final GeomPointsTo ptsProvider = (GeomPointsTo)Scene.v().getPointsToAnalysis();
        this.pt_objs = new HashMap<AllocNode, GeometricManager>();
        this.me.getP2Set().forall(new P2SetVisitor(){

            @Override
            public void visit(Node n) {
                if (ptsProvider.isValidGeometricNode(n)) {
                    FullSensitiveNode.this.pt_objs.put((AllocNode)n, (GeometricManager)stubManager);
                }
            }
        });
        this.new_pts = null;
    }

    @Override
    public boolean pointer_interval_points_to(long l, long r, AllocNode obj) {
        SegmentNode[] int_entry = this.find_points_to(obj);
        for (int i = 0; i < 2; ++i) {
            SegmentNode p = int_entry[i];
            while (p != null) {
                long R = p.I1 + p.L;
                if (l <= p.I1 && p.I1 < r || p.I1 <= l && l < R) {
                    return true;
                }
                p = p.next;
            }
        }
        return false;
    }

    @Override
    public void remove_points_to(AllocNode obj) {
        this.pt_objs.remove(obj);
    }

    @Override
    public void get_all_context_sensitive_objects(long l, long r, PtSensVisitor visitor) {
        GeomPointsTo ptsProvider = (GeomPointsTo)Scene.v().getPointsToAnalysis();
        block0: for (Map.Entry<AllocNode, GeometricManager> entry : this.pt_objs.entrySet()) {
            AllocNode obj = entry.getKey();
            SootMethod sm = obj.getMethod();
            int sm_int = 0;
            if (sm != null) {
                sm_int = ptsProvider.getIDFromSootMethod(sm);
            }
            GeometricManager gm = entry.getValue();
            SegmentNode[] int_entry = gm.getFigures();
            boolean flag = true;
            for (int i = 0; i < 2; ++i) {
                SegmentNode p = int_entry[i];
                while (p != null) {
                    long d;
                    long R = p.I1 + p.L;
                    long objL = -1L;
                    long objR = -1L;
                    if (l <= p.I1 && p.I1 < r) {
                        if (i == 0) {
                            d = r - p.I1;
                            if (d > p.L) {
                                d = p.L;
                            }
                            objL = p.I2;
                            objR = objL + d;
                        } else {
                            objL = p.I2;
                            objR = p.I2 + ((RectangleNode)p).L_prime;
                        }
                    } else if (p.I1 <= l && l < R) {
                        if (i == 0) {
                            d = R - l;
                            if (R > r) {
                                d = r - l;
                            }
                            objL = p.I2 + l - p.I1;
                            objR = objL + d;
                        } else {
                            objL = p.I2;
                            objR = p.I2 + ((RectangleNode)p).L_prime;
                        }
                    }
                    if (objL != -1L && objR != -1L) {
                        flag = visitor.visit(obj, objL, objR, sm_int);
                    }
                    if (!flag) break;
                    p = p.next;
                }
                if (!flag) continue block0;
            }
        }
    }

    @Override
    public int count_new_pts_intervals() {
        int ans = 0;
        for (GeometricManager gm : this.new_pts.values()) {
            SegmentNode[] int_entry = gm.getFigures();
            for (int i = 0; i < 2; ++i) {
                SegmentNode p = int_entry[i];
                while (p != null && p.is_new) {
                    ++ans;
                    p = p.next;
                }
            }
        }
        return ans;
    }

    private boolean addPointsTo(int code, AllocNode obj) {
        GeometricManager gm = this.pt_objs.get(obj);
        if (gm == null) {
            gm = new GeometricManager();
            this.pt_objs.put(obj, gm);
        } else if (gm == deadManager) {
            return false;
        }
        SegmentNode p = gm.addNewFigure(code, pres);
        if (p != null) {
            this.new_pts.put(obj, gm);
            return true;
        }
        return false;
    }

    private boolean addFlowsTo(int code, IVarAbstraction qv) {
        GeometricManager gm = this.flowto.get(qv);
        if (gm == null) {
            gm = new GeometricManager();
            this.flowto.put((FullSensitiveNode)qv, gm);
        }
        return gm.addNewFigure(code, pres) != null;
    }

    private void do_pts_interval_merge() {
        for (GeometricManager gm : this.new_pts.values()) {
            gm.mergeFigures(Constants.max_pts_budget);
        }
    }

    private void do_flow_edge_interval_merge() {
        for (GeometricManager gm : this.flowto.values()) {
            gm.mergeFigures(Constants.max_cons_budget);
        }
    }

    private SegmentNode[] find_flowto(FullSensitiveNode qv) {
        GeometricManager im = this.flowto.get(qv);
        return im == null ? null : im.getFigures();
    }

    private SegmentNode[] find_points_to(AllocNode obj) {
        GeometricManager im = this.pt_objs.get(obj);
        return im == null ? null : im.getFigures();
    }

    private int infer_pts_is_one_to_one(SegmentNode pts, SegmentNode pe, int code) {
        long interJ;
        long interI = pe.I1 < pts.I1 ? pts.I1 : pe.I1;
        long l = interJ = pe.I1 + pe.L < pts.I1 + pts.L ? pe.I1 + pe.L : pts.I1 + pts.L;
        if (interI < interJ) {
            switch (code) {
                case 0: {
                    FullSensitiveNode.pres.I1 = interI - pe.I1 + pe.I2;
                    FullSensitiveNode.pres.I2 = interI - pts.I1 + pts.I2;
                    FullSensitiveNode.pres.L = interJ - interI;
                    return 0;
                }
                case 1: {
                    FullSensitiveNode.pres.I1 = pe.I2;
                    FullSensitiveNode.pres.I2 = interI - pts.I1 + pts.I2;
                    FullSensitiveNode.pres.L = ((RectangleNode)pe).L_prime;
                    FullSensitiveNode.pres.L_prime = interJ - interI;
                    return 1;
                }
            }
        }
        return -1;
    }

    private int infer_pts_is_many_to_many(RectangleNode pts, SegmentNode pe, int code) {
        long interJ;
        long interI = pe.I1 < pts.I1 ? pts.I1 : pe.I1;
        long l = interJ = pe.I1 + pe.L < pts.I1 + pts.L ? pe.I1 + pe.L : pts.I1 + pts.L;
        if (interI < interJ) {
            switch (code) {
                case 0: {
                    FullSensitiveNode.pres.I1 = interI - pe.I1 + pe.I2;
                    FullSensitiveNode.pres.I2 = pts.I2;
                    FullSensitiveNode.pres.L = interJ - interI;
                    FullSensitiveNode.pres.L_prime = pts.L_prime;
                    break;
                }
                case 1: {
                    FullSensitiveNode.pres.I1 = pe.I2;
                    FullSensitiveNode.pres.I2 = pts.I2;
                    FullSensitiveNode.pres.L = ((RectangleNode)pe).L_prime;
                    FullSensitiveNode.pres.L_prime = pts.L_prime;
                }
            }
            return 1;
        }
        return -1;
    }

    private boolean reasonAndPropagate(FullSensitiveNode qn, AllocNode obj, SegmentNode pts, SegmentNode pe, int code) {
        int ret_type = -1;
        switch (code >> 8) {
            case 0: {
                ret_type = this.infer_pts_is_one_to_one(pts, pe, code & 0xFF);
                break;
            }
            case 1: {
                ret_type = this.infer_pts_is_many_to_many((RectangleNode)pts, pe, code & 0xFF);
            }
        }
        if (ret_type != -1) {
            return qn.addPointsTo(ret_type, obj);
        }
        return false;
    }

    private boolean instantiateLoadConstraint(FullSensitiveNode objn, FullSensitiveNode qn, SegmentNode pts, int code) {
        int ret_type = -1;
        if (code >> 8 == 0) {
            FullSensitiveNode.pres.I1 = pts.I2;
            FullSensitiveNode.pres.I2 = pts.I1;
            switch (code & 0xFF) {
                case 0: {
                    FullSensitiveNode.pres.L = pts.L;
                    ret_type = 0;
                    break;
                }
                case 1: {
                    FullSensitiveNode.pres.L = ((RectangleNode)pts).L_prime;
                    FullSensitiveNode.pres.L_prime = pts.L;
                    ret_type = 1;
                }
            }
        } else {
            FullSensitiveNode.pres.I1 = pts.I2;
            FullSensitiveNode.pres.I2 = 1L;
            FullSensitiveNode.pres.L_prime = 1L;
            switch (code & 0xFF) {
                case 0: {
                    FullSensitiveNode.pres.L = pts.L;
                    ret_type = 1;
                    break;
                }
                case 1: {
                    FullSensitiveNode.pres.L = ((RectangleNode)pts).L_prime;
                    ret_type = 1;
                }
            }
        }
        return objn.addFlowsTo(ret_type, qn);
    }

    private boolean instantiateStoreConstraint(FullSensitiveNode qn, FullSensitiveNode objn, SegmentNode pts, int code) {
        int ret_type = -1;
        if (code >> 8 == 0) {
            FullSensitiveNode.pres.I1 = pts.I1;
            FullSensitiveNode.pres.I2 = pts.I2;
            FullSensitiveNode.pres.L = pts.L;
            switch (code & 0xFF) {
                case 0: {
                    ret_type = 0;
                    break;
                }
                case 1: {
                    FullSensitiveNode.pres.L_prime = ((RectangleNode)pts).L_prime;
                    ret_type = 1;
                }
            }
        } else {
            FullSensitiveNode.pres.I1 = 1L;
            FullSensitiveNode.pres.I2 = pts.I2;
            FullSensitiveNode.pres.L = 1L;
            switch (code & 0xFF) {
                case 0: {
                    FullSensitiveNode.pres.L_prime = pts.L;
                    ret_type = 1;
                    break;
                }
                case 1: {
                    FullSensitiveNode.pres.L_prime = ((RectangleNode)pts).L_prime;
                    ret_type = 1;
                }
            }
        }
        return qn.addFlowsTo(ret_type, objn);
    }

    static {
        stubManager = new GeometricManager();
        pres = new RectangleNode(1L, 1L, 0x7FFFFFFFFFFFFFFEL, 0x7FFFFFFFFFFFFFFEL);
        stubManager.addNewFigure(1, pres);
        deadManager = new GeometricManager();
    }
}

