/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.spark.geom.geomPA;

import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import soot.RefLikeType;
import soot.Scene;
import soot.SootClass;
import soot.SootMethod;
import soot.Value;
import soot.jimple.AssignStmt;
import soot.jimple.CastExpr;
import soot.jimple.Stmt;
import soot.jimple.spark.geom.geomPA.CgEdge;
import soot.jimple.spark.geom.geomPA.GeomPointsTo;
import soot.jimple.spark.geom.geomPA.IVarAbstraction;
import soot.jimple.spark.geom.geomPA.PlainConstraint;
import soot.jimple.spark.geom.geomPA.ZArrayNumberer;
import soot.jimple.spark.pag.AllocNode;
import soot.jimple.spark.pag.GlobalVarNode;
import soot.jimple.spark.pag.LocalVarNode;
import soot.jimple.spark.pag.Node;
import soot.jimple.spark.pag.SparkField;
import soot.jimple.spark.pag.VarNode;
import soot.jimple.spark.sets.P2SetVisitor;
import soot.jimple.toolkits.callgraph.Edge;

public class OfflineProcessor {
    private boolean visitedFlag;
    GeomPointsTo ptAnalyzer;
    ZArrayNumberer<IVarAbstraction> int2var;
    ArrayList<off_graph_edge> varGraph;
    int[] pre;
    int[] low;
    int[] count;
    int[] rep;
    int[] repsize;
    Deque<Integer> queue;
    int pre_cnt;
    int n_var;

    public OfflineProcessor(int size, GeomPointsTo pta) {
        this.ptAnalyzer = pta;
        this.int2var = this.ptAnalyzer.pointers;
        this.varGraph = new ArrayList(size);
        this.queue = new LinkedList<Integer>();
        this.pre = new int[size];
        this.low = new int[size];
        this.count = new int[size];
        this.rep = new int[size];
        this.repsize = new int[size];
        for (int i = 0; i < size; ++i) {
            this.varGraph.add(null);
        }
    }

    public void runOptimizations(int useClients, boolean useSpark, Set<VarNode> basePointers) {
        this.n_var = this.int2var.size();
        this.queue.clear();
        for (int i = 0; i < this.n_var; ++i) {
            this.varGraph.set(i, null);
            ((IVarAbstraction)this.int2var.get((long)((long)i))).willUpdate = false;
        }
        this.buildInstanceAssignmentGraph(useSpark);
        switch (useClients) {
            case 1: {
                this.setVirualBaseVarsUseful();
                break;
            }
            case 2: {
                this.setStaticCastsVarUseful(useSpark);
                break;
            }
            default: {
                this.setAllUserCodeVariablesUseful();
            }
        }
        this.addUsefulVariables(basePointers);
        this.eliminateUselessConstraints(useSpark);
        this.buildSymbolicAssignmentGraph(useSpark);
        this.makeTopologicalOrder();
        if (useSpark) {
            this.mergeLocalVariables();
        }
    }

    public void destroy() {
        this.pre = null;
        this.low = null;
        this.count = null;
        this.rep = null;
        this.repsize = null;
        this.varGraph = null;
        this.queue = null;
    }

    protected void buildInstanceAssignmentGraph(boolean useSpark) {
        IVarAbstraction[] container2 = new IVarAbstraction[2];
        block5: for (PlainConstraint cons : this.ptAnalyzer.constraints) {
            if (!cons.isViable && cons.type != 1) continue;
            final IVarAbstraction lhs = cons.expr.getO1();
            final IVarAbstraction rhs = cons.expr.getO2();
            final SparkField field = cons.f;
            container2[0] = lhs;
            container2[1] = rhs;
            for (IVarAbstraction pn : container2) {
                SootMethod sm;
                int sm_int;
                if (!(pn.getWrappedNode() instanceof LocalVarNode) || this.ptAnalyzer.isReachableMethod(sm_int = this.ptAnalyzer.getIDFromSootMethod(sm = ((LocalVarNode)pn.getWrappedNode()).getMethod()))) continue;
                cons.isViable = false;
                break;
            }
            switch (cons.type) {
                case 1: {
                    this.add_graph_edge(rhs.id, lhs.id);
                    break;
                }
                case 2: {
                    off_graph_edge e;
                    if (useSpark) {
                        lhs.getWrappedNode().getP2Set().forall(new P2SetVisitor(){

                            @Override
                            public void visit(Node n) {
                                IVarAbstraction padf = OfflineProcessor.this.ptAnalyzer.findAndInsertInstanceField((AllocNode)n, field);
                                if (padf == null) {
                                    return;
                                }
                                off_graph_edge e = OfflineProcessor.this.add_graph_edge(rhs.id, padf.id);
                                e.base_var = lhs;
                            }
                        });
                        break;
                    }
                    for (AllocNode o : lhs.getRepresentative().get_all_points_to_objects()) {
                        IVarAbstraction padf = this.ptAnalyzer.findAndInsertInstanceField(o, field);
                        if (padf == null) {
                            return;
                        }
                        e = this.add_graph_edge(rhs.id, padf.id);
                        e.base_var = lhs;
                    }
                    continue block5;
                }
                case 3: {
                    off_graph_edge e;
                    if (useSpark) {
                        rhs.getWrappedNode().getP2Set().forall(new P2SetVisitor(){

                            @Override
                            public void visit(Node n) {
                                IVarAbstraction padf = OfflineProcessor.this.ptAnalyzer.findAndInsertInstanceField((AllocNode)n, field);
                                if (padf == null) {
                                    return;
                                }
                                off_graph_edge e = OfflineProcessor.this.add_graph_edge(padf.id, lhs.id);
                                e.base_var = rhs;
                            }
                        });
                        break;
                    }
                    for (AllocNode o : rhs.getRepresentative().get_all_points_to_objects()) {
                        IVarAbstraction padf = this.ptAnalyzer.findAndInsertInstanceField(o, field);
                        if (padf == null) {
                            return;
                        }
                        e = this.add_graph_edge(padf.id, lhs.id);
                        e.base_var = rhs;
                    }
                    break;
                }
            }
        }
    }

    protected void addUsefulVariables(Set<? extends Node> initVars) {
        for (int i = 0; i < this.n_var; ++i) {
            IVarAbstraction node = (IVarAbstraction)this.int2var.get(i);
            if (!initVars.contains(node.getWrappedNode())) continue;
            this.queue.add(i);
            node.willUpdate = true;
        }
    }

    protected void setAllUserCodeVariablesUseful() {
        for (int i = 0; i < this.n_var; ++i) {
            SootClass sc;
            Node node = ((IVarAbstraction)this.int2var.get(i)).getWrappedNode();
            int sm_id = this.ptAnalyzer.getMappedMethodID(node);
            if (sm_id == -1 || !(node instanceof VarNode)) continue;
            boolean defined_in_lib = false;
            if (node instanceof LocalVarNode) {
                defined_in_lib = ((LocalVarNode)node).getMethod().isJavaLibraryMethod();
            } else if (node instanceof GlobalVarNode && (sc = ((GlobalVarNode)node).getDeclaringClass()) != null) {
                defined_in_lib = sc.isJavaLibraryClass();
            }
            if (defined_in_lib) continue;
            this.queue.add(i);
            ((IVarAbstraction)this.int2var.get((long)((long)i))).willUpdate = true;
        }
    }

    protected void setVirualBaseVarsUseful() {
        for (int i = this.ptAnalyzer.n_func - 1; i > 1; --i) {
            SootMethod sm = this.ptAnalyzer.getSootMethodFromID(i);
            if (sm.isJavaLibraryMethod()) continue;
            CgEdge p = this.ptAnalyzer.getCallEgesOutFrom(i);
            while (p != null) {
                if (p.base_var != null) {
                    IVarAbstraction pn;
                    int count = 0;
                    Iterator<Edge> it = Scene.v().getCallGraph().edgesOutOf(p.sootEdge.srcStmt());
                    while (it.hasNext()) {
                        it.next();
                        ++count;
                    }
                    if (count > 1 && (pn = this.ptAnalyzer.findInternalNode(p.base_var)) != null) {
                        int k = pn.getNumber();
                        this.queue.add(k);
                        ((IVarAbstraction)this.int2var.get((long)((long)k))).willUpdate = true;
                    }
                }
                p = p.next;
            }
        }
    }

    protected void setStaticCastsVarUseful(boolean useSpark) {
        for (SootMethod sm : this.ptAnalyzer.getAllReachableMethods()) {
            if (sm.isJavaLibraryMethod() || !sm.isConcrete()) continue;
            if (!sm.hasActiveBody()) {
                sm.retrieveActiveBody();
            }
            if (!this.ptAnalyzer.isValidMethod(sm)) continue;
            for (Stmt stmt : sm.getActiveBody().getUnits()) {
                IVarAbstraction pn;
                Value v;
                LocalVarNode node;
                if (!(stmt instanceof AssignStmt)) continue;
                Value rhs = ((AssignStmt)stmt).getRightOp();
                Value lhs = ((AssignStmt)stmt).getLeftOp();
                if (!(rhs instanceof CastExpr) || !(lhs.getType() instanceof RefLikeType) || (node = this.ptAnalyzer.findLocalVarNode(v = ((CastExpr)rhs).getOp())) == null) continue;
                final RefLikeType targetType = (RefLikeType)((CastExpr)rhs).getCastType();
                this.visitedFlag = true;
                if (useSpark) {
                    node.getP2Set().forall(new P2SetVisitor(){

                        @Override
                        public void visit(Node arg0) {
                            if (!OfflineProcessor.this.visitedFlag) {
                                return;
                            }
                            OfflineProcessor.this.visitedFlag = (byte)(OfflineProcessor.this.visitedFlag & (OfflineProcessor.this.ptAnalyzer.castNeverFails(arg0.getType(), targetType) ? 1 : 0));
                        }
                    });
                } else {
                    pn = this.ptAnalyzer.findInternalNode(node).getRepresentative();
                    Set<AllocNode> set = pn.get_all_points_to_objects();
                    for (AllocNode obj : set) {
                        this.visitedFlag = this.ptAnalyzer.castNeverFails(obj.getType(), targetType);
                        if (this.visitedFlag) continue;
                        break;
                    }
                }
                if (this.visitedFlag || (pn = this.ptAnalyzer.findInternalNode(node)) == null) continue;
                int k = pn.getNumber();
                this.queue.add(k);
                ((IVarAbstraction)this.int2var.get((long)((long)k))).willUpdate = true;
            }
        }
    }

    protected void eliminateUselessConstraints(boolean useSpark) {
        IVarAbstraction pn;
        while (!this.queue.isEmpty()) {
            int i = this.queue.getFirst();
            this.queue.removeFirst();
            off_graph_edge p = this.varGraph.get(i);
            while (p != null) {
                pn = (IVarAbstraction)this.int2var.get(p.t);
                if (!pn.willUpdate) {
                    pn.willUpdate = true;
                    this.queue.add(p.t);
                }
                if (p.base_var != null && !p.base_var.willUpdate) {
                    p.base_var.willUpdate = true;
                    this.queue.add(p.base_var.id);
                }
                p = p.next;
            }
        }
        for (PlainConstraint cons : this.ptAnalyzer.constraints) {
            if (!cons.isViable) continue;
            pn = cons.expr.getO2();
            final SparkField field = cons.f;
            this.visitedFlag = false;
            block0 : switch (cons.type) {
                case 0: 
                case 1: 
                case 2: {
                    this.visitedFlag = pn.willUpdate;
                    break;
                }
                case 3: {
                    if (useSpark) {
                        pn.getWrappedNode().getP2Set().forall(new P2SetVisitor(){

                            @Override
                            public void visit(Node n) {
                                if (!OfflineProcessor.this.visitedFlag) {
                                    IVarAbstraction padf = OfflineProcessor.this.ptAnalyzer.findAndInsertInstanceField((AllocNode)n, field);
                                    if (padf == null) {
                                        return;
                                    }
                                    OfflineProcessor.this.visitedFlag = padf.willUpdate;
                                }
                            }
                        });
                        break;
                    }
                    for (AllocNode o : pn.getRepresentative().get_all_points_to_objects()) {
                        IVarAbstraction padf = this.ptAnalyzer.findAndInsertInstanceField(o, field);
                        if (padf == null) {
                            return;
                        }
                        this.visitedFlag = padf.willUpdate;
                        if (!this.visitedFlag) continue;
                        break block0;
                    }
                    break;
                }
            }
            cons.isViable = this.visitedFlag;
        }
    }

    protected void buildSymbolicAssignmentGraph(boolean useSpark) {
        for (int i = 0; i < this.n_var; ++i) {
            this.varGraph.set(i, null);
        }
        this.queue.clear();
        block7: for (PlainConstraint cons : this.ptAnalyzer.constraints) {
            if (!cons.isViable) continue;
            final IVarAbstraction lhs = cons.expr.getO1();
            final IVarAbstraction rhs = cons.expr.getO2();
            final SparkField field = cons.f;
            switch (cons.type) {
                case 0: {
                    this.queue.add(rhs.id);
                    break;
                }
                case 1: {
                    this.add_graph_edge(lhs.id, rhs.id);
                    break;
                }
                case 2: {
                    IVarAbstraction padf;
                    if (useSpark) {
                        lhs.getWrappedNode().getP2Set().forall(new P2SetVisitor(){

                            @Override
                            public void visit(Node n) {
                                IVarAbstraction padf = OfflineProcessor.this.ptAnalyzer.findAndInsertInstanceField((AllocNode)n, field);
                                if (padf == null) {
                                    return;
                                }
                                OfflineProcessor.this.add_graph_edge(padf.id, rhs.id);
                            }
                        });
                        break;
                    }
                    for (AllocNode o : lhs.getRepresentative().get_all_points_to_objects()) {
                        padf = this.ptAnalyzer.findAndInsertInstanceField(o, field);
                        if (padf == null) {
                            return;
                        }
                        this.add_graph_edge(padf.id, rhs.id);
                    }
                    continue block7;
                }
                case 3: {
                    IVarAbstraction padf;
                    if (useSpark) {
                        rhs.getWrappedNode().getP2Set().forall(new P2SetVisitor(){

                            @Override
                            public void visit(Node n) {
                                IVarAbstraction padf = OfflineProcessor.this.ptAnalyzer.findAndInsertInstanceField((AllocNode)n, field);
                                if (padf == null) {
                                    return;
                                }
                                OfflineProcessor.this.add_graph_edge(lhs.id, padf.id);
                            }
                        });
                        break;
                    }
                    for (AllocNode o : rhs.getRepresentative().get_all_points_to_objects()) {
                        padf = this.ptAnalyzer.findAndInsertInstanceField(o, field);
                        if (padf == null) {
                            return;
                        }
                        this.add_graph_edge(lhs.id, padf.id);
                    }
                    break;
                }
            }
        }
    }

    protected void makeTopologicalOrder() {
        int t;
        int s;
        off_graph_edge p;
        IVarAbstraction node;
        int i;
        this.pre_cnt = 0;
        for (i = 0; i < this.n_var; ++i) {
            this.pre[i] = -1;
            this.count[i] = 0;
            this.rep[i] = i;
            this.repsize[i] = 1;
            node = (IVarAbstraction)this.int2var.get(i);
            node.top_value = Integer.MIN_VALUE;
        }
        for (i = 0; i < this.n_var; ++i) {
            if (this.pre[i] != -1) continue;
            this.tarjan_scc(i);
        }
        for (i = 0; i < this.n_var; ++i) {
            p = this.varGraph.get(i);
            s = this.find_parent(i);
            while (p != null) {
                t = this.find_parent(p.t);
                if (t != s) {
                    int n = t;
                    this.count[n] = this.count[n] + 1;
                }
                p = p.next;
            }
        }
        for (i = 0; i < this.n_var; ++i) {
            p = this.varGraph.get(i);
            if (p == null || this.rep[i] == i) continue;
            t = this.find_parent(i);
            while (p.next != null) {
                p = p.next;
            }
            p.next = this.varGraph.get(t);
            this.varGraph.set(t, this.varGraph.get(i));
            this.varGraph.set(i, null);
        }
        this.queue.clear();
        for (i = 0; i < this.n_var; ++i) {
            if (this.rep[i] != i || this.count[i] != 0) continue;
            this.queue.addLast(i);
        }
        i = 0;
        while (!this.queue.isEmpty()) {
            s = this.queue.getFirst();
            this.queue.removeFirst();
            node = (IVarAbstraction)this.int2var.get(s);
            node.top_value = i;
            i += this.repsize[s];
            p = this.varGraph.get(s);
            while (p != null) {
                t = this.find_parent(p.t);
                if (t != s) {
                    int n = t;
                    this.count[n] = this.count[n] - 1;
                    if (this.count[n] == 0) {
                        this.queue.addLast(t);
                    }
                }
                p = p.next;
            }
        }
        for (i = this.n_var - 1; i > -1; --i) {
            if (this.rep[i] == i) continue;
            node = (IVarAbstraction)this.int2var.get(this.find_parent(i));
            IVarAbstraction me = (IVarAbstraction)this.int2var.get(i);
            me.top_value = node.top_value + this.repsize[node.id] - 1;
            int n = node.id;
            this.repsize[n] = this.repsize[n] - 1;
        }
    }

    protected void mergeLocalVariables() {
        IVarAbstraction my_rhs;
        for (int i = 0; i < this.n_var; ++i) {
            off_graph_edge p = this.varGraph.get(i);
            while (p != null) {
                int n = p.t;
                this.count[n] = this.count[n] + 1;
                p = p.next;
            }
        }
        for (PlainConstraint cons : this.ptAnalyzer.constraints) {
            if (!cons.isViable || cons.type != 0) continue;
            my_rhs = cons.expr.getO2();
            int n = my_rhs.id;
            this.count[n] = this.count[n] + 1;
        }
        for (PlainConstraint cons : this.ptAnalyzer.constraints) {
            SootMethod sm2;
            SootMethod sm1;
            if (!cons.isViable || cons.type != 1) continue;
            IVarAbstraction my_lhs = cons.expr.getO1();
            my_rhs = cons.expr.getO2();
            Node lhs = my_lhs.getWrappedNode();
            Node rhs = my_rhs.getWrappedNode();
            if (!(lhs instanceof LocalVarNode) || !(rhs instanceof LocalVarNode) || (sm1 = ((LocalVarNode)lhs).getMethod()) != (sm2 = ((LocalVarNode)rhs).getMethod()) || this.count[my_rhs.id] != 1 || lhs.getType() != rhs.getType()) continue;
            boolean willUpdate = my_rhs.willUpdate;
            IVarAbstraction root = my_rhs.merge(my_lhs);
            if (!root.willUpdate) {
                root.willUpdate = willUpdate;
            }
            cons.isViable = false;
        }
    }

    private off_graph_edge add_graph_edge(int s, int t) {
        off_graph_edge e = new off_graph_edge();
        e.s = s;
        e.t = t;
        e.next = this.varGraph.get(s);
        this.varGraph.set(s, e);
        return e;
    }

    private void tarjan_scc(int s) {
        int t;
        ++this.pre_cnt;
        this.pre[s] = this.low[s];
        this.queue.addLast(s);
        off_graph_edge p = this.varGraph.get(s);
        while (p != null) {
            t = p.t;
            if (this.pre[t] == -1) {
                this.tarjan_scc(t);
            }
            if (this.low[t] < this.low[s]) {
                this.low[s] = this.low[t];
            }
            p = p.next;
        }
        if (this.low[s] < this.pre[s]) {
            return;
        }
        int w = s;
        do {
            t = this.queue.getLast();
            this.queue.removeLast();
            int n = t;
            this.low[n] = this.low[n] + this.n_var;
            w = this.merge_nodes(w, t);
        } while (t != s);
    }

    private int find_parent(int v) {
        return v == this.rep[v] ? v : this.find_parent(this.rep[v]);
    }

    private int merge_nodes(int v1, int v2) {
        if ((v1 = this.find_parent(v1)) != (v2 = this.find_parent(v2))) {
            if (this.repsize[v1] < this.repsize[v2]) {
                int t = v1;
                v1 = v2;
                v2 = t;
            }
            this.rep[v2] = v1;
            int n = v1;
            this.repsize[n] = this.repsize[n] + this.repsize[v2];
        }
        return v1;
    }

    class off_graph_edge {
        int s;
        int t;
        IVarAbstraction base_var;
        off_graph_edge next;

        off_graph_edge() {
        }
    }
}

