/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.spark.geom.geomPA;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import soot.Local;
import soot.SootField;
import soot.SootMethod;
import soot.Value;
import soot.jimple.ArrayRef;
import soot.jimple.AssignStmt;
import soot.jimple.InstanceFieldRef;
import soot.jimple.StaticFieldRef;
import soot.jimple.Stmt;
import soot.jimple.spark.geom.dataRep.CallsiteContextVar;
import soot.jimple.spark.geom.geomPA.CgEdge;
import soot.jimple.spark.geom.geomPA.GeomPointsTo;
import soot.jimple.spark.geom.geomPA.Histogram;
import soot.jimple.spark.geom.geomPA.IVarAbstraction;
import soot.jimple.spark.geom.geomPA.ZArrayNumberer;
import soot.jimple.spark.geom.helper.Obj_1cfa_extractor;
import soot.jimple.spark.pag.AllocDotField;
import soot.jimple.spark.pag.AllocNode;
import soot.jimple.spark.pag.ArrayElement;
import soot.jimple.spark.pag.GlobalVarNode;
import soot.jimple.spark.pag.LocalVarNode;
import soot.jimple.spark.pag.Node;
import soot.jimple.spark.pag.SparkField;
import soot.util.BitSetIterator;
import soot.util.BitVector;
import soot.util.Numberable;

public class SideEffectAnalyzer {
    private GeomPointsTo ptsProvider;
    private ZArrayNumberer<modRefSet> allModRefSets = new ZArrayNumberer();
    private Map<Stmt, modRefSet> stmt2ModRefSet = new HashMap<Stmt, modRefSet>();
    private Map<SootMethod, modRefSet> method2ModSet = new HashMap<SootMethod, modRefSet>();
    private Map<SootMethod, modRefSet> method2RefSet = new HashMap<SootMethod, modRefSet>();
    private CallsiteContextVar tmpVar = new CallsiteContextVar();
    private ZArrayNumberer<CallsiteContextVar> selfMap = new ZArrayNumberer();

    public SideEffectAnalyzer(GeomPointsTo pts) {
        this.ptsProvider = pts;
    }

    public void compute() {
        Obj_1cfa_extractor objs_1cfa = new Obj_1cfa_extractor();
        for (SootMethod sm : this.ptsProvider.getAllReachableMethods()) {
            int sm_int = this.ptsProvider.getIDFromSootMethod(sm);
            if (!this.ptsProvider.isReachableMethod(sm_int) || !sm.isConcrete()) continue;
            if (!sm.hasActiveBody()) {
                sm.retrieveActiveBody();
            }
            if (!this.ptsProvider.isValidMethod(sm)) continue;
            for (Stmt stmt : sm.getActiveBody().getUnits()) {
                Value rop;
                AssignStmt as;
                Value lop;
                int type;
                if (!(stmt instanceof AssignStmt) || (type = this.loadOrStoreStmt(lop = (as = (AssignStmt)stmt).getLeftOp(), rop = as.getRightOp())) == -1) continue;
                Value op = lop;
                if (type == 2) {
                    op = rop;
                }
                if (op instanceof StaticFieldRef) {
                    SootField f = ((StaticFieldRef)op).getField();
                    GlobalVarNode vn = this.ptsProvider.makeGlobalVarNode(f, f.getType());
                    if (this.ptsProvider.isExceptionPointer(vn)) continue;
                    modRefSet modOrRef = this.generateModRefSet(null, stmt, type);
                    CallsiteContextVar cVar = this.getContextVar(null, vn);
                    modOrRef.addBit(cVar);
                    continue;
                }
                LocalVarNode vn = null;
                SparkField fld = null;
                if (op instanceof InstanceFieldRef) {
                    InstanceFieldRef ifr = (InstanceFieldRef)op;
                    vn = this.ptsProvider.findLocalVarNode((Local)ifr.getBase());
                    fld = ifr.getField();
                } else if (op instanceof ArrayRef) {
                    ArrayRef arf = (ArrayRef)op;
                    vn = this.ptsProvider.findLocalVarNode((Local)arf.getBase());
                    fld = ArrayElement.v();
                }
                if (vn == null || this.ptsProvider.isExceptionPointer(vn)) continue;
                IVarAbstraction pn = this.ptsProvider.findInternalNode(vn);
                pn = pn.getRepresentative();
                if (!pn.willUpdate) {
                    modRefSet modOrRef = this.generateModRefSet(null, stmt, type);
                    objs_1cfa.prepare();
                    pn.get_all_context_sensitive_objects(1L, 0x7FFFFFFFFFFFFFFEL, objs_1cfa);
                    for (CallsiteContextVar can : objs_1cfa.outList) {
                        AllocNode an = (AllocNode)can.var;
                        AllocDotField adf = this.ptsProvider.makeAllocDotField(an, fld);
                        CallsiteContextVar cVar = this.getContextVar(can.context, adf);
                        modOrRef.addBit(cVar);
                    }
                    continue;
                }
                LinkedList<CgEdge> edges = this.ptsProvider.getCallEdgesInto(sm_int);
                for (CgEdge cxtEdge : edges) {
                    modRefSet modOrRef = this.generateModRefSet(cxtEdge, stmt, type);
                    long l = cxtEdge.map_offset;
                    long r = l + this.ptsProvider.max_context_size_block[cxtEdge.s];
                    objs_1cfa.prepare();
                    pn.get_all_context_sensitive_objects(l, r, objs_1cfa);
                    for (CallsiteContextVar can : objs_1cfa.outList) {
                        AllocNode an = (AllocNode)can.var;
                        AllocDotField adf = this.ptsProvider.makeAllocDotField(an, fld);
                        CallsiteContextVar cVar = this.getContextVar(can.context, adf);
                        modOrRef.addBit(cVar);
                    }
                }
            }
        }
    }

    public void evaluateSideEffectMatrix() {
        int[] limits = new int[]{1, 5, 10, 25, 50, 75, 100};
        Histogram refSize = new Histogram(limits);
        for (modRefSet mr : this.allModRefSets) {
            refSize.addNumber(mr.getBitVector().cardinality());
        }
        this.ptsProvider.ps.println();
        this.ptsProvider.ps.println("--------------------Side Effect Matrix Information-------------------");
        refSize.printResult(this.ptsProvider.ps, "Side-effect matrix reference size distribution");
    }

    public void dumpSideEffectMatrix() {
        try {
            PrintWriter file = new PrintWriter(this.ptsProvider.createOutputFile("geomModRef.txt"));
            file.println(this.allModRefSets.size() + " " + this.selfMap.size());
            for (modRefSet mr : this.allModRefSets) {
                file.print(mr.getType());
                BitVector vec = mr.getBitVector();
                file.print(" " + vec.cardinality());
                BitSetIterator bit = vec.iterator();
                while (bit.hasNext()) {
                    int v = bit.next();
                    file.print(" " + v);
                }
                file.println();
            }
            file.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't dump solution." + e);
        }
    }

    public void destroy() {
        this.allModRefSets.clear();
        this.stmt2ModRefSet.clear();
        this.selfMap.clear();
        this.tmpVar = null;
        System.gc();
        System.gc();
        System.gc();
    }

    private int loadOrStoreStmt(Value lop, Value rop) {
        if (lop instanceof StaticFieldRef || lop instanceof InstanceFieldRef || lop instanceof ArrayRef) {
            return 1;
        }
        if (rop instanceof StaticFieldRef || rop instanceof InstanceFieldRef || rop instanceof ArrayRef) {
            return 2;
        }
        return -1;
    }

    private CallsiteContextVar getContextVar(CgEdge ctxt, Node vn) {
        this.tmpVar.context = ctxt;
        this.tmpVar.var = vn;
        CallsiteContextVar ccVar = this.selfMap.searchFor(this.tmpVar);
        if (ccVar == null) {
            ccVar = new CallsiteContextVar(ctxt, vn);
            this.selfMap.add(ccVar);
        }
        return ccVar;
    }

    private modRefSet generateModRefSet(CgEdge ctxt, Stmt st, int type) {
        modRefSet set = new modRefSet(type, st, ctxt);
        this.allModRefSets.add(set);
        this.stmt2ModRefSet.put(st, set);
        return set;
    }

    class modRefSet
    implements Numberable {
        public static final int UNKNOWN = 0;
        public static final int MODSET = 1;
        public static final int REFSET = 2;
        private int id = -1;
        private int type = 0;
        private Stmt stmt = null;
        private CgEdge context = null;
        private BitVector ref_vars = new BitVector();

        public modRefSet(int tp, Stmt st, CgEdge ctxt) {
            this.stmt = st;
            this.type = tp;
            this.context = ctxt;
        }

        @Override
        public void setNumber(int number) {
            this.id = number;
        }

        @Override
        public int getNumber() {
            return this.id;
        }

        public String toString() {
            return this.stmt.toString();
        }

        public void addBit(CallsiteContextVar var) {
            this.ref_vars.set(var.getNumber());
        }

        public void mergeBits(modRefSet other) {
            this.ref_vars.and(other.getBitVector());
        }

        public BitVector getBitVector() {
            return this.ref_vars;
        }

        public int getNumberOfVars() {
            return this.ref_vars.cardinality();
        }

        public int getType() {
            return this.type;
        }

        public Stmt getStatement() {
            return this.stmt;
        }

        public CgEdge getContext() {
            return this.context;
        }
    }
}

