/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.spark.geom.helper;

import java.util.LinkedList;
import soot.SootMethod;
import soot.jimple.spark.geom.dataRep.CallsiteContextVar;
import soot.jimple.spark.geom.geomPA.CgEdge;
import soot.jimple.spark.geom.geomPA.GeomPointsTo;
import soot.jimple.spark.geom.geomPA.IVarAbstraction;
import soot.jimple.spark.geom.geomPA.ZArrayNumberer;
import soot.jimple.spark.pag.AllocNode;
import soot.jimple.spark.pag.LocalVarNode;
import soot.jimple.spark.pag.Node;

public class ContextTranslator {
    public static ZArrayNumberer<CallsiteContextVar> pts_1cfa_map = null;
    public static ZArrayNumberer<CallsiteContextVar> objs_1cfa_map = null;

    public static void build_1cfa_map(GeomPointsTo ptsProvider) {
        if (ContextTranslator.is_1cfa_built()) {
            return;
        }
        pts_1cfa_map = new ZArrayNumberer();
        objs_1cfa_map = new ZArrayNumberer();
        for (IVarAbstraction pn : ptsProvider.pointers) {
            if (!pn.willUpdate) continue;
            Node v = pn.getWrappedNode();
            if (v instanceof LocalVarNode) {
                LocalVarNode lvn = (LocalVarNode)v;
                SootMethod sm = lvn.getMethod();
                int sm_int = ptsProvider.getIDFromSootMethod(sm);
                LinkedList<CgEdge> edges = ptsProvider.getCallEdgesInto(sm_int);
                for (CgEdge ce : edges) {
                    CallsiteContextVar context_var = new CallsiteContextVar(ce, v);
                    pts_1cfa_map.add(context_var);
                }
                continue;
            }
            CallsiteContextVar context_var = new CallsiteContextVar(null, v);
            pts_1cfa_map.add(context_var);
        }
        for (IVarAbstraction pobj : ptsProvider.allocations) {
            AllocNode obj = (AllocNode)pobj.getWrappedNode();
            SootMethod sm = obj.getMethod();
            if (sm == null) {
                CallsiteContextVar context_obj = new CallsiteContextVar(null, obj);
                objs_1cfa_map.add(context_obj);
                continue;
            }
            int sm_int = ptsProvider.getIDFromSootMethod(sm);
            LinkedList<CgEdge> edges = ptsProvider.getCallEdgesInto(sm_int);
            for (CgEdge ce : edges) {
                CallsiteContextVar context_obj = new CallsiteContextVar(ce, obj);
                objs_1cfa_map.add(context_obj);
            }
        }
    }

    public static boolean is_1cfa_built() {
        return pts_1cfa_map != null && objs_1cfa_map != null;
    }
}

