/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.spark.geom.helper;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import soot.AnySubType;
import soot.ArrayType;
import soot.Local;
import soot.RefLikeType;
import soot.RefType;
import soot.Scene;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.Type;
import soot.Value;
import soot.jimple.AssignStmt;
import soot.jimple.CastExpr;
import soot.jimple.InstanceFieldRef;
import soot.jimple.InvokeExpr;
import soot.jimple.Stmt;
import soot.jimple.VirtualInvokeExpr;
import soot.jimple.spark.geom.geomPA.CgEdge;
import soot.jimple.spark.geom.geomPA.Constants;
import soot.jimple.spark.geom.geomPA.GeomPointsTo;
import soot.jimple.spark.geom.geomPA.Histogram;
import soot.jimple.spark.geom.geomPA.IVarAbstraction;
import soot.jimple.spark.geom.helper.EvalHelper;
import soot.jimple.spark.pag.AllocDotField;
import soot.jimple.spark.pag.AllocNode;
import soot.jimple.spark.pag.LocalVarNode;
import soot.jimple.spark.pag.Node;
import soot.jimple.spark.sets.P2SetVisitor;
import soot.jimple.toolkits.callgraph.CallGraph;
import soot.jimple.toolkits.callgraph.Edge;
import soot.util.queue.QueueReader;

public class GeomEvaluator {
    private GeomPointsTo ptsProvider;
    private PrintStream outputer;
    private boolean solved;

    public GeomEvaluator(GeomPointsTo gpts, PrintStream ps) {
        this.ptsProvider = gpts;
        this.outputer = ps;
    }

    private void test_1cfa_call_graph(LocalVarNode vn, SootMethod caller, SootMethod callee_signature, Histogram ce_range) {
        IVarAbstraction pn = this.ptsProvider.findInternalNode(vn).getRepresentative();
        HashSet<SootMethod> tgts = new HashSet<SootMethod>();
        Set<AllocNode> set = pn.get_all_points_to_objects();
        LinkedList<CgEdge> list = this.ptsProvider.getCallEdgesInto(this.ptsProvider.getIDFromSootMethod(caller));
        for (CgEdge p : list) {
            long l = p.map_offset;
            long r = l + this.ptsProvider.max_context_size_block[p.s];
            tgts.clear();
            for (AllocNode obj : set) {
                Type t;
                if (!pn.pointer_interval_points_to(l, r, obj) || (t = obj.getType()) == null) continue;
                if (t instanceof AnySubType) {
                    t = ((AnySubType)t).getBase();
                } else if (t instanceof ArrayType) {
                    t = RefType.v("java.lang.Object");
                }
                try {
                    tgts.add(Scene.v().getOrMakeFastHierarchy().resolveConcreteDispatch(((RefType)t).getSootClass(), callee_signature));
                }
                catch (Exception e) {}
            }
            tgts.remove(null);
            ce_range.addNumber(tgts.size());
        }
    }

    public void reportBasicMetrics() {
        int loc = 0;
        int n_legal_var = 0;
        int n_alloc_dot_fields = 0;
        long total_geom_ins_pts = 0L;
        long total_geom_sen_pts = 0L;
        long total_spark_pts = 0L;
        int max_pts_geom = 0;
        int max_pts_spark = 0;
        HashSet<Type> geom_types = new HashSet<Type>();
        final HashSet spark_types = new HashSet();
        int[] limits = new int[]{1, 5, 10, 25, 50, 75, 100};
        Histogram pts_size_bar_geom = new Histogram(limits);
        Histogram pts_size_bar_spark = new Histogram(limits);
        Histogram type_size_bar_geom = new Histogram(limits);
        Histogram type_size_bar_spark = new Histogram(limits);
        n_legal_var = 0;
        n_alloc_dot_fields = 0;
        total_geom_ins_pts = 0L;
        total_geom_sen_pts = 0L;
        max_pts_geom = 0;
        for (SootMethod sm : this.ptsProvider.getAllReachableMethods()) {
            if (!sm.isConcrete()) continue;
            if (!sm.hasActiveBody()) {
                sm.retrieveActiveBody();
            }
            loc += sm.getActiveBody().getUnits().size();
        }
        for (IVarAbstraction pn : this.ptsProvider.pointers) {
            if (!pn.willUpdate || !this.ptsProvider.isLegalPointer(pn)) continue;
            Node var = pn.getWrappedNode();
            pn = pn.getRepresentative();
            if (var instanceof AllocDotField) {
                ++n_alloc_dot_fields;
            }
            ++n_legal_var;
            int size = pn.num_of_diff_objs();
            pts_size_bar_geom.addNumber(size);
            total_geom_ins_pts += (long)size;
            if (size > max_pts_geom) {
                max_pts_geom = size;
            }
            size = var.getP2Set().size();
            pts_size_bar_spark.addNumber(size);
            total_spark_pts += (long)size;
            if (size > max_pts_spark) {
                max_pts_spark = size;
            }
            geom_types.clear();
            Set<AllocNode> obj_set = pn.get_all_points_to_objects();
            for (AllocNode obj : obj_set) {
                if (obj.getType() instanceof AnySubType) {
                    SootClass rc = ((AnySubType)obj.getType()).getBase().getSootClass();
                    List<SootClass> list = null;
                    list = rc.isInterface() ? Scene.v().getActiveHierarchy().getImplementersOf(rc) : Scene.v().getActiveHierarchy().getSubclassesOfIncluding(rc);
                    for (SootClass sc : list) {
                        geom_types.add(sc.getType());
                    }
                } else {
                    geom_types.add(obj.getType());
                }
                total_geom_sen_pts += (long)pn.count_pts_intervals(obj);
            }
            type_size_bar_geom.addNumber(geom_types.size());
            spark_types.clear();
            var.getP2Set().forall(new P2SetVisitor(){

                @Override
                public final void visit(Node n) {
                    AllocNode an = (AllocNode)n;
                    if (an.getType() instanceof AnySubType) {
                        SootClass rc = ((AnySubType)an.getType()).getBase().getSootClass();
                        List<SootClass> list = null;
                        list = rc.isInterface() ? Scene.v().getActiveHierarchy().getImplementersOf(rc) : Scene.v().getActiveHierarchy().getSubclassesOfIncluding(rc);
                        for (SootClass sc : list) {
                            spark_types.add(sc.getType());
                        }
                    } else {
                        spark_types.add(an.getType());
                    }
                }
            });
            type_size_bar_spark.addNumber(spark_types.size());
        }
        this.outputer.println("");
        this.outputer.println("--------------Geom Solver Basics <Format:  Geometric Analysis (SPARK)>--------------");
        this.outputer.printf("Lines of code (jimple): %.1fK\n", (double)loc / 1000.0);
        this.outputer.printf("Reachable Methods : %d (%d)\n", this.ptsProvider.getNumberOfReachableFunctions(), this.ptsProvider.getNumberOfFunctions());
        this.outputer.printf("Reachable User Methods : %d (%d)\n", this.ptsProvider.n_reach_user_methods, this.ptsProvider.n_reach_spark_user_methods);
        this.outputer.println("#Pointers (all code): " + this.ptsProvider.getNumberOfPointers());
        this.outputer.println("#Pointers (app code only): " + n_legal_var + ", in which #AllocDot Fields : " + n_alloc_dot_fields);
        this.outputer.printf("Total/Average Projected Points-to Tuples (app code only): %d (%d) / %.3f (%.3f) \n", total_geom_ins_pts, total_spark_pts, (double)total_geom_ins_pts / (double)n_legal_var, (double)total_spark_pts / (double)n_legal_var);
        this.outputer.printf("Total/Average Context Sensitive Points-to Tuples (app code only): %d / %.3f \n", total_geom_sen_pts, (double)total_geom_sen_pts / (double)n_legal_var);
        this.outputer.println("The largest points-to set size (app code only): " + max_pts_geom + " (" + max_pts_spark + ")");
        this.outputer.println();
        pts_size_bar_geom.printResult(this.ptsProvider.ps, "Points-to Set Sizes Distribution (app code only):", pts_size_bar_spark);
        type_size_bar_geom.printResult(this.ptsProvider.ps, "Points-to Set Types Distribution (app code only):", type_size_bar_spark);
    }

    public void checkCallGraph() {
        HashMap<Stmt, HashSet<SootMethod>> my_vir_tgts = new HashMap<Stmt, HashSet<SootMethod>>();
        int total_virtual_calls = 0;
        int n_geom_call_edges = 0;
        int n_geom_user_edges = 0;
        int n_spark_user_edges = 0;
        int n_spark_cinit_edges = 0;
        int geom_solved = 0;
        int spark_solved = 0;
        int n_func = this.ptsProvider.n_func;
        for (int i = 1; i < n_func; ++i) {
            if (!this.ptsProvider.isReachableMethod(i)) continue;
            CgEdge p = this.ptsProvider.getCallEgesOutFrom(i);
            int edge_cnt = 0;
            while (p != null) {
                Stmt expr;
                if (p.base_var != null && (expr = p.sootEdge.srcStmt()) != null) {
                    HashSet<SootMethod> tgts = (HashSet<SootMethod>)my_vir_tgts.get(expr);
                    if (tgts == null) {
                        tgts = new HashSet<SootMethod>();
                        my_vir_tgts.put(expr, tgts);
                    }
                    tgts.add(p.sootEdge.tgt().method());
                }
                ++edge_cnt;
                p = p.next;
            }
            n_geom_call_edges += edge_cnt;
            if (this.ptsProvider.getSootMethodFromID(i).isJavaLibraryMethod()) continue;
            n_geom_user_edges += edge_cnt;
        }
        int[] limits = new int[]{1, 2, 4, 8};
        Histogram total_call_edges = new Histogram(limits);
        System.gc();
        System.gc();
        System.gc();
        CallGraph cGraph = Scene.v().getCallGraph();
        for (SootMethod sm : this.ptsProvider.getAllReachableMethods()) {
            if (sm.isJavaLibraryMethod() || !sm.isConcrete()) continue;
            if (!sm.hasActiveBody()) {
                sm.retrieveActiveBody();
            }
            if (!this.ptsProvider.isValidMethod(sm)) continue;
            for (Stmt stmt : sm.getActiveBody().getUnits()) {
                InvokeExpr ie;
                if (!stmt.containsInvokeExpr() || !((ie = stmt.getInvokeExpr()) instanceof VirtualInvokeExpr)) continue;
                ++total_virtual_calls;
                Local l = (Local)((VirtualInvokeExpr)ie).getBase();
                LocalVarNode vn = this.ptsProvider.findLocalVarNode(l);
                this.solved = false;
                if (my_vir_tgts.containsKey(stmt)) {
                    Set tgts = (Set)my_vir_tgts.get(stmt);
                    if (tgts.size() == 1) {
                        ++geom_solved;
                        this.solved = true;
                    } else {
                        Histogram call_edges = new Histogram(limits);
                        this.test_1cfa_call_graph(vn, sm, ie.getMethod(), call_edges);
                        total_call_edges.merge(call_edges);
                        call_edges = null;
                    }
                } else {
                    ++geom_solved;
                    this.solved = true;
                }
                int count = 0;
                Iterator<Edge> it = cGraph.edgesOutOf(stmt);
                while (it.hasNext()) {
                    it.next();
                    ++count;
                }
                if (count <= 1) {
                    ++spark_solved;
                }
                if (count <= 1 || !this.solved || !this.ptsProvider.getOpts().verbose()) continue;
                this.outputer.println();
                this.outputer.println("<<<<<<<<<   Additional Solved Call   >>>>>>>>>>");
                this.outputer.println(sm.toString());
                this.outputer.println(ie.toString());
                EvalHelper.debug_succint_pointsto_info(vn, this.ptsProvider);
            }
            Iterator<Edge> it = cGraph.edgesOutOf(sm);
            while (it.hasNext()) {
                Edge edge = it.next();
                if (edge.isClinit()) continue;
                ++n_spark_user_edges;
            }
        }
        QueueReader<Edge> edgeList = Scene.v().getCallGraph().listener();
        while (edgeList.hasNext()) {
            Edge edge = edgeList.next();
            if (!edge.isClinit()) continue;
            ++n_spark_cinit_edges;
        }
        this.ptsProvider.ps.println();
        this.ptsProvider.ps.printf("Call graph edges (total): Geom = %d, SPARK = %d\n", n_geom_call_edges, cGraph.size() - n_spark_cinit_edges);
        this.ptsProvider.ps.printf("Call graph edges (app code): Geom = %d, SPARK = %d\n", n_geom_user_edges, n_spark_user_edges);
        this.ptsProvider.ps.println("Total virtual callsites (app code): " + total_virtual_calls);
        this.ptsProvider.ps.println("Resolved virtual callsites : Geom = " + geom_solved + ", SPARK = " + spark_solved);
        total_call_edges.printResult(this.ptsProvider.ps, "Random testing of the 1-CFA call graph : ");
        if (this.ptsProvider.getOpts().verbose()) {
            this.ptsProvider.outputNotEvaluatedMethods();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void checkAliasAnalysis() {
        void var13_12;
        HashSet<LocalVarNode> access_expr = new HashSet<LocalVarNode>();
        ArrayList<Node> al = new ArrayList<Node>();
        Value[] values = new Value[2];
        long cnt_all = 0L;
        long cnt_hs_alias = 0L;
        long cnt_hi_alias = 0L;
        for (SootMethod sootMethod : this.ptsProvider.getAllReachableMethods()) {
            if (sootMethod.isJavaLibraryMethod() || !sootMethod.isConcrete()) continue;
            if (!sootMethod.hasActiveBody()) {
                sootMethod.retrieveActiveBody();
            }
            if (!this.ptsProvider.isValidMethod(sootMethod)) continue;
            for (Stmt stmt : sootMethod.getActiveBody().getUnits()) {
                if (!(stmt instanceof AssignStmt)) continue;
                AssignStmt a = (AssignStmt)stmt;
                values[0] = a.getLeftOp();
                values[1] = a.getRightOp();
                for (Value v : values) {
                    LocalVarNode vn;
                    InstanceFieldRef ifr;
                    SootField field;
                    if (!(v instanceof InstanceFieldRef) || !((field = (ifr = (InstanceFieldRef)v).getField()).getType() instanceof RefType) || (vn = this.ptsProvider.findLocalVarNode((Local)ifr.getBase())) == null) continue;
                    access_expr.add(vn);
                }
            }
        }
        access_expr.remove(null);
        al.clear();
        for (Node node : access_expr) {
            SootClass sc;
            if (node.getType() instanceof RefType && !(sc = ((RefType)node.getType()).getSootClass()).isInterface() && Scene.v().getActiveHierarchy().isClassSubclassOfIncluding(sc, Constants.exeception_type.getSootClass())) continue;
            al.add(node);
        }
        Date begin = new Date();
        boolean bl = false;
        while (var13_12 < al.size()) {
            Node n1 = (Node)al.get((int)var13_12);
            IVarAbstraction pn = this.ptsProvider.findInternalNode(n1);
            pn = pn.getRepresentative();
            for (void var15_16 = var13_12 + true; var15_16 < al.size(); ++var15_16) {
                Node n2 = (Node)al.get((int)var15_16);
                IVarAbstraction qn = this.ptsProvider.findInternalNode(n2);
                if (pn.heap_sensitive_intersection(qn = qn.getRepresentative())) {
                    ++cnt_hs_alias;
                }
                if (!n1.getP2Set().hasNonEmptyIntersection(n2.getP2Set())) continue;
                ++cnt_hi_alias;
            }
            cnt_all += (long)(al.size() - 1 - var13_12);
            ++var13_12;
        }
        Date date = new Date();
        this.ptsProvider.ps.println();
        this.ptsProvider.ps.println("--------> Alias Pairs Evaluation <---------");
        this.ptsProvider.ps.println("All pointer pairs (app code) : " + cnt_all);
        this.ptsProvider.ps.printf("Heap sensitive alias pairs (by Geom) : %d, Percentage = %.3f%%\n", cnt_hs_alias, (double)cnt_hs_alias / (double)cnt_all * 100.0);
        this.ptsProvider.ps.printf("Heap insensitive alias pairs (by SPARK) : %d, Percentage = %.3f%%\n", cnt_hi_alias, (double)cnt_hi_alias / (double)cnt_all * 100.0);
        this.ptsProvider.ps.printf("Using time: %dms \n", date.getTime() - begin.getTime());
        this.ptsProvider.ps.println();
    }

    public void checkCastsSafety() {
        int total_casts = 0;
        int geom_solved_casts = 0;
        int spark_solved_casts = 0;
        for (SootMethod sm : this.ptsProvider.getAllReachableMethods()) {
            if (sm.isJavaLibraryMethod() || !sm.isConcrete()) continue;
            if (!sm.hasActiveBody()) {
                sm.retrieveActiveBody();
            }
            if (!this.ptsProvider.isValidMethod(sm)) continue;
            for (Stmt stmt : sm.getActiveBody().getUnits()) {
                IVarAbstraction pn;
                Value v;
                LocalVarNode node;
                if (!(stmt instanceof AssignStmt)) continue;
                Value rhs = ((AssignStmt)stmt).getRightOp();
                Value lhs = ((AssignStmt)stmt).getLeftOp();
                if (!(rhs instanceof CastExpr) || !(lhs.getType() instanceof RefLikeType) || (node = this.ptsProvider.findLocalVarNode(v = ((CastExpr)rhs).getOp())) == null || (pn = this.ptsProvider.findInternalNode(node)) == null) continue;
                ++total_casts;
                pn = pn.getRepresentative();
                final RefLikeType targetType = (RefLikeType)((CastExpr)rhs).getCastType();
                this.solved = true;
                Set<AllocNode> set = pn.get_all_points_to_objects();
                for (AllocNode obj : set) {
                    this.solved = this.ptsProvider.castNeverFails(obj.getType(), targetType);
                    if (this.solved) continue;
                    break;
                }
                if (this.solved) {
                    ++geom_solved_casts;
                }
                this.solved = true;
                node.getP2Set().forall(new P2SetVisitor(){

                    @Override
                    public void visit(Node arg0) {
                        if (!GeomEvaluator.this.solved) {
                            return;
                        }
                        GeomEvaluator.this.solved = GeomEvaluator.this.ptsProvider.castNeverFails(arg0.getType(), targetType);
                    }
                });
                if (!this.solved) continue;
                ++spark_solved_casts;
            }
        }
        this.ptsProvider.ps.println();
        this.ptsProvider.ps.println("-----------> Static Casts Safety Evaluation <------------");
        this.ptsProvider.ps.println("Total casts (app code) : " + total_casts);
        this.ptsProvider.ps.println("Safe casts: Geom = " + geom_solved_casts + ", SPARK = " + spark_solved_casts);
    }

    public void estimateHeapDefuseGraph() {
        long ans_geom = 0L;
        long ans_spark = 0L;
        HashMap<IVarAbstraction, int[]> defUseCounterForGeom = new HashMap<IVarAbstraction, int[]>();
        final HashMap defUseCounterForSpark = new HashMap();
        Date begin = new Date();
        for (SootMethod sm : this.ptsProvider.getAllReachableMethods()) {
            if (!sm.isConcrete()) continue;
            if (!sm.hasActiveBody()) {
                sm.retrieveActiveBody();
            }
            if (!this.ptsProvider.isValidMethod(sm)) continue;
            for (Stmt stmt : sm.getActiveBody().getUnits()) {
                if (!(stmt instanceof AssignStmt)) continue;
                AssignStmt a = (AssignStmt)stmt;
                final Value lValue = a.getLeftOp();
                Value rValue = a.getRightOp();
                InstanceFieldRef ifr = null;
                if (lValue instanceof InstanceFieldRef) {
                    ifr = (InstanceFieldRef)lValue;
                } else if (rValue instanceof InstanceFieldRef) {
                    ifr = (InstanceFieldRef)rValue;
                }
                if (ifr == null) continue;
                final SootField field = ifr.getField();
                LocalVarNode vn = this.ptsProvider.findLocalVarNode((Local)ifr.getBase());
                if (vn == null) continue;
                vn.getP2Set().forall(new P2SetVisitor(){

                    @Override
                    public void visit(Node n) {
                        IVarAbstraction padf = GeomEvaluator.this.ptsProvider.findAndInsertInstanceField((AllocNode)n, field);
                        AllocDotField adf = (AllocDotField)padf.getWrappedNode();
                        int[] defUseUnit = (int[])defUseCounterForSpark.get(adf);
                        if (defUseUnit == null) {
                            defUseUnit = new int[2];
                            defUseCounterForSpark.put(adf, defUseUnit);
                        }
                        if (lValue instanceof InstanceFieldRef) {
                            defUseUnit[0] = defUseUnit[0] + 1;
                        } else {
                            defUseUnit[1] = defUseUnit[1] + 1;
                        }
                    }
                });
                IVarAbstraction pn = this.ptsProvider.findInternalNode(vn);
                if (pn == null) continue;
                pn = pn.getRepresentative();
                Set<AllocNode> objsSet = pn.get_all_points_to_objects();
                for (AllocNode obj : objsSet) {
                    IVarAbstraction padf = this.ptsProvider.findAndInsertInstanceField(obj, field);
                    int[] defUseUnit = (int[])defUseCounterForGeom.get(padf);
                    if (defUseUnit == null) {
                        defUseUnit = new int[2];
                        defUseCounterForGeom.put(padf, defUseUnit);
                    }
                    if (lValue instanceof InstanceFieldRef) {
                        defUseUnit[0] = defUseUnit[0] + 1;
                        continue;
                    }
                    defUseUnit[1] = defUseUnit[1] + 1;
                }
            }
        }
        for (int[] defUseUnit : defUseCounterForSpark.values()) {
            ans_spark += (long)defUseUnit[0] * (long)defUseUnit[1];
        }
        for (int[] defUseUnit : defUseCounterForGeom.values()) {
            ans_geom += (long)defUseUnit[0] * (long)defUseUnit[1];
        }
        Date end = new Date();
        this.ptsProvider.ps.println();
        this.ptsProvider.ps.println("-----------> Heap Def Use Graph Evaluation <------------");
        this.ptsProvider.ps.println("The edges in the heap def-use graph is (by Geom): " + ans_geom);
        this.ptsProvider.ps.println("The edges in the heap def-use graph is (by Spark): " + ans_spark);
        this.ptsProvider.ps.printf("Using time: %dms \n", end.getTime() - begin.getTime());
        this.ptsProvider.ps.println();
    }
}

