/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.spark.geom.helper;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Set;
import java.util.TreeSet;
import soot.Scene;
import soot.jimple.spark.geom.dataRep.CallsiteContextVar;
import soot.jimple.spark.geom.dataRep.IntervalContextVar;
import soot.jimple.spark.geom.geomPA.CgEdge;
import soot.jimple.spark.geom.geomPA.GeomPointsTo;
import soot.jimple.spark.geom.geomPA.IVarAbstraction;
import soot.jimple.spark.geom.helper.ContextTranslator;
import soot.jimple.spark.geom.helper.Obj_1cfa_extractor;
import soot.jimple.spark.geom.helper.Obj_full_extractor;
import soot.jimple.spark.pag.AllocNode;
import soot.jimple.spark.pag.LocalVarNode;
import soot.jimple.spark.pag.Node;

public class PointsToDumper {
    private GeomPointsTo ptsProvider = (GeomPointsTo)Scene.v().getPointsToAnalysis();

    public PointsToDumper() {
        ContextTranslator.build_1cfa_map(this.ptsProvider);
    }

    public void dump_context_insensitive_mapped_result() {
        try {
            PrintWriter file = new PrintWriter(this.ptsProvider.createOutputFile("p0_o0.ptm"));
            file.println(this.ptsProvider.getNumberOfPointers() + " " + this.ptsProvider.getNumberOfObjects());
            for (IVarAbstraction pn : this.ptsProvider.pointers) {
                pn = pn.getRepresentative();
                Set<AllocNode> objSet = pn.get_all_points_to_objects();
                file.print(objSet.size());
                for (AllocNode obj : objSet) {
                    IVarAbstraction pobj = this.ptsProvider.findInternalNode(obj);
                    file.print(" " + pobj.getNumber());
                }
                file.println();
            }
            file.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't dump solution." + e);
        }
    }

    public void dump_pointer_1cfa_object_insensitive_mapped_result() {
        ArrayList<AllocNode> list = new ArrayList<AllocNode>();
        try {
            PrintWriter file = new PrintWriter(this.ptsProvider.createOutputFile("p1_o0.ptm"));
            int var_num = ContextTranslator.pts_1cfa_map.size();
            file.println(var_num + " " + this.ptsProvider.getNumberOfObjects());
            for (CallsiteContextVar cvar : ContextTranslator.pts_1cfa_map) {
                Node v = cvar.var;
                IVarAbstraction pn = this.ptsProvider.findInternalNode(v);
                pn = pn.getRepresentative();
                if (v instanceof LocalVarNode) {
                    CgEdge p = cvar.context;
                    long l = p.map_offset;
                    long r = l + this.ptsProvider.max_context_size_block[p.s];
                    list.clear();
                    for (AllocNode obj : pn.get_all_points_to_objects()) {
                        if (!pn.pointer_interval_points_to(l, r, obj)) continue;
                        list.add(obj);
                    }
                    file.print(list.size());
                    for (AllocNode obj : list) {
                        IVarAbstraction po = this.ptsProvider.findInternalNode(obj);
                        file.print(" " + po.getNumber());
                    }
                    file.println();
                    continue;
                }
                Set<AllocNode> objSet = pn.get_all_points_to_objects();
                file.print(objSet.size());
                for (AllocNode obj : objSet) {
                    IVarAbstraction po = this.ptsProvider.findInternalNode(obj);
                    file.print(" " + po.getNumber());
                }
                file.println();
            }
            file.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't dump solution." + e);
        }
    }

    public void dump_pointer_insensitive_object_1cfa_mapped_result() {
        Obj_1cfa_extractor objs_1cfa = new Obj_1cfa_extractor();
        try {
            PrintWriter file = new PrintWriter(this.ptsProvider.createOutputFile("p0_o1.ptm"));
            int var_num = this.ptsProvider.getNumberOfPointers();
            int obj_num = ContextTranslator.objs_1cfa_map.size();
            file.println(var_num + " " + obj_num);
            for (IVarAbstraction pn : this.ptsProvider.pointers) {
                pn = pn.getRepresentative();
                objs_1cfa.prepare();
                pn.get_all_context_sensitive_objects(1L, 0x7FFFFFFFFFFFFFFEL, objs_1cfa);
                file.print(objs_1cfa.outList.size());
                for (CallsiteContextVar cobj : objs_1cfa.outList) {
                    file.print(" " + cobj.getNumber());
                }
                file.println();
            }
            obj_num = this.ptsProvider.getNumberOfObjects();
            file.println(obj_num);
            int i = 1;
            int j = 0;
            do {
                CallsiteContextVar first_obj = (CallsiteContextVar)ContextTranslator.objs_1cfa_map.get(j);
                while (i < obj_num) {
                    CallsiteContextVar cobj;
                    cobj = (CallsiteContextVar)ContextTranslator.objs_1cfa_map.get(i);
                    if (cobj.var != first_obj.var) break;
                    ++i;
                }
                file.print(i - j);
                while (j < i) {
                    file.print(" " + j);
                    ++j;
                }
                file.println();
            } while (i != obj_num);
            file.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't dump solution." + e);
        }
        finally {
            objs_1cfa = null;
        }
    }

    public void dump_pointer_object_1cfa_mapped_result() {
        Obj_1cfa_extractor objs_1cfa = new Obj_1cfa_extractor();
        try {
            PrintWriter file = new PrintWriter(this.ptsProvider.createOutputFile("p1_o1.ptm"));
            int var_num = ContextTranslator.pts_1cfa_map.size();
            int obj_num = ContextTranslator.objs_1cfa_map.size();
            file.println(var_num + " " + obj_num);
            for (CallsiteContextVar cvar : ContextTranslator.pts_1cfa_map) {
                long r;
                long l;
                Node v = cvar.var;
                IVarAbstraction pn = this.ptsProvider.findInternalNode(v);
                pn = pn.getRepresentative();
                objs_1cfa.prepare();
                if (cvar.context != null) {
                    CgEdge p = cvar.context;
                    l = p.map_offset;
                    r = l + this.ptsProvider.max_context_size_block[p.s];
                } else {
                    l = 1L;
                    r = 0x7FFFFFFFFFFFFFFEL;
                }
                pn.get_all_context_sensitive_objects(l, r, objs_1cfa);
                file.print(objs_1cfa.outList.size());
                for (CallsiteContextVar cobj : objs_1cfa.outList) {
                    file.print(" " + cobj.getNumber());
                }
                file.println();
            }
            file.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't dump solution." + e);
        }
        finally {
            objs_1cfa = null;
        }
    }

    public void dump_pointer_1cfa_object_full_result() {
        Obj_full_extractor objs_full = new Obj_full_extractor();
        HashMap<Integer, TreeSet<Long>> endPointsTree = new HashMap<Integer, TreeSet<Long>>();
        HashMap<Integer, long[]> endPointsList = new HashMap<Integer, long[]>();
        try {
            long r;
            long l;
            PrintWriter file = new PrintWriter(this.ptsProvider.createOutputFile("p1_oN.ptm"));
            for (CallsiteContextVar cvar : ContextTranslator.pts_1cfa_map) {
                Node v = cvar.var;
                IVarAbstraction pn = this.ptsProvider.findInternalNode(v);
                pn = pn.getRepresentative();
                objs_full.prepare();
                if (cvar.context != null) {
                    CgEdge p = cvar.context;
                    l = p.map_offset;
                    r = l + this.ptsProvider.max_context_size_block[p.s];
                } else {
                    l = 1L;
                    r = 0x7FFFFFFFFFFFFFFEL;
                }
                pn.get_all_context_sensitive_objects(l, r, objs_full);
                objs_full.finish();
                for (IntervalContextVar icv : objs_full.icvList) {
                    IVarAbstraction pobj = this.ptsProvider.findInternalNode(icv.var);
                    TreeSet<Long> tree = (TreeSet<Long>)endPointsTree.get(pobj.id);
                    if (tree == null) {
                        tree = new TreeSet<Long>();
                        endPointsTree.put(pobj.id, tree);
                    }
                    tree.add(icv.L);
                    tree.add(icv.R);
                }
            }
            int num_obj = this.ptsProvider.getNumberOfObjects();
            int[] offset = new int[num_obj + 1];
            offset[0] = 0;
            for (int i = 0; i < num_obj; ++i) {
                TreeSet tree = (TreeSet)endPointsTree.get(i);
                offset[i + 1] = offset[i];
                if (tree == null) continue;
                int j = 0;
                long[] list = new long[tree.size()];
                int n = i + 1;
                offset[n] = offset[n] + tree.size();
                for (Long v : tree) {
                    list[j] = v;
                    ++j;
                }
                tree.clear();
                endPointsList.put(i, list);
            }
            endPointsTree = null;
            objs_full.prepare();
            System.gc();
            System.gc();
            System.gc();
            int var_num = ContextTranslator.pts_1cfa_map.size();
            file.println(var_num + " " + offset[num_obj]);
            TreeSet<Integer> outList = new TreeSet<Integer>();
            for (CallsiteContextVar cvar : ContextTranslator.pts_1cfa_map) {
                Node v = cvar.var;
                IVarAbstraction pn = this.ptsProvider.findInternalNode(v);
                pn = pn.getRepresentative();
                objs_full.prepare();
                if (cvar.context != null) {
                    CgEdge p = cvar.context;
                    l = p.map_offset;
                    r = l + this.ptsProvider.max_context_size_block[p.s];
                } else {
                    l = 1L;
                    r = 0x7FFFFFFFFFFFFFFEL;
                }
                pn.get_all_context_sensitive_objects(l, r, objs_full);
                objs_full.finish();
                outList.clear();
                for (IntervalContextVar icv : objs_full.icvList) {
                    int i;
                    IVarAbstraction pobj = this.ptsProvider.findInternalNode(icv.var);
                    long[] list = (long[])endPointsList.get(pobj.id);
                    int j = Arrays.binarySearch(list, icv.R);
                    assert (i >= 0);
                    assert (j > i);
                    for (i = Arrays.binarySearch(list, icv.L); i < j; ++i) {
                        outList.add(i + offset[pobj.id]);
                    }
                }
                file.print(outList.size());
                for (Integer id : outList) {
                    file.print(" " + id);
                }
                file.println();
            }
            file.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't dump solution." + e);
        }
        finally {
            objs_full = null;
            endPointsList = null;
        }
    }
}

