/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.spark.geom.helper;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Set;
import soot.Local;
import soot.Scene;
import soot.SootMethod;
import soot.Value;
import soot.jimple.ArrayRef;
import soot.jimple.AssignStmt;
import soot.jimple.InstanceFieldRef;
import soot.jimple.Stmt;
import soot.jimple.spark.geom.dataRep.CallsiteContextVar;
import soot.jimple.spark.geom.geomPA.GeomPointsTo;
import soot.jimple.spark.geom.geomPA.IVarAbstraction;
import soot.jimple.spark.geom.helper.ContextTranslator;
import soot.jimple.spark.pag.LocalVarNode;

public class PtInfoCollector {
    private GeomPointsTo geom = (GeomPointsTo)Scene.v().getPointsToAnalysis();

    public Set<IVarAbstraction> collectBasePointers(boolean isDump) {
        Value[] values = new Value[2];
        HashSet<IVarAbstraction> basePointers = new HashSet<IVarAbstraction>();
        for (SootMethod sm : this.geom.getAllReachableMethods()) {
            int sm_int = this.geom.getIDFromSootMethod(sm);
            if (!this.geom.isReachableMethod(sm_int) || !sm.isConcrete()) continue;
            if (!sm.hasActiveBody()) {
                sm.retrieveActiveBody();
            }
            if (!this.geom.isValidMethod(sm)) continue;
            for (Stmt stmt : sm.getActiveBody().getUnits()) {
                if (!(stmt instanceof AssignStmt)) continue;
                AssignStmt a = (AssignStmt)stmt;
                values[0] = a.getLeftOp();
                values[1] = a.getRightOp();
                for (Value v : values) {
                    ArrayRef arf;
                    IVarAbstraction pn;
                    LocalVarNode vn;
                    if (v instanceof InstanceFieldRef) {
                        InstanceFieldRef ifr = (InstanceFieldRef)v;
                        vn = this.geom.findLocalVarNode((Local)ifr.getBase());
                        if (vn == null || (pn = this.geom.findInternalNode(vn)) == null) continue;
                        basePointers.add(pn);
                        continue;
                    }
                    if (!(v instanceof ArrayRef) || (vn = this.geom.findLocalVarNode((Local)(arf = (ArrayRef)v).getBase())) == null || (pn = this.geom.findInternalNode(vn)) == null) continue;
                    basePointers.add(pn);
                }
            }
        }
        if (isDump) {
            try {
                PrintWriter file = new PrintWriter(this.geom.createOutputFile("geomBasePointers.txt"));
                for (CallsiteContextVar cvar : ContextTranslator.pts_1cfa_map) {
                    IVarAbstraction pn = this.geom.findInternalNode(cvar.var);
                    if (!basePointers.contains(pn)) continue;
                    file.println(cvar.getNumber());
                }
                file.close();
            }
            catch (IOException e) {
                throw new RuntimeException("Couldn't dump solution." + e);
            }
        }
        return basePointers;
    }
}

