/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.spark.geom.ptinsE;

import soot.jimple.spark.geom.geomPA.IFigureManager;
import soot.jimple.spark.geom.geomPA.RectangleNode;
import soot.jimple.spark.geom.geomPA.SegmentNode;

public class PtInsIntervalManager
extends IFigureManager {
    public static final int Divisions = 3;
    public static final int ALL_TO_ALL = -1;
    public static final int ALL_TO_MANY = 0;
    public static final int MANY_TO_ALL = 1;
    public static final int ONE_TO_ONE = 2;
    int[] size = new int[]{0, 0, 0};
    SegmentNode[] header = new SegmentNode[]{null, null, null};
    private boolean hasNewObject = false;

    @Override
    public SegmentNode[] getFigures() {
        return this.header;
    }

    @Override
    public int[] getSizes() {
        return this.size;
    }

    @Override
    public boolean isThereUnprocessedFigures() {
        return this.hasNewObject;
    }

    @Override
    public void flush() {
        this.hasNewObject = false;
        for (int i = 0; i < 3; ++i) {
            SegmentNode p = this.header[i];
            while (p != null && p.is_new) {
                p.is_new = false;
                p = p.next;
            }
        }
    }

    @Override
    public SegmentNode addNewFigure(int code, RectangleNode pnew) {
        SegmentNode p;
        if (code == -1) {
            if (this.header[0] != null && this.header[0].I2 == 0L) {
                return null;
            }
            p = new SegmentNode();
            p.I2 = 0L;
            p.I1 = 0L;
            p.L = 0x7FFFFFFFFFFFFFFEL;
            for (int i = 0; i < 3; ++i) {
                this.size[i] = 0;
                this.header[i] = null;
            }
        } else {
            if (code == 0 || code == 2) {
                p = this.header[0];
                while (p != null) {
                    if (p.I2 <= pnew.I2 && p.I2 + p.L >= pnew.I2 + pnew.L) {
                        return null;
                    }
                    p = p.next;
                }
            }
            if (code == 1 || code == 2) {
                p = this.header[1];
                while (p != null) {
                    if (p.I1 <= pnew.I1 && p.I1 + p.L >= pnew.I1 + pnew.L) {
                        return null;
                    }
                    p = p.next;
                }
            }
            if (code == 2) {
                p = this.header[2];
                while (p != null) {
                    if (p.I1 - p.I2 == pnew.I1 - pnew.I2 && p.I1 <= pnew.I1 && p.I1 + p.L >= pnew.I1 + pnew.L) {
                        return null;
                    }
                    p = p.next;
                }
            }
            p = new SegmentNode(pnew);
            if (code == 0) {
                this.clean_garbage_all_to_many(p);
            } else if (code == 1) {
                this.clean_garbage_many_to_all(p);
            } else {
                this.clean_garbage_one_to_one(p);
            }
        }
        this.hasNewObject = true;
        int n = code;
        this.size[n] = this.size[n] + 1;
        p.next = this.header[code];
        this.header[code] = p;
        return p;
    }

    @Override
    public void mergeFigures(int upperSize) {
        if (this.size[2] > upperSize && this.header[2].is_new) {
            SegmentNode p = this.generate_all_to_many(this.header[2]);
            this.clean_garbage_all_to_many(p);
            p.next = this.header[0];
            this.header[0] = p;
            this.header[2] = null;
            this.size[0] = this.size[0] + 1;
            this.size[2] = 0;
        }
        if (this.size[1] > upperSize && this.header[1].is_new) {
            this.header[1] = this.generate_many_to_all(this.header[1]);
            this.size[1] = 1;
        }
        if (this.size[0] > upperSize && this.header[0].is_new) {
            this.header[0] = this.generate_all_to_many(this.header[0]);
            this.size[0] = 1;
        }
    }

    @Override
    public void removeUselessSegments() {
        SegmentNode p = this.header[2];
        this.size[2] = 0;
        SegmentNode q = null;
        while (p != null) {
            SegmentNode temp;
            boolean contained = false;
            block1: for (int i = 0; i < 2; ++i) {
                temp = this.header[i];
                while (temp != null) {
                    if ((temp.I1 == 0L || temp.I1 <= p.I1 && temp.I1 + temp.L >= p.I1 + p.L) && (temp.I2 == 0L || temp.I2 <= p.I2 && temp.I2 + temp.L >= p.I2 + p.L)) {
                        contained = true;
                        continue block1;
                    }
                    temp = temp.next;
                }
            }
            temp = p.next;
            if (!contained) {
                p.next = q;
                q = p;
                this.size[2] = this.size[2] + 1;
            }
            p = temp;
        }
        this.header[2] = q;
    }

    private SegmentNode generate_all_to_many(SegmentNode mp) {
        long left = mp.I2;
        long right = left + mp.L;
        SegmentNode p = mp.next;
        while (p != null) {
            long t;
            if (p.I2 < left) {
                left = p.I2;
            }
            if ((t = p.I2 + p.L) > right) {
                right = t;
            }
            p = p.next;
        }
        mp.I1 = 0L;
        mp.I2 = left;
        mp.L = right - left;
        mp.next = null;
        return mp;
    }

    private SegmentNode generate_many_to_all(SegmentNode mp) {
        long left = mp.I1;
        long right = left + mp.L;
        SegmentNode p = mp.next;
        while (p != null) {
            long t;
            if (p.I1 < left) {
                left = p.I1;
            }
            if ((t = p.I1 + p.L) > right) {
                right = t;
            }
            p = p.next;
        }
        mp.I1 = left;
        mp.I2 = 0L;
        mp.L = right - left;
        mp.next = null;
        return mp;
    }

    private void clean_garbage_many_to_all(SegmentNode mp) {
        SegmentNode list = this.header[1];
        SegmentNode q = null;
        SegmentNode p = null;
        int num = 0;
        long left = mp.I1;
        long right = left + mp.L;
        while (list != null) {
            if (list.I1 >= left) {
                if (list.I1 <= right) {
                    if (list.I1 + list.L > right) {
                        right = list.I1 + list.L;
                    }
                    list = list.next;
                    continue;
                }
            } else if (list.I1 + list.L >= left) {
                left = list.I1;
                list = list.next;
                continue;
            }
            if (q == null) {
                p = q = list;
            } else {
                q.next = list;
                q = list;
            }
            ++num;
            list = list.next;
        }
        mp.I1 = left;
        mp.L = right - left;
        if (q != null) {
            q.next = null;
        }
        this.header[1] = p;
        this.size[1] = num;
    }

    private void clean_garbage_all_to_many(SegmentNode mp) {
        SegmentNode list = this.header[0];
        SegmentNode q = null;
        SegmentNode p = null;
        int num = 0;
        long left = mp.I2;
        long right = mp.I2 + mp.L;
        while (list != null) {
            if (list.I2 >= left) {
                if (list.I2 <= right) {
                    if (list.I2 + list.L > right) {
                        right = list.I2 + list.L;
                    }
                    list = list.next;
                    continue;
                }
            } else if (list.I2 + list.L >= left) {
                left = list.I2;
                list = list.next;
                continue;
            }
            if (q == null) {
                p = q = list;
            } else {
                q.next = list;
                q = list;
            }
            ++num;
            list = list.next;
        }
        mp.I2 = left;
        mp.L = right - left;
        if (q != null) {
            q.next = null;
        }
        this.header[0] = p;
        this.size[0] = num;
    }

    private void clean_garbage_one_to_one(SegmentNode predator) {
        SegmentNode list = this.header[2];
        SegmentNode q = null;
        SegmentNode p = null;
        int num = 0;
        while (list != null) {
            long L = list.L;
            if (predator.I2 - predator.I1 != list.I2 - list.I1 || predator.I1 > list.I1 || predator.I1 + predator.L < list.I2 + L) {
                if (q == null) {
                    p = q = list;
                } else {
                    q.next = list;
                    q = list;
                }
                ++num;
            }
            list = list.next;
        }
        if (q != null) {
            q.next = null;
        }
        this.header[2] = p;
        this.size[2] = num;
    }
}

