/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.spark.pag;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.HashSet;
import soot.SootClass;
import soot.SootMethod;
import soot.Type;
import soot.jimple.spark.pag.AllocNode;
import soot.jimple.spark.pag.FieldRefNode;
import soot.jimple.spark.pag.LocalVarNode;
import soot.jimple.spark.pag.Node;
import soot.jimple.spark.pag.PAG;
import soot.jimple.spark.pag.SparkField;
import soot.jimple.spark.pag.VarNode;
import soot.jimple.spark.sets.P2SetVisitor;
import soot.jimple.spark.sets.PointsToSetInternal;
import soot.jimple.spark.solver.TopoSorter;

public class PAGDumper {
    protected PAG pag;
    protected String output_dir;
    protected int fieldNum = 0;
    protected HashMap<SparkField, Integer> fieldMap = new HashMap();
    protected ObjectNumberer root = new ObjectNumberer(null, 0);

    public PAGDumper(PAG pag, String output_dir) {
        this.pag = pag;
        this.output_dir = output_dir;
    }

    public void dumpPointsToSets() {
        try {
            final PrintWriter file = new PrintWriter(new FileOutputStream(new File(this.output_dir, "solution")));
            file.println("Solution:");
            for (final VarNode vn : this.pag.getVarNodeNumberer()) {
                PointsToSetInternal p2set;
                if (vn.getReplacement() != vn || (p2set = vn.getP2Set()) == null) continue;
                p2set.forall(new P2SetVisitor(){

                    @Override
                    public final void visit(Node n) {
                        try {
                            PAGDumper.this.dumpNode(vn, file);
                            file.print(" ");
                            PAGDumper.this.dumpNode(n, file);
                            file.println("");
                        }
                        catch (IOException e) {
                            throw new RuntimeException("Couldn't dump solution." + e);
                        }
                    }
                });
            }
            file.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't dump solution." + e);
        }
    }

    public void dump() {
        try {
            Node[] succs;
            Node n;
            PrintWriter file = new PrintWriter(new FileOutputStream(new File(this.output_dir, "pag")));
            if (this.pag.getOpts().topo_sort()) {
                new TopoSorter(this.pag, false).sort();
            }
            file.println("Allocations:");
            for (Object object : this.pag.allocSources()) {
                n = (AllocNode)object;
                if (n.getReplacement() != n) continue;
                for (Node element0 : succs = this.pag.allocLookup((AllocNode)n)) {
                    this.dumpNode(n, file);
                    file.print(" ");
                    this.dumpNode(element0, file);
                    file.println("");
                }
            }
            file.println("Assignments:");
            for (Object object : this.pag.simpleSources()) {
                n = (VarNode)object;
                if (n.getReplacement() != n) continue;
                for (Node element0 : succs = this.pag.simpleLookup((VarNode)n)) {
                    this.dumpNode(n, file);
                    file.print(" ");
                    this.dumpNode(element0, file);
                    file.println("");
                }
            }
            file.println("Loads:");
            for (Object object : this.pag.loadSources()) {
                n = (FieldRefNode)object;
                for (Node element0 : succs = this.pag.loadLookup((FieldRefNode)n)) {
                    this.dumpNode(n, file);
                    file.print(" ");
                    this.dumpNode(element0, file);
                    file.println("");
                }
            }
            file.println("Stores:");
            for (Object object : this.pag.storeSources()) {
                n = (VarNode)object;
                if (n.getReplacement() != n) continue;
                for (Node element0 : succs = this.pag.storeLookup((VarNode)n)) {
                    this.dumpNode(n, file);
                    file.print(" ");
                    this.dumpNode(element0, file);
                    file.println("");
                }
            }
            if (this.pag.getOpts().dump_types()) {
                this.dumpTypes(file);
            }
            file.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't dump PAG." + e);
        }
    }

    protected void dumpTypes(PrintWriter file) throws IOException {
        Type t3;
        Node n;
        HashSet<Type> declaredTypes = new HashSet<Type>();
        HashSet<Type> actualTypes = new HashSet<Type>();
        HashSet<SparkField> allFields = new HashSet<SparkField>();
        for (Node n2 : this.pag.getVarNodeNumberer()) {
            Type t2 = n2.getType();
            if (t2 == null) continue;
            declaredTypes.add(t2);
        }
        for (Object object : this.pag.loadSources()) {
            n = (Node)object;
            if (n.getReplacement() != n) continue;
            t3 = n.getType();
            if (t3 != null) {
                declaredTypes.add(t3);
            }
            allFields.add(((FieldRefNode)n).getField());
        }
        for (Object object : this.pag.storeInvSources()) {
            n = (Node)object;
            if (n.getReplacement() != n) continue;
            t3 = n.getType();
            if (t3 != null) {
                declaredTypes.add(t3);
            }
            allFields.add(((FieldRefNode)n).getField());
        }
        for (Object object : this.pag.allocSources()) {
            n = (Node)object;
            if (n.getReplacement() != n || (t3 = n.getType()) == null) continue;
            actualTypes.add(t3);
        }
        HashMap<Type, Integer> typeToInt = new HashMap<Type, Integer>();
        int nextint = 1;
        for (Type type : declaredTypes) {
            typeToInt.put(type, new Integer(nextint++));
        }
        for (Type t3 : actualTypes) {
            if (typeToInt.containsKey(t3)) continue;
            typeToInt.put(t3, new Integer(nextint++));
        }
        file.println("Declared Types:");
        for (Type declType : declaredTypes) {
            for (Type actType : actualTypes) {
                if (!this.pag.getTypeManager().castNeverFails(actType, declType)) continue;
                file.println("" + typeToInt.get(declType) + " " + typeToInt.get(actType));
            }
        }
        file.println("Allocation Types:");
        for (Object object : this.pag.allocSources()) {
            Node n3 = (Node)object;
            if (n3.getReplacement() != n3) continue;
            Type t4 = n3.getType();
            this.dumpNode(n3, file);
            if (t4 == null) {
                throw new RuntimeException("allocnode with null type");
            }
            file.println(" " + typeToInt.get(t4));
        }
        file.println("Variable Types:");
        for (Node n4 : this.pag.getVarNodeNumberer()) {
            if (n4.getReplacement() != n4) continue;
            Type t5 = n4.getType();
            this.dumpNode(n4, file);
            if (t5 == null) {
                file.println(" 0");
                continue;
            }
            file.println(" " + typeToInt.get(t5));
        }
    }

    protected int fieldToNum(SparkField f) {
        Integer ret = this.fieldMap.get(f);
        if (ret == null) {
            ret = new Integer(++this.fieldNum);
            this.fieldMap.put(f, ret);
        }
        return ret;
    }

    protected void dumpNode(Node n, PrintWriter out) throws IOException {
        if (n.getReplacement() != n) {
            throw new RuntimeException("Attempt to dump collapsed node.");
        }
        if (n instanceof FieldRefNode) {
            FieldRefNode fn = (FieldRefNode)n;
            this.dumpNode(fn.getBase(), out);
            out.print(" " + this.fieldToNum(fn.getField()));
        } else if (this.pag.getOpts().class_method_var() && n instanceof VarNode) {
            VarNode vn = (VarNode)n;
            SootMethod m = null;
            if (vn instanceof LocalVarNode) {
                m = ((LocalVarNode)vn).getMethod();
            }
            SootClass c = null;
            if (m != null) {
                c = m.getDeclaringClass();
            }
            ObjectNumberer cl = this.root.findOrAdd(c);
            ObjectNumberer me = cl.findOrAdd(m);
            ObjectNumberer vr = me.findOrAdd(vn);
            out.print("" + cl.num + " " + me.num + " " + vr.num);
        } else if (this.pag.getOpts().topo_sort() && n instanceof VarNode) {
            out.print("" + ((VarNode)n).finishingNumber);
        } else {
            out.print("" + n.getNumber());
        }
    }

    class ObjectNumberer {
        Object o = null;
        int num = 0;
        int nextChildNum = 1;
        HashMap<Object, ObjectNumberer> children = null;

        ObjectNumberer(Object o, int num) {
            this.o = o;
            this.num = num;
        }

        ObjectNumberer findOrAdd(Object child) {
            ObjectNumberer ret;
            if (this.children == null) {
                this.children = new HashMap();
            }
            if ((ret = this.children.get(child)) == null) {
                ret = new ObjectNumberer(child, this.nextChildNum++);
                this.children.put(child, ret);
            }
            return ret;
        }
    }
}

