/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.spark.solver;

import soot.FastHierarchy;
import soot.G;
import soot.jimple.spark.pag.AllocDotField;
import soot.jimple.spark.pag.AllocNode;
import soot.jimple.spark.pag.FieldRefNode;
import soot.jimple.spark.pag.Node;
import soot.jimple.spark.pag.PAG;
import soot.jimple.spark.pag.SparkField;
import soot.jimple.spark.pag.VarNode;
import soot.jimple.spark.sets.P2SetVisitor;
import soot.jimple.spark.sets.PointsToSetInternal;

public class Checker {
    protected PAG pag;

    public Checker(PAG pag) {
        this.pag = pag;
    }

    public void check() {
        for (Object object : this.pag.allocSources()) {
            this.handleAllocNode((AllocNode)object);
        }
        for (Object object : this.pag.simpleSources()) {
            this.handleSimples((VarNode)object);
        }
        for (Object object : this.pag.loadSources()) {
            this.handleLoads((FieldRefNode)object);
        }
        for (Object object : this.pag.storeSources()) {
            this.handleStores((VarNode)object);
        }
    }

    protected void checkAll(final Node container2, PointsToSetInternal nodes, final Node upstream) {
        nodes.forall(new P2SetVisitor(){

            @Override
            public final void visit(Node n) {
                Checker.this.checkNode(container2, n, upstream);
            }
        });
    }

    protected void checkNode(Node container2, Node n, Node upstream) {
        if (container2.getReplacement() != container2) {
            throw new RuntimeException("container " + container2 + " is illegal");
        }
        if (upstream.getReplacement() != upstream) {
            throw new RuntimeException("upstream " + upstream + " is illegal");
        }
        PointsToSetInternal p2set = container2.getP2Set();
        FastHierarchy fh = this.pag.getTypeManager().getFastHierarchy();
        if (!p2set.contains(n) && (fh == null || container2.getType() == null || fh.canStoreType(n.getType(), container2.getType()))) {
            G.v().out.println("Check failure: " + container2 + " does not have " + n + "; upstream is " + upstream);
        }
    }

    protected void handleAllocNode(AllocNode src) {
        Node[] targets;
        for (Node element : targets = this.pag.allocLookup(src)) {
            this.checkNode(element, src, src);
        }
    }

    protected void handleSimples(VarNode src) {
        Node[] simpleTargets;
        PointsToSetInternal srcSet = src.getP2Set();
        if (srcSet.isEmpty()) {
            return;
        }
        for (Node element : simpleTargets = this.pag.simpleLookup(src)) {
            this.checkAll(element, srcSet, src);
        }
    }

    protected void handleStores(final VarNode src) {
        Node[] storeTargets;
        final PointsToSetInternal srcSet = src.getP2Set();
        if (srcSet.isEmpty()) {
            return;
        }
        for (Node element : storeTargets = this.pag.storeLookup(src)) {
            FieldRefNode fr = (FieldRefNode)element;
            final SparkField f = fr.getField();
            fr.getBase().getP2Set().forall(new P2SetVisitor(){

                @Override
                public final void visit(Node n) {
                    AllocDotField nDotF = Checker.this.pag.makeAllocDotField((AllocNode)n, f);
                    Checker.this.checkAll(nDotF, srcSet, src);
                }
            });
        }
    }

    protected void handleLoads(final FieldRefNode src) {
        final Node[] loadTargets = this.pag.loadLookup(src);
        final SparkField f = src.getField();
        src.getBase().getP2Set().forall(new P2SetVisitor(){

            @Override
            public final void visit(Node n) {
                AllocDotField nDotF = ((AllocNode)n).dot(f);
                if (nDotF == null) {
                    return;
                }
                PointsToSetInternal set = nDotF.getP2Set();
                if (set.isEmpty()) {
                    return;
                }
                for (Node element : loadTargets) {
                    VarNode target = (VarNode)element;
                    Checker.this.checkAll(target, set, src);
                }
            }
        });
    }
}

