/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.spark.solver;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import soot.G;
import soot.jimple.spark.pag.AllocDotField;
import soot.jimple.spark.pag.AllocNode;
import soot.jimple.spark.pag.FieldRefNode;
import soot.jimple.spark.pag.Node;
import soot.jimple.spark.pag.PAG;
import soot.jimple.spark.pag.SparkField;
import soot.jimple.spark.pag.VarNode;
import soot.jimple.spark.sets.P2SetVisitor;
import soot.jimple.spark.sets.PointsToSetInternal;
import soot.jimple.spark.solver.OnFlyCallGraph;
import soot.jimple.spark.solver.Propagator;
import soot.jimple.spark.solver.TopoSorter;
import soot.util.IdentityHashSet;
import soot.util.queue.QueueReader;

public final class PropWorklist
extends Propagator {
    protected final Set<VarNode> varNodeWorkList = new TreeSet<VarNode>();
    protected PAG pag;
    protected OnFlyCallGraph ofcg;

    public PropWorklist(PAG pag) {
        this.pag = pag;
    }

    @Override
    public final void propagate() {
        this.ofcg = this.pag.getOnFlyCallGraph();
        new TopoSorter(this.pag, false).sort();
        for (Object object : this.pag.allocSources()) {
            this.handleAllocNode((AllocNode)object);
        }
        boolean verbose = this.pag.getOpts().verbose();
        do {
            if (verbose) {
                G.v().out.println("Worklist has " + this.varNodeWorkList.size() + " nodes.");
            }
            while (!this.varNodeWorkList.isEmpty()) {
                VarNode src = this.varNodeWorkList.iterator().next();
                this.varNodeWorkList.remove(src);
                this.handleVarNode(src);
            }
            if (verbose) {
                G.v().out.println("Now handling field references");
            }
            for (Object object : this.pag.storeSources()) {
                Node[] targets;
                final VarNode src = (VarNode)object;
                for (Node element0 : targets = this.pag.storeLookup(src)) {
                    final FieldRefNode target = (FieldRefNode)element0;
                    target.getBase().makeP2Set().forall(new P2SetVisitor(){

                        @Override
                        public final void visit(Node n) {
                            AllocDotField nDotF = PropWorklist.this.pag.makeAllocDotField((AllocNode)n, target.getField());
                            nDotF.makeP2Set().addAll(src.getP2Set(), null);
                        }
                    });
                }
            }
            HashSet<Object[]> edgesToPropagate = new HashSet<Object[]>();
            for (Object object : this.pag.loadSources()) {
                this.handleFieldRefNode((FieldRefNode)object, edgesToPropagate);
            }
            IdentityHashSet<PointsToSetInternal> nodesToFlush = new IdentityHashSet<PointsToSetInternal>();
            for (Object[] pair : edgesToPropagate) {
                PointsToSetInternal nDotF = (PointsToSetInternal)pair[0];
                PointsToSetInternal newP2Set = nDotF.getNewSet();
                VarNode loadTarget = (VarNode)pair[1];
                if (loadTarget.makeP2Set().addAll(newP2Set, null)) {
                    this.varNodeWorkList.add(loadTarget);
                }
                nodesToFlush.add(nDotF);
            }
            for (PointsToSetInternal nDotF : nodesToFlush) {
                nDotF.flushNew();
            }
        } while (!this.varNodeWorkList.isEmpty());
    }

    protected final boolean handleAllocNode(AllocNode src) {
        Node[] targets;
        boolean ret = false;
        for (Node element : targets = this.pag.allocLookup(src)) {
            if (!element.makeP2Set().add(src)) continue;
            this.varNodeWorkList.add((VarNode)element);
            ret = true;
        }
        return ret;
    }

    protected final boolean handleVarNode(VarNode src) {
        Node[] storeTargets;
        Node[] simpleTargets;
        boolean ret = false;
        boolean flush = true;
        if (src.getReplacement() != src) {
            throw new RuntimeException("Got bad node " + src + " with rep " + src.getReplacement());
        }
        final PointsToSetInternal newP2Set = src.getP2Set().getNewSet();
        if (newP2Set.isEmpty()) {
            return false;
        }
        if (this.ofcg != null) {
            QueueReader addedEdges = this.pag.edgeReader();
            this.ofcg.updatedNode(src);
            this.ofcg.build();
            while (addedEdges.hasNext()) {
                VarNode edgeTgt;
                Node edgeSrc;
                Node addedSrc = (Node)addedEdges.next();
                Node addedTgt = (Node)addedEdges.next();
                ret = true;
                if (addedSrc instanceof VarNode) {
                    if (!(addedTgt instanceof VarNode)) continue;
                    edgeSrc = (VarNode)addedSrc.getReplacement();
                    edgeTgt = (VarNode)addedTgt.getReplacement();
                    if (!edgeTgt.makeP2Set().addAll(edgeSrc.getP2Set(), null)) continue;
                    this.varNodeWorkList.add(edgeTgt);
                    if (edgeTgt != src) continue;
                    flush = false;
                    continue;
                }
                if (!(addedSrc instanceof AllocNode)) continue;
                edgeSrc = (AllocNode)addedSrc;
                edgeTgt = (VarNode)addedTgt.getReplacement();
                if (!edgeTgt.makeP2Set().add(edgeSrc)) continue;
                this.varNodeWorkList.add(edgeTgt);
                if (edgeTgt != src) continue;
                flush = false;
            }
        }
        for (Node element : simpleTargets = this.pag.simpleLookup(src)) {
            if (!element.makeP2Set().addAll(newP2Set, null)) continue;
            this.varNodeWorkList.add((VarNode)element);
            if (element == src) {
                flush = false;
            }
            ret = true;
        }
        for (Node element : storeTargets = this.pag.storeLookup(src)) {
            FieldRefNode fr = (FieldRefNode)element;
            final SparkField f = fr.getField();
            ret = fr.getBase().getP2Set().forall(new P2SetVisitor(){

                @Override
                public final void visit(Node n) {
                    AllocDotField nDotF = PropWorklist.this.pag.makeAllocDotField((AllocNode)n, f);
                    if (nDotF.makeP2Set().addAll(newP2Set, null)) {
                        this.returnValue = true;
                    }
                }
            }) | ret;
        }
        final HashSet storesToPropagate = new HashSet();
        final HashSet loadsToPropagate = new HashSet();
        Collection<FieldRefNode> fieldRefs = src.getAllFieldRefs();
        for (FieldRefNode fr : fieldRefs) {
            Node[] loadTargets;
            final SparkField field = fr.getField();
            final Node[] storeSources = this.pag.storeInvLookup(fr);
            if (storeSources.length > 0) {
                newP2Set.forall(new P2SetVisitor(){

                    @Override
                    public final void visit(Node n) {
                        AllocDotField nDotF = PropWorklist.this.pag.makeAllocDotField((AllocNode)n, field);
                        for (Node element : storeSources) {
                            Node[] pair = new Node[]{element, nDotF.getReplacement()};
                            storesToPropagate.add(pair);
                        }
                    }
                });
            }
            if ((loadTargets = this.pag.loadLookup(fr)).length <= 0) continue;
            newP2Set.forall(new P2SetVisitor(){

                @Override
                public final void visit(Node n) {
                    AllocDotField nDotF = PropWorklist.this.pag.makeAllocDotField((AllocNode)n, field);
                    if (nDotF != null) {
                        for (Node element : loadTargets) {
                            Node[] pair = new Node[]{nDotF.getReplacement(), element};
                            loadsToPropagate.add(pair);
                        }
                    }
                }
            });
        }
        if (flush) {
            src.getP2Set().flushNew();
        }
        for (Node[] p : storesToPropagate) {
            VarNode storeSource = (VarNode)p[0];
            AllocDotField nDotF = (AllocDotField)p[1];
            if (!nDotF.makeP2Set().addAll(storeSource.getP2Set(), null)) continue;
            ret = true;
        }
        for (Node[] p : loadsToPropagate) {
            AllocDotField nDotF = (AllocDotField)p[0];
            VarNode loadTarget = (VarNode)p[1];
            if (!loadTarget.makeP2Set().addAll(nDotF.getP2Set(), null)) continue;
            this.varNodeWorkList.add(loadTarget);
            ret = true;
        }
        return ret;
    }

    protected final void handleFieldRefNode(FieldRefNode src, final HashSet<Object[]> edgesToPropagate) {
        final Node[] loadTargets = this.pag.loadLookup(src);
        if (loadTargets.length == 0) {
            return;
        }
        final SparkField field = src.getField();
        src.getBase().getP2Set().forall(new P2SetVisitor(){

            @Override
            public final void visit(Node n) {
                PointsToSetInternal p2Set;
                AllocDotField nDotF = PropWorklist.this.pag.makeAllocDotField((AllocNode)n, field);
                if (nDotF != null && !(p2Set = nDotF.getP2Set()).getNewSet().isEmpty()) {
                    for (Node element : loadTargets) {
                        Object[] pair = new Object[]{p2Set, element};
                        edgesToPropagate.add(pair);
                    }
                }
            }
        });
    }
}

