/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.annotation.logic;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import soot.Unit;
import soot.jimple.Stmt;
import soot.toolkits.graph.UnitGraph;

public class Loop {
    protected final Stmt header;
    protected final Stmt backJump;
    protected final List<Stmt> loopStatements;
    protected final UnitGraph g;
    protected Collection<Stmt> loopExists;

    Loop(Stmt head, List<Stmt> loopStatements, UnitGraph g) {
        this.header = head;
        this.g = g;
        loopStatements.remove(head);
        loopStatements.add(0, head);
        this.backJump = loopStatements.get(loopStatements.size() - 1);
        assert (g.getSuccsOf(this.backJump).contains(head));
        this.loopStatements = loopStatements;
    }

    public Stmt getHead() {
        return this.header;
    }

    public Stmt getBackJumpStmt() {
        return this.backJump;
    }

    public List<Stmt> getLoopStatements() {
        return this.loopStatements;
    }

    public Collection<Stmt> getLoopExits() {
        if (this.loopExists == null) {
            this.loopExists = new HashSet<Stmt>();
            for (Stmt s : this.loopStatements) {
                for (Unit succ : this.g.getSuccsOf(s)) {
                    if (this.loopStatements.contains(succ)) continue;
                    this.loopExists.add(s);
                }
            }
        }
        return this.loopExists;
    }

    public Collection<Stmt> targetsOfLoopExit(Stmt loopExit) {
        assert (this.getLoopExits().contains(loopExit));
        List<Unit> succs = this.g.getSuccsOf(loopExit);
        HashSet<Stmt> res = new HashSet<Stmt>();
        for (Unit u : succs) {
            Stmt s = (Stmt)u;
            res.add(s);
        }
        res.removeAll(this.loopStatements);
        return res;
    }

    public boolean loopsForever() {
        return this.getLoopExits().isEmpty();
    }

    public boolean hasSingleExit() {
        return this.getLoopExits().size() == 1;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.header == null ? 0 : this.header.hashCode());
        result = 31 * result + (this.loopStatements == null ? 0 : ((Object)this.loopStatements).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Loop other = (Loop)obj;
        if (this.header == null ? other.header != null : !this.header.equals(other.header)) {
            return false;
        }
        return !(this.loopStatements == null ? other.loopStatements != null : !((Object)this.loopStatements).equals(other.loopStatements));
    }
}

