/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.ide.icfg;

import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import heros.DontSynchronize;
import heros.InterproceduralCFG;
import heros.SynchronizedBy;
import heros.ThreadSafe;
import heros.solver.IDESolver;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import soot.Body;
import soot.MethodOrMethodContext;
import soot.PatchingChain;
import soot.Scene;
import soot.SootMethod;
import soot.Unit;
import soot.UnitBox;
import soot.jimple.Stmt;
import soot.jimple.toolkits.callgraph.CallGraph;
import soot.jimple.toolkits.callgraph.Edge;
import soot.jimple.toolkits.callgraph.EdgePredicate;
import soot.jimple.toolkits.callgraph.Filter;
import soot.toolkits.exceptions.UnitThrowAnalysis;
import soot.toolkits.graph.DirectedGraph;
import soot.toolkits.graph.ExceptionalUnitGraph;
import soot.util.queue.QueueReader;

@ThreadSafe
public class JimpleBasedInterproceduralCFG
implements InterproceduralCFG<Unit, SootMethod> {
    @DontSynchronize(value="readonly")
    protected final CallGraph cg;
    @DontSynchronize(value="written by single thread; read afterwards")
    protected final Map<Unit, Body> unitToOwner = new HashMap<Unit, Body>();
    @SynchronizedBy(value="by use of synchronized LoadingCache class")
    protected final LoadingCache<Body, DirectedGraph<Unit>> bodyToUnitGraph = IDESolver.DEFAULT_CACHE_BUILDER.build(new CacheLoader<Body, DirectedGraph<Unit>>(){

        @Override
        public DirectedGraph<Unit> load(Body body) throws Exception {
            return JimpleBasedInterproceduralCFG.this.makeGraph(body);
        }
    });
    @SynchronizedBy(value="by use of synchronized LoadingCache class")
    protected final LoadingCache<Unit, Set<SootMethod>> unitToCallees = IDESolver.DEFAULT_CACHE_BUILDER.build(new CacheLoader<Unit, Set<SootMethod>>(){

        @Override
        public Set<SootMethod> load(Unit u) throws Exception {
            LinkedHashSet<SootMethod> res = new LinkedHashSet<SootMethod>();
            Iterator<Edge> edgeIter = new EdgeFilter().wrap(JimpleBasedInterproceduralCFG.this.cg.edgesOutOf(u));
            while (edgeIter.hasNext()) {
                Edge edge = edgeIter.next();
                SootMethod m = edge.getTgt().method();
                if (m.hasActiveBody()) {
                    res.add(m);
                    continue;
                }
                if (!IDESolver.DEBUG) continue;
                System.err.println("Method " + m.getSignature() + " is referenced but has no body!");
            }
            return res;
        }
    });
    @SynchronizedBy(value="by use of synchronized LoadingCache class")
    protected final LoadingCache<SootMethod, Set<Unit>> methodToCallers = IDESolver.DEFAULT_CACHE_BUILDER.build(new CacheLoader<SootMethod, Set<Unit>>(){

        @Override
        public Set<Unit> load(SootMethod m) throws Exception {
            LinkedHashSet<Unit> res = new LinkedHashSet<Unit>();
            Iterator<Edge> edgeIter = new EdgeFilter().wrap(JimpleBasedInterproceduralCFG.this.cg.edgesInto(m));
            while (edgeIter.hasNext()) {
                Edge edge = edgeIter.next();
                res.add(edge.srcUnit());
            }
            return res;
        }
    });
    @SynchronizedBy(value="by use of synchronized LoadingCache class")
    protected final LoadingCache<SootMethod, Set<Unit>> methodToCallsFromWithin = IDESolver.DEFAULT_CACHE_BUILDER.build(new CacheLoader<SootMethod, Set<Unit>>(){

        @Override
        public Set<Unit> load(SootMethod m) throws Exception {
            LinkedHashSet<Unit> res = new LinkedHashSet<Unit>();
            for (Unit u : m.getActiveBody().getUnits()) {
                if (!JimpleBasedInterproceduralCFG.this.isCallStmt(u)) continue;
                res.add(u);
            }
            return res;
        }
    });

    public JimpleBasedInterproceduralCFG() {
        this.cg = Scene.v().getCallGraph();
        this.initializeUnitToOwner();
    }

    protected void initializeUnitToOwner() {
        QueueReader<MethodOrMethodContext> iter = Scene.v().getReachableMethods().listener();
        while (iter.hasNext()) {
            SootMethod m = ((MethodOrMethodContext)iter.next()).method();
            if (!m.hasActiveBody()) continue;
            Body b = m.getActiveBody();
            PatchingChain<Unit> units = b.getUnits();
            for (Unit unit : units) {
                this.unitToOwner.put(unit, b);
            }
        }
    }

    @Override
    public SootMethod getMethodOf(Unit u) {
        return this.unitToOwner.get(u).getMethod();
    }

    @Override
    public List<Unit> getSuccsOf(Unit u) {
        Body body = this.unitToOwner.get(u);
        DirectedGraph<Unit> unitGraph = this.getOrCreateUnitGraph(body);
        return unitGraph.getSuccsOf(u);
    }

    protected DirectedGraph<Unit> getOrCreateUnitGraph(Body body) {
        return this.bodyToUnitGraph.getUnchecked(body);
    }

    protected synchronized DirectedGraph<Unit> makeGraph(Body body) {
        return new ExceptionalUnitGraph(body, UnitThrowAnalysis.v(), true);
    }

    @Override
    public Set<SootMethod> getCalleesOfCallAt(Unit u) {
        return this.unitToCallees.getUnchecked(u);
    }

    @Override
    public List<Unit> getReturnSitesOfCallAt(Unit u) {
        return this.getSuccsOf(u);
    }

    @Override
    public boolean isCallStmt(Unit u) {
        return ((Stmt)u).containsInvokeExpr();
    }

    @Override
    public boolean isExitStmt(Unit u) {
        Body body = this.unitToOwner.get(u);
        DirectedGraph<Unit> unitGraph = this.getOrCreateUnitGraph(body);
        return unitGraph.getTails().contains(u);
    }

    @Override
    public Set<Unit> getCallersOf(SootMethod m) {
        return this.methodToCallers.getUnchecked(m);
    }

    @Override
    public Set<Unit> getCallsFromWithin(SootMethod m) {
        return this.methodToCallsFromWithin.getUnchecked(m);
    }

    @Override
    public Set<Unit> getStartPointsOf(SootMethod m) {
        if (m.hasActiveBody()) {
            Body body = m.getActiveBody();
            DirectedGraph<Unit> unitGraph = this.getOrCreateUnitGraph(body);
            return new LinkedHashSet<Unit>(unitGraph.getHeads());
        }
        return null;
    }

    @Override
    public boolean isStartPoint(Unit u) {
        Body body = this.unitToOwner.get(u);
        DirectedGraph<Unit> unitGraph = this.getOrCreateUnitGraph(body);
        return unitGraph.getHeads().contains(u);
    }

    @Override
    public Set<Unit> allNonCallStartNodes() {
        LinkedHashSet<Unit> res = new LinkedHashSet<Unit>(this.unitToOwner.keySet());
        Iterator iter = res.iterator();
        while (iter.hasNext()) {
            Unit u = (Unit)iter.next();
            if (!this.isStartPoint(u) && !this.isCallStmt(u)) continue;
            iter.remove();
        }
        return res;
    }

    @Override
    public boolean isFallThroughSuccessor(Unit u, Unit succ) {
        assert (this.getSuccsOf(u).contains(succ));
        if (!u.fallsThrough()) {
            return false;
        }
        Body body = this.unitToOwner.get(u);
        return body.getUnits().getSuccOf(u) == succ;
    }

    @Override
    public boolean isBranchTarget(Unit u, Unit succ) {
        assert (this.getSuccsOf(u).contains(succ));
        if (!u.branches()) {
            return false;
        }
        for (UnitBox ub : succ.getUnitBoxes()) {
            if (ub.getUnit() != succ) continue;
            return true;
        }
        return false;
    }

    public static class EdgeFilter
    extends Filter {
        protected EdgeFilter() {
            super(new EdgePredicate(){

                @Override
                public boolean want(Edge e) {
                    return e.kind().isExplicit() || e.kind().isThread() || e.kind().isClinit();
                }
            });
        }
    }
}

