/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.scalar;

import java.util.List;
import java.util.Map;
import soot.Body;
import soot.BodyTransformer;
import soot.G;
import soot.Local;
import soot.Singletons;
import soot.Unit;
import soot.Value;
import soot.ValueBox;
import soot.jimple.Constant;
import soot.jimple.DefinitionStmt;
import soot.jimple.NumericConstant;
import soot.jimple.Stmt;
import soot.jimple.StmtBody;
import soot.jimple.toolkits.scalar.Evaluator;
import soot.options.Options;
import soot.toolkits.graph.ExceptionalUnitGraph;
import soot.toolkits.graph.PseudoTopologicalOrderer;
import soot.toolkits.scalar.SimpleLiveLocals;
import soot.toolkits.scalar.SmartLocalDefs;

public class ConstantPropagatorAndFolder
extends BodyTransformer {
    public ConstantPropagatorAndFolder(Singletons.Global g) {
    }

    public static ConstantPropagatorAndFolder v() {
        return G.v().soot_jimple_toolkits_scalar_ConstantPropagatorAndFolder();
    }

    @Override
    protected void internalTransform(Body b, String phaseName, Map options) {
        StmtBody stmtBody = (StmtBody)b;
        int numFolded = 0;
        int numPropagated = 0;
        if (Options.v().verbose()) {
            G.v().out.println("[" + stmtBody.getMethod().getName() + "] Propagating and folding constants...");
        }
        ExceptionalUnitGraph unitGraph = new ExceptionalUnitGraph(stmtBody);
        SmartLocalDefs localDefs = new SmartLocalDefs(unitGraph, new SimpleLiveLocals(unitGraph));
        for (Stmt stmt : new PseudoTopologicalOrderer<Unit>().newList(unitGraph, false)) {
            for (ValueBox useBox : stmt.getUseBoxes()) {
                DefinitionStmt defStmt;
                Local local;
                List<Unit> defsOfUse;
                if (!(useBox.getValue() instanceof Local) || (defsOfUse = localDefs.getDefsOfAt(local = (Local)useBox.getValue(), stmt)).size() != 1 || !((defStmt = (DefinitionStmt)defsOfUse.get(0)).getRightOp() instanceof NumericConstant) || !useBox.canContainValue(defStmt.getRightOp())) continue;
                useBox.setValue(defStmt.getRightOp());
                ++numPropagated;
            }
            for (ValueBox useBox : stmt.getUseBoxes()) {
                Value constValue;
                Value value = useBox.getValue();
                if (value instanceof Constant || !Evaluator.isValueConstantValued(value) || !useBox.canContainValue(constValue = Evaluator.getConstantValueOf(value))) continue;
                useBox.setValue(constValue);
                ++numFolded;
            }
        }
        if (Options.v().verbose()) {
            G.v().out.println("[" + stmtBody.getMethod().getName() + "]     Propagated: " + numPropagated + ", Folded:  " + numFolded);
        }
    }
}

