/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.thread.synchronization;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import soot.EquivalentValue;
import soot.G;
import soot.MethodOrMethodContext;
import soot.Scene;
import soot.Unit;
import soot.Value;
import soot.jimple.spark.pag.PAG;
import soot.jimple.spark.sets.HashPointsToSet;
import soot.jimple.spark.sets.PointsToSetInternal;
import soot.jimple.toolkits.callgraph.Filter;
import soot.jimple.toolkits.callgraph.TransitiveTargets;
import soot.jimple.toolkits.thread.synchronization.CriticalSection;
import soot.jimple.toolkits.thread.synchronization.CriticalSectionGroup;
import soot.jimple.toolkits.thread.synchronization.CriticalSectionVisibleEdgesPred;
import soot.jimple.toolkits.thread.synchronization.DeadlockAvoidanceEdge;
import soot.jimple.toolkits.thread.synchronization.LockAllocator;
import soot.toolkits.graph.HashMutableDirectedGraph;
import soot.toolkits.graph.HashMutableEdgeLabelledDirectedGraph;
import soot.toolkits.graph.MutableDirectedGraph;
import soot.toolkits.graph.MutableEdgeLabelledDirectedGraph;

public class DeadlockDetector {
    boolean optionPrintDebug;
    boolean optionRepairDeadlock;
    boolean optionAllowSelfEdges;
    List<CriticalSection> criticalSections;
    TransitiveTargets tt;

    public DeadlockDetector(boolean optionPrintDebug, boolean optionRepairDeadlock, boolean optionAllowSelfEdges, List<CriticalSection> criticalSections) {
        this.optionPrintDebug = optionPrintDebug;
        this.optionRepairDeadlock = optionRepairDeadlock;
        this.optionAllowSelfEdges = optionAllowSelfEdges && !optionRepairDeadlock;
        this.criticalSections = criticalSections;
        this.tt = new TransitiveTargets(Scene.v().getCallGraph(), new Filter(new CriticalSectionVisibleEdgesPred(null)));
    }

    public MutableDirectedGraph<CriticalSectionGroup> detectComponentBasedDeadlock() {
        HashMutableDirectedGraph lockOrder;
        boolean foundDeadlock;
        int iteration = 0;
        do {
            G.v().out.println("[DeadlockDetector] Deadlock Iteration #" + ++iteration);
            foundDeadlock = false;
            lockOrder = new HashMutableDirectedGraph();
            Iterator<CriticalSection> deadlockIt1 = this.criticalSections.iterator();
            while (deadlockIt1.hasNext() && !foundDeadlock) {
                CriticalSection tn1 = deadlockIt1.next();
                if (tn1.setNumber <= 0) continue;
                if (!lockOrder.containsNode(tn1.group)) {
                    lockOrder.addNode(tn1.group);
                }
                if (tn1.transitiveTargets == null) {
                    tn1.transitiveTargets = new HashSet();
                    for (Unit tn1Invoke : tn1.invokes) {
                        Iterator<MethodOrMethodContext> targetIt = this.tt.iterator(tn1Invoke);
                        while (targetIt.hasNext()) {
                            tn1.transitiveTargets.add(targetIt.next());
                        }
                    }
                }
                Iterator<CriticalSection> deadlockIt2 = this.criticalSections.iterator();
                while (!(!deadlockIt2.hasNext() || this.optionRepairDeadlock && foundDeadlock)) {
                    CriticalSection tn2 = deadlockIt2.next();
                    if (tn2.setNumber <= 0 || tn2.setNumber == tn1.setNumber && !this.optionAllowSelfEdges) continue;
                    if (!lockOrder.containsNode(tn2.group)) {
                        lockOrder.addNode(tn2.group);
                    }
                    if (!tn1.transitiveTargets.contains(tn2.method)) continue;
                    if (this.optionPrintDebug) {
                        G.v().out.println("group" + tn1.setNumber + " before group" + tn2.setNumber + ": " + "outer: " + tn1.name + " inner: " + tn2.name);
                    }
                    ArrayList<CriticalSectionGroup> afterTn2 = new ArrayList<CriticalSectionGroup>();
                    afterTn2.addAll(lockOrder.getSuccsOf(tn2.group));
                    for (int i = 0; i < afterTn2.size(); ++i) {
                        List<CriticalSectionGroup> succs = lockOrder.getSuccsOf((CriticalSectionGroup)afterTn2.get(i));
                        for (CriticalSectionGroup o : succs) {
                            if (afterTn2.contains(o)) continue;
                            afterTn2.add(o);
                        }
                    }
                    if (afterTn2.contains(tn1.group)) {
                        if (!this.optionRepairDeadlock) {
                            G.v().out.println("[DeadlockDetector]  DEADLOCK HAS BEEN DETECTED: not correcting");
                            foundDeadlock = true;
                        } else {
                            G.v().out.println("[DeadlockDetector]  DEADLOCK HAS BEEN DETECTED: merging group" + tn1.setNumber + " and group" + tn2.setNumber + " and restarting deadlock detection");
                            if (this.optionPrintDebug) {
                                G.v().out.println("tn1.setNumber was " + tn1.setNumber + " and tn2.setNumber was " + tn2.setNumber);
                                G.v().out.println("tn1.group.size was " + tn1.group.criticalSections.size() + " and tn2.group.size was " + tn2.group.criticalSections.size());
                                G.v().out.println("tn1.group.num was  " + tn1.group.num() + " and tn2.group.num was  " + tn2.group.num());
                            }
                            tn1.group.mergeGroups(tn2.group);
                            if (this.optionPrintDebug) {
                                G.v().out.println("tn1.setNumber is  " + tn1.setNumber + " and tn2.setNumber is  " + tn2.setNumber);
                                G.v().out.println("tn1.group.size is  " + tn1.group.criticalSections.size() + " and tn2.group.size is  " + tn2.group.criticalSections.size());
                            }
                            foundDeadlock = true;
                        }
                    }
                    lockOrder.addEdge(tn1.group, tn2.group);
                }
            }
        } while (foundDeadlock && this.optionRepairDeadlock);
        return lockOrder;
    }

    public MutableEdgeLabelledDirectedGraph detectLocksetDeadlock(Map<Value, Integer> lockToLockNum, List<PointsToSetInternal> lockPTSets) {
        HashMutableEdgeLabelledDirectedGraph lockOrder;
        boolean foundDeadlock;
        HashMutableEdgeLabelledDirectedGraph permanentOrder = new HashMutableEdgeLabelledDirectedGraph();
        int iteration = 0;
        do {
            G.v().out.println("[DeadlockDetector] Deadlock Iteration #" + ++iteration);
            foundDeadlock = false;
            lockOrder = (HashMutableEdgeLabelledDirectedGraph)permanentOrder.clone();
            Iterator<CriticalSection> deadlockIt1 = this.criticalSections.iterator();
            while (deadlockIt1.hasNext() && !foundDeadlock) {
                CriticalSection tn1 = deadlockIt1.next();
                if (tn1.group == null) continue;
                for (EquivalentValue lockEqVal : tn1.lockset) {
                    Value lock = lockEqVal.getValue();
                    if (lockOrder.containsNode(lockToLockNum.get(lock))) continue;
                    lockOrder.addNode(lockToLockNum.get(lock));
                }
                if (tn1.transitiveTargets == null) {
                    tn1.transitiveTargets = new HashSet();
                    for (Unit tn1Invoke : tn1.invokes) {
                        Iterator<MethodOrMethodContext> targetIt = this.tt.iterator(tn1Invoke);
                        while (targetIt.hasNext()) {
                            tn1.transitiveTargets.add(targetIt.next());
                        }
                    }
                }
                Iterator<CriticalSection> deadlockIt2 = this.criticalSections.iterator();
                block5: while (deadlockIt2.hasNext() && !foundDeadlock) {
                    CriticalSection tn2 = deadlockIt2.next();
                    if (tn2.group == null) continue;
                    for (EquivalentValue lockEqVal : tn2.lockset) {
                        Value lock = lockEqVal.getValue();
                        if (lockOrder.containsNode(lockToLockNum.get(lock))) continue;
                        lockOrder.addNode(lockToLockNum.get(lock));
                    }
                    if (!tn1.transitiveTargets.contains(tn2.method) || foundDeadlock) continue;
                    G.v().out.println("[DeadlockDetector] locks in " + tn1.name + " before locks in " + tn2.name + ": " + "outer: " + tn1.name + " inner: " + tn2.name);
                    for (EquivalentValue lock2EqVal : tn2.lockset) {
                        Value lock2 = lock2EqVal.getValue();
                        Integer lock2Num = lockToLockNum.get(lock2);
                        ArrayList<Integer> afterTn2 = new ArrayList<Integer>();
                        afterTn2.addAll(lockOrder.getSuccsOf(lock2Num));
                        ListIterator lit = afterTn2.listIterator();
                        while (lit.hasNext()) {
                            Integer to = (Integer)lit.next();
                            List<Object> labels = lockOrder.getLabelsForEdges(lock2Num, to);
                            boolean keep = false;
                            if (labels != null) {
                                for (Object l : labels) {
                                    CriticalSection labelTn = (CriticalSection)l;
                                    boolean tnsShareAStaticLock = false;
                                    for (EquivalentValue tn1LockEqVal : tn1.lockset) {
                                        Integer tn1LockNum = lockToLockNum.get(tn1LockEqVal.getValue());
                                        if (tn1LockNum >= 0) continue;
                                        for (EquivalentValue labelTnLockEqVal : labelTn.lockset) {
                                            if (lockToLockNum.get(labelTnLockEqVal.getValue()) != tn1LockNum) continue;
                                            tnsShareAStaticLock = true;
                                        }
                                    }
                                    if (tnsShareAStaticLock) continue;
                                    keep = true;
                                    break;
                                }
                            }
                            if (keep) continue;
                            lit.remove();
                        }
                        for (EquivalentValue lock1EqVal : tn1.lockset) {
                            Value lock1 = lock1EqVal.getValue();
                            Integer lock1Num = lockToLockNum.get(lock1);
                            if ((lock1Num != lock2Num || lock1Num > 0) && afterTn2.contains(lock1Num)) {
                                if (!this.optionRepairDeadlock) {
                                    G.v().out.println("[DeadlockDetector] DEADLOCK HAS BEEN DETECTED: not correcting");
                                    foundDeadlock = true;
                                } else {
                                    List<Object> backwardLabels;
                                    G.v().out.println("[DeadlockDetector] DEADLOCK HAS BEEN DETECTED while inspecting " + lock1Num + " (" + lock1 + ") and " + lock2Num + " (" + lock2 + ") ");
                                    DeadlockAvoidanceEdge dae = new DeadlockAvoidanceEdge(tn1.method.getDeclaringClass());
                                    EquivalentValue daeEqVal = new EquivalentValue(dae);
                                    Integer daeNum = new Integer(-lockPTSets.size());
                                    permanentOrder.addNode(daeNum);
                                    lockToLockNum.put(dae, daeNum);
                                    HashPointsToSet dummyLockPT = new HashPointsToSet(lock1.getType(), (PAG)Scene.v().getPointsToAnalysis());
                                    lockPTSets.add(dummyLockPT);
                                    for (EquivalentValue lockEqVal : tn1.lockset) {
                                        Integer lockNum = lockToLockNum.get(lockEqVal.getValue());
                                        if (!permanentOrder.containsNode(lockNum)) {
                                            permanentOrder.addNode(lockNum);
                                        }
                                        permanentOrder.addEdge(daeNum, lockNum, tn1);
                                    }
                                    tn1.lockset.add(daeEqVal);
                                    List<Object> forwardLabels = lockOrder.getLabelsForEdges(lock1Num, lock2Num);
                                    if (forwardLabels != null) {
                                        for (Object t : forwardLabels) {
                                            CriticalSection tn = (CriticalSection)t;
                                            if (tn.lockset.contains(daeEqVal)) continue;
                                            for (EquivalentValue lockEqVal : tn.lockset) {
                                                Integer lockNum = lockToLockNum.get(lockEqVal.getValue());
                                                if (!permanentOrder.containsNode(lockNum)) {
                                                    permanentOrder.addNode(lockNum);
                                                }
                                                permanentOrder.addEdge(daeNum, lockNum, tn);
                                            }
                                            tn.lockset.add(daeEqVal);
                                        }
                                    }
                                    if ((backwardLabels = lockOrder.getLabelsForEdges(lock2Num, lock1Num)) != null) {
                                        for (Object t : backwardLabels) {
                                            CriticalSection tn = (CriticalSection)t;
                                            if (tn.lockset.contains(daeEqVal)) continue;
                                            for (EquivalentValue lockEqVal : tn.lockset) {
                                                Integer lockNum = lockToLockNum.get(lockEqVal.getValue());
                                                if (!permanentOrder.containsNode(lockNum)) {
                                                    permanentOrder.addNode(lockNum);
                                                }
                                                permanentOrder.addEdge(daeNum, lockNum, tn);
                                            }
                                            tn.lockset.add(daeEqVal);
                                            G.v().out.println("[DeadlockDetector]   Adding deadlock avoidance edge between " + tn1.name + " and " + tn.name);
                                        }
                                        G.v().out.println("[DeadlockDetector]   Restarting deadlock detection");
                                    }
                                    foundDeadlock = true;
                                    break;
                                }
                            }
                            if (lock1Num == lock2Num) continue;
                            lockOrder.addEdge(lock1Num, lock2Num, tn1);
                        }
                        if (!foundDeadlock) continue;
                        continue block5;
                    }
                }
            }
        } while (foundDeadlock && this.optionRepairDeadlock);
        return lockOrder;
    }

    public void reorderLocksets(Map<Value, Integer> lockToLockNum, MutableEdgeLabelledDirectedGraph lockOrder) {
        for (CriticalSection tn : this.criticalSections) {
            HashMutableDirectedGraph visibleOrder = new HashMutableDirectedGraph();
            if (tn.group == null) continue;
            for (CriticalSection otherTn : this.criticalSections) {
                boolean tnsShareAStaticLock = false;
                for (EquivalentValue tnLockEqVal : tn.lockset) {
                    Integer tnLockNum = lockToLockNum.get(tnLockEqVal.getValue());
                    if (tnLockNum >= 0) continue;
                    if (otherTn.group != null) {
                        for (EquivalentValue otherTnLockEqVal : otherTn.lockset) {
                            if (lockToLockNum.get(otherTnLockEqVal.getValue()) != tnLockNum) continue;
                            tnsShareAStaticLock = true;
                        }
                        continue;
                    }
                    tnsShareAStaticLock = true;
                }
                if (tnsShareAStaticLock && tn != otherTn) continue;
                MutableDirectedGraph orderings = lockOrder.getEdgesForLabel(otherTn);
                for (Object node1 : orderings.getNodes()) {
                    if (!visibleOrder.containsNode(node1)) {
                        visibleOrder.addNode(node1);
                    }
                    for (EquivalentValue node2 : orderings.getSuccsOf(node1)) {
                        if (!visibleOrder.containsNode(node2)) {
                            visibleOrder.addNode(node2);
                        }
                        visibleOrder.addEdge(node1, node2);
                    }
                }
            }
            G.v().out.println("VISIBLE ORDER FOR " + tn.name);
            visibleOrder.printGraph();
            ArrayList<EquivalentValue> newLockset = new ArrayList<EquivalentValue>();
            for (EquivalentValue lockEqVal : tn.lockset) {
                EquivalentValue existingLockEqVal;
                Value existingLock;
                Integer existingLockNum;
                int i;
                Value lockToInsert = lockEqVal.getValue();
                Integer lockNumToInsert = lockToLockNum.get(lockToInsert);
                for (i = 0; i < newLockset.size() && !visibleOrder.containsEdge(lockNumToInsert, existingLockNum = lockToLockNum.get(existingLock = (existingLockEqVal = (EquivalentValue)newLockset.get(i)).getValue())) && lockNumToInsert >= existingLockNum; ++i) {
                }
                newLockset.add(i, lockEqVal);
            }
            G.v().out.println("reordered from " + LockAllocator.locksetToLockNumString(tn.lockset, lockToLockNum) + " to " + LockAllocator.locksetToLockNumString(newLockset, lockToLockNum));
            tn.lockset = newLockset;
        }
    }
}

