/*
 * Decompiled with CFR 0.152.
 */
package soot.shimple.internal;

import java.util.Collections;
import java.util.List;
import soot.Type;
import soot.Unit;
import soot.UnitPrinter;
import soot.Value;
import soot.shimple.PiExpr;
import soot.shimple.internal.SValueUnitPair;
import soot.toolkits.scalar.ValueUnitPair;
import soot.util.Switch;

public class SPiExpr
implements PiExpr {
    protected ValueUnitPair argBox;
    protected Object targetKey;

    public SPiExpr(Value v, Unit u, Object o) {
        this.argBox = new SValueUnitPair(v, u);
        this.targetKey = o;
    }

    @Override
    public ValueUnitPair getArgBox() {
        return this.argBox;
    }

    @Override
    public Value getValue() {
        return this.argBox.getValue();
    }

    @Override
    public Unit getCondStmt() {
        return this.argBox.getUnit();
    }

    @Override
    public Object getTargetKey() {
        return this.targetKey;
    }

    @Override
    public void setValue(Value value) {
        this.argBox.setValue(value);
    }

    @Override
    public void setCondStmt(Unit pred) {
        this.argBox.setUnit(pred);
    }

    @Override
    public void setTargetKey(Object targetKey) {
        this.targetKey = targetKey;
    }

    @Override
    public List getUnitBoxes() {
        return Collections.singletonList(this.argBox);
    }

    @Override
    public void clearUnitBoxes() {
        System.out.println("clear unit boxes");
        this.argBox.setUnit(null);
    }

    @Override
    public boolean equivTo(Object o) {
        if (!(o instanceof SPiExpr)) {
            return false;
        }
        return this.getArgBox().equivTo(((SPiExpr)o).getArgBox());
    }

    @Override
    public int equivHashCode() {
        return this.getArgBox().equivHashCode() * 17;
    }

    @Override
    public void apply(Switch sw) {
        throw new RuntimeException("Not Yet Implemented.");
    }

    @Override
    public Object clone() {
        return new SPiExpr(this.getValue(), this.getCondStmt(), this.getTargetKey());
    }

    public String toString() {
        String s = "Pi(" + this.getValue() + ")";
        return s;
    }

    @Override
    public void toString(UnitPrinter up) {
        up.literal("Pi");
        up.literal("(");
        this.argBox.toString(up);
        up.literal(" [");
        up.literal(this.targetKey.toString());
        up.literal("])");
    }

    @Override
    public Type getType() {
        return this.getValue().getType();
    }

    @Override
    public List getUseBoxes() {
        return Collections.singletonList(this.argBox);
    }
}

