/*
 * Decompiled with CFR 0.152.
 */
package soot.tagkit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import soot.tagkit.AnnotationElem;
import soot.tagkit.Tag;

public class AnnotationTag
implements Tag {
    private String type;
    private List<AnnotationElem> elems;

    public AnnotationTag(String type) {
        this(type, new ArrayList<AnnotationElem>());
    }

    public AnnotationTag(String type, Collection<AnnotationElem> elements) {
        this.type = type;
        this.elems = elements instanceof List ? (List<Object>)elements : new ArrayList<AnnotationElem>(elements);
    }

    @Deprecated
    public AnnotationTag(String type, int numElem) {
        this.type = type;
        this.elems = new ArrayList<AnnotationElem>(numElem);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Annotation: type: " + this.type + " num elems: " + this.elems.size() + " elems: ");
        if (this.elems != null) {
            Iterator<AnnotationElem> it = this.elems.iterator();
            while (it.hasNext()) {
                sb.append("\n");
                sb.append(it.next());
            }
        }
        sb.append("\n");
        return sb.toString();
    }

    @Override
    public String getName() {
        return "AnnotationTag";
    }

    public String getInfo() {
        return "Annotation";
    }

    public String getType() {
        return this.type;
    }

    @Deprecated
    public int getNumElems() {
        return this.elems.size();
    }

    @Override
    public byte[] getValue() {
        throw new RuntimeException("AnnotationTag has no value for bytecode");
    }

    public void addElem(AnnotationElem elem) {
        this.elems.add(elem);
    }

    public void setElems(List<AnnotationElem> list) {
        this.elems = list;
    }

    @Deprecated
    public AnnotationElem getElemAt(int i) {
        return this.elems.get(i);
    }

    public Collection<AnnotationElem> getElems() {
        return Collections.unmodifiableCollection(this.elems);
    }
}

