/*
 * Decompiled with CFR 0.152.
 */
package soot.toDex;

import org.jf.dexlib.Code.Opcode;
import org.jf.dexlib.StringIdItem;
import org.jf.dexlib.TypeIdItem;
import soot.jimple.ClassConstant;
import soot.jimple.ConstantSwitch;
import soot.jimple.DoubleConstant;
import soot.jimple.FloatConstant;
import soot.jimple.IntConstant;
import soot.jimple.LongConstant;
import soot.jimple.NullConstant;
import soot.jimple.StringConstant;
import soot.toDex.Register;
import soot.toDex.SootToDexUtils;
import soot.toDex.StmtVisitor;
import soot.toDex.instructions.Insn;
import soot.toDex.instructions.Insn11n;
import soot.toDex.instructions.Insn21c;
import soot.toDex.instructions.Insn21s;
import soot.toDex.instructions.Insn31i;
import soot.toDex.instructions.Insn51l;

public class ConstantVisitor
implements ConstantSwitch {
    private StmtVisitor stmtV;
    private Register destinationReg;

    public ConstantVisitor(StmtVisitor stmtV) {
        this.stmtV = stmtV;
    }

    public void setDestination(Register destinationReg) {
        this.destinationReg = destinationReg;
    }

    @Override
    public void defaultCase(Object o) {
        throw new Error("unknown Object (" + o.getClass() + ") as Constant: " + o);
    }

    @Override
    public void caseStringConstant(StringConstant s) {
        StringIdItem referencedString = StringIdItem.internStringIdItem(this.stmtV.getBelongingFile(), s.value);
        this.stmtV.addInsn(new Insn21c(Opcode.CONST_STRING, this.destinationReg, referencedString));
    }

    @Override
    public void caseClassConstant(ClassConstant c) {
        boolean classIsArray = c.value.startsWith("[");
        String className = classIsArray ? c.value : SootToDexUtils.getDexClassName(c.value);
        TypeIdItem referencedClass = TypeIdItem.internTypeIdItem(this.stmtV.getBelongingFile(), className);
        this.stmtV.addInsn(new Insn21c(Opcode.CONST_CLASS, this.destinationReg, referencedClass));
    }

    @Override
    public void caseLongConstant(LongConstant l) {
        long constant = l.value;
        this.stmtV.addInsn(this.buildConstWideInsn(constant));
    }

    private Insn buildConstWideInsn(long literal) {
        if (SootToDexUtils.fitsSigned16(literal)) {
            return new Insn21s(Opcode.CONST_WIDE_16, this.destinationReg, (short)literal);
        }
        if (SootToDexUtils.fitsSigned32(literal)) {
            return new Insn31i(Opcode.CONST_WIDE_32, this.destinationReg, (int)literal);
        }
        return new Insn51l(Opcode.CONST_WIDE, this.destinationReg, literal);
    }

    @Override
    public void caseDoubleConstant(DoubleConstant d) {
        long longBits = Double.doubleToLongBits(d.value);
        this.stmtV.addInsn(this.buildConstWideInsn(longBits));
    }

    @Override
    public void caseFloatConstant(FloatConstant f) {
        int intBits = Float.floatToIntBits(f.value);
        this.stmtV.addInsn(this.buildConstInsn(intBits));
    }

    private Insn buildConstInsn(int literal) {
        if (SootToDexUtils.fitsSigned4(literal)) {
            return new Insn11n(Opcode.CONST_4, this.destinationReg, (byte)literal);
        }
        if (SootToDexUtils.fitsSigned16(literal)) {
            return new Insn21s(Opcode.CONST_16, this.destinationReg, (short)literal);
        }
        return new Insn31i(Opcode.CONST, this.destinationReg, literal);
    }

    @Override
    public void caseIntConstant(IntConstant i) {
        this.stmtV.addInsn(this.buildConstInsn(i.value));
    }

    @Override
    public void caseNullConstant(NullConstant v) {
        this.stmtV.addInsn(this.buildConstInsn(0));
    }
}

