/*
 * Decompiled with CFR 0.152.
 */
package soot.toDex;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.jf.dexlib.ClassDataItem;
import org.jf.dexlib.ClassDefItem;
import org.jf.dexlib.Code.Instruction;
import org.jf.dexlib.CodeItem;
import org.jf.dexlib.DexFile;
import org.jf.dexlib.FieldIdItem;
import org.jf.dexlib.MethodIdItem;
import org.jf.dexlib.ProtoIdItem;
import org.jf.dexlib.StringIdItem;
import org.jf.dexlib.TypeIdItem;
import org.jf.dexlib.TypeListItem;
import org.jf.dexlib.Util.ByteArrayAnnotatedOutput;
import org.jf.dexlib.Util.Pair;
import soot.Body;
import soot.CompilationDeathException;
import soot.G;
import soot.PatchingChain;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.SootMethodRef;
import soot.SourceLocator;
import soot.Trap;
import soot.Type;
import soot.Unit;
import soot.jimple.Stmt;
import soot.toDex.SootToDexUtils;
import soot.toDex.StmtVisitor;

public class DexPrinter {
    private static final String CLASSES_DEX = "classes.dex";
    private DexFile dexFile = new DexFile();
    private File originalApk;

    private void printApk(String outputDir, File originalApk) throws IOException {
        String outputFileName = outputDir + File.separatorChar + originalApk.getName();
        File outputFile = new File(outputFileName);
        ZipOutputStream outputApk = new ZipOutputStream(new FileOutputStream(outputFile));
        G.v().out.println("Writing APK to: " + outputFileName);
        G.v().out.println("do not forget to sign the .apk file with jarsigner and to align it with zipalign");
        ZipFile original = new ZipFile(originalApk);
        this.copyAllButClassesDexAndSigFiles(original, outputApk);
        original.close();
        outputApk.putNextEntry(new ZipEntry(CLASSES_DEX));
        this.writeTo(outputApk);
        outputApk.closeEntry();
        outputApk.close();
    }

    private void copyAllButClassesDexAndSigFiles(ZipFile source, ZipOutputStream destination) throws IOException {
        Enumeration<? extends ZipEntry> sourceEntries = source.entries();
        while (sourceEntries.hasMoreElements()) {
            ZipEntry sourceEntry = sourceEntries.nextElement();
            String sourceEntryName = sourceEntry.getName();
            if (sourceEntryName.equals(CLASSES_DEX) || DexPrinter.isSignatureFile(sourceEntryName)) continue;
            ZipEntry destinationEntry = new ZipEntry(sourceEntryName);
            destinationEntry.setMethod(sourceEntry.getMethod());
            destinationEntry.setSize(sourceEntry.getSize());
            destinationEntry.setCrc(sourceEntry.getCrc());
            destination.putNextEntry(destinationEntry);
            InputStream zipEntryInput = source.getInputStream(sourceEntry);
            byte[] buffer = new byte[2048];
            int bytesRead = zipEntryInput.read(buffer);
            while (bytesRead > 0) {
                destination.write(buffer, 0, bytesRead);
                bytesRead = zipEntryInput.read(buffer);
            }
        }
    }

    private static boolean isSignatureFile(String fileName) {
        StringBuilder sigFileRegex = new StringBuilder();
        sigFileRegex.append("META\\-INF");
        sigFileRegex.append('/');
        sigFileRegex.append("[^/]+");
        sigFileRegex.append("(\\.SF|\\.DSA|\\.RSA|\\.EC)$");
        return fileName.matches(sigFileRegex.toString());
    }

    private void writeTo(OutputStream outputStream) throws IOException {
        this.dexFile.place();
        byte[] outArray = new byte[this.dexFile.getFileSize()];
        ByteArrayAnnotatedOutput outBytes = new ByteArrayAnnotatedOutput(outArray);
        this.dexFile.writeTo(outBytes);
        DexFile.calcSignature(outArray);
        DexFile.calcChecksum(outArray);
        outputStream.write(outArray);
        outputStream.flush();
    }

    private void addAsClassDefItem(SootClass c) {
        TypeIdItem classType = DexPrinter.toTypeIdItem(c.getType(), this.dexFile);
        int accessFlags = c.getModifiers();
        TypeIdItem superType = c.hasSuperclass() ? DexPrinter.toTypeIdItem(c.getSuperclass().getType(), this.dexFile) : null;
        ArrayList<Type> interfaceTypes = new ArrayList<Type>(c.getInterfaceCount());
        for (SootClass implementedInterface : c.getInterfaces()) {
            interfaceTypes.add(implementedInterface.getType());
        }
        TypeListItem implementedInterfaces = DexPrinter.toTypeListItem(interfaceTypes, this.dexFile);
        ClassDataItem classData = DexPrinter.toClassDataItem(c, this.dexFile);
        ClassDefItem.internClassDefItem(this.dexFile, classType, accessFlags, superType, implementedInterfaces, null, null, classData, null);
    }

    private static ClassDataItem toClassDataItem(SootClass c, DexFile belongingDexFile) {
        Pair<List<ClassDataItem.EncodedField>, List<ClassDataItem.EncodedField>> fields = DexPrinter.toFields(c.getFields(), belongingDexFile);
        Pair<List<ClassDataItem.EncodedMethod>, List<ClassDataItem.EncodedMethod>> methods = DexPrinter.toMethods(c.getMethods(), belongingDexFile);
        return ClassDataItem.internClassDataItem(belongingDexFile, (List)fields.first, (List)fields.second, (List)methods.first, (List)methods.second);
    }

    private static Pair<List<ClassDataItem.EncodedField>, List<ClassDataItem.EncodedField>> toFields(Collection<SootField> sootFields, DexFile belongingDexFile) {
        ArrayList<ClassDataItem.EncodedField> staticFields = new ArrayList<ClassDataItem.EncodedField>();
        ArrayList<ClassDataItem.EncodedField> instanceFields = new ArrayList<ClassDataItem.EncodedField>();
        Pair<List<ClassDataItem.EncodedField>, List<ClassDataItem.EncodedField>> fields = new Pair<List<ClassDataItem.EncodedField>, List<ClassDataItem.EncodedField>>(staticFields, instanceFields);
        for (SootField f : sootFields) {
            if (f.isPhantom()) continue;
            FieldIdItem fieldIdItem = DexPrinter.toFieldIdItem(f, belongingDexFile);
            int accessFlags = f.getModifiers();
            ClassDataItem.EncodedField ef = new ClassDataItem.EncodedField(fieldIdItem, accessFlags);
            if (f.isStatic()) {
                staticFields.add(ef);
                continue;
            }
            instanceFields.add(ef);
        }
        return fields;
    }

    private static Pair<List<ClassDataItem.EncodedMethod>, List<ClassDataItem.EncodedMethod>> toMethods(Collection<SootMethod> sootMethods, DexFile belongingDexFile) {
        ArrayList<ClassDataItem.EncodedMethod> directMethods = new ArrayList<ClassDataItem.EncodedMethod>();
        ArrayList<ClassDataItem.EncodedMethod> virtualMethods = new ArrayList<ClassDataItem.EncodedMethod>();
        Pair<List<ClassDataItem.EncodedMethod>, List<ClassDataItem.EncodedMethod>> methods = new Pair<List<ClassDataItem.EncodedMethod>, List<ClassDataItem.EncodedMethod>>(directMethods, virtualMethods);
        for (SootMethod m : sootMethods) {
            CodeItem codeItem;
            int accessFlags;
            if (m.isPhantom()) continue;
            MethodIdItem methodIdItem = DexPrinter.toMethodIdItem(m.makeRef(), belongingDexFile);
            ClassDataItem.EncodedMethod eM = new ClassDataItem.EncodedMethod(methodIdItem, accessFlags = SootToDexUtils.getDexAccessFlags(m), codeItem = DexPrinter.toCodeItem(m, belongingDexFile));
            if (eM.isDirect()) {
                directMethods.add(eM);
                continue;
            }
            virtualMethods.add(eM);
        }
        return methods;
    }

    private static TypeListItem toTypeListItem(List<Type> types, DexFile belongingDexFile) {
        ArrayList<TypeIdItem> typeItems = new ArrayList<TypeIdItem>(types.size());
        for (Type t : types) {
            typeItems.add(DexPrinter.toTypeIdItem(t, belongingDexFile));
        }
        return TypeListItem.internTypeListItem(belongingDexFile, typeItems);
    }

    protected static FieldIdItem toFieldIdItem(SootField f, DexFile belongingDexFile) {
        TypeIdItem declaringClassType = DexPrinter.toTypeIdItem(f.getDeclaringClass().getType(), belongingDexFile);
        TypeIdItem fieldType = DexPrinter.toTypeIdItem(f.getType(), belongingDexFile);
        StringIdItem fieldName = StringIdItem.internStringIdItem(belongingDexFile, f.getName());
        return FieldIdItem.internFieldIdItem(belongingDexFile, declaringClassType, fieldType, fieldName);
    }

    protected static MethodIdItem toMethodIdItem(SootMethodRef m, DexFile belongingDexFile) {
        TypeIdItem declaringClassType = DexPrinter.toTypeIdItem(m.declaringClass().getType(), belongingDexFile);
        ProtoIdItem methodType = DexPrinter.toProtoIdItem(m, belongingDexFile);
        StringIdItem methodName = StringIdItem.internStringIdItem(belongingDexFile, m.name());
        return MethodIdItem.internMethodIdItem(belongingDexFile, declaringClassType, methodType, methodName);
    }

    private static ProtoIdItem toProtoIdItem(SootMethodRef m, DexFile belongingDexFile) {
        TypeIdItem returnType = DexPrinter.toTypeIdItem(m.returnType(), belongingDexFile);
        List parameterTypes = m.parameterTypes();
        TypeListItem parameters = DexPrinter.toTypeListItem(parameterTypes, belongingDexFile);
        return ProtoIdItem.internProtoIdItem(belongingDexFile, returnType, parameters);
    }

    protected static TypeIdItem toTypeIdItem(Type sootType, DexFile belongingDexFile) {
        String dexTypeDescriptor = SootToDexUtils.getDexTypeDescriptor(sootType);
        StringIdItem dexDescriptor = StringIdItem.internStringIdItem(belongingDexFile, dexTypeDescriptor);
        return TypeIdItem.internTypeIdItem(belongingDexFile, dexDescriptor);
    }

    private static CodeItem toCodeItem(SootMethod m, DexFile belongingDexFile) {
        if (m.isAbstract() || m.isNative()) {
            return null;
        }
        Body activeBody = m.getActiveBody();
        int inWords = SootToDexUtils.getDexWords(m.getParameterTypes());
        if (!m.isStatic()) {
            ++inWords;
        }
        PatchingChain<Unit> units = activeBody.getUnits();
        int outWords = SootToDexUtils.getOutWordCount(units);
        StmtVisitor stmtV = new StmtVisitor(m, belongingDexFile);
        List<Instruction> instructions = DexPrinter.toInstructions(units, stmtV);
        int registerCount = stmtV.getRegisterCount();
        if (inWords > registerCount) {
            registerCount = inWords;
        }
        ArrayList<CodeItem.EncodedCatchHandler> encodedCatchHandlers = new ArrayList<CodeItem.EncodedCatchHandler>();
        List<CodeItem.TryItem> tries = DexPrinter.toTries(activeBody.getTraps(), encodedCatchHandlers, stmtV, belongingDexFile);
        return CodeItem.internCodeItem(belongingDexFile, registerCount, inWords, outWords, null, instructions, tries, encodedCatchHandlers);
    }

    private static List<Instruction> toInstructions(Collection<Unit> units, StmtVisitor stmtV) {
        for (Unit u : units) {
            stmtV.beginNewStmt((Stmt)u);
            u.apply(stmtV);
        }
        return stmtV.getFinalInsns();
    }

    private static List<CodeItem.TryItem> toTries(Collection<Trap> traps, List<CodeItem.EncodedCatchHandler> encodedCatchHandlers, StmtVisitor stmtV, DexFile belongingDexFile) {
        HashMap<Integer, CodeItem.TryItem> codeRangesToTryItem = new HashMap<Integer, CodeItem.TryItem>();
        for (Trap t : traps) {
            CodeItem.EncodedTypeAddrPair[] handlersInfo;
            CodeItem.EncodedTypeAddrPair newHandlerInfo = DexPrinter.createNewHandlerInfo(t, stmtV, belongingDexFile);
            Stmt beginStmt = (Stmt)t.getBeginUnit();
            Stmt endStmt = (Stmt)t.getEndUnit();
            int startCodeAddress = stmtV.getOffset(beginStmt);
            int tryLength = stmtV.getOffset(endStmt) - startCodeAddress;
            if (codeRangesToTryItem.containsKey(startCodeAddress)) {
                CodeItem.TryItem oldTryItem = (CodeItem.TryItem)codeRangesToTryItem.get(startCodeAddress);
                handlersInfo = DexPrinter.addNewHandlerInfo(newHandlerInfo, oldTryItem.encodedCatchHandler.handlers);
            } else {
                handlersInfo = new CodeItem.EncodedTypeAddrPair[]{newHandlerInfo};
            }
            int catchAllHandlerAddress = -1;
            CodeItem.EncodedCatchHandler handler = new CodeItem.EncodedCatchHandler(handlersInfo, catchAllHandlerAddress);
            encodedCatchHandlers.add(handler);
            CodeItem.TryItem newTryItem = new CodeItem.TryItem(startCodeAddress, tryLength, handler);
            codeRangesToTryItem.put(startCodeAddress, newTryItem);
        }
        return DexPrinter.toSortedTries(codeRangesToTryItem.values());
    }

    private static CodeItem.EncodedTypeAddrPair createNewHandlerInfo(Trap t, StmtVisitor stmtV, DexFile belongingDexFile) {
        Stmt handlerStmt = (Stmt)t.getHandlerUnit();
        int handlerAddress = stmtV.getOffset(handlerStmt);
        TypeIdItem exceptionTypeIdItem = DexPrinter.toTypeIdItem(t.getException().getType(), belongingDexFile);
        return new CodeItem.EncodedTypeAddrPair(exceptionTypeIdItem, handlerAddress);
    }

    private static CodeItem.EncodedTypeAddrPair[] addNewHandlerInfo(CodeItem.EncodedTypeAddrPair newHandler, CodeItem.EncodedTypeAddrPair[] oldHandlers) {
        int oldHandlersSize = oldHandlers.length;
        CodeItem.EncodedTypeAddrPair[] newHandlers = new CodeItem.EncodedTypeAddrPair[oldHandlersSize + 1];
        System.arraycopy(oldHandlers, 0, newHandlers, 0, oldHandlersSize);
        newHandlers[newHandlers.length - 1] = newHandler;
        return newHandlers;
    }

    private static List<CodeItem.TryItem> toSortedTries(Collection<CodeItem.TryItem> unsortedTries) {
        ArrayList<CodeItem.TryItem> tries = new ArrayList<CodeItem.TryItem>(unsortedTries);
        Collections.sort(tries, new Comparator<CodeItem.TryItem>(){

            @Override
            public int compare(CodeItem.TryItem a, CodeItem.TryItem b) {
                int addressA = a.getStartCodeAddress();
                int addressB = b.getStartCodeAddress();
                return addressA - addressB;
            }
        });
        return tries;
    }

    public void add(SootClass c) {
        if (c.isPhantom()) {
            return;
        }
        this.addAsClassDefItem(c);
        Map<String, File> dexClassIndex = SourceLocator.v().dexClassIndex();
        if (dexClassIndex == null) {
            return;
        }
        File sourceForClass = dexClassIndex.get(c.getName());
        if (sourceForClass == null || sourceForClass.getName().endsWith(".dex")) {
            return;
        }
        if (this.originalApk != null && !this.originalApk.equals(sourceForClass)) {
            throw new CompilationDeathException("multiple APKs as source of an application are not supported");
        }
        this.originalApk = sourceForClass;
    }

    public void print() {
        this.assertClassesAdded();
        String outputDir = SourceLocator.v().getOutputDir();
        try {
            if (this.originalApk != null) {
                this.printApk(outputDir, this.originalApk);
            } else {
                String fileName = outputDir + File.separatorChar + CLASSES_DEX;
                G.v().out.println("Writing dex to: " + fileName);
                FileOutputStream outputStream = new FileOutputStream(fileName);
                this.writeTo(outputStream);
                ((OutputStream)outputStream).close();
            }
        }
        catch (IOException e) {
            throw new CompilationDeathException("I/O exception while printing dex", e);
        }
    }

    private void assertClassesAdded() {
        List classes = this.dexFile.ClassDefsSection.getItems();
        if (classes.isEmpty()) {
            throw new IllegalStateException("there were no classes added");
        }
    }
}

