/*
 * Decompiled with CFR 0.152.
 */
package soot.toDex;

import java.util.HashMap;
import java.util.Map;
import soot.Local;
import soot.Type;
import soot.Value;
import soot.jimple.Constant;
import soot.jimple.internal.JimpleLocal;
import soot.toDex.ConstantVisitor;
import soot.toDex.Register;
import soot.toDex.SootToDexUtils;

public class RegisterAllocator {
    private int nextRegNum;
    private Map<String, Integer> localToLastRegNum = new HashMap<String, Integer>();
    private int paramRegCount;

    private Register asConstant(Value v, ConstantVisitor constantV) {
        Constant c = (Constant)v;
        Register constantRegister = new Register(c.getType(), this.nextRegNum);
        this.nextRegNum += SootToDexUtils.getDexWords(c.getType());
        constantV.setDestination(constantRegister);
        c.apply(constantV);
        return constantRegister.clone();
    }

    public Register asLocal(Value v) {
        Register localRegister;
        Local l = (Local)v;
        String localName = l.getName();
        if (this.localToLastRegNum.containsKey(localName)) {
            int oldRegNum = this.localToLastRegNum.get(localName);
            localRegister = new Register(l.getType(), oldRegNum);
        } else {
            localRegister = new Register(l.getType(), this.nextRegNum);
            this.localToLastRegNum.put(localName, this.nextRegNum);
            this.nextRegNum += SootToDexUtils.getDexWords(l.getType());
        }
        return localRegister;
    }

    public void asParameter(Local l) {
        this.localToLastRegNum.put(l.getName(), this.nextRegNum);
        int wordsforParameters = SootToDexUtils.getDexWords(l.getType());
        this.nextRegNum += wordsforParameters;
        this.paramRegCount += wordsforParameters;
    }

    public Register asImmediate(Value v, ConstantVisitor constantV) {
        if (v instanceof Constant) {
            return this.asConstant(v, constantV);
        }
        if (v instanceof Local) {
            return this.asLocal(v);
        }
        throw new RuntimeException("expected Immediate (Constant or Local), but was: " + v.getClass());
    }

    public Register asTmpReg(Type regType) {
        String tmpRegName = "tmp" + this.getRegCount();
        return this.asLocal(new JimpleLocal(tmpRegName, regType));
    }

    public void increaseRegCount(int amount) {
        this.nextRegNum += amount;
    }

    public int getParamRegCount() {
        return this.paramRegCount;
    }

    public int getRegCount() {
        return this.nextRegNum;
    }
}

