/*
 * Decompiled with CFR 0.152.
 */
package soot.toDex;

import java.util.BitSet;
import java.util.List;
import java.util.ListIterator;
import org.jf.dexlib.Code.Opcode;
import soot.toDex.Register;
import soot.toDex.RegisterAllocator;
import soot.toDex.SootToDexUtils;
import soot.toDex.StmtVisitor;
import soot.toDex.instructions.AddressInsn;
import soot.toDex.instructions.Insn;
import soot.toDex.instructions.Insn11n;
import soot.toDex.instructions.Insn21s;
import soot.toDex.instructions.Insn23x;
import soot.toDex.instructions.TwoRegInsn;

public class RegisterAssigner {
    private RegisterAllocator regAlloc;

    public RegisterAssigner(RegisterAllocator regAlloc) {
        this.regAlloc = regAlloc;
    }

    public List<Insn> finishRegs(List<Insn> insns) {
        this.renumParamRegsToHigh(insns);
        this.reserveRegisters(insns);
        ListIterator<Insn> insnIter = insns.listIterator();
        while (insnIter.hasNext()) {
            Insn oldInsn = insnIter.next();
            if (!oldInsn.hasIncompatibleRegs()) continue;
            Insn fittingInsn = this.findFittingInsn(oldInsn);
            if (fittingInsn != null) {
                insnIter.set(fittingInsn);
                continue;
            }
            this.fixIncompatRegs(oldInsn, insnIter);
        }
        return insns;
    }

    private void renumParamRegsToHigh(List<Insn> insns) {
        int regCount = this.regAlloc.getRegCount();
        int paramRegCount = this.regAlloc.getParamRegCount();
        if (paramRegCount == 0 || paramRegCount == regCount) {
            return;
        }
        for (Insn insn : insns) {
            for (Register r : insn.getRegs()) {
                this.renumParamRegToHigh(r, regCount, paramRegCount);
            }
        }
    }

    private void renumParamRegToHigh(Register r, int regCount, int paramRegCount) {
        int oldNum = r.getNumber();
        if (oldNum >= paramRegCount) {
            int newNormalRegNum = oldNum - paramRegCount;
            r.setNumber(newNormalRegNum);
        } else {
            int newParamRegNum = oldNum + regCount - paramRegCount;
            r.setNumber(newParamRegNum);
        }
    }

    private void reserveRegisters(List<Insn> insns) {
        int regsNeeded;
        int regsToReserve;
        int reservedRegs = 0;
        while ((regsToReserve = (regsNeeded = this.getRegsNeeded(reservedRegs, insns)) - reservedRegs) > 0) {
            this.regAlloc.increaseRegCount(regsToReserve);
            for (Insn insn : insns) {
                this.shiftRegs(insn, regsToReserve);
            }
            reservedRegs += regsToReserve;
        }
    }

    private int getRegsNeeded(int regsAlreadyReserved, List<Insn> insns) {
        int regsNeeded = regsAlreadyReserved;
        for (int i = 0; i < insns.size(); ++i) {
            Insn insn = insns.get(i);
            if (insn instanceof AddressInsn) continue;
            Insn fittingInsn = this.findFittingInsn(insn);
            if (fittingInsn != null) {
                insns.set(i, fittingInsn);
                continue;
            }
            int newRegsNeeded = insn.getMinimumRegsNeeded();
            if (newRegsNeeded <= regsNeeded) continue;
            regsNeeded = newRegsNeeded;
        }
        return regsNeeded;
    }

    private void shiftRegs(Insn insn, int shiftAmount) {
        for (Register r : insn.getRegs()) {
            r.setNumber(r.getNumber() + shiftAmount);
        }
    }

    private void fixIncompatRegs(Insn insn, ListIterator<Insn> allInsns) {
        List<Register> regs = insn.getRegs();
        BitSet incompatRegs = insn.getIncompatibleRegs();
        Register resultReg = regs.get(0);
        boolean hasResultReg = insn.getOpcode().setsRegister();
        boolean isResultRegIncompat = incompatRegs.get(0);
        if (hasResultReg && isResultRegIncompat && !insn.getOpcode().name.endsWith("/2addr")) {
            incompatRegs.clear(0);
        }
        if (incompatRegs.cardinality() > 0) {
            this.addMovesForIncompatRegs(allInsns, regs, incompatRegs);
        }
        if (hasResultReg && isResultRegIncompat) {
            Register resultRegClone = resultReg.clone();
            this.addMoveForIncompatResultReg(allInsns, resultRegClone, resultReg);
        }
    }

    private void addMoveForIncompatResultReg(ListIterator<Insn> insns, Register destReg, Register origResultReg) {
        if (destReg.getNumber() == 0) {
            return;
        }
        origResultReg.setNumber(0);
        Register sourceReg = new Register(destReg.getType(), 0);
        Insn extraMove = StmtVisitor.buildMoveInsn(destReg, sourceReg);
        insns.add(extraMove);
    }

    private void addMovesForIncompatRegs(ListIterator<Insn> insns, List<Register> regs, BitSet incompatRegs) {
        insns.previous();
        int nextNewDestination = 0;
        for (int regIdx = 0; regIdx < regs.size(); ++regIdx) {
            Register incompatReg;
            if (!incompatRegs.get(regIdx) || (incompatReg = regs.get(regIdx)).isEmptyReg()) continue;
            Register source = incompatReg.clone();
            Register destination = new Register(source.getType(), nextNewDestination);
            nextNewDestination += SootToDexUtils.getDexWords(source.getType());
            if (source.getNumber() == destination.getNumber()) continue;
            Insn extraMove = StmtVisitor.buildMoveInsn(destination, source);
            insns.add(extraMove);
            incompatReg.setNumber(destination.getNumber());
        }
        insns.next();
    }

    private Insn findFittingInsn(Insn insn) {
        if (!insn.hasIncompatibleRegs()) {
            return null;
        }
        Opcode opc = insn.getOpcode();
        if (insn instanceof Insn11n && opc.equals((Object)Opcode.CONST_4)) {
            Insn11n unfittingInsn = (Insn11n)insn;
            if (unfittingInsn.getRegA().fitsShort()) {
                return new Insn21s(Opcode.CONST_16, unfittingInsn.getRegA(), unfittingInsn.getLitB());
            }
        } else if (insn instanceof TwoRegInsn && opc.name.endsWith("/2addr")) {
            Register regA = ((TwoRegInsn)insn).getRegA();
            Register regB = ((TwoRegInsn)insn).getRegB();
            if (regA.fitsShort() && regB.fitsShort()) {
                int oldOpcLength = opc.name.length();
                String newOpcName = opc.name.substring(0, oldOpcLength - 6);
                Opcode newOpc = Opcode.getOpcodeByName(newOpcName);
                Register regAClone = regA.clone();
                return new Insn23x(newOpc, regA, regAClone, regB);
            }
        } else if (insn instanceof TwoRegInsn && SootToDexUtils.isNormalMove(opc)) {
            Register regA = ((TwoRegInsn)insn).getRegA();
            Register regB = ((TwoRegInsn)insn).getRegB();
            if (regA.getNumber() != regB.getNumber()) {
                return StmtVisitor.buildMoveInsn(regA, regB);
            }
        }
        return null;
    }
}

