/*
 * Decompiled with CFR 0.152.
 */
package soot.toDex;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.jf.dexlib.Code.Instruction;
import org.jf.dexlib.Code.Opcode;
import org.jf.dexlib.DexFile;
import org.jf.dexlib.FieldIdItem;
import soot.ArrayType;
import soot.Local;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.Type;
import soot.Value;
import soot.jimple.ArrayRef;
import soot.jimple.AssignStmt;
import soot.jimple.BreakpointStmt;
import soot.jimple.CaughtExceptionRef;
import soot.jimple.ConcreteRef;
import soot.jimple.Constant;
import soot.jimple.EnterMonitorStmt;
import soot.jimple.ExitMonitorStmt;
import soot.jimple.GotoStmt;
import soot.jimple.IdentityStmt;
import soot.jimple.IfStmt;
import soot.jimple.InstanceFieldRef;
import soot.jimple.IntConstant;
import soot.jimple.InvokeExpr;
import soot.jimple.InvokeStmt;
import soot.jimple.LookupSwitchStmt;
import soot.jimple.MonitorStmt;
import soot.jimple.NopStmt;
import soot.jimple.ParameterRef;
import soot.jimple.RetStmt;
import soot.jimple.ReturnStmt;
import soot.jimple.ReturnVoidStmt;
import soot.jimple.StaticFieldRef;
import soot.jimple.Stmt;
import soot.jimple.StmtSwitch;
import soot.jimple.TableSwitchStmt;
import soot.jimple.ThisRef;
import soot.jimple.ThrowStmt;
import soot.toDex.ConstantVisitor;
import soot.toDex.DexPrinter;
import soot.toDex.ExprVisitor;
import soot.toDex.Register;
import soot.toDex.RegisterAllocator;
import soot.toDex.RegisterAssigner;
import soot.toDex.SootToDexUtils;
import soot.toDex.instructions.AddressInsn;
import soot.toDex.instructions.Insn;
import soot.toDex.instructions.Insn10t;
import soot.toDex.instructions.Insn10x;
import soot.toDex.instructions.Insn11x;
import soot.toDex.instructions.Insn12x;
import soot.toDex.instructions.Insn20t;
import soot.toDex.instructions.Insn21c;
import soot.toDex.instructions.Insn21t;
import soot.toDex.instructions.Insn22c;
import soot.toDex.instructions.Insn22t;
import soot.toDex.instructions.Insn22x;
import soot.toDex.instructions.Insn23x;
import soot.toDex.instructions.Insn30t;
import soot.toDex.instructions.Insn31t;
import soot.toDex.instructions.Insn32x;
import soot.toDex.instructions.InsnWithOffset;
import soot.toDex.instructions.PackedSwitchPayload;
import soot.toDex.instructions.SparseSwitchPayload;
import soot.toDex.instructions.SwitchPayload;

public class StmtVisitor
implements StmtSwitch {
    private static final Map<Opcode, Opcode> oppositeIfs = new HashMap<Opcode, Opcode>();
    private SootMethod belongingMethod;
    private DexFile belongingFile;
    private ConstantVisitor constantV;
    private RegisterAllocator regAlloc;
    private ExprVisitor exprV;
    private String lastReturnTypeDescriptor;
    private List<Insn> insns;
    private List<SwitchPayload> switchPayloads;

    public StmtVisitor(SootMethod belongingMethod, DexFile belongingFile) {
        this.belongingMethod = belongingMethod;
        this.belongingFile = belongingFile;
        this.constantV = new ConstantVisitor(this);
        this.regAlloc = new RegisterAllocator();
        this.exprV = new ExprVisitor(this, this.constantV, this.regAlloc);
        this.insns = new ArrayList<Insn>();
        this.switchPayloads = new ArrayList<SwitchPayload>();
    }

    protected void setLastReturnTypeDescriptor(String typeDescriptor) {
        this.lastReturnTypeDescriptor = typeDescriptor;
    }

    protected DexFile getBelongingFile() {
        return this.belongingFile;
    }

    protected SootClass getBelongingClass() {
        return this.belongingMethod.getDeclaringClass();
    }

    protected void addInsn(Insn insn) {
        int highestIndex = this.insns.size();
        this.addInsn(highestIndex, insn);
    }

    private void addInsn(int positionInList, Insn insn) {
        this.insns.add(positionInList, insn);
    }

    protected int getOffset(Stmt stmt) {
        return SootToDexUtils.getOffset(stmt, this.insns);
    }

    protected void beginNewStmt(Stmt s) {
        this.addInsn(new AddressInsn(s));
    }

    private void setTargets() {
        for (Insn insn : this.insns) {
            if (!(insn instanceof InsnWithOffset)) continue;
            ((InsnWithOffset)insn).setOffsetAddress(this.insns);
        }
    }

    public List<Instruction> getFinalInsns() {
        this.addSwitchPayloads();
        this.updateOffsets();
        this.finishRegs();
        this.finishTargets();
        return this.getRealInsns();
    }

    private void updateOffsets() {
        int nextOffset = 0;
        for (Insn i : this.insns) {
            i.setInsnOffset(nextOffset);
            nextOffset += i.getSize();
        }
        this.setTargets();
    }

    private void addSwitchPayloads() {
        for (SwitchPayload payload : this.switchPayloads) {
            this.addInsn(new AddressInsn(payload));
            this.addInsn(payload);
        }
    }

    private List<Instruction> getRealInsns() {
        ArrayList<Instruction> finalInsns = new ArrayList<Instruction>();
        for (Insn i : this.insns) {
            if (i instanceof AddressInsn) continue;
            Instruction realInsn = i.getRealInsn();
            finalInsns.add(realInsn);
        }
        return finalInsns;
    }

    private void finishRegs() {
        RegisterAssigner regAssigner = new RegisterAssigner(this.regAlloc);
        this.insns = regAssigner.finishRegs(this.insns);
    }

    private void finishTargets() {
        do {
            this.updateOffsets();
        } while (this.patchTargets());
    }

    private boolean patchTargets() {
        boolean hadToPatch = false;
        int size = this.insns.size();
        for (int i = 0; i < size; ++i) {
            InsnWithOffset curInsn;
            Insn insn = this.insns.get(i);
            if (!(insn instanceof InsnWithOffset) || (curInsn = (InsnWithOffset)insn).offsetFit()) continue;
            if (curInsn.getOpcode().name.startsWith("goto")) {
                InsnWithOffset patchedGoto = this.patchGoto(curInsn);
                this.insns.set(i, patchedGoto);
                hadToPatch = true;
                continue;
            }
            if (curInsn.getOpcode().name.startsWith("if-")) {
                this.reverseIfAndAddGoto(curInsn, i);
                ++size;
                ++i;
                hadToPatch = true;
                continue;
            }
            throw new Error("cannot fix targets of instruction " + curInsn);
        }
        return hadToPatch;
    }

    private InsnWithOffset patchGoto(InsnWithOffset gotoInsn) {
        InsnWithOffset patchedGoto;
        int curInsnOffset = gotoInsn.getInsnOffset();
        if (SootToDexUtils.fitsSigned16(curInsnOffset)) {
            patchedGoto = new Insn20t(Opcode.GOTO_16);
        } else if (SootToDexUtils.fitsSigned32(curInsnOffset)) {
            patchedGoto = new Insn30t(Opcode.GOTO_32);
        } else {
            throw new Error("a goto target does not fit into 32 bit - this means that the method has too many instructions");
        }
        patchedGoto.setInsnOffset(curInsnOffset);
        patchedGoto.setOffset(gotoInsn.getOffset());
        return patchedGoto;
    }

    private void reverseIfAndAddGoto(InsnWithOffset oldIfInsn, int insnIndex) {
        InsnWithOffset reversedIf = this.reverseIf(oldIfInsn);
        AddressInsn newIfTarget = this.getNextTarget(insnIndex + 1);
        reversedIf.setOffset(newIfTarget.getOriginalSource());
        this.insns.set(insnIndex, reversedIf);
        Insn10t newGoto = new Insn10t(Opcode.GOTO);
        newGoto.setOffset(oldIfInsn.getOffset());
        this.insns.add(insnIndex + 1, newGoto);
    }

    private InsnWithOffset reverseIf(InsnWithOffset ifInsn) {
        Opcode oldOpc = ifInsn.getOpcode();
        Opcode reversedOpc = oppositeIfs.get((Object)oldOpc);
        if (oldOpc.name.endsWith("z")) {
            Insn21t oldIfz = (Insn21t)ifInsn;
            return new Insn21t(reversedOpc, oldIfz.getRegA());
        }
        Insn22t oldIf = (Insn22t)ifInsn;
        return new Insn22t(reversedOpc, oldIf.getRegA(), oldIf.getRegB());
    }

    private AddressInsn getNextTarget(int startIndex) {
        int insnIndex = startIndex;
        Insn potentialTarget = this.insns.get(insnIndex);
        while (!(potentialTarget instanceof AddressInsn)) {
            if (++insnIndex >= this.insns.size()) {
                throw new RuntimeException("no next target found");
            }
            potentialTarget = this.insns.get(insnIndex);
        }
        return (AddressInsn)potentialTarget;
    }

    protected int getRegisterCount() {
        return this.regAlloc.getRegCount();
    }

    @Override
    public void defaultCase(Object o) {
        throw new Error("unknown Object (" + o.getClass() + ") as Stmt: " + o);
    }

    @Override
    public void caseBreakpointStmt(BreakpointStmt stmt) {
    }

    @Override
    public void caseNopStmt(NopStmt stmt) {
        this.addInsn(new Insn10x(Opcode.NOP));
    }

    @Override
    public void caseRetStmt(RetStmt stmt) {
        throw new Error("ret statements are deprecated!");
    }

    @Override
    public void caseEnterMonitorStmt(EnterMonitorStmt stmt) {
        this.addInsn(this.buildMonitorInsn(stmt, Opcode.MONITOR_ENTER));
    }

    @Override
    public void caseExitMonitorStmt(ExitMonitorStmt stmt) {
        this.addInsn(this.buildMonitorInsn(stmt, Opcode.MONITOR_EXIT));
    }

    private Insn buildMonitorInsn(MonitorStmt stmt, Opcode opc) {
        Value lockValue = stmt.getOp();
        Register lockReg = this.regAlloc.asLocal(lockValue);
        return new Insn11x(opc, lockReg);
    }

    @Override
    public void caseThrowStmt(ThrowStmt stmt) {
        Value exception = stmt.getOp();
        Register exceptionReg = this.regAlloc.asImmediate(exception, this.constantV);
        this.addInsn(new Insn11x(Opcode.THROW, exceptionReg));
    }

    @Override
    public void caseAssignStmt(AssignStmt stmt) {
        Value lhs = stmt.getLeftOp();
        if (lhs instanceof ConcreteRef) {
            Value source = stmt.getRightOp();
            this.addInsn(this.buildPutInsn((ConcreteRef)lhs, source));
            return;
        }
        if (!(lhs instanceof Local)) {
            throw new Error("left-hand side of AssignStmt is not a Local: " + lhs.getClass());
        }
        Register lhsReg = this.regAlloc.asLocal(lhs);
        Value rhs = stmt.getRightOp();
        if (rhs instanceof Local) {
            String rhsName;
            String lhsName = ((Local)lhs).getName();
            if (lhsName.equals(rhsName = ((Local)rhs).getName())) {
                return;
            }
            Register sourceReg = this.regAlloc.asLocal(rhs);
            this.addInsn(StmtVisitor.buildMoveInsn(lhsReg, sourceReg));
        } else if (rhs instanceof Constant) {
            this.constantV.setDestination(lhsReg);
            rhs.apply(this.constantV);
        } else if (rhs instanceof ConcreteRef) {
            this.addInsn(this.buildGetInsn((ConcreteRef)rhs, lhsReg));
        } else {
            this.exprV.setDestinationReg(lhsReg);
            rhs.apply(this.exprV);
            if (rhs instanceof InvokeExpr) {
                Insn moveResultInsn = this.buildMoveResultInsn(lhsReg);
                int invokeInsnIndex = this.insns.indexOf(this.getLastInvokeInsn());
                this.addInsn(invokeInsnIndex + 1, moveResultInsn);
            }
        }
    }

    private Insn buildGetInsn(ConcreteRef sourceRef, Register destinationReg) {
        if (sourceRef instanceof StaticFieldRef) {
            return this.buildStaticFieldGetInsn(destinationReg, (StaticFieldRef)sourceRef);
        }
        if (sourceRef instanceof InstanceFieldRef) {
            return this.buildInstanceFieldGetInsn(destinationReg, (InstanceFieldRef)sourceRef);
        }
        if (sourceRef instanceof ArrayRef) {
            return this.buildArrayGetInsn(destinationReg, (ArrayRef)sourceRef);
        }
        throw new RuntimeException("unsupported type of ConcreteRef: " + sourceRef.getClass());
    }

    private Insn buildPutInsn(ConcreteRef destRef, Value source) {
        if (destRef instanceof StaticFieldRef) {
            return this.buildStaticFieldPutInsn((StaticFieldRef)destRef, source);
        }
        if (destRef instanceof InstanceFieldRef) {
            return this.buildInstanceFieldPutInsn((InstanceFieldRef)destRef, source);
        }
        if (destRef instanceof ArrayRef) {
            return this.buildArrayPutInsn((ArrayRef)destRef, source);
        }
        throw new RuntimeException("unsupported type of ConcreteRef: " + destRef.getClass());
    }

    protected static Insn buildMoveInsn(Register destinationReg, Register sourceReg) {
        String opcType = sourceReg.isObject() ? "move-object" : (sourceReg.isWide() ? "move-wide" : "move");
        if (!destinationReg.fitsShort()) {
            Opcode opc = Opcode.getOpcodeByName(opcType + "/16");
            return new Insn32x(opc, destinationReg, sourceReg);
        }
        if (!destinationReg.fitsByte() || !sourceReg.fitsByte()) {
            Opcode opc = Opcode.getOpcodeByName(opcType + "/from16");
            return new Insn22x(opc, destinationReg, sourceReg);
        }
        Opcode opc = Opcode.getOpcodeByName(opcType);
        return new Insn12x(opc, destinationReg, sourceReg);
    }

    private Insn buildStaticFieldPutInsn(StaticFieldRef destRef, Value source) {
        SootField destSootField = destRef.getField();
        FieldIdItem destField = DexPrinter.toFieldIdItem(destSootField, this.getBelongingFile());
        Register sourceReg = this.regAlloc.asImmediate(source, this.constantV);
        Opcode opc = this.getPutGetOpcodeWithTypeSuffix("sput", destField.getFieldType().getTypeDescriptor());
        return new Insn21c(opc, sourceReg, destField);
    }

    private Insn buildInstanceFieldPutInsn(InstanceFieldRef destRef, Value source) {
        SootField destSootField = destRef.getField();
        FieldIdItem destField = DexPrinter.toFieldIdItem(destSootField, this.getBelongingFile());
        Value instance = destRef.getBase();
        Register instanceReg = this.regAlloc.asLocal(instance);
        Register sourceReg = this.regAlloc.asImmediate(source, this.constantV);
        Opcode opc = this.getPutGetOpcodeWithTypeSuffix("iput", destField.getFieldType().getTypeDescriptor());
        return new Insn22c(opc, sourceReg, instanceReg, destField);
    }

    private Insn buildArrayPutInsn(ArrayRef destRef, Value source) {
        Value array = destRef.getBase();
        Register arrayReg = this.regAlloc.asLocal(array);
        Value index = destRef.getIndex();
        Register indexReg = this.regAlloc.asImmediate(index, this.constantV);
        Register sourceReg = this.regAlloc.asImmediate(source, this.constantV);
        String arrayTypeDescriptor = SootToDexUtils.getArrayTypeDescriptor((ArrayType)array.getType());
        Opcode opc = this.getPutGetOpcodeWithTypeSuffix("aput", arrayTypeDescriptor);
        return new Insn23x(opc, sourceReg, arrayReg, indexReg);
    }

    private Insn buildStaticFieldGetInsn(Register destinationReg, StaticFieldRef sourceRef) {
        SootField sourceSootField = sourceRef.getField();
        FieldIdItem sourceField = DexPrinter.toFieldIdItem(sourceSootField, this.getBelongingFile());
        Opcode opc = this.getPutGetOpcodeWithTypeSuffix("sget", sourceField.getFieldType().getTypeDescriptor());
        return new Insn21c(opc, destinationReg, sourceField);
    }

    private Insn buildInstanceFieldGetInsn(Register destinationReg, InstanceFieldRef sourceRef) {
        Value instance = sourceRef.getBase();
        Register instanceReg = this.regAlloc.asLocal(instance);
        SootField sourceSootField = sourceRef.getField();
        FieldIdItem sourceField = DexPrinter.toFieldIdItem(sourceSootField, this.getBelongingFile());
        Opcode opc = this.getPutGetOpcodeWithTypeSuffix("iget", sourceField.getFieldType().getTypeDescriptor());
        return new Insn22c(opc, destinationReg, instanceReg, sourceField);
    }

    private Insn buildArrayGetInsn(Register destinationReg, ArrayRef sourceRef) {
        Value index = sourceRef.getIndex();
        Register indexReg = this.regAlloc.asImmediate(index, this.constantV);
        Value array = sourceRef.getBase();
        Register arrayReg = this.regAlloc.asLocal(array);
        String arrayTypeDescriptor = SootToDexUtils.getArrayTypeDescriptor((ArrayType)array.getType());
        Opcode opc = this.getPutGetOpcodeWithTypeSuffix("aget", arrayTypeDescriptor);
        return new Insn23x(opc, destinationReg, arrayReg, indexReg);
    }

    private Opcode getPutGetOpcodeWithTypeSuffix(String prefix, String fieldType) {
        if (fieldType.equals("Z")) {
            return Opcode.getOpcodeByName(prefix + "-boolean");
        }
        if (fieldType.equals("I") || fieldType.equals("F")) {
            return Opcode.getOpcodeByName(prefix);
        }
        if (fieldType.equals("B")) {
            return Opcode.getOpcodeByName(prefix + "-byte");
        }
        if (fieldType.equals("C")) {
            return Opcode.getOpcodeByName(prefix + "-char");
        }
        if (fieldType.equals("S")) {
            return Opcode.getOpcodeByName(prefix + "-short");
        }
        if (SootToDexUtils.isWide(fieldType)) {
            return Opcode.getOpcodeByName(prefix + "-wide");
        }
        if (SootToDexUtils.isObject(fieldType)) {
            return Opcode.getOpcodeByName(prefix + "-object");
        }
        throw new RuntimeException("unsupported field type for *put*/*get* opcode: " + fieldType);
    }

    private Insn getLastInvokeInsn() {
        ListIterator<Insn> listIterator = this.insns.listIterator(this.insns.size());
        while (listIterator.hasPrevious()) {
            Insn inst = listIterator.previous();
            if (!inst.getOpcode().name.startsWith("invoke-")) continue;
            return inst;
        }
        throw new Error("tried to get last invoke-* instruction, but there was none!");
    }

    private Insn buildMoveResultInsn(Register destinationReg) {
        Opcode opc = SootToDexUtils.isObject(this.lastReturnTypeDescriptor) ? Opcode.MOVE_RESULT_OBJECT : (SootToDexUtils.isWide(this.lastReturnTypeDescriptor) ? Opcode.MOVE_RESULT_WIDE : Opcode.MOVE_RESULT);
        return new Insn11x(opc, destinationReg);
    }

    @Override
    public void caseInvokeStmt(InvokeStmt stmt) {
        stmt.getInvokeExpr().apply(this.exprV);
    }

    @Override
    public void caseReturnVoidStmt(ReturnVoidStmt stmt) {
        this.addInsn(new Insn10x(Opcode.RETURN_VOID));
    }

    @Override
    public void caseReturnStmt(ReturnStmt stmt) {
        Value returnValue = stmt.getOp();
        Register returnReg = this.regAlloc.asImmediate(returnValue, this.constantV);
        Type retType = returnValue.getType();
        Opcode opc = SootToDexUtils.isObject(retType) ? Opcode.RETURN_OBJECT : (SootToDexUtils.isWide(retType) ? Opcode.RETURN_WIDE : Opcode.RETURN);
        this.addInsn(new Insn11x(opc, returnReg));
    }

    @Override
    public void caseIdentityStmt(IdentityStmt stmt) {
        Value lhs = stmt.getLeftOp();
        Value rhs = stmt.getRightOp();
        if (rhs instanceof CaughtExceptionRef) {
            Register localReg = this.regAlloc.asLocal(lhs);
            this.addInsn(new Insn11x(Opcode.MOVE_EXCEPTION, localReg));
        } else if (rhs instanceof ThisRef || rhs instanceof ParameterRef) {
            Local localForThis = (Local)lhs;
            this.regAlloc.asParameter(localForThis);
        } else {
            throw new Error("unknown Value as right-hand side of IdentityStmt: " + rhs);
        }
    }

    @Override
    public void caseGotoStmt(GotoStmt stmt) {
        Stmt target = (Stmt)stmt.getTarget();
        this.addInsn(this.buildGotoInsn(target));
    }

    private Insn buildGotoInsn(Stmt target) {
        Insn10t insn = new Insn10t(Opcode.GOTO);
        insn.setOffset(target);
        return insn;
    }

    @Override
    public void caseLookupSwitchStmt(LookupSwitchStmt stmt) {
        List keyValues = stmt.getLookupValues();
        int[] keys = new int[keyValues.size()];
        for (int i = 0; i < keys.length; ++i) {
            keys[i] = ((IntConstant)keyValues.get((int)i)).value;
        }
        List targets = stmt.getTargets();
        SparseSwitchPayload payload = new SparseSwitchPayload(keys, targets);
        this.switchPayloads.add(payload);
        Value key = stmt.getKey();
        Stmt defaultTarget = (Stmt)stmt.getDefaultTarget();
        this.addInsn(this.buildSwitchInsn(Opcode.SPARSE_SWITCH, key, defaultTarget, payload));
    }

    @Override
    public void caseTableSwitchStmt(TableSwitchStmt stmt) {
        int firstKey = stmt.getLowIndex();
        List targets = stmt.getTargets();
        PackedSwitchPayload payload = new PackedSwitchPayload(firstKey, targets);
        this.switchPayloads.add(payload);
        Value key = stmt.getKey();
        Stmt defaultTarget = (Stmt)stmt.getDefaultTarget();
        this.addInsn(this.buildSwitchInsn(Opcode.PACKED_SWITCH, key, defaultTarget, payload));
    }

    private Insn buildSwitchInsn(Opcode opc, Value key, Stmt defaultTarget, SwitchPayload payload) {
        Register keyReg = this.regAlloc.asImmediate(key, this.constantV);
        Insn31t switchInsn = new Insn31t(opc, keyReg);
        switchInsn.setOffset(payload);
        payload.setSwitchInsn(switchInsn);
        this.addInsn(switchInsn);
        return this.buildGotoInsn(defaultTarget);
    }

    @Override
    public void caseIfStmt(IfStmt stmt) {
        Stmt target = stmt.getTarget();
        this.exprV.setTargetForOffset(target);
        stmt.getCondition().apply(this.exprV);
    }

    static {
        oppositeIfs.put(Opcode.IF_EQ, Opcode.IF_NE);
        oppositeIfs.put(Opcode.IF_NE, Opcode.IF_EQ);
        oppositeIfs.put(Opcode.IF_EQZ, Opcode.IF_NEZ);
        oppositeIfs.put(Opcode.IF_NEZ, Opcode.IF_EQZ);
        oppositeIfs.put(Opcode.IF_GT, Opcode.IF_LE);
        oppositeIfs.put(Opcode.IF_LE, Opcode.IF_GT);
        oppositeIfs.put(Opcode.IF_GTZ, Opcode.IF_LEZ);
        oppositeIfs.put(Opcode.IF_LEZ, Opcode.IF_GTZ);
        oppositeIfs.put(Opcode.IF_GE, Opcode.IF_LT);
        oppositeIfs.put(Opcode.IF_LT, Opcode.IF_GE);
        oppositeIfs.put(Opcode.IF_GEZ, Opcode.IF_LTZ);
        oppositeIfs.put(Opcode.IF_LTZ, Opcode.IF_GEZ);
    }
}

