/*
 * Decompiled with CFR 0.152.
 */
package soot.toDex.instructions;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import org.jf.dexlib.Code.Instruction;
import org.jf.dexlib.Code.Opcode;
import soot.toDex.Register;
import soot.toDex.SootToDexUtils;
import soot.toDex.instructions.Insn;

public abstract class AbstractInsn
implements Insn {
    protected Opcode opc;
    protected int insnOffset;
    protected List<Register> regs;

    public AbstractInsn(Opcode opc) {
        if (opc == null) {
            throw new IllegalArgumentException("opcode must not be null");
        }
        this.opc = opc;
        this.insnOffset = -1;
        this.regs = new ArrayList<Register>();
    }

    @Override
    public Opcode getOpcode() {
        return this.opc;
    }

    @Override
    public void setInsnOffset(int insnOffset) {
        this.insnOffset = insnOffset;
    }

    @Override
    public int getInsnOffset() {
        return this.insnOffset;
    }

    @Override
    public List<Register> getRegs() {
        return this.regs;
    }

    @Override
    public BitSet getIncompatibleRegs() {
        return new BitSet(0);
    }

    @Override
    public boolean hasIncompatibleRegs() {
        return this.getIncompatibleRegs().cardinality() > 0;
    }

    @Override
    public int getMinimumRegsNeeded() {
        int i;
        BitSet incompatRegs = this.getIncompatibleRegs();
        int resultNeed = 0;
        int miscRegsNeed = 0;
        boolean hasResult = this.opc.setsRegister();
        if (hasResult && incompatRegs.get(0)) {
            resultNeed = SootToDexUtils.getDexWords(this.regs.get(0).getType());
        }
        int n = i = hasResult ? 1 : 0;
        while (i < this.regs.size()) {
            if (incompatRegs.get(i)) {
                miscRegsNeed += SootToDexUtils.getDexWords(this.regs.get(i).getType());
            }
            ++i;
        }
        return Math.max(resultNeed, miscRegsNeed);
    }

    @Override
    public Instruction getRealInsn() {
        if (this.hasIncompatibleRegs()) {
            throw new RuntimeException("the instruction still has incompatible registers: " + this.getIncompatibleRegs());
        }
        return this.getRealInsn0();
    }

    protected abstract Instruction getRealInsn0();

    public String toString() {
        return this.opc.toString() + " @" + this.insnOffset + " " + this.regs;
    }

    @Override
    public int getSize() {
        return this.opc.format.size / 2;
    }
}

