/*
 * Decompiled with CFR 0.152.
 */
package soot.toDex.instructions;

import java.util.BitSet;
import org.jf.dexlib.Code.Format.Instruction22s;
import org.jf.dexlib.Code.Instruction;
import org.jf.dexlib.Code.Opcode;
import soot.toDex.Register;
import soot.toDex.instructions.AbstractInsn;
import soot.toDex.instructions.TwoRegInsn;

public class Insn22s
extends AbstractInsn
implements TwoRegInsn {
    private short litC;

    public Insn22s(Opcode opc, Register regA, Register regB, short litC) {
        super(opc);
        this.regs.add(regA);
        this.regs.add(regB);
        this.litC = litC;
    }

    @Override
    public Register getRegA() {
        return (Register)this.regs.get(0);
    }

    @Override
    public Register getRegB() {
        return (Register)this.regs.get(1);
    }

    public short getLitC() {
        return this.litC;
    }

    @Override
    protected Instruction getRealInsn0() {
        return new Instruction22s(this.opc, (byte)this.getRegA().getNumber(), (byte)this.getRegB().getNumber(), this.getLitC());
    }

    @Override
    public BitSet getIncompatibleRegs() {
        BitSet incompatRegs = new BitSet(2);
        if (!this.getRegA().fitsByte()) {
            incompatRegs.set(0);
        }
        if (!this.getRegB().fitsByte()) {
            incompatRegs.set(1);
        }
        return incompatRegs;
    }

    @Override
    public String toString() {
        return super.toString() + " lit: " + this.getLitC();
    }
}

