/*
 * Decompiled with CFR 0.152.
 */
package soot.toDex.instructions;

import java.util.BitSet;
import org.jf.dexlib.Code.Format.Instruction35c;
import org.jf.dexlib.Code.Instruction;
import org.jf.dexlib.Code.Opcode;
import org.jf.dexlib.Item;
import soot.toDex.Register;
import soot.toDex.instructions.AbstractInsn;
import soot.toDex.instructions.FiveRegInsn;

public class Insn35c
extends AbstractInsn
implements FiveRegInsn {
    private int regCount;
    private final Item<?> referencedItem;

    public Insn35c(Opcode opc, int regCount, Register regD, Register regE, Register regF, Register regG, Register regA, Item<?> referencedItem) {
        super(opc);
        this.regCount = regCount;
        this.regs.add(regD);
        this.regs.add(regE);
        this.regs.add(regF);
        this.regs.add(regG);
        this.regs.add(regA);
        this.referencedItem = referencedItem;
    }

    @Override
    public Register getRegD() {
        return (Register)this.regs.get(0);
    }

    @Override
    public Register getRegE() {
        return (Register)this.regs.get(1);
    }

    @Override
    public Register getRegF() {
        return (Register)this.regs.get(2);
    }

    @Override
    public Register getRegG() {
        return (Register)this.regs.get(3);
    }

    @Override
    public Register getRegA() {
        return (Register)this.regs.get(4);
    }

    private static boolean isImplicitWide(Register firstReg, Register secondReg) {
        return firstReg.isWide() && secondReg.isEmptyReg();
    }

    private static int getPossiblyWideNumber(Register reg, Register previousReg) {
        if (Insn35c.isImplicitWide(previousReg, reg)) {
            return previousReg.getNumber() + 1;
        }
        return reg.getNumber();
    }

    private int[] getRealRegNumbers() {
        int[] realRegNumbers = new int[5];
        Register regD = this.getRegD();
        Register regE = this.getRegE();
        Register regF = this.getRegF();
        Register regG = this.getRegG();
        Register regA = this.getRegA();
        realRegNumbers[0] = regD.getNumber();
        realRegNumbers[1] = Insn35c.getPossiblyWideNumber(regE, regD);
        realRegNumbers[2] = Insn35c.getPossiblyWideNumber(regF, regE);
        realRegNumbers[3] = Insn35c.getPossiblyWideNumber(regG, regF);
        realRegNumbers[4] = Insn35c.getPossiblyWideNumber(regA, regG);
        return realRegNumbers;
    }

    @Override
    protected Instruction getRealInsn0() {
        int[] realRegNumbers = this.getRealRegNumbers();
        byte regDNumber = (byte)realRegNumbers[0];
        byte regENumber = (byte)realRegNumbers[1];
        byte regFNumber = (byte)realRegNumbers[2];
        byte regGNumber = (byte)realRegNumbers[3];
        byte regANumber = (byte)realRegNumbers[4];
        return new Instruction35c(this.opc, this.regCount, regDNumber, regENumber, regFNumber, regGNumber, regANumber, this.referencedItem);
    }

    @Override
    public BitSet getIncompatibleRegs() {
        BitSet incompatRegs = new BitSet(5);
        int[] realRegNumbers = this.getRealRegNumbers();
        for (int i = 0; i < realRegNumbers.length; ++i) {
            Register possibleFirstHalf;
            boolean isCompatible = Register.fitsByte(realRegNumbers[i], false);
            if (isCompatible) continue;
            incompatRegs.set(i);
            Register possibleSecondHalf = (Register)this.regs.get(i);
            if (!possibleSecondHalf.isEmptyReg() || i <= 0 || !(possibleFirstHalf = (Register)this.regs.get(i - 1)).isWide()) continue;
            incompatRegs.set(i - 1);
        }
        return incompatRegs;
    }

    @Override
    public String toString() {
        return super.toString() + " (" + this.regCount + " regs), ref: " + this.referencedItem;
    }
}

