/*
 * Decompiled with CFR 0.152.
 */
package soot.toDex.instructions;

import java.util.BitSet;
import java.util.List;
import org.jf.dexlib.Code.Format.Instruction3rc;
import org.jf.dexlib.Code.Instruction;
import org.jf.dexlib.Code.Opcode;
import org.jf.dexlib.Item;
import soot.toDex.Register;
import soot.toDex.SootToDexUtils;
import soot.toDex.instructions.AbstractInsn;

public class Insn3rc
extends AbstractInsn {
    private short regCount;
    private Item<?> referencedItem;

    public Insn3rc(Opcode opc, List<Register> regs, short regCount, Item<?> referencedItem) {
        super(opc);
        this.regs = regs;
        this.regCount = regCount;
        this.referencedItem = referencedItem;
    }

    @Override
    protected Instruction getRealInsn0() {
        Register startReg = (Register)this.regs.get(0);
        return new Instruction3rc(this.opc, this.regCount, startReg.getNumber(), this.referencedItem);
    }

    @Override
    public BitSet getIncompatibleRegs() {
        int regCount = SootToDexUtils.getRealRegCount(this.regs);
        if (this.hasHoleInRange()) {
            return Insn3rc.getAllIncompatible(regCount);
        }
        for (Register r : this.regs) {
            boolean secondWideHalfFits;
            if (!r.fitsUnconstrained()) {
                return Insn3rc.getAllIncompatible(regCount);
            }
            if (!r.isWide() || (secondWideHalfFits = Register.fitsUnconstrained(r.getNumber() + 1, false))) continue;
            return Insn3rc.getAllIncompatible(regCount);
        }
        return new BitSet(regCount);
    }

    private static BitSet getAllIncompatible(int regCount) {
        BitSet incompatRegs = new BitSet(regCount);
        incompatRegs.flip(0, regCount);
        return incompatRegs;
    }

    private boolean hasHoleInRange() {
        Register startReg = (Register)this.regs.get(0);
        int nextExpectedRegNum = startReg.getNumber() + 1;
        if (startReg.isWide()) {
            ++nextExpectedRegNum;
        }
        for (int i = 1; i < this.regs.size(); ++i) {
            Register r = (Register)this.regs.get(i);
            int regNum = r.getNumber();
            if (regNum != nextExpectedRegNum) {
                return true;
            }
            ++nextExpectedRegNum;
            if (!r.isWide()) continue;
            ++nextExpectedRegNum;
        }
        return false;
    }

    @Override
    public String toString() {
        return super.toString() + " ref: " + this.referencedItem;
    }
}

