/*
 * Decompiled with CFR 0.152.
 */
package soot.toDex.instructions;

import java.util.List;
import org.jf.dexlib.Code.Opcode;
import soot.jimple.Stmt;
import soot.toDex.SootToDexUtils;
import soot.toDex.instructions.Insn;
import soot.toDex.instructions.Insn31t;
import soot.toDex.instructions.InsnWithOffset;

public abstract class SwitchPayload
extends InsnWithOffset {
    protected Insn31t switchInsn;
    protected List<Stmt> targets;
    protected int[] targetAddresses;

    public SwitchPayload(List<Stmt> targets) {
        super(Opcode.NOP);
        this.targets = targets;
        this.targetAddresses = new int[targets.size()];
    }

    public void setSwitchInsn(Insn31t switchInsn) {
        this.switchInsn = switchInsn;
    }

    @Override
    public void setOffsetAddress(List<Insn> insns) {
        for (int i = 0; i < this.targetAddresses.length; ++i) {
            this.targetAddresses[i] = SootToDexUtils.getOffset(this.targets.get(i), insns);
        }
    }

    @Override
    public boolean offsetFit() {
        int[] relativeOffsets;
        for (int relativeOffset : relativeOffsets = this.getRelativeOffsets()) {
            if (SootToDexUtils.fitsSigned32(relativeOffset)) continue;
            return false;
        }
        return true;
    }

    public int[] getRelativeOffsets() {
        int switchOffset = this.switchInsn.getInsnOffset();
        int[] relativeOffsets = new int[this.targetAddresses.length];
        for (int i = 0; i < relativeOffsets.length; ++i) {
            relativeOffsets[i] = this.targetAddresses[i] - switchOffset;
        }
        return relativeOffsets;
    }
}

