/*
 * Decompiled with CFR 0.152.
 */
package soot.toolkits.graph;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import soot.Body;
import soot.jimple.Stmt;
import soot.jimple.toolkits.annotation.logic.Loop;
import soot.jimple.toolkits.annotation.logic.LoopFinder;

public class LoopNestTree
extends TreeSet<Loop> {
    public LoopNestTree(Body b) {
        this(LoopNestTree.computeLoops(b));
    }

    public LoopNestTree(Collection<Loop> loops) {
        super(new LoopNestTreeComparator());
        this.addAll(loops);
    }

    private static Collection<Loop> computeLoops(Body b) {
        LoopFinder loopFinder = new LoopFinder();
        loopFinder.transform(b);
        Collection<Loop> loops = loopFinder.loops();
        return loops;
    }

    public boolean hasNestedLoops() {
        LoopNestTreeComparator comp = new LoopNestTreeComparator();
        for (Loop loop1 : this) {
            for (Loop loop2 : this) {
                if (comp.compare(loop1, loop2) == 0) continue;
                return true;
            }
        }
        return false;
    }

    private static class LoopNestTreeComparator
    implements Comparator<Loop> {
        private LoopNestTreeComparator() {
        }

        @Override
        public int compare(Loop loop1, Loop loop2) {
            List<Stmt> stmts2;
            List<Stmt> stmts1 = loop1.getLoopStatements();
            if (((Object)stmts1).equals(stmts2 = loop2.getLoopStatements())) {
                assert (loop1.getHead().equals(loop2.getHead()));
                return 0;
            }
            if (stmts1.containsAll(stmts2)) {
                return 1;
            }
            if (stmts2.containsAll(stmts1)) {
                return -1;
            }
            return 1;
        }
    }
}

