/*
 * Decompiled with CFR 0.152.
 */
package soot.toolkits.scalar;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import soot.Body;
import soot.BodyTransformer;
import soot.G;
import soot.Local;
import soot.PatchingChain;
import soot.Scene;
import soot.Singletons;
import soot.Timers;
import soot.Unit;
import soot.Value;
import soot.ValueBox;
import soot.options.Options;
import soot.toolkits.exceptions.ThrowAnalysis;
import soot.toolkits.graph.ExceptionalUnitGraph;
import soot.toolkits.scalar.LocalDefs;
import soot.toolkits.scalar.SimpleLiveLocals;
import soot.toolkits.scalar.SimpleLocalUses;
import soot.toolkits.scalar.SmartLocalDefs;
import soot.toolkits.scalar.UnitValueBoxPair;

public class LocalSplitter
extends BodyTransformer {
    private ThrowAnalysis throwAnalysis;

    public LocalSplitter(Singletons.Global g) {
    }

    public LocalSplitter(ThrowAnalysis throwAnalysis) {
        if (throwAnalysis == null) {
            throw new NullPointerException();
        }
        this.throwAnalysis = throwAnalysis;
    }

    public static LocalSplitter v() {
        return G.v().soot_toolkits_scalar_LocalSplitter();
    }

    @Override
    protected void internalTransform(Body body, String phaseName, Map options) {
        if (this.throwAnalysis == null) {
            this.throwAnalysis = Scene.v().getDefaultThrowAnalysis();
        }
        PatchingChain<Unit> units = body.getUnits();
        ArrayList webs = new ArrayList();
        if (Options.v().verbose()) {
            G.v().out.println("[" + body.getMethod().getName() + "] Splitting locals...");
        }
        HashMap boxToSet = new HashMap(units.size() * 2 + 1, 0.7f);
        if (Options.v().time()) {
            Timers.v().splitPhase1Timer.start();
        }
        ExceptionalUnitGraph graph = new ExceptionalUnitGraph(body, this.throwAnalysis, true);
        SmartLocalDefs localDefs = new SmartLocalDefs(graph, new SimpleLiveLocals(graph));
        SimpleLocalUses simpleLocalUses = new SimpleLocalUses(graph, (LocalDefs)localDefs);
        if (Options.v().time()) {
            Timers.v().splitPhase1Timer.end();
        }
        if (Options.v().time()) {
            Timers.v().splitPhase2Timer.start();
        }
        HashSet<ValueBox> markedBoxes = new HashSet<ValueBox>();
        HashMap<ValueBox, Unit> boxToUnit = new HashMap<ValueBox, Unit>(units.size() * 2 + 1, 0.7f);
        for (Unit s : units) {
            ValueBox loBox;
            Value lo;
            if (s.getDefBoxes().size() > 1) {
                throw new RuntimeException("stmt with more than 1 defbox!");
            }
            if (s.getDefBoxes().size() < 1 || !((lo = (loBox = s.getDefBoxes().get(0)).getValue()) instanceof Local) || markedBoxes.contains(loBox)) continue;
            LinkedList<Unit> defsToVisit = new LinkedList<Unit>();
            LinkedList<ValueBox> boxesToVisit = new LinkedList<ValueBox>();
            ArrayList<ValueBox> web = new ArrayList<ValueBox>();
            webs.add(web);
            defsToVisit.add(s);
            markedBoxes.add(loBox);
            while (!boxesToVisit.isEmpty() || !defsToVisit.isEmpty()) {
                if (!defsToVisit.isEmpty()) {
                    Unit d = (Unit)defsToVisit.removeFirst();
                    web.add(d.getDefBoxes().get(0));
                    List uses = simpleLocalUses.getUsesOf(d);
                    for (UnitValueBoxPair use : uses) {
                        if (markedBoxes.contains(use.valueBox)) continue;
                        markedBoxes.add(use.valueBox);
                        boxesToVisit.addLast(use.valueBox);
                        boxToUnit.put(use.valueBox, use.unit);
                    }
                    continue;
                }
                ValueBox box = (ValueBox)boxesToVisit.removeFirst();
                web.add(box);
                List<Unit> defs = localDefs.getDefsOfAt((Local)box.getValue(), (Unit)boxToUnit.get(box));
                for (Unit u : defs) {
                    for (ValueBox b : u.getDefBoxes()) {
                        if (markedBoxes.contains(b)) continue;
                        markedBoxes.add(b);
                        defsToVisit.addLast(u);
                    }
                }
            }
        }
        HashMap<Local, Integer> localToUseCount = new HashMap<Local, Integer>(body.getLocalCount() * 2 + 1, 0.7f);
        for (List list : webs) {
            ValueBox rep = (ValueBox)list.get(0);
            Local desiredLocal = (Local)rep.getValue();
            if (!localToUseCount.containsKey(desiredLocal)) {
                localToUseCount.put(desiredLocal, new Integer(1));
                continue;
            }
            int useCount = (Integer)localToUseCount.get(desiredLocal) + 1;
            localToUseCount.put(desiredLocal, new Integer(useCount));
            Local local = (Local)desiredLocal.clone();
            local.setName(desiredLocal.getName() + "#" + useCount);
            body.getLocals().add(local);
            for (ValueBox box : list) {
                box.setValue(local);
            }
        }
        if (Options.v().time()) {
            Timers.v().splitPhase2Timer.end();
        }
    }
}

