/*
 * Decompiled with CFR 0.152.
 */
package soot.toolkits.scalar;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import soot.Body;
import soot.G;
import soot.Local;
import soot.PatchingChain;
import soot.Timers;
import soot.Unit;
import soot.ValueBox;
import soot.options.Options;
import soot.toolkits.graph.UnitGraph;
import soot.toolkits.scalar.LocalDefs;
import soot.toolkits.scalar.LocalUses;
import soot.toolkits.scalar.UnitValueBoxPair;

public class SimpleLocalUses
implements LocalUses {
    Map<Unit, List> unitToUses;

    public SimpleLocalUses(UnitGraph graph, LocalDefs localDefs) {
        this(graph.getBody(), localDefs);
    }

    public SimpleLocalUses(Body body, LocalDefs localDefs) {
        if (Options.v().time()) {
            Timers.v().usesTimer.start();
        }
        if (Options.v().time()) {
            Timers.v().usePhase1Timer.start();
        }
        if (Options.v().verbose()) {
            G.v().out.println("[" + body.getMethod().getName() + "]     Constructing SimpleLocalUses...");
        }
        PatchingChain<Unit> units = body.getUnits();
        this.unitToUses = new HashMap<Unit, List>(units.size() * 2 + 1, 0.7f);
        for (Unit s : units) {
            this.unitToUses.put(s, new ArrayList());
        }
        if (Options.v().time()) {
            Timers.v().usePhase1Timer.end();
        }
        if (Options.v().time()) {
            Timers.v().usePhase2Timer.start();
        }
        for (Unit s : units) {
            for (ValueBox useBox : s.getUseBoxes()) {
                if (!(useBox.getValue() instanceof Local)) continue;
                Local l = (Local)useBox.getValue();
                List<Unit> possibleDefs = localDefs.getDefsOfAt(l, s);
                Iterator<Unit> defIt = possibleDefs.iterator();
                while (defIt.hasNext()) {
                    List useList = this.unitToUses.get(defIt.next());
                    useList.add(new UnitValueBoxPair(s, useBox));
                }
            }
        }
        if (Options.v().time()) {
            Timers.v().usePhase2Timer.end();
        }
        if (Options.v().time()) {
            Timers.v().usePhase3Timer.start();
        }
        for (Unit s : units) {
            this.unitToUses.put(s, Collections.unmodifiableList(this.unitToUses.get(s)));
        }
        if (Options.v().time()) {
            Timers.v().usePhase3Timer.end();
        }
        if (Options.v().time()) {
            Timers.v().usesTimer.end();
        }
        if (Options.v().verbose()) {
            G.v().out.println("[" + body.getMethod().getName() + "]     finished SimpleLocalUses...");
        }
    }

    @Override
    public List getUsesOf(Unit s) {
        List l = this.unitToUses.get(s);
        return l;
    }
}

