/*
 * Decompiled with CFR 0.152.
 */
package soot.toolkits.scalar;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import soot.G;
import soot.Local;
import soot.Timers;
import soot.Unit;
import soot.Value;
import soot.ValueBox;
import soot.options.Options;
import soot.toolkits.graph.UnitGraph;
import soot.toolkits.scalar.ForwardFlowAnalysis;
import soot.toolkits.scalar.LiveLocals;
import soot.toolkits.scalar.LocalDefs;
import soot.util.Cons;

public class SmartLocalDefs
implements LocalDefs {
    private final Map<Cons, ArrayList<Unit>> answer;
    private final Map<Local, HashSet<Unit>> localToDefs;
    private final UnitGraph graph;
    private final LocalDefsAnalysis analysis;
    private final Map<Unit, HashSet> unitToMask;

    public SmartLocalDefs(UnitGraph g, LiveLocals live) {
        this.graph = g;
        if (Options.v().time()) {
            Timers.v().defsTimer.start();
        }
        if (Options.v().verbose()) {
            G.v().out.println("[" + g.getBody().getMethod().getName() + "]     Constructing SmartLocalDefs...");
        }
        this.localToDefs = new HashMap<Local, HashSet<Unit>>();
        this.unitToMask = new HashMap<Unit, HashSet>();
        for (Unit u : g) {
            Local l = this.localDef(u);
            if (l == null) continue;
            HashSet<Unit> s = this.defsOf(l);
            s.add(u);
        }
        if (Options.v().verbose()) {
            G.v().out.println("[" + g.getBody().getMethod().getName() + "]        done localToDefs map...");
        }
        for (Unit u : g) {
            this.unitToMask.put(u, new HashSet(live.getLiveLocalsAfter(u)));
        }
        if (Options.v().verbose()) {
            G.v().out.println("[" + g.getBody().getMethod().getName() + "]        done unitToMask map...");
        }
        this.analysis = new LocalDefsAnalysis(this.graph);
        this.answer = new HashMap<Cons, ArrayList<Unit>>();
        for (Unit u : this.graph) {
            for (ValueBox vb : u.getUseBoxes()) {
                Value v = vb.getValue();
                if (!(v instanceof Local)) continue;
                HashSet analysisResult = (HashSet)this.analysis.getFlowBefore(u);
                ArrayList<Unit> al = new ArrayList<Unit>();
                for (Unit unit : this.defsOf((Local)v)) {
                    if (!analysisResult.contains(unit)) continue;
                    al.add(unit);
                }
                this.answer.put(new Cons(u, v), al);
            }
        }
        if (Options.v().time()) {
            Timers.v().defsTimer.end();
        }
        if (Options.v().verbose()) {
            G.v().out.println("[" + g.getBody().getMethod().getName() + "]     SmartLocalDefs finished.");
        }
    }

    private Local localDef(Unit u) {
        List<ValueBox> defBoxes = u.getDefBoxes();
        int size = defBoxes.size();
        if (size == 0) {
            return null;
        }
        if (size != 1) {
            throw new RuntimeException();
        }
        ValueBox vb = defBoxes.get(0);
        Value v = vb.getValue();
        if (!(v instanceof Local)) {
            return null;
        }
        return (Local)v;
    }

    private HashSet<Unit> defsOf(Local l) {
        HashSet<Unit> ret = this.localToDefs.get(l);
        if (ret == null) {
            ret = new HashSet();
            this.localToDefs.put(l, ret);
        }
        return ret;
    }

    @Override
    public List<Unit> getDefsOfAt(Local l, Unit s) {
        return this.answer.get(new Cons(s, l));
    }

    class LocalDefsAnalysis
    extends ForwardFlowAnalysis {
        LocalDefsAnalysis(UnitGraph g) {
            super(g);
            this.doAnalysis();
        }

        protected void merge(Object inoutO, Object inO) {
            HashSet inout = (HashSet)inoutO;
            HashSet in = (HashSet)inO;
            inout.addAll(in);
        }

        @Override
        protected void merge(Object in1, Object in2, Object out) {
            HashSet inSet1 = (HashSet)in1;
            HashSet inSet2 = (HashSet)in2;
            HashSet outSet = (HashSet)out;
            outSet.clear();
            outSet.addAll(inSet1);
            outSet.addAll(inSet2);
        }

        @Override
        protected void flowThrough(Object inValue, Object unit, Object outValue) {
            Unit u = (Unit)unit;
            HashSet in = (HashSet)inValue;
            HashSet out = (HashSet)outValue;
            out.clear();
            Set mask = (Set)SmartLocalDefs.this.unitToMask.get(u);
            Local l = SmartLocalDefs.this.localDef(u);
            HashSet allDefUnits = null;
            if (l == null) {
                for (Unit inU : in) {
                    if (!mask.contains(SmartLocalDefs.this.localDef(inU))) continue;
                    out.add(inU);
                }
            } else {
                allDefUnits = SmartLocalDefs.this.defsOf(l);
                for (Unit inU : in) {
                    if (!mask.contains(SmartLocalDefs.this.localDef(inU))) continue;
                    if (allDefUnits.contains(inU)) {
                        out.remove(inU);
                        continue;
                    }
                    out.add(inU);
                }
                out.removeAll(allDefUnits);
                if (mask.contains(l)) {
                    out.add(u);
                }
            }
        }

        @Override
        protected void copy(Object source, Object dest) {
            HashSet sourceSet = (HashSet)source;
            HashSet destSet = (HashSet)dest;
            if (destSet.size() > 0) {
                destSet.retainAll(sourceSet);
            }
            if (sourceSet.size() > 0) {
                for (Object o : sourceSet) {
                    if (destSet.contains(o)) continue;
                    destSet.add(o);
                }
            }
        }

        @Override
        protected Object newInitialFlow() {
            return new HashSet();
        }

        @Override
        protected Object entryInitialFlow() {
            return new HashSet();
        }
    }
}

