/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.app.ActivityManagerNative;
import android.app.IAlarmManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.Uri;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.os.PowerManager;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.text.TextUtils;
import android.util.Slog;
import android.util.TimeUtils;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AlarmManagerService
extends IAlarmManager.Stub {
    private static final long LATE_ALARM_THRESHOLD = 10000L;
    private static final int RTC_WAKEUP_MASK = 1;
    private static final int RTC_MASK = 2;
    private static final int ELAPSED_REALTIME_WAKEUP_MASK = 4;
    private static final int ELAPSED_REALTIME_MASK = 8;
    private static final int TIME_CHANGED_MASK = 65536;
    private static final long QUANTUM = 900000L;
    private static final String TAG = "AlarmManager";
    private static final String ClockReceiver_TAG = "ClockReceiver";
    private static final boolean localLOGV = false;
    private static final int ALARM_EVENT = 1;
    private static final String TIMEZONE_PROPERTY = "persist.sys.timezone";
    private static final Intent mBackgroundIntent = new Intent().addFlags(4);
    private final Context mContext;
    private Object mLock = new Object();
    private final ArrayList<Alarm> mRtcWakeupAlarms = new ArrayList();
    private final ArrayList<Alarm> mRtcAlarms = new ArrayList();
    private final ArrayList<Alarm> mElapsedRealtimeWakeupAlarms = new ArrayList();
    private final ArrayList<Alarm> mElapsedRealtimeAlarms = new ArrayList();
    private final IncreasingTimeOrder mIncreasingTimeOrder = new IncreasingTimeOrder();
    private int mDescriptor;
    private int mBroadcastRefCount = 0;
    private PowerManager.WakeLock mWakeLock;
    private final AlarmThread mWaitThread = new AlarmThread();
    private final AlarmHandler mHandler = new AlarmHandler();
    private ClockReceiver mClockReceiver;
    private UninstallReceiver mUninstallReceiver;
    private final ResultReceiver mResultReceiver = new ResultReceiver();
    private final PendingIntent mTimeTickSender;
    private final PendingIntent mDateChangeSender;
    private final HashMap<String, BroadcastStats> mBroadcastStats = new HashMap();

    public AlarmManagerService(Context context) {
        this.mContext = context;
        this.mDescriptor = this.init();
        String tz = SystemProperties.get((String)TIMEZONE_PROPERTY);
        if (tz != null) {
            this.setTimeZone(tz);
        }
        PowerManager pm = (PowerManager)context.getSystemService("power");
        this.mWakeLock = pm.newWakeLock(1, TAG);
        this.mTimeTickSender = PendingIntent.getBroadcast((Context)context, (int)0, (Intent)new Intent("android.intent.action.TIME_TICK").addFlags(0x40000000), (int)0);
        Intent intent = new Intent("android.intent.action.DATE_CHANGED");
        intent.addFlags(0x20000000);
        this.mDateChangeSender = PendingIntent.getBroadcast((Context)context, (int)0, (Intent)intent, (int)0);
        this.mClockReceiver = new ClockReceiver();
        this.mClockReceiver.scheduleTimeTickEvent();
        this.mClockReceiver.scheduleDateChangedEvent();
        this.mUninstallReceiver = new UninstallReceiver();
        if (this.mDescriptor != -1) {
            this.mWaitThread.start();
        } else {
            Slog.w((String)TAG, (String)"Failed to open alarm driver. Falling back to a handler.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.close(this.mDescriptor);
        }
        finally {
            super.finalize();
        }
    }

    public void set(int type, long triggerAtTime, PendingIntent operation) {
        this.setRepeating(type, triggerAtTime, 0L, operation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRepeating(int type, long triggerAtTime, long interval, PendingIntent operation) {
        if (operation == null) {
            Slog.w((String)TAG, (String)"set/setRepeating ignored because there is no intent");
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            Alarm alarm = new Alarm();
            alarm.type = type;
            alarm.when = triggerAtTime;
            alarm.repeatInterval = interval;
            alarm.operation = operation;
            this.removeLocked(operation);
            int index = this.addAlarmLocked(alarm);
            if (index == 0) {
                this.setLocked(alarm);
            }
        }
    }

    public void setInexactRepeating(int type, long triggerAtTime, long interval, PendingIntent operation) {
        if (operation == null) {
            Slog.w((String)TAG, (String)"setInexactRepeating ignored because there is no intent");
            return;
        }
        if (interval <= 0L) {
            Slog.w((String)TAG, (String)("setInexactRepeating ignored because interval " + interval + " is invalid"));
            return;
        }
        if (interval % 900000L != 0L) {
            this.setRepeating(type, triggerAtTime, interval, operation);
            return;
        }
        boolean isRtc = type == 1 || type == 0;
        long skew = isRtc ? System.currentTimeMillis() - SystemClock.elapsedRealtime() : 0L;
        long offset = (triggerAtTime - skew) % 900000L;
        long adjustedTriggerTime = offset != 0L ? triggerAtTime - offset + 900000L : triggerAtTime;
        this.setRepeating(type, adjustedTriggerTime, interval, operation);
    }

    public void setTime(long millis) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.SET_TIME", "setTime");
        SystemClock.setCurrentTimeMillis((long)millis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTimeZone(String tz) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.SET_TIME_ZONE", "setTimeZone");
        if (TextUtils.isEmpty((CharSequence)tz)) {
            return;
        }
        TimeZone zone = TimeZone.getTimeZone(tz);
        boolean timeZoneWasChanged = false;
        AlarmManagerService alarmManagerService = this;
        synchronized (alarmManagerService) {
            String current = SystemProperties.get((String)TIMEZONE_PROPERTY);
            if (current == null || !current.equals(zone.getID())) {
                timeZoneWasChanged = true;
                SystemProperties.set((String)TIMEZONE_PROPERTY, (String)zone.getID());
            }
            int gmtOffset = zone.getOffset(System.currentTimeMillis());
            this.setKernelTimezone(this.mDescriptor, -(gmtOffset / 60000));
        }
        TimeZone.setDefault(null);
        if (timeZoneWasChanged) {
            Intent intent = new Intent("android.intent.action.TIMEZONE_CHANGED");
            intent.addFlags(0x20000000);
            intent.putExtra("time-zone", zone.getID());
            this.mContext.sendBroadcast(intent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(PendingIntent operation) {
        if (operation == null) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            this.removeLocked(operation);
        }
    }

    public void removeLocked(PendingIntent operation) {
        this.removeLocked(this.mRtcWakeupAlarms, operation);
        this.removeLocked(this.mRtcAlarms, operation);
        this.removeLocked(this.mElapsedRealtimeWakeupAlarms, operation);
        this.removeLocked(this.mElapsedRealtimeAlarms, operation);
    }

    private void removeLocked(ArrayList<Alarm> alarmList, PendingIntent operation) {
        if (alarmList.size() <= 0) {
            return;
        }
        Iterator<Alarm> it = alarmList.iterator();
        while (it.hasNext()) {
            Alarm alarm = it.next();
            if (!alarm.operation.equals((Object)operation)) continue;
            it.remove();
        }
    }

    public void removeLocked(String packageName) {
        this.removeLocked(this.mRtcWakeupAlarms, packageName);
        this.removeLocked(this.mRtcAlarms, packageName);
        this.removeLocked(this.mElapsedRealtimeWakeupAlarms, packageName);
        this.removeLocked(this.mElapsedRealtimeAlarms, packageName);
    }

    private void removeLocked(ArrayList<Alarm> alarmList, String packageName) {
        if (alarmList.size() <= 0) {
            return;
        }
        Iterator<Alarm> it = alarmList.iterator();
        while (it.hasNext()) {
            Alarm alarm = it.next();
            if (!alarm.operation.getTargetPackage().equals(packageName)) continue;
            it.remove();
        }
    }

    public boolean lookForPackageLocked(String packageName) {
        return this.lookForPackageLocked(this.mRtcWakeupAlarms, packageName) || this.lookForPackageLocked(this.mRtcAlarms, packageName) || this.lookForPackageLocked(this.mElapsedRealtimeWakeupAlarms, packageName) || this.lookForPackageLocked(this.mElapsedRealtimeAlarms, packageName);
    }

    private boolean lookForPackageLocked(ArrayList<Alarm> alarmList, String packageName) {
        for (int i = alarmList.size() - 1; i >= 0; --i) {
            if (!alarmList.get((int)i).operation.getTargetPackage().equals(packageName)) continue;
            return true;
        }
        return false;
    }

    private ArrayList<Alarm> getAlarmList(int type) {
        switch (type) {
            case 0: {
                return this.mRtcWakeupAlarms;
            }
            case 1: {
                return this.mRtcAlarms;
            }
            case 2: {
                return this.mElapsedRealtimeWakeupAlarms;
            }
            case 3: {
                return this.mElapsedRealtimeAlarms;
            }
        }
        return null;
    }

    private int addAlarmLocked(Alarm alarm) {
        ArrayList<Alarm> alarmList = this.getAlarmList(alarm.type);
        int index = Collections.binarySearch(alarmList, alarm, this.mIncreasingTimeOrder);
        if (index < 0) {
            index = 0 - index - 1;
        }
        alarmList.add(index, alarm);
        return index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long timeToNextAlarm() {
        long nextAlarm = Long.MAX_VALUE;
        Object object = this.mLock;
        synchronized (object) {
            for (int i = 0; i <= 3; ++i) {
                ArrayList<Alarm> alarmList = this.getAlarmList(i);
                if (alarmList.size() <= 0) continue;
                Alarm a = alarmList.get(0);
                if (a.when >= nextAlarm) continue;
                nextAlarm = a.when;
            }
        }
        return nextAlarm;
    }

    private void setLocked(Alarm alarm) {
        if (this.mDescriptor != -1) {
            long alarmNanoseconds;
            long alarmSeconds;
            if (alarm.when < 0L) {
                alarmSeconds = 0L;
                alarmNanoseconds = 0L;
            } else {
                alarmSeconds = alarm.when / 1000L;
                alarmNanoseconds = alarm.when % 1000L * 1000L * 1000L;
            }
            this.set(this.mDescriptor, alarm.type, alarmSeconds, alarmNanoseconds);
        } else {
            Message msg = Message.obtain();
            msg.what = 1;
            this.mHandler.removeMessages(1);
            this.mHandler.sendMessageAtTime(msg, alarm.when);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.DUMP") != 0) {
            pw.println("Permission Denial: can't dump AlarmManager from from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid());
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            long now;
            pw.println("Current Alarm Manager state:");
            if (this.mRtcWakeupAlarms.size() > 0 || this.mRtcAlarms.size() > 0) {
                now = System.currentTimeMillis();
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                pw.println(" ");
                pw.print("  Realtime wakeup (now=");
                pw.print(sdf.format(new Date(now)));
                pw.println("):");
                if (this.mRtcWakeupAlarms.size() > 0) {
                    AlarmManagerService.dumpAlarmList(pw, this.mRtcWakeupAlarms, "  ", "RTC_WAKEUP", now);
                }
                if (this.mRtcAlarms.size() > 0) {
                    AlarmManagerService.dumpAlarmList(pw, this.mRtcAlarms, "  ", "RTC", now);
                }
            }
            if (this.mElapsedRealtimeWakeupAlarms.size() > 0 || this.mElapsedRealtimeAlarms.size() > 0) {
                now = SystemClock.elapsedRealtime();
                pw.println(" ");
                pw.print("  Elapsed realtime wakeup (now=");
                TimeUtils.formatDuration((long)now, (PrintWriter)pw);
                pw.println("):");
                if (this.mElapsedRealtimeWakeupAlarms.size() > 0) {
                    AlarmManagerService.dumpAlarmList(pw, this.mElapsedRealtimeWakeupAlarms, "  ", "ELAPSED_WAKEUP", now);
                }
                if (this.mElapsedRealtimeAlarms.size() > 0) {
                    AlarmManagerService.dumpAlarmList(pw, this.mElapsedRealtimeAlarms, "  ", "ELAPSED", now);
                }
            }
            pw.println(" ");
            pw.print("  Broadcast ref count: ");
            pw.println(this.mBroadcastRefCount);
            pw.println(" ");
            pw.println("  Alarm Stats:");
            for (Map.Entry<String, BroadcastStats> be : this.mBroadcastStats.entrySet()) {
                BroadcastStats bs = be.getValue();
                pw.print("  ");
                pw.println(be.getKey());
                pw.print("    ");
                pw.print(bs.aggregateTime);
                pw.print("ms running, ");
                pw.print(bs.numWakeup);
                pw.println(" wakeups");
                for (Map.Entry<Intent.FilterComparison, FilterStats> fe : bs.filterStats.entrySet()) {
                    pw.print("    ");
                    pw.print(fe.getValue().count);
                    pw.print(" alarms: ");
                    pw.println(fe.getKey().getIntent().toShortString(false, true, false));
                }
            }
        }
    }

    private static final void dumpAlarmList(PrintWriter pw, ArrayList<Alarm> list, String prefix, String label, long now) {
        for (int i = list.size() - 1; i >= 0; --i) {
            Alarm a = list.get(i);
            pw.print(prefix);
            pw.print(label);
            pw.print(" #");
            pw.print(i);
            pw.print(": ");
            pw.println(a);
            a.dump(pw, prefix + "  ", now);
        }
    }

    private native int init();

    private native void close(int var1);

    private native void set(int var1, int var2, long var3, long var5);

    private native int waitForAlarm(int var1);

    private native int setKernelTimezone(int var1, int var2);

    private void triggerAlarmsLocked(ArrayList<Alarm> alarmList, ArrayList<Alarm> triggerList, long now) {
        Iterator<Alarm> it = alarmList.iterator();
        ArrayList<Alarm> repeats = new ArrayList<Alarm>();
        while (it.hasNext()) {
            Alarm alarm = it.next();
            if (alarm.when > now) break;
            alarm.count = 1;
            if (alarm.repeatInterval > 0L) {
                alarm.count = (int)((long)alarm.count + (now - alarm.when) / alarm.repeatInterval);
            }
            triggerList.add(alarm);
            it.remove();
            if (alarm.repeatInterval <= 0L) continue;
            repeats.add(alarm);
        }
        for (Alarm alarm : repeats) {
            alarm.when += (long)alarm.count * alarm.repeatInterval;
            this.addAlarmLocked(alarm);
        }
        if (alarmList.size() > 0) {
            this.setLocked(alarmList.get(0));
        }
    }

    private final BroadcastStats getStatsLocked(PendingIntent pi) {
        String pkg = pi.getTargetPackage();
        BroadcastStats bs = this.mBroadcastStats.get(pkg);
        if (bs == null) {
            bs = new BroadcastStats();
            this.mBroadcastStats.put(pkg, bs);
        }
        return bs;
    }

    class ResultReceiver
    implements PendingIntent.OnFinished {
        ResultReceiver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onSendFinished(PendingIntent pi, Intent intent, int resultCode, String resultData, Bundle resultExtras) {
            Object object = AlarmManagerService.this.mLock;
            synchronized (object) {
                BroadcastStats bs = AlarmManagerService.this.getStatsLocked(pi);
                if (bs != null) {
                    --bs.nesting;
                    if (bs.nesting <= 0) {
                        bs.nesting = 0;
                        bs.aggregateTime += SystemClock.elapsedRealtime() - bs.startTime;
                        Intent.FilterComparison fc = new Intent.FilterComparison(intent);
                        FilterStats fs = bs.filterStats.get(fc);
                        if (fs == null) {
                            fs = new FilterStats();
                            bs.filterStats.put(fc, fs);
                        }
                        ++fs.count;
                    }
                }
                AlarmManagerService.this.mBroadcastRefCount--;
                if (AlarmManagerService.this.mBroadcastRefCount == 0) {
                    AlarmManagerService.this.mWakeLock.release();
                }
            }
        }
    }

    class UninstallReceiver
    extends BroadcastReceiver {
        public UninstallReceiver() {
            IntentFilter filter = new IntentFilter();
            filter.addAction("android.intent.action.PACKAGE_REMOVED");
            filter.addAction("android.intent.action.PACKAGE_RESTARTED");
            filter.addAction("android.intent.action.QUERY_PACKAGE_RESTART");
            filter.addDataScheme("package");
            AlarmManagerService.this.mContext.registerReceiver((BroadcastReceiver)this, filter);
            IntentFilter sdFilter = new IntentFilter();
            sdFilter.addAction("android.intent.action.EXTERNAL_APPLICATIONS_UNAVAILABLE");
            AlarmManagerService.this.mContext.registerReceiver((BroadcastReceiver)this, sdFilter);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onReceive(Context context, Intent intent) {
            Object object = AlarmManagerService.this.mLock;
            synchronized (object) {
                String action = intent.getAction();
                String[] pkgList = null;
                if ("android.intent.action.QUERY_PACKAGE_RESTART".equals(action)) {
                    for (String packageName : pkgList = intent.getStringArrayExtra("android.intent.extra.PACKAGES")) {
                        if (!AlarmManagerService.this.lookForPackageLocked(packageName)) continue;
                        this.setResultCode(-1);
                        return;
                    }
                    return;
                }
                if ("android.intent.action.EXTERNAL_APPLICATIONS_UNAVAILABLE".equals(action)) {
                    pkgList = intent.getStringArrayExtra("android.intent.extra.changed_package_list");
                } else {
                    String pkg;
                    if ("android.intent.action.PACKAGE_REMOVED".equals(action) && intent.getBooleanExtra("android.intent.extra.REPLACING", false)) {
                        return;
                    }
                    Uri data = intent.getData();
                    if (data != null && (pkg = data.getSchemeSpecificPart()) != null) {
                        pkgList = new String[]{pkg};
                    }
                }
                if (pkgList != null && pkgList.length > 0) {
                    for (String pkg : pkgList) {
                        AlarmManagerService.this.removeLocked(pkg);
                        AlarmManagerService.this.mBroadcastStats.remove(pkg);
                    }
                }
            }
        }
    }

    class ClockReceiver
    extends BroadcastReceiver {
        public ClockReceiver() {
            IntentFilter filter = new IntentFilter();
            filter.addAction("android.intent.action.TIME_TICK");
            filter.addAction("android.intent.action.DATE_CHANGED");
            AlarmManagerService.this.mContext.registerReceiver((BroadcastReceiver)this, filter);
        }

        public void onReceive(Context context, Intent intent) {
            if (intent.getAction().equals("android.intent.action.TIME_TICK")) {
                this.scheduleTimeTickEvent();
            } else if (intent.getAction().equals("android.intent.action.DATE_CHANGED")) {
                TimeZone zone = TimeZone.getTimeZone(SystemProperties.get((String)AlarmManagerService.TIMEZONE_PROPERTY));
                int gmtOffset = zone.getOffset(System.currentTimeMillis());
                AlarmManagerService.this.setKernelTimezone(AlarmManagerService.this.mDescriptor, -(gmtOffset / 60000));
                this.scheduleDateChangedEvent();
            }
        }

        public void scheduleTimeTickEvent() {
            Calendar calendar = Calendar.getInstance();
            long currentTime = System.currentTimeMillis();
            calendar.setTimeInMillis(currentTime);
            calendar.add(12, 1);
            calendar.set(13, 0);
            calendar.set(14, 0);
            long tickEventDelay = calendar.getTimeInMillis() - currentTime;
            AlarmManagerService.this.set(3, SystemClock.elapsedRealtime() + tickEventDelay, AlarmManagerService.this.mTimeTickSender);
        }

        public void scheduleDateChangedEvent() {
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis(System.currentTimeMillis());
            calendar.set(10, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            calendar.add(5, 1);
            AlarmManagerService.this.set(1, calendar.getTimeInMillis(), AlarmManagerService.this.mDateChangeSender);
        }
    }

    private class AlarmHandler
    extends Handler {
        public static final int ALARM_EVENT = 1;
        public static final int MINUTE_CHANGE_EVENT = 2;
        public static final int DATE_CHANGE_EVENT = 3;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(Message msg) {
            if (msg.what == 1) {
                ArrayList triggerList = new ArrayList();
                Object object = AlarmManagerService.this.mLock;
                synchronized (object) {
                    long nowRTC = System.currentTimeMillis();
                    AlarmManagerService.this.triggerAlarmsLocked(AlarmManagerService.this.mRtcWakeupAlarms, triggerList, nowRTC);
                    AlarmManagerService.this.triggerAlarmsLocked(AlarmManagerService.this.mRtcAlarms, triggerList, nowRTC);
                    AlarmManagerService.this.triggerAlarmsLocked(AlarmManagerService.this.mElapsedRealtimeWakeupAlarms, triggerList, nowRTC);
                    AlarmManagerService.this.triggerAlarmsLocked(AlarmManagerService.this.mElapsedRealtimeAlarms, triggerList, nowRTC);
                }
                for (Alarm alarm : triggerList) {
                    try {
                        alarm.operation.send();
                    }
                    catch (PendingIntent.CanceledException e) {
                        if (alarm.repeatInterval <= 0L) continue;
                        AlarmManagerService.this.remove(alarm.operation);
                    }
                }
            }
        }
    }

    private class AlarmThread
    extends Thread {
        public AlarmThread() {
            super(AlarmManagerService.TAG);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                int result = AlarmManagerService.this.waitForAlarm(AlarmManagerService.this.mDescriptor);
                ArrayList triggerList = new ArrayList();
                if ((result & 0x10000) != 0) {
                    AlarmManagerService.this.remove(AlarmManagerService.this.mTimeTickSender);
                    AlarmManagerService.this.mClockReceiver.scheduleTimeTickEvent();
                    Intent intent = new Intent("android.intent.action.TIME_SET");
                    intent.addFlags(0x30000000);
                    AlarmManagerService.this.mContext.sendBroadcast(intent);
                }
                Object object = AlarmManagerService.this.mLock;
                synchronized (object) {
                    long nowRTC = System.currentTimeMillis();
                    long nowELAPSED = SystemClock.elapsedRealtime();
                    if ((result & 1) != 0) {
                        AlarmManagerService.this.triggerAlarmsLocked(AlarmManagerService.this.mRtcWakeupAlarms, triggerList, nowRTC);
                    }
                    if ((result & 2) != 0) {
                        AlarmManagerService.this.triggerAlarmsLocked(AlarmManagerService.this.mRtcAlarms, triggerList, nowRTC);
                    }
                    if ((result & 4) != 0) {
                        AlarmManagerService.this.triggerAlarmsLocked(AlarmManagerService.this.mElapsedRealtimeWakeupAlarms, triggerList, nowELAPSED);
                    }
                    if ((result & 8) != 0) {
                        AlarmManagerService.this.triggerAlarmsLocked(AlarmManagerService.this.mElapsedRealtimeAlarms, triggerList, nowELAPSED);
                    }
                    for (Alarm alarm : triggerList) {
                        try {
                            alarm.operation.send(AlarmManagerService.this.mContext, 0, mBackgroundIntent.putExtra("android.intent.extra.ALARM_COUNT", alarm.count), (PendingIntent.OnFinished)AlarmManagerService.this.mResultReceiver, (Handler)AlarmManagerService.this.mHandler);
                            if (AlarmManagerService.this.mBroadcastRefCount == 0) {
                                AlarmManagerService.this.mWakeLock.acquire();
                            }
                            AlarmManagerService.this.mBroadcastRefCount++;
                            BroadcastStats bs = AlarmManagerService.this.getStatsLocked(alarm.operation);
                            if (bs.nesting == 0) {
                                bs.startTime = nowELAPSED;
                            } else {
                                ++bs.nesting;
                            }
                            if (alarm.type != 2 && alarm.type != 0) continue;
                            ++bs.numWakeup;
                            ActivityManagerNative.noteWakeupAlarm((PendingIntent)alarm.operation);
                        }
                        catch (PendingIntent.CanceledException e) {
                            if (alarm.repeatInterval <= 0L) continue;
                            AlarmManagerService.this.remove(alarm.operation);
                        }
                        catch (RuntimeException e) {
                            Slog.w((String)AlarmManagerService.TAG, (String)"Failure sending alarm.", (Throwable)e);
                        }
                    }
                }
            }
        }
    }

    private static class Alarm {
        public int type;
        public int count;
        public long when = 0L;
        public long repeatInterval = 0L;
        public PendingIntent operation = null;

        public String toString() {
            StringBuilder sb = new StringBuilder(128);
            sb.append("Alarm{");
            sb.append(Integer.toHexString(System.identityHashCode(this)));
            sb.append(" type ");
            sb.append(this.type);
            sb.append(" ");
            sb.append(this.operation.getTargetPackage());
            sb.append('}');
            return sb.toString();
        }

        public void dump(PrintWriter pw, String prefix, long now) {
            pw.print(prefix);
            pw.print("type=");
            pw.print(this.type);
            pw.print(" when=");
            TimeUtils.formatDuration((long)this.when, (long)now, (PrintWriter)pw);
            pw.print(" repeatInterval=");
            pw.print(this.repeatInterval);
            pw.print(" count=");
            pw.println(this.count);
            pw.print(prefix);
            pw.print("operation=");
            pw.println(this.operation);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class IncreasingTimeOrder
    implements Comparator<Alarm> {
        @Override
        public int compare(Alarm a1, Alarm a2) {
            long when1 = a1.when;
            long when2 = a2.when;
            if (when1 - when2 > 0L) {
                return 1;
            }
            if (when1 - when2 < 0L) {
                return -1;
            }
            return 0;
        }
    }

    private static final class BroadcastStats {
        long aggregateTime;
        int numWakeup;
        long startTime;
        int nesting;
        HashMap<Intent.FilterComparison, FilterStats> filterStats = new HashMap();

        private BroadcastStats() {
        }
    }

    private static final class FilterStats {
        int count;

        private FilterStats() {
        }
    }
}

