/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.appwidget.AppWidgetProviderInfo;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.SystemClock;
import android.util.AttributeSet;
import android.util.Log;
import android.util.Pair;
import android.util.Slog;
import android.util.TypedValue;
import android.util.Xml;
import android.widget.RemoteViews;
import com.android.internal.R;
import com.android.internal.appwidget.IAppWidgetHost;
import com.android.internal.appwidget.IAppWidgetService;
import com.android.internal.os.AtomicFile;
import com.android.internal.util.FastXmlSerializer;
import com.android.internal.widget.IRemoteViewsAdapterConnection;
import com.android.internal.widget.IRemoteViewsFactory;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AppWidgetService
extends IAppWidgetService.Stub {
    private static final String TAG = "AppWidgetService";
    private static final String SETTINGS_FILENAME = "appwidgets.xml";
    private static final int MIN_UPDATE_PERIOD = 1800000;
    private final HashMap<Pair<Integer, Intent.FilterComparison>, ServiceConnection> mBoundRemoteViewsServices = new HashMap();
    private final HashMap<Intent.FilterComparison, HashSet<Integer>> mRemoteViewsServicesAppWidgets = new HashMap();
    Context mContext;
    Locale mLocale;
    PackageManager mPackageManager;
    AlarmManager mAlarmManager;
    ArrayList<Provider> mInstalledProviders = new ArrayList();
    int mNextAppWidgetId = 1;
    final ArrayList<AppWidgetId> mAppWidgetIds = new ArrayList();
    ArrayList<Host> mHosts = new ArrayList();
    boolean mSafeMode;
    boolean mStateLoaded;
    ArrayList<Provider> mDeletedProviders = new ArrayList();
    ArrayList<Host> mDeletedHosts = new ArrayList();
    BroadcastReceiver mBroadcastReceiver = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if ("android.intent.action.BOOT_COMPLETED".equals(action)) {
                AppWidgetService.this.sendInitialBroadcasts();
            } else if ("android.intent.action.CONFIGURATION_CHANGED".equals(action)) {
                Locale revised = Locale.getDefault();
                if (revised == null || AppWidgetService.this.mLocale == null || !revised.equals(AppWidgetService.this.mLocale)) {
                    AppWidgetService.this.mLocale = revised;
                    ArrayList<AppWidgetId> arrayList = AppWidgetService.this.mAppWidgetIds;
                    synchronized (arrayList) {
                        AppWidgetService.this.ensureStateLoadedLocked();
                        int N = AppWidgetService.this.mInstalledProviders.size();
                        for (int i = N - 1; i >= 0; --i) {
                            Provider p = AppWidgetService.this.mInstalledProviders.get(i);
                            String pkgName = p.info.provider.getPackageName();
                            AppWidgetService.this.updateProvidersForPackageLocked(pkgName);
                        }
                        AppWidgetService.this.saveStateLocked();
                    }
                }
            } else {
                Object uri;
                boolean added = false;
                boolean changed = false;
                String[] pkgList = null;
                if ("android.intent.action.EXTERNAL_APPLICATIONS_AVAILABLE".equals(action)) {
                    pkgList = intent.getStringArrayExtra("android.intent.extra.changed_package_list");
                    added = true;
                } else if ("android.intent.action.EXTERNAL_APPLICATIONS_UNAVAILABLE".equals(action)) {
                    pkgList = intent.getStringArrayExtra("android.intent.extra.changed_package_list");
                    added = false;
                } else {
                    uri = intent.getData();
                    if (uri == null) {
                        return;
                    }
                    String pkgName = uri.getSchemeSpecificPart();
                    if (pkgName == null) {
                        return;
                    }
                    pkgList = new String[]{pkgName};
                    added = "android.intent.action.PACKAGE_ADDED".equals(action);
                    changed = "android.intent.action.PACKAGE_CHANGED".equals(action);
                }
                if (pkgList == null || pkgList.length == 0) {
                    return;
                }
                if (added || changed) {
                    uri = AppWidgetService.this.mAppWidgetIds;
                    synchronized (uri) {
                        AppWidgetService.this.ensureStateLoadedLocked();
                        Bundle extras = intent.getExtras();
                        if (changed || extras != null && extras.getBoolean("android.intent.extra.REPLACING", false)) {
                            for (String pkgName : pkgList) {
                                AppWidgetService.this.updateProvidersForPackageLocked(pkgName);
                            }
                        } else {
                            for (String pkgName : pkgList) {
                                AppWidgetService.this.addProvidersForPackageLocked(pkgName);
                            }
                        }
                        AppWidgetService.this.saveStateLocked();
                    }
                }
                Bundle extras = intent.getExtras();
                if (extras == null || !extras.getBoolean("android.intent.extra.REPLACING", false)) {
                    ArrayList<AppWidgetId> arrayList = AppWidgetService.this.mAppWidgetIds;
                    synchronized (arrayList) {
                        AppWidgetService.this.ensureStateLoadedLocked();
                        for (String pkgName : pkgList) {
                            AppWidgetService.this.removeProvidersForPackageLocked(pkgName);
                            AppWidgetService.this.saveStateLocked();
                        }
                    }
                }
            }
        }
    };

    AppWidgetService(Context context) {
        this.mContext = context;
        this.mPackageManager = context.getPackageManager();
        this.mAlarmManager = (AlarmManager)this.mContext.getSystemService("alarm");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void systemReady(boolean safeMode) {
        this.mSafeMode = safeMode;
        ArrayList<AppWidgetId> arrayList = this.mAppWidgetIds;
        synchronized (arrayList) {
            this.ensureStateLoadedLocked();
        }
        this.mContext.registerReceiver(this.mBroadcastReceiver, new IntentFilter("android.intent.action.BOOT_COMPLETED"), null, null);
        this.mContext.registerReceiver(this.mBroadcastReceiver, new IntentFilter("android.intent.action.CONFIGURATION_CHANGED"), null, null);
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.intent.action.PACKAGE_ADDED");
        filter.addAction("android.intent.action.PACKAGE_CHANGED");
        filter.addAction("android.intent.action.PACKAGE_REMOVED");
        filter.addDataScheme("package");
        this.mContext.registerReceiver(this.mBroadcastReceiver, filter);
        IntentFilter sdFilter = new IntentFilter();
        sdFilter.addAction("android.intent.action.EXTERNAL_APPLICATIONS_AVAILABLE");
        sdFilter.addAction("android.intent.action.EXTERNAL_APPLICATIONS_UNAVAILABLE");
        this.mContext.registerReceiver(this.mBroadcastReceiver, sdFilter);
    }

    private void ensureStateLoadedLocked() {
        if (!this.mStateLoaded) {
            this.loadAppWidgetList();
            this.loadStateLocked();
            this.mStateLoaded = true;
        }
    }

    private void dumpProvider(Provider p, int index, PrintWriter pw) {
        AppWidgetProviderInfo info = p.info;
        pw.print("  [");
        pw.print(index);
        pw.print("] provider ");
        pw.print(info.provider.flattenToShortString());
        pw.println(':');
        pw.print("    min=(");
        pw.print(info.minWidth);
        pw.print("x");
        pw.print(info.minHeight);
        pw.print(")   minResize=(");
        pw.print(info.minResizeWidth);
        pw.print("x");
        pw.print(info.minResizeHeight);
        pw.print(") updatePeriodMillis=");
        pw.print(info.updatePeriodMillis);
        pw.print(" resizeMode=");
        pw.print(info.resizeMode);
        pw.print(" autoAdvanceViewId=");
        pw.print(info.autoAdvanceViewId);
        pw.print(" initialLayout=#");
        pw.print(Integer.toHexString(info.initialLayout));
        pw.print(" zombie=");
        pw.println(p.zombie);
    }

    private void dumpHost(Host host, int index, PrintWriter pw) {
        pw.print("  [");
        pw.print(index);
        pw.print("] hostId=");
        pw.print(host.hostId);
        pw.print(' ');
        pw.print(host.packageName);
        pw.print('/');
        pw.print(host.uid);
        pw.println(':');
        pw.print("    callbacks=");
        pw.println(host.callbacks);
        pw.print("    instances.size=");
        pw.print(host.instances.size());
        pw.print(" zombie=");
        pw.println(host.zombie);
    }

    private void dumpAppWidgetId(AppWidgetId id, int index, PrintWriter pw) {
        pw.print("  [");
        pw.print(index);
        pw.print("] id=");
        pw.println(id.appWidgetId);
        pw.print("    hostId=");
        pw.print(id.host.hostId);
        pw.print(' ');
        pw.print(id.host.packageName);
        pw.print('/');
        pw.println(id.host.uid);
        if (id.provider != null) {
            pw.print("    provider=");
            pw.println(id.provider.info.provider.flattenToShortString());
        }
        if (id.host != null) {
            pw.print("    host.callbacks=");
            pw.println(id.host.callbacks);
        }
        if (id.views != null) {
            pw.print("    views=");
            pw.println(id.views);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.DUMP") != 0) {
            pw.println("Permission Denial: can't dump from from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid());
            return;
        }
        ArrayList<AppWidgetId> arrayList = this.mAppWidgetIds;
        synchronized (arrayList) {
            int i;
            int N = this.mInstalledProviders.size();
            pw.println("Providers:");
            for (i = 0; i < N; ++i) {
                this.dumpProvider(this.mInstalledProviders.get(i), i, pw);
            }
            N = this.mAppWidgetIds.size();
            pw.println(" ");
            pw.println("AppWidgetIds:");
            for (i = 0; i < N; ++i) {
                this.dumpAppWidgetId(this.mAppWidgetIds.get(i), i, pw);
            }
            N = this.mHosts.size();
            pw.println(" ");
            pw.println("Hosts:");
            for (i = 0; i < N; ++i) {
                this.dumpHost(this.mHosts.get(i), i, pw);
            }
            N = this.mDeletedProviders.size();
            pw.println(" ");
            pw.println("Deleted Providers:");
            for (i = 0; i < N; ++i) {
                this.dumpProvider(this.mDeletedProviders.get(i), i, pw);
            }
            N = this.mDeletedHosts.size();
            pw.println(" ");
            pw.println("Deleted Hosts:");
            for (i = 0; i < N; ++i) {
                this.dumpHost(this.mDeletedHosts.get(i), i, pw);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int allocateAppWidgetId(String packageName, int hostId) {
        int callingUid = this.enforceCallingUid(packageName);
        ArrayList<AppWidgetId> arrayList = this.mAppWidgetIds;
        synchronized (arrayList) {
            this.ensureStateLoadedLocked();
            int appWidgetId = this.mNextAppWidgetId++;
            Host host = this.lookupOrAddHostLocked(callingUid, packageName, hostId);
            AppWidgetId id = new AppWidgetId();
            id.appWidgetId = appWidgetId;
            id.host = host;
            host.instances.add(id);
            this.mAppWidgetIds.add(id);
            this.saveStateLocked();
            return appWidgetId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAppWidgetId(int appWidgetId) {
        ArrayList<AppWidgetId> arrayList = this.mAppWidgetIds;
        synchronized (arrayList) {
            this.ensureStateLoadedLocked();
            AppWidgetId id = this.lookupAppWidgetIdLocked(appWidgetId);
            if (id != null) {
                this.deleteAppWidgetLocked(id);
                this.saveStateLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteHost(int hostId) {
        ArrayList<AppWidgetId> arrayList = this.mAppWidgetIds;
        synchronized (arrayList) {
            this.ensureStateLoadedLocked();
            int callingUid = AppWidgetService.getCallingUid();
            Host host = this.lookupHostLocked(callingUid, hostId);
            if (host != null) {
                this.deleteHostLocked(host);
                this.saveStateLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAllHosts() {
        ArrayList<AppWidgetId> arrayList = this.mAppWidgetIds;
        synchronized (arrayList) {
            this.ensureStateLoadedLocked();
            int callingUid = AppWidgetService.getCallingUid();
            int N = this.mHosts.size();
            boolean changed = false;
            for (int i = N - 1; i >= 0; --i) {
                Host host = this.mHosts.get(i);
                if (host.uid != callingUid) continue;
                this.deleteHostLocked(host);
                changed = true;
            }
            if (changed) {
                this.saveStateLocked();
            }
        }
    }

    void deleteHostLocked(Host host) {
        int N = host.instances.size();
        for (int i = N - 1; i >= 0; --i) {
            AppWidgetId id = host.instances.get(i);
            this.deleteAppWidgetLocked(id);
        }
        host.instances.clear();
        this.mHosts.remove(host);
        this.mDeletedHosts.add(host);
        host.callbacks = null;
    }

    void deleteAppWidgetLocked(AppWidgetId id) {
        this.unbindAppWidgetRemoteViewsServicesLocked(id);
        Host host = id.host;
        host.instances.remove(id);
        this.pruneHostLocked(host);
        this.mAppWidgetIds.remove(id);
        Provider p = id.provider;
        if (p != null) {
            p.instances.remove(id);
            if (!p.zombie) {
                Intent intent = new Intent("android.appwidget.action.APPWIDGET_DELETED");
                intent.setComponent(p.info.provider);
                intent.putExtra("appWidgetId", id.appWidgetId);
                this.mContext.sendBroadcast(intent);
                if (p.instances.size() == 0) {
                    this.cancelBroadcasts(p);
                    intent = new Intent("android.appwidget.action.APPWIDGET_DISABLED");
                    intent.setComponent(p.info.provider);
                    this.mContext.sendBroadcast(intent);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancelBroadcasts(Provider p) {
        if (p.broadcast != null) {
            this.mAlarmManager.cancel(p.broadcast);
            long token = Binder.clearCallingIdentity();
            try {
                p.broadcast.cancel();
            }
            finally {
                Binder.restoreCallingIdentity((long)token);
            }
            p.broadcast = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bindAppWidgetId(int appWidgetId, ComponentName provider) {
        this.mContext.enforceCallingPermission("android.permission.BIND_APPWIDGET", "bindGagetId appWidgetId=" + appWidgetId + " provider=" + provider);
        long ident = Binder.clearCallingIdentity();
        try {
            ArrayList<AppWidgetId> arrayList = this.mAppWidgetIds;
            synchronized (arrayList) {
                this.ensureStateLoadedLocked();
                AppWidgetId id = this.lookupAppWidgetIdLocked(appWidgetId);
                if (id == null) {
                    throw new IllegalArgumentException("bad appWidgetId");
                }
                if (id.provider != null) {
                    throw new IllegalArgumentException("appWidgetId " + appWidgetId + " already bound to " + id.provider.info.provider);
                }
                Provider p = this.lookupProviderLocked(provider);
                if (p == null) {
                    throw new IllegalArgumentException("not a appwidget provider: " + provider);
                }
                if (p.zombie) {
                    throw new IllegalArgumentException("can't bind to a 3rd party provider in safe mode: " + provider);
                }
                id.provider = p;
                p.instances.add(id);
                int instancesSize = p.instances.size();
                if (instancesSize == 1) {
                    this.sendEnableIntentLocked(p);
                }
                this.sendUpdateIntentLocked(p, new int[]{appWidgetId});
                this.registerForBroadcastsLocked(p, AppWidgetService.getAppWidgetIds(p));
                this.saveStateLocked();
            }
        }
        finally {
            Binder.restoreCallingIdentity((long)ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bindRemoteViewsService(int appWidgetId, Intent intent, IBinder connection) {
        ArrayList<AppWidgetId> arrayList = this.mAppWidgetIds;
        synchronized (arrayList) {
            this.ensureStateLoadedLocked();
            AppWidgetId id = this.lookupAppWidgetIdLocked(appWidgetId);
            if (id == null) {
                throw new IllegalArgumentException("bad appWidgetId");
            }
            ComponentName componentName = intent.getComponent();
            try {
                ServiceInfo si = this.mContext.getPackageManager().getServiceInfo(componentName, 4096);
                if (!"android.permission.BIND_REMOTEVIEWS".equals(si.permission)) {
                    throw new SecurityException("Selected service does not require android.permission.BIND_REMOTEVIEWS: " + componentName);
                }
            }
            catch (PackageManager.NameNotFoundException e) {
                throw new IllegalArgumentException("Unknown component " + componentName);
            }
            ServiceConnectionProxy conn = null;
            Intent.FilterComparison fc = new Intent.FilterComparison(intent);
            Pair key = Pair.create((Object)appWidgetId, (Object)fc);
            if (this.mBoundRemoteViewsServices.containsKey(key)) {
                conn = (ServiceConnectionProxy)this.mBoundRemoteViewsServices.get(key);
                conn.disconnect();
                this.mContext.unbindService((ServiceConnection)conn);
                this.mBoundRemoteViewsServices.remove(key);
            }
            long token = Binder.clearCallingIdentity();
            try {
                conn = new ServiceConnectionProxy((Pair<Integer, Intent.FilterComparison>)key, connection);
                this.mContext.bindService(intent, (ServiceConnection)conn, 1);
                this.mBoundRemoteViewsServices.put((Pair<Integer, Intent.FilterComparison>)key, conn);
            }
            finally {
                Binder.restoreCallingIdentity((long)token);
            }
            this.incrementAppWidgetServiceRefCount(appWidgetId, fc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbindRemoteViewsService(int appWidgetId, Intent intent) {
        ArrayList<AppWidgetId> arrayList = this.mAppWidgetIds;
        synchronized (arrayList) {
            this.ensureStateLoadedLocked();
            Pair key = Pair.create((Object)appWidgetId, (Object)new Intent.FilterComparison(intent));
            if (this.mBoundRemoteViewsServices.containsKey(key)) {
                AppWidgetId id = this.lookupAppWidgetIdLocked(appWidgetId);
                if (id == null) {
                    throw new IllegalArgumentException("bad appWidgetId");
                }
                ServiceConnectionProxy conn = (ServiceConnectionProxy)this.mBoundRemoteViewsServices.get(key);
                conn.disconnect();
                this.mContext.unbindService((ServiceConnection)conn);
                this.mBoundRemoteViewsServices.remove(key);
            } else {
                Log.e((String)TAG, (String)"Error (unbindRemoteViewsService): Connection not bound");
            }
        }
    }

    private void unbindAppWidgetRemoteViewsServicesLocked(AppWidgetId id) {
        int appWidgetId = id.appWidgetId;
        Iterator<Pair<Integer, Intent.FilterComparison>> it = this.mBoundRemoteViewsServices.keySet().iterator();
        while (it.hasNext()) {
            Pair<Integer, Intent.FilterComparison> key = it.next();
            if ((Integer)key.first != appWidgetId) continue;
            ServiceConnectionProxy conn = (ServiceConnectionProxy)this.mBoundRemoteViewsServices.get(key);
            conn.disconnect();
            this.mContext.unbindService((ServiceConnection)conn);
            it.remove();
        }
        this.decrementAppWidgetServiceRefCount(appWidgetId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyRemoteViewsService(final Intent intent) {
        ServiceConnection conn = new ServiceConnection(){

            public void onServiceConnected(ComponentName name, IBinder service) {
                IRemoteViewsFactory cb = IRemoteViewsFactory.Stub.asInterface((IBinder)service);
                try {
                    cb.onDestroy(intent);
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                }
                catch (RuntimeException e) {
                    e.printStackTrace();
                }
                AppWidgetService.this.mContext.unbindService((ServiceConnection)this);
            }

            public void onServiceDisconnected(ComponentName name) {
            }
        };
        long token = Binder.clearCallingIdentity();
        try {
            this.mContext.bindService(intent, conn, 1);
        }
        finally {
            Binder.restoreCallingIdentity((long)token);
        }
    }

    private void incrementAppWidgetServiceRefCount(int appWidgetId, Intent.FilterComparison fc) {
        HashSet<Object> appWidgetIds = null;
        if (this.mRemoteViewsServicesAppWidgets.containsKey(fc)) {
            appWidgetIds = this.mRemoteViewsServicesAppWidgets.get(fc);
        } else {
            appWidgetIds = new HashSet();
            this.mRemoteViewsServicesAppWidgets.put(fc, appWidgetIds);
        }
        appWidgetIds.add(appWidgetId);
    }

    private void decrementAppWidgetServiceRefCount(int appWidgetId) {
        Iterator<Intent.FilterComparison> it = this.mRemoteViewsServicesAppWidgets.keySet().iterator();
        while (it.hasNext()) {
            Intent.FilterComparison key = it.next();
            HashSet<Integer> ids = this.mRemoteViewsServicesAppWidgets.get(key);
            if (!ids.remove(appWidgetId) || !ids.isEmpty()) continue;
            this.destroyRemoteViewsService(key.getIntent());
            it.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AppWidgetProviderInfo getAppWidgetInfo(int appWidgetId) {
        ArrayList<AppWidgetId> arrayList = this.mAppWidgetIds;
        synchronized (arrayList) {
            this.ensureStateLoadedLocked();
            AppWidgetId id = this.lookupAppWidgetIdLocked(appWidgetId);
            if (id != null && id.provider != null && !id.provider.zombie) {
                return id.provider.info;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemoteViews getAppWidgetViews(int appWidgetId) {
        ArrayList<AppWidgetId> arrayList = this.mAppWidgetIds;
        synchronized (arrayList) {
            this.ensureStateLoadedLocked();
            AppWidgetId id = this.lookupAppWidgetIdLocked(appWidgetId);
            if (id != null) {
                return id.views;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AppWidgetProviderInfo> getInstalledProviders() {
        ArrayList<AppWidgetId> arrayList = this.mAppWidgetIds;
        synchronized (arrayList) {
            this.ensureStateLoadedLocked();
            int N = this.mInstalledProviders.size();
            ArrayList<AppWidgetProviderInfo> result = new ArrayList<AppWidgetProviderInfo>(N);
            for (int i = 0; i < N; ++i) {
                Provider p = this.mInstalledProviders.get(i);
                if (p.zombie) continue;
                result.add(p.info);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAppWidgetIds(int[] appWidgetIds, RemoteViews views) {
        if (appWidgetIds == null) {
            return;
        }
        if (appWidgetIds.length == 0) {
            return;
        }
        int N = appWidgetIds.length;
        ArrayList<AppWidgetId> arrayList = this.mAppWidgetIds;
        synchronized (arrayList) {
            this.ensureStateLoadedLocked();
            for (int i = 0; i < N; ++i) {
                AppWidgetId id = this.lookupAppWidgetIdLocked(appWidgetIds[i]);
                this.updateAppWidgetInstanceLocked(id, views);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void partiallyUpdateAppWidgetIds(int[] appWidgetIds, RemoteViews views) {
        if (appWidgetIds == null) {
            return;
        }
        if (appWidgetIds.length == 0) {
            return;
        }
        int N = appWidgetIds.length;
        ArrayList<AppWidgetId> arrayList = this.mAppWidgetIds;
        synchronized (arrayList) {
            this.ensureStateLoadedLocked();
            for (int i = 0; i < N; ++i) {
                AppWidgetId id = this.lookupAppWidgetIdLocked(appWidgetIds[i]);
                this.updateAppWidgetInstanceLocked(id, views, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyAppWidgetViewDataChanged(int[] appWidgetIds, int viewId) {
        if (appWidgetIds == null) {
            return;
        }
        if (appWidgetIds.length == 0) {
            return;
        }
        int N = appWidgetIds.length;
        ArrayList<AppWidgetId> arrayList = this.mAppWidgetIds;
        synchronized (arrayList) {
            this.ensureStateLoadedLocked();
            for (int i = 0; i < N; ++i) {
                AppWidgetId id = this.lookupAppWidgetIdLocked(appWidgetIds[i]);
                this.notifyAppWidgetViewDataChangedInstanceLocked(id, viewId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAppWidgetProvider(ComponentName provider, RemoteViews views) {
        ArrayList<AppWidgetId> arrayList = this.mAppWidgetIds;
        synchronized (arrayList) {
            this.ensureStateLoadedLocked();
            Provider p = this.lookupProviderLocked(provider);
            if (p == null) {
                Slog.w((String)TAG, (String)("updateAppWidgetProvider: provider doesn't exist: " + provider));
                return;
            }
            ArrayList<AppWidgetId> instances = p.instances;
            int callingUid = AppWidgetService.getCallingUid();
            int N = instances.size();
            for (int i = 0; i < N; ++i) {
                AppWidgetId id = instances.get(i);
                if (!this.canAccessAppWidgetId(id, callingUid)) continue;
                this.updateAppWidgetInstanceLocked(id, views);
            }
        }
    }

    void updateAppWidgetInstanceLocked(AppWidgetId id, RemoteViews views) {
        this.updateAppWidgetInstanceLocked(id, views, false);
    }

    void updateAppWidgetInstanceLocked(AppWidgetId id, RemoteViews views, boolean isPartialUpdate) {
        if (id != null && id.provider != null && !id.provider.zombie && !id.host.zombie) {
            if (!isPartialUpdate) {
                id.views = views;
            }
            if (id.host.callbacks != null) {
                try {
                    id.host.callbacks.updateAppWidget(id.appWidgetId, views);
                }
                catch (RemoteException e) {
                    id.host.callbacks = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyAppWidgetViewDataChangedInstanceLocked(AppWidgetId id, int viewId) {
        if (id != null && id.provider != null && !id.provider.zombie && !id.host.zombie) {
            if (id.host.callbacks != null) {
                try {
                    id.host.callbacks.viewDataChanged(id.appWidgetId, viewId);
                }
                catch (RemoteException e) {
                    id.host.callbacks = null;
                }
            }
            if (id.host.callbacks == null) {
                Set<Intent.FilterComparison> keys = this.mRemoteViewsServicesAppWidgets.keySet();
                for (Intent.FilterComparison key : keys) {
                    if (!this.mRemoteViewsServicesAppWidgets.get(key).contains(id.appWidgetId)) continue;
                    Intent intent = key.getIntent();
                    ServiceConnection conn = new ServiceConnection(){

                        public void onServiceConnected(ComponentName name, IBinder service) {
                            IRemoteViewsFactory cb = IRemoteViewsFactory.Stub.asInterface((IBinder)service);
                            try {
                                cb.onDataSetChangedAsync();
                            }
                            catch (RemoteException e) {
                                e.printStackTrace();
                            }
                            catch (RuntimeException e) {
                                e.printStackTrace();
                            }
                            AppWidgetService.this.mContext.unbindService((ServiceConnection)this);
                        }

                        public void onServiceDisconnected(ComponentName name) {
                        }
                    };
                    long token = Binder.clearCallingIdentity();
                    try {
                        this.mContext.bindService(intent, conn, 1);
                    }
                    finally {
                        Binder.restoreCallingIdentity((long)token);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] startListening(IAppWidgetHost callbacks, String packageName, int hostId, List<RemoteViews> updatedViews) {
        int callingUid = this.enforceCallingUid(packageName);
        ArrayList<AppWidgetId> arrayList = this.mAppWidgetIds;
        synchronized (arrayList) {
            this.ensureStateLoadedLocked();
            Host host = this.lookupOrAddHostLocked(callingUid, packageName, hostId);
            host.callbacks = callbacks;
            updatedViews.clear();
            ArrayList<AppWidgetId> instances = host.instances;
            int N = instances.size();
            int[] updatedIds = new int[N];
            for (int i = 0; i < N; ++i) {
                AppWidgetId id = instances.get(i);
                updatedIds[i] = id.appWidgetId;
                updatedViews.add(id.views);
            }
            return updatedIds;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopListening(int hostId) {
        ArrayList<AppWidgetId> arrayList = this.mAppWidgetIds;
        synchronized (arrayList) {
            this.ensureStateLoadedLocked();
            Host host = this.lookupHostLocked(AppWidgetService.getCallingUid(), hostId);
            if (host != null) {
                host.callbacks = null;
                this.pruneHostLocked(host);
            }
        }
    }

    boolean canAccessAppWidgetId(AppWidgetId id, int callingUid) {
        if (id.host.uid == callingUid) {
            return true;
        }
        if (id.provider != null && id.provider.uid == callingUid) {
            return true;
        }
        return this.mContext.checkCallingOrSelfPermission("android.permission.BIND_APPWIDGET") == 0;
    }

    AppWidgetId lookupAppWidgetIdLocked(int appWidgetId) {
        int callingUid = AppWidgetService.getCallingUid();
        int N = this.mAppWidgetIds.size();
        for (int i = 0; i < N; ++i) {
            AppWidgetId id = this.mAppWidgetIds.get(i);
            if (id.appWidgetId != appWidgetId || !this.canAccessAppWidgetId(id, callingUid)) continue;
            return id;
        }
        return null;
    }

    Provider lookupProviderLocked(ComponentName provider) {
        int N = this.mInstalledProviders.size();
        for (int i = 0; i < N; ++i) {
            Provider p = this.mInstalledProviders.get(i);
            if (!p.info.provider.equals((Object)provider)) continue;
            return p;
        }
        return null;
    }

    Host lookupHostLocked(int uid, int hostId) {
        int N = this.mHosts.size();
        for (int i = 0; i < N; ++i) {
            Host h = this.mHosts.get(i);
            if (h.uid != uid || h.hostId != hostId) continue;
            return h;
        }
        return null;
    }

    Host lookupOrAddHostLocked(int uid, String packageName, int hostId) {
        int N = this.mHosts.size();
        for (int i = 0; i < N; ++i) {
            Host h = this.mHosts.get(i);
            if (h.hostId != hostId || !h.packageName.equals(packageName)) continue;
            return h;
        }
        Host host = new Host();
        host.packageName = packageName;
        host.uid = uid;
        host.hostId = hostId;
        this.mHosts.add(host);
        return host;
    }

    void pruneHostLocked(Host host) {
        if (host.instances.size() == 0 && host.callbacks == null) {
            this.mHosts.remove(host);
        }
    }

    void loadAppWidgetList() {
        PackageManager pm = this.mPackageManager;
        Intent intent = new Intent("android.appwidget.action.APPWIDGET_UPDATE");
        List broadcastReceivers = pm.queryBroadcastReceivers(intent, 128);
        int N = broadcastReceivers == null ? 0 : broadcastReceivers.size();
        for (int i = 0; i < N; ++i) {
            ResolveInfo ri = (ResolveInfo)broadcastReceivers.get(i);
            this.addProviderLocked(ri);
        }
    }

    boolean addProviderLocked(ResolveInfo ri) {
        if ((ri.activityInfo.applicationInfo.flags & 0x40000) != 0) {
            return false;
        }
        if (!ri.activityInfo.isEnabled()) {
            return false;
        }
        Provider p = this.parseProviderInfoXml(new ComponentName(ri.activityInfo.packageName, ri.activityInfo.name), ri);
        if (p != null) {
            this.mInstalledProviders.add(p);
            return true;
        }
        return false;
    }

    void removeProviderLocked(int index, Provider p) {
        int N = p.instances.size();
        for (int i = 0; i < N; ++i) {
            AppWidgetId id = p.instances.get(i);
            this.updateAppWidgetInstanceLocked(id, null);
            this.cancelBroadcasts(p);
            id.host.instances.remove(id);
            this.mAppWidgetIds.remove(id);
            id.provider = null;
            this.pruneHostLocked(id.host);
            id.host = null;
        }
        p.instances.clear();
        this.mInstalledProviders.remove(index);
        this.mDeletedProviders.add(p);
        this.cancelBroadcasts(p);
    }

    void sendEnableIntentLocked(Provider p) {
        Intent intent = new Intent("android.appwidget.action.APPWIDGET_ENABLED");
        intent.setComponent(p.info.provider);
        this.mContext.sendBroadcast(intent);
    }

    void sendUpdateIntentLocked(Provider p, int[] appWidgetIds) {
        if (appWidgetIds != null && appWidgetIds.length > 0) {
            Intent intent = new Intent("android.appwidget.action.APPWIDGET_UPDATE");
            intent.putExtra("appWidgetIds", appWidgetIds);
            intent.setComponent(p.info.provider);
            this.mContext.sendBroadcast(intent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerForBroadcastsLocked(Provider p, int[] appWidgetIds) {
        if (p.info.updatePeriodMillis > 0) {
            boolean alreadyRegistered = p.broadcast != null;
            Intent intent = new Intent("android.appwidget.action.APPWIDGET_UPDATE");
            intent.putExtra("appWidgetIds", appWidgetIds);
            intent.setComponent(p.info.provider);
            long token = Binder.clearCallingIdentity();
            try {
                p.broadcast = PendingIntent.getBroadcast((Context)this.mContext, (int)1, (Intent)intent, (int)0x8000000);
            }
            finally {
                Binder.restoreCallingIdentity((long)token);
            }
            if (!alreadyRegistered) {
                long period = p.info.updatePeriodMillis;
                if (period < 1800000L) {
                    period = 1800000L;
                }
                this.mAlarmManager.setInexactRepeating(2, SystemClock.elapsedRealtime() + period, period, p.broadcast);
            }
        }
    }

    static int[] getAppWidgetIds(Provider p) {
        int instancesSize = p.instances.size();
        int[] appWidgetIds = new int[instancesSize];
        for (int i = 0; i < instancesSize; ++i) {
            appWidgetIds[i] = p.instances.get((int)i).appWidgetId;
        }
        return appWidgetIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getAppWidgetIds(ComponentName provider) {
        ArrayList<AppWidgetId> arrayList = this.mAppWidgetIds;
        synchronized (arrayList) {
            this.ensureStateLoadedLocked();
            Provider p = this.lookupProviderLocked(provider);
            if (p != null && AppWidgetService.getCallingUid() == p.uid) {
                return AppWidgetService.getAppWidgetIds(p);
            }
            return new int[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Provider parseProviderInfoXml(ComponentName component, ResolveInfo ri) {
        Provider p = null;
        ActivityInfo activityInfo = ri.activityInfo;
        XmlResourceParser parser = null;
        try {
            int type;
            parser = activityInfo.loadXmlMetaData(this.mPackageManager, "android.appwidget.provider");
            if (parser == null) {
                Slog.w((String)TAG, (String)("No android.appwidget.provider meta-data for AppWidget provider '" + component + '\''));
                Provider provider = null;
                return provider;
            }
            AttributeSet attrs = Xml.asAttributeSet((XmlPullParser)parser);
            while ((type = parser.next()) != 1 && type != 2) {
            }
            String nodeName = parser.getName();
            if (!"appwidget-provider".equals(nodeName)) {
                Slog.w((String)TAG, (String)("Meta-data does not start with appwidget-provider tag for AppWidget provider '" + component + '\''));
                Provider provider = null;
                return provider;
            }
            p = new Provider();
            AppWidgetProviderInfo info = p.info = new AppWidgetProviderInfo();
            info.provider = component;
            p.uid = activityInfo.applicationInfo.uid;
            Resources res = this.mPackageManager.getResourcesForApplication(activityInfo.applicationInfo);
            TypedArray sa = res.obtainAttributes(attrs, R.styleable.AppWidgetProviderInfo);
            TypedValue value = sa.peekValue(0);
            info.minWidth = value != null ? value.data : 0;
            value = sa.peekValue(1);
            info.minHeight = value != null ? value.data : 0;
            value = sa.peekValue(8);
            info.minResizeWidth = value != null ? value.data : info.minWidth;
            value = sa.peekValue(9);
            info.minResizeHeight = value != null ? value.data : info.minHeight;
            info.updatePeriodMillis = sa.getInt(2, 0);
            info.initialLayout = sa.getResourceId(3, 0);
            String className = sa.getString(4);
            if (className != null) {
                info.configure = new ComponentName(component.getPackageName(), className);
            }
            info.label = ((Object)activityInfo.loadLabel(this.mPackageManager)).toString();
            info.icon = ri.getIconResource();
            info.previewImage = sa.getResourceId(5, 0);
            info.autoAdvanceViewId = sa.getResourceId(6, -1);
            info.resizeMode = sa.getInt(7, 0);
            sa.recycle();
        }
        catch (Exception e) {
            Slog.w((String)TAG, (String)("XML parsing failed for AppWidget provider '" + component + '\''), (Throwable)e);
            Provider provider = null;
            return provider;
        }
        finally {
            if (parser != null) {
                parser.close();
            }
        }
        return p;
    }

    int getUidForPackage(String packageName) throws PackageManager.NameNotFoundException {
        PackageInfo pkgInfo = this.mPackageManager.getPackageInfo(packageName, 0);
        if (pkgInfo == null || pkgInfo.applicationInfo == null) {
            throw new PackageManager.NameNotFoundException();
        }
        return pkgInfo.applicationInfo.uid;
    }

    int enforceCallingUid(String packageName) throws IllegalArgumentException {
        int packageUid;
        int callingUid = AppWidgetService.getCallingUid();
        try {
            packageUid = this.getUidForPackage(packageName);
        }
        catch (PackageManager.NameNotFoundException ex) {
            throw new IllegalArgumentException("packageName and uid don't match packageName=" + packageName);
        }
        if (callingUid != packageUid) {
            throw new IllegalArgumentException("packageName and uid don't match packageName=" + packageName);
        }
        return callingUid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendInitialBroadcasts() {
        ArrayList<AppWidgetId> arrayList = this.mAppWidgetIds;
        synchronized (arrayList) {
            this.ensureStateLoadedLocked();
            int N = this.mInstalledProviders.size();
            for (int i = 0; i < N; ++i) {
                Provider p = this.mInstalledProviders.get(i);
                if (p.instances.size() <= 0) continue;
                this.sendEnableIntentLocked(p);
                int[] appWidgetIds = AppWidgetService.getAppWidgetIds(p);
                this.sendUpdateIntentLocked(p, appWidgetIds);
                this.registerForBroadcastsLocked(p, appWidgetIds);
            }
        }
    }

    void loadStateLocked() {
        AtomicFile file = this.savedStateFile();
        try {
            FileInputStream stream = file.openRead();
            this.readStateFromFileLocked(stream);
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    Slog.w((String)TAG, (String)("Failed to close state FileInputStream " + e));
                }
            }
        }
        catch (FileNotFoundException e) {
            Slog.w((String)TAG, (String)("Failed to read state: " + e));
        }
    }

    void saveStateLocked() {
        AtomicFile file = this.savedStateFile();
        try {
            FileOutputStream stream = file.startWrite();
            if (this.writeStateToFileLocked(stream)) {
                file.finishWrite(stream);
            } else {
                file.failWrite(stream);
                Slog.w((String)TAG, (String)"Failed to save state, restoring backup.");
            }
        }
        catch (IOException e) {
            Slog.w((String)TAG, (String)("Failed open state file for write: " + e));
        }
    }

    boolean writeStateToFileLocked(FileOutputStream stream) {
        try {
            int i;
            FastXmlSerializer out = new FastXmlSerializer();
            out.setOutput((OutputStream)stream, "utf-8");
            out.startDocument(null, Boolean.valueOf(true));
            out.startTag(null, "gs");
            int providerIndex = 0;
            int N = this.mInstalledProviders.size();
            for (i = 0; i < N; ++i) {
                Provider p = this.mInstalledProviders.get(i);
                if (p.instances.size() <= 0) continue;
                out.startTag(null, "p");
                out.attribute(null, "pkg", p.info.provider.getPackageName());
                out.attribute(null, "cl", p.info.provider.getClassName());
                out.endTag(null, "p");
                p.tag = providerIndex++;
            }
            N = this.mHosts.size();
            i = 0;
            while (i < N) {
                Host host = this.mHosts.get(i);
                out.startTag(null, "h");
                out.attribute(null, "pkg", host.packageName);
                out.attribute(null, "id", Integer.toHexString(host.hostId));
                out.endTag(null, "h");
                host.tag = i++;
            }
            N = this.mAppWidgetIds.size();
            for (i = 0; i < N; ++i) {
                AppWidgetId id = this.mAppWidgetIds.get(i);
                out.startTag(null, "g");
                out.attribute(null, "id", Integer.toHexString(id.appWidgetId));
                out.attribute(null, "h", Integer.toHexString(id.host.tag));
                if (id.provider != null) {
                    out.attribute(null, "p", Integer.toHexString(id.provider.tag));
                }
                out.endTag(null, "g");
            }
            out.endTag(null, "gs");
            out.endDocument();
            return true;
        }
        catch (IOException e) {
            Slog.w((String)TAG, (String)("Failed to write state: " + e));
            return false;
        }
    }

    void readStateFromFileLocked(FileInputStream stream) {
        boolean success = false;
        try {
            int type;
            XmlPullParser parser = Xml.newPullParser();
            parser.setInput((InputStream)stream, null);
            int providerIndex = 0;
            HashMap<Integer, Provider> loadedProviders = new HashMap<Integer, Provider>();
            do {
                String providerString;
                if ((type = parser.next()) != 2) continue;
                String tag = parser.getName();
                if ("p".equals(tag)) {
                    String pkg = parser.getAttributeValue(null, "pkg");
                    String cl = parser.getAttributeValue(null, "cl");
                    PackageManager packageManager = this.mContext.getPackageManager();
                    try {
                        packageManager.getReceiverInfo(new ComponentName(pkg, cl), 0);
                    }
                    catch (PackageManager.NameNotFoundException e) {
                        String[] pkgs = packageManager.currentToCanonicalPackageNames(new String[]{pkg});
                        pkg = pkgs[0];
                    }
                    Provider p = this.lookupProviderLocked(new ComponentName(pkg, cl));
                    if (p == null && this.mSafeMode) {
                        p = new Provider();
                        p.info = new AppWidgetProviderInfo();
                        p.info.provider = new ComponentName(pkg, cl);
                        p.zombie = true;
                        this.mInstalledProviders.add(p);
                    }
                    if (p != null) {
                        loadedProviders.put(providerIndex, p);
                    }
                    ++providerIndex;
                    continue;
                }
                if ("h".equals(tag)) {
                    Host host = new Host();
                    host.packageName = parser.getAttributeValue(null, "pkg");
                    try {
                        host.uid = this.getUidForPackage(host.packageName);
                    }
                    catch (PackageManager.NameNotFoundException ex) {
                        host.zombie = true;
                    }
                    if (host.zombie && !this.mSafeMode) continue;
                    host.hostId = Integer.parseInt(parser.getAttributeValue(null, "id"), 16);
                    this.mHosts.add(host);
                    continue;
                }
                if (!"g".equals(tag)) continue;
                AppWidgetId id = new AppWidgetId();
                id.appWidgetId = Integer.parseInt(parser.getAttributeValue(null, "id"), 16);
                if (id.appWidgetId >= this.mNextAppWidgetId) {
                    this.mNextAppWidgetId = id.appWidgetId + 1;
                }
                if ((providerString = parser.getAttributeValue(null, "p")) != null) {
                    int pIndex = Integer.parseInt(providerString, 16);
                    id.provider = (Provider)loadedProviders.get(pIndex);
                    if (id.provider == null) continue;
                }
                int hIndex = Integer.parseInt(parser.getAttributeValue(null, "h"), 16);
                id.host = this.mHosts.get(hIndex);
                if (id.host == null) continue;
                if (id.provider != null) {
                    id.provider.instances.add(id);
                }
                id.host.instances.add(id);
                this.mAppWidgetIds.add(id);
            } while (type != 1);
            success = true;
        }
        catch (NullPointerException e) {
            Slog.w((String)TAG, (String)("failed parsing " + e));
        }
        catch (NumberFormatException e) {
            Slog.w((String)TAG, (String)("failed parsing " + e));
        }
        catch (XmlPullParserException e) {
            Slog.w((String)TAG, (String)("failed parsing " + (Object)((Object)e)));
        }
        catch (IOException e) {
            Slog.w((String)TAG, (String)("failed parsing " + e));
        }
        catch (IndexOutOfBoundsException e) {
            Slog.w((String)TAG, (String)("failed parsing " + e));
        }
        if (success) {
            for (int i = this.mHosts.size() - 1; i >= 0; --i) {
                this.pruneHostLocked(this.mHosts.get(i));
            }
        } else {
            Slog.w((String)TAG, (String)"Failed to read state, clearing widgets and hosts.");
            this.mAppWidgetIds.clear();
            this.mHosts.clear();
            int N = this.mInstalledProviders.size();
            for (int i = 0; i < N; ++i) {
                this.mInstalledProviders.get((int)i).instances.clear();
            }
        }
    }

    AtomicFile savedStateFile() {
        return new AtomicFile(new File("/data/system/appwidgets.xml"));
    }

    void addProvidersForPackageLocked(String pkgName) {
        Intent intent = new Intent("android.appwidget.action.APPWIDGET_UPDATE");
        intent.setPackage(pkgName);
        List broadcastReceivers = this.mPackageManager.queryBroadcastReceivers(intent, 128);
        int N = broadcastReceivers == null ? 0 : broadcastReceivers.size();
        for (int i = 0; i < N; ++i) {
            ResolveInfo ri = (ResolveInfo)broadcastReceivers.get(i);
            ActivityInfo ai = ri.activityInfo;
            if ((ai.applicationInfo.flags & 0x40000) != 0 || !pkgName.equals(ai.packageName)) continue;
            this.addProviderLocked(ri);
        }
    }

    void updateProvidersForPackageLocked(String pkgName) {
        int i;
        HashSet<String> keep = new HashSet<String>();
        Intent intent = new Intent("android.appwidget.action.APPWIDGET_UPDATE");
        intent.setPackage(pkgName);
        List broadcastReceivers = this.mPackageManager.queryBroadcastReceivers(intent, 128);
        int N = broadcastReceivers == null ? 0 : broadcastReceivers.size();
        for (i = 0; i < N; ++i) {
            ResolveInfo ri = (ResolveInfo)broadcastReceivers.get(i);
            ActivityInfo ai = ri.activityInfo;
            if ((ai.applicationInfo.flags & 0x40000) != 0 || !pkgName.equals(ai.packageName)) continue;
            ComponentName component = new ComponentName(ai.packageName, ai.name);
            Provider p = this.lookupProviderLocked(component);
            if (p == null) {
                if (!this.addProviderLocked(ri)) continue;
                keep.add(ai.name);
                continue;
            }
            Provider parsed = this.parseProviderInfoXml(component, ri);
            if (parsed == null) continue;
            keep.add(ai.name);
            p.info = parsed.info;
            int M = p.instances.size();
            if (M <= 0) continue;
            int[] appWidgetIds = AppWidgetService.getAppWidgetIds(p);
            this.cancelBroadcasts(p);
            this.registerForBroadcastsLocked(p, appWidgetIds);
            for (int j = 0; j < M; ++j) {
                AppWidgetId id = p.instances.get(j);
                id.views = null;
                if (id.host == null || id.host.callbacks == null) continue;
                try {
                    id.host.callbacks.providerChanged(id.appWidgetId, p.info);
                    continue;
                }
                catch (RemoteException ex) {
                    id.host.callbacks = null;
                }
            }
            this.sendUpdateIntentLocked(p, appWidgetIds);
        }
        N = this.mInstalledProviders.size();
        for (i = N - 1; i >= 0; --i) {
            Provider p = this.mInstalledProviders.get(i);
            if (!pkgName.equals(p.info.provider.getPackageName()) || keep.contains(p.info.provider.getClassName())) continue;
            this.removeProviderLocked(i, p);
        }
    }

    void removeProvidersForPackageLocked(String pkgName) {
        int i;
        int N = this.mInstalledProviders.size();
        for (i = N - 1; i >= 0; --i) {
            Provider p = this.mInstalledProviders.get(i);
            if (!pkgName.equals(p.info.provider.getPackageName())) continue;
            this.removeProviderLocked(i, p);
        }
        N = this.mHosts.size();
        for (i = N - 1; i >= 0; --i) {
            Host host = this.mHosts.get(i);
            if (!pkgName.equals(host.packageName)) continue;
            this.deleteHostLocked(host);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ServiceConnectionProxy
    implements ServiceConnection {
        private final Pair<Integer, Intent.FilterComparison> mKey;
        private final IBinder mConnectionCb;

        ServiceConnectionProxy(Pair<Integer, Intent.FilterComparison> key, IBinder connectionCb) {
            this.mKey = key;
            this.mConnectionCb = connectionCb;
        }

        public void onServiceConnected(ComponentName name, IBinder service) {
            IRemoteViewsAdapterConnection cb = IRemoteViewsAdapterConnection.Stub.asInterface((IBinder)this.mConnectionCb);
            try {
                cb.onServiceConnected(service);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void onServiceDisconnected(ComponentName name) {
            this.disconnect();
        }

        public void disconnect() {
            IRemoteViewsAdapterConnection cb = IRemoteViewsAdapterConnection.Stub.asInterface((IBinder)this.mConnectionCb);
            try {
                cb.onServiceDisconnected();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    static class AppWidgetId {
        int appWidgetId;
        Provider provider;
        RemoteViews views;
        Host host;

        AppWidgetId() {
        }
    }

    static class Host {
        int uid;
        int hostId;
        String packageName;
        ArrayList<AppWidgetId> instances = new ArrayList();
        IAppWidgetHost callbacks;
        boolean zombie;
        int tag;

        Host() {
        }
    }

    static class Provider {
        int uid;
        AppWidgetProviderInfo info;
        ArrayList<AppWidgetId> instances = new ArrayList();
        PendingIntent broadcast;
        boolean zombie;
        int tag;

        Provider() {
        }
    }
}

