/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.app.ActivityManagerNative;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.os.Binder;
import android.os.DropBoxManager;
import android.os.FileUtils;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.os.UEventObserver;
import android.provider.Settings;
import android.util.EventLog;
import android.util.Slog;
import com.android.internal.app.IBatteryStats;
import com.android.server.LightsService;
import com.android.server.am.BatteryStatsService;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;

class BatteryService
extends Binder {
    private static final String TAG = BatteryService.class.getSimpleName();
    private static final boolean LOCAL_LOGV = false;
    static final int BATTERY_SCALE = 100;
    private int mCriticalBatteryLevel;
    private static final int DUMP_MAX_LENGTH = 24576;
    private static final String[] DUMPSYS_ARGS = new String[]{"--checkin", "-u"};
    private static final String BATTERY_STATS_SERVICE_NAME = "batteryinfo";
    private static final String DUMPSYS_DATA_PATH = "/data/system/";
    private static final int BATTERY_PLUGGED_NONE = 0;
    private final Context mContext;
    private final IBatteryStats mBatteryStats;
    private boolean mAcOnline;
    private boolean mUsbOnline;
    private int mBatteryStatus;
    private int mBatteryHealth;
    private boolean mBatteryPresent;
    private int mBatteryLevel;
    private int mBatteryVoltage;
    private int mBatteryTemperature;
    private String mBatteryTechnology;
    private boolean mBatteryLevelCritical;
    private int mInvalidCharger;
    private int mLastBatteryStatus;
    private int mLastBatteryHealth;
    private boolean mLastBatteryPresent;
    private int mLastBatteryLevel;
    private int mLastBatteryVoltage;
    private int mLastBatteryTemperature;
    private boolean mLastBatteryLevelCritical;
    private int mLastInvalidCharger;
    private int mLowBatteryWarningLevel;
    private int mLowBatteryCloseWarningLevel;
    private int mPlugType;
    private int mLastPlugType = -1;
    private long mDischargeStartTime;
    private int mDischargeStartLevel;
    private Led mLed;
    private boolean mSentLowBatteryBroadcast = false;
    private UEventObserver mPowerSupplyObserver = new UEventObserver(){

        public void onUEvent(UEventObserver.UEvent event) {
            BatteryService.this.update();
        }
    };
    private UEventObserver mInvalidChargerObserver = new UEventObserver(){

        public void onUEvent(UEventObserver.UEvent event) {
            int invalidCharger;
            int n = invalidCharger = "1".equals(event.get("SWITCH_STATE")) ? 1 : 0;
            if (BatteryService.this.mInvalidCharger != invalidCharger) {
                BatteryService.this.mInvalidCharger = invalidCharger;
                BatteryService.this.update();
            }
        }
    };

    public BatteryService(Context context, LightsService lights) {
        this.mContext = context;
        this.mLed = new Led(context, lights);
        this.mBatteryStats = BatteryStatsService.getService();
        this.mCriticalBatteryLevel = this.mContext.getResources().getInteger(17694739);
        this.mLowBatteryWarningLevel = this.mContext.getResources().getInteger(17694740);
        this.mLowBatteryCloseWarningLevel = this.mContext.getResources().getInteger(17694741);
        this.mPowerSupplyObserver.startObserving("SUBSYSTEM=power_supply");
        if (new File("/sys/devices/virtual/switch/invalid_charger/state").exists()) {
            this.mInvalidChargerObserver.startObserving("DEVPATH=/devices/virtual/switch/invalid_charger");
        }
        this.update();
    }

    final boolean isPowered() {
        return this.mAcOnline || this.mUsbOnline || this.mBatteryStatus == 1;
    }

    final boolean isPowered(int plugTypeSet) {
        if (this.mBatteryStatus == 1) {
            return true;
        }
        if (plugTypeSet == 0) {
            return false;
        }
        int plugTypeBit = 0;
        if (this.mAcOnline) {
            plugTypeBit |= 1;
        }
        if (this.mUsbOnline) {
            plugTypeBit |= 2;
        }
        return (plugTypeSet & plugTypeBit) != 0;
    }

    final int getPlugType() {
        return this.mPlugType;
    }

    final int getBatteryLevel() {
        return this.mBatteryLevel;
    }

    void systemReady() {
        this.shutdownIfNoPower();
        this.shutdownIfOverTemp();
    }

    private final void shutdownIfNoPower() {
        if (this.mBatteryLevel == 0 && !this.isPowered() && ActivityManagerNative.isSystemReady()) {
            Intent intent = new Intent("android.intent.action.ACTION_REQUEST_SHUTDOWN");
            intent.putExtra("android.intent.extra.KEY_CONFIRM", false);
            intent.setFlags(0x10000000);
            this.mContext.startActivity(intent);
        }
    }

    private final void shutdownIfOverTemp() {
        if (this.mBatteryTemperature > 680 && ActivityManagerNative.isSystemReady()) {
            Intent intent = new Intent("android.intent.action.ACTION_REQUEST_SHUTDOWN");
            intent.putExtra("android.intent.extra.KEY_CONFIRM", false);
            intent.setFlags(0x10000000);
            this.mContext.startActivity(intent);
        }
    }

    private native void native_update();

    private final synchronized void update() {
        this.native_update();
        this.processValues();
    }

    private void processValues() {
        boolean logOutlier = false;
        long dischargeDuration = 0L;
        boolean bl = this.mBatteryLevelCritical = this.mBatteryLevel <= this.mCriticalBatteryLevel;
        this.mPlugType = this.mAcOnline ? 1 : (this.mUsbOnline ? 2 : 0);
        try {
            this.mBatteryStats.setBatteryState(this.mBatteryStatus, this.mBatteryHealth, this.mPlugType, this.mBatteryLevel, this.mBatteryTemperature, this.mBatteryVoltage);
        }
        catch (RemoteException e) {
            // empty catch block
        }
        this.shutdownIfNoPower();
        this.shutdownIfOverTemp();
        if (this.mBatteryStatus != this.mLastBatteryStatus || this.mBatteryHealth != this.mLastBatteryHealth || this.mBatteryPresent != this.mLastBatteryPresent || this.mBatteryLevel != this.mLastBatteryLevel || this.mPlugType != this.mLastPlugType || this.mBatteryVoltage != this.mLastBatteryVoltage || this.mBatteryTemperature != this.mLastBatteryTemperature || this.mInvalidCharger != this.mLastInvalidCharger) {
            if (this.mPlugType != this.mLastPlugType) {
                if (this.mLastPlugType == 0) {
                    if (this.mDischargeStartTime != 0L && this.mDischargeStartLevel != this.mBatteryLevel) {
                        dischargeDuration = SystemClock.elapsedRealtime() - this.mDischargeStartTime;
                        logOutlier = true;
                        EventLog.writeEvent((int)2730, (Object[])new Object[]{dischargeDuration, this.mDischargeStartLevel, this.mBatteryLevel});
                        this.mDischargeStartTime = 0L;
                    }
                } else if (this.mPlugType == 0) {
                    this.mDischargeStartTime = SystemClock.elapsedRealtime();
                    this.mDischargeStartLevel = this.mBatteryLevel;
                }
            }
            if (this.mBatteryStatus != this.mLastBatteryStatus || this.mBatteryHealth != this.mLastBatteryHealth || this.mBatteryPresent != this.mLastBatteryPresent || this.mPlugType != this.mLastPlugType) {
                EventLog.writeEvent((int)2723, (Object[])new Object[]{this.mBatteryStatus, this.mBatteryHealth, this.mBatteryPresent ? 1 : 0, this.mPlugType, this.mBatteryTechnology});
            }
            if (this.mBatteryLevel != this.mLastBatteryLevel || this.mBatteryVoltage != this.mLastBatteryVoltage || this.mBatteryTemperature != this.mLastBatteryTemperature) {
                EventLog.writeEvent((int)2722, (Object[])new Object[]{this.mBatteryLevel, this.mBatteryVoltage, this.mBatteryTemperature});
            }
            if (this.mBatteryLevelCritical && !this.mLastBatteryLevelCritical && this.mPlugType == 0) {
                dischargeDuration = SystemClock.elapsedRealtime() - this.mDischargeStartTime;
                logOutlier = true;
            }
            boolean plugged = this.mPlugType != 0;
            boolean oldPlugged = this.mLastPlugType != 0;
            boolean sendBatteryLow = !plugged && this.mBatteryStatus != 1 && this.mBatteryLevel <= this.mLowBatteryWarningLevel && (oldPlugged || this.mLastBatteryLevel > this.mLowBatteryWarningLevel);
            this.sendIntent();
            Intent statusIntent = new Intent();
            statusIntent.setFlags(0x10000000);
            if (this.mPlugType != 0 && this.mLastPlugType == 0) {
                statusIntent.setAction("android.intent.action.ACTION_POWER_CONNECTED");
                this.mContext.sendBroadcast(statusIntent);
            } else if (this.mPlugType == 0 && this.mLastPlugType != 0) {
                statusIntent.setAction("android.intent.action.ACTION_POWER_DISCONNECTED");
                this.mContext.sendBroadcast(statusIntent);
            }
            if (sendBatteryLow) {
                this.mSentLowBatteryBroadcast = true;
                statusIntent.setAction("android.intent.action.BATTERY_LOW");
                this.mContext.sendBroadcast(statusIntent);
            } else if (this.mSentLowBatteryBroadcast && this.mLastBatteryLevel >= this.mLowBatteryCloseWarningLevel) {
                this.mSentLowBatteryBroadcast = false;
                statusIntent.setAction("android.intent.action.BATTERY_OKAY");
                this.mContext.sendBroadcast(statusIntent);
            }
            this.mLed.updateLightsLocked();
            if (logOutlier && dischargeDuration != 0L) {
                this.logOutlier(dischargeDuration);
            }
            this.mLastBatteryStatus = this.mBatteryStatus;
            this.mLastBatteryHealth = this.mBatteryHealth;
            this.mLastBatteryPresent = this.mBatteryPresent;
            this.mLastBatteryLevel = this.mBatteryLevel;
            this.mLastPlugType = this.mPlugType;
            this.mLastBatteryVoltage = this.mBatteryVoltage;
            this.mLastBatteryTemperature = this.mBatteryTemperature;
            this.mLastBatteryLevelCritical = this.mBatteryLevelCritical;
            this.mLastInvalidCharger = this.mInvalidCharger;
        }
    }

    private final void sendIntent() {
        Intent intent = new Intent("android.intent.action.BATTERY_CHANGED");
        intent.addFlags(0x60000000);
        int icon = this.getIcon(this.mBatteryLevel);
        intent.putExtra("status", this.mBatteryStatus);
        intent.putExtra("health", this.mBatteryHealth);
        intent.putExtra("present", this.mBatteryPresent);
        intent.putExtra("level", this.mBatteryLevel);
        intent.putExtra("scale", 100);
        intent.putExtra("icon-small", icon);
        intent.putExtra("plugged", this.mPlugType);
        intent.putExtra("voltage", this.mBatteryVoltage);
        intent.putExtra("temperature", this.mBatteryTemperature);
        intent.putExtra("technology", this.mBatteryTechnology);
        intent.putExtra("invalid_charger", this.mInvalidCharger);
        ActivityManagerNative.broadcastStickyIntent((Intent)intent, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void logBatteryStats() {
        IBinder batteryInfoService = ServiceManager.getService((String)BATTERY_STATS_SERVICE_NAME);
        if (batteryInfoService == null) {
            return;
        }
        DropBoxManager db = (DropBoxManager)this.mContext.getSystemService("dropbox");
        if (db == null || !db.isTagEnabled("BATTERY_DISCHARGE_INFO")) {
            return;
        }
        File dumpFile = null;
        FileOutputStream dumpStream = null;
        try {
            dumpFile = new File("/data/system/batteryinfo.dump");
            dumpStream = new FileOutputStream(dumpFile);
            batteryInfoService.dump(dumpStream.getFD(), DUMPSYS_ARGS);
            FileUtils.sync((FileOutputStream)dumpStream);
            db.addFile("BATTERY_DISCHARGE_INFO", dumpFile, 2);
        }
        catch (RemoteException e) {
            Slog.e((String)TAG, (String)"failed to dump battery service", (Throwable)e);
        }
        catch (IOException e) {
            Slog.e((String)TAG, (String)"failed to write dumpsys file", (Throwable)e);
        }
        finally {
            if (dumpStream != null) {
                try {
                    dumpStream.close();
                }
                catch (IOException e) {
                    Slog.e((String)TAG, (String)"failed to close dumpsys output stream");
                }
            }
            if (dumpFile != null && !dumpFile.delete()) {
                Slog.e((String)TAG, (String)("failed to delete temporary dumpsys file: " + dumpFile.getAbsolutePath()));
            }
        }
    }

    private final void logOutlier(long duration) {
        ContentResolver cr = this.mContext.getContentResolver();
        String dischargeThresholdString = Settings.Secure.getString((ContentResolver)cr, (String)"battery_discharge_threshold");
        String durationThresholdString = Settings.Secure.getString((ContentResolver)cr, (String)"battery_discharge_duration_threshold");
        if (dischargeThresholdString != null && durationThresholdString != null) {
            try {
                long durationThreshold = Long.parseLong(durationThresholdString);
                int dischargeThreshold = Integer.parseInt(dischargeThresholdString);
                if (duration <= durationThreshold && this.mDischargeStartLevel - this.mBatteryLevel >= dischargeThreshold) {
                    this.logBatteryStats();
                }
            }
            catch (NumberFormatException e) {
                Slog.e((String)TAG, (String)("Invalid DischargeThresholds GService string: " + durationThresholdString + " or " + dischargeThresholdString));
                return;
            }
        }
    }

    private final int getIcon(int level) {
        if (this.mBatteryStatus == 2) {
            return 17302788;
        }
        if (this.mBatteryStatus == 3) {
            return 17302774;
        }
        if (this.mBatteryStatus == 4 || this.mBatteryStatus == 5) {
            if (this.isPowered() && this.mBatteryLevel >= 100) {
                return 17302788;
            }
            return 17302774;
        }
        return 17302802;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.DUMP") != 0) {
            pw.println("Permission Denial: can't dump Battery service from from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid());
            return;
        }
        if (args == null || args.length == 0 || "-a".equals(args[0])) {
            BatteryService batteryService = this;
            synchronized (batteryService) {
                pw.println("Current Battery Service state:");
                pw.println("  AC powered: " + this.mAcOnline);
                pw.println("  USB powered: " + this.mUsbOnline);
                pw.println("  status: " + this.mBatteryStatus);
                pw.println("  health: " + this.mBatteryHealth);
                pw.println("  present: " + this.mBatteryPresent);
                pw.println("  level: " + this.mBatteryLevel);
                pw.println("  scale: 100");
                pw.println("  voltage:" + this.mBatteryVoltage);
                pw.println("  temperature: " + this.mBatteryTemperature);
                pw.println("  technology: " + this.mBatteryTechnology);
            }
        }
    }

    class Led {
        private LightsService mLightsService;
        private LightsService.Light mBatteryLight;
        private int mBatteryLowARGB;
        private int mBatteryMediumARGB;
        private int mBatteryFullARGB;
        private int mBatteryLedOn;
        private int mBatteryLedOff;
        private boolean mBatteryCharging;
        private boolean mBatteryLow;
        private boolean mBatteryFull;

        Led(Context context, LightsService lights) {
            this.mLightsService = lights;
            this.mBatteryLight = lights.getLight(3);
            this.mBatteryLowARGB = BatteryService.this.mContext.getResources().getInteger(17694744);
            this.mBatteryMediumARGB = BatteryService.this.mContext.getResources().getInteger(17694745);
            this.mBatteryFullARGB = BatteryService.this.mContext.getResources().getInteger(17694746);
            this.mBatteryLedOn = BatteryService.this.mContext.getResources().getInteger(17694747);
            this.mBatteryLedOff = BatteryService.this.mContext.getResources().getInteger(17694748);
        }

        void updateLightsLocked() {
            int level = BatteryService.this.mBatteryLevel;
            int status = BatteryService.this.mBatteryStatus;
            if (level < BatteryService.this.mLowBatteryWarningLevel) {
                if (status == 2) {
                    this.mBatteryLight.setColor(this.mBatteryLowARGB);
                } else {
                    this.mBatteryLight.setFlashing(this.mBatteryLowARGB, 1, this.mBatteryLedOn, this.mBatteryLedOff);
                }
            } else if (status == 2 || status == 5) {
                if (status == 5 || level >= 90) {
                    this.mBatteryLight.setColor(this.mBatteryFullARGB);
                } else {
                    this.mBatteryLight.setColor(this.mBatteryMediumARGB);
                }
            } else {
                this.mBatteryLight.turnOff();
            }
        }
    }
}

