/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.net.Downloads;
import android.os.Build;
import android.os.DropBoxManager;
import android.os.FileObserver;
import android.os.FileUtils;
import android.os.RecoverySystem;
import android.os.SystemProperties;
import android.util.Slog;
import java.io.File;
import java.io.IOException;

public class BootReceiver
extends BroadcastReceiver {
    private static final String TAG = "BootReceiver";
    private static final int LOG_SIZE = 65536;
    private static final File TOMBSTONE_DIR = new File("/data/tombstones");
    private static final String OLD_UPDATER_PACKAGE = "com.google.android.systemupdater";
    private static final String OLD_UPDATER_CLASS = "com.google.android.systemupdater.SystemUpdateReceiver";
    private static FileObserver sTombstoneObserver = null;

    public void onReceive(final Context context, Intent intent) {
        new Thread(){

            public void run() {
                try {
                    BootReceiver.this.logBootEvents(context);
                }
                catch (Exception e) {
                    Slog.e((String)BootReceiver.TAG, (String)"Can't log boot events", (Throwable)e);
                }
                try {
                    BootReceiver.this.removeOldUpdatePackages(context);
                }
                catch (Exception e) {
                    Slog.e((String)BootReceiver.TAG, (String)"Can't remove old update packages", (Throwable)e);
                }
            }
        }.start();
    }

    private void removeOldUpdatePackages(Context ctx) {
        Downloads.ByUri.removeAllDownloadsByPackage((Context)ctx, (String)OLD_UPDATER_PACKAGE, (String)OLD_UPDATER_CLASS);
    }

    private void logBootEvents(Context ctx) throws IOException {
        final DropBoxManager db = (DropBoxManager)ctx.getSystemService("dropbox");
        final SharedPreferences prefs = ctx.getSharedPreferences("log_files", 0);
        final String headers = new StringBuilder(512).append("Build: ").append(Build.FINGERPRINT).append("\n").append("Hardware: ").append(Build.BOARD).append("\n").append("Bootloader: ").append(Build.BOOTLOADER).append("\n").append("Radio: ").append(Build.RADIO).append("\n").append("Kernel: ").append(FileUtils.readTextFile((File)new File("/proc/version"), (int)1024, (String)"...\n")).append("\n").toString();
        String recovery = RecoverySystem.handleAftermath();
        if (recovery != null && db != null) {
            db.addText("SYSTEM_RECOVERY_LOG", headers + recovery);
        }
        if (SystemProperties.getLong((String)"ro.runtime.firstboot", (long)0L) == 0L) {
            String now = Long.toString(System.currentTimeMillis());
            SystemProperties.set((String)"ro.runtime.firstboot", (String)now);
            if (db != null) {
                db.addText("SYSTEM_BOOT", headers);
            }
            BootReceiver.addFileToDropBox(db, prefs, headers, "/proc/last_kmsg", -65536, "SYSTEM_LAST_KMSG");
            BootReceiver.addFileToDropBox(db, prefs, headers, "/cache/recovery/log", -65536, "SYSTEM_RECOVERY_LOG");
            BootReceiver.addFileToDropBox(db, prefs, headers, "/data/dontpanic/apanic_console", -65536, "APANIC_CONSOLE");
            BootReceiver.addFileToDropBox(db, prefs, headers, "/data/dontpanic/apanic_threads", -65536, "APANIC_THREADS");
        } else if (db != null) {
            db.addText("SYSTEM_RESTART", headers);
        }
        File[] tombstoneFiles = TOMBSTONE_DIR.listFiles();
        for (int i = 0; tombstoneFiles != null && i < tombstoneFiles.length; ++i) {
            BootReceiver.addFileToDropBox(db, prefs, headers, tombstoneFiles[i].getPath(), 65536, "SYSTEM_TOMBSTONE");
        }
        sTombstoneObserver = new FileObserver(TOMBSTONE_DIR.getPath(), 8){

            public void onEvent(int event, String path) {
                try {
                    String filename = new File(TOMBSTONE_DIR, path).getPath();
                    BootReceiver.addFileToDropBox(db, prefs, headers, filename, 65536, "SYSTEM_TOMBSTONE");
                }
                catch (IOException e) {
                    Slog.e((String)BootReceiver.TAG, (String)"Can't log tombstone", (Throwable)e);
                }
            }
        };
        sTombstoneObserver.startWatching();
    }

    private static void addFileToDropBox(DropBoxManager db, SharedPreferences prefs, String headers, String filename, int maxSize, String tag) throws IOException {
        if (db == null || !db.isTagEnabled(tag)) {
            return;
        }
        File file = new File(filename);
        long fileTime = file.lastModified();
        if (fileTime <= 0L) {
            return;
        }
        if (prefs != null) {
            long lastTime = prefs.getLong(filename, 0L);
            if (lastTime == fileTime) {
                return;
            }
            prefs.edit().putLong(filename, fileTime).apply();
        }
        Slog.i((String)TAG, (String)("Copying " + filename + " to DropBox (" + tag + ")"));
        db.addText(tag, headers + FileUtils.readTextFile((File)file, (int)maxSize, (String)"[[TRUNCATED]]\n"));
    }
}

