/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.app.ActivityManagerNative;
import android.app.IActivityManager;
import android.content.ClipData;
import android.content.ClipDescription;
import android.content.Context;
import android.content.IClipboard;
import android.content.IOnPrimaryClipChangedListener;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.Process;
import android.os.RemoteCallbackList;
import android.os.RemoteException;
import android.util.Slog;
import java.util.HashSet;

public class ClipboardService
extends IClipboard.Stub {
    private final Context mContext;
    private final IActivityManager mAm;
    private final PackageManager mPm;
    private final IBinder mPermissionOwner;
    private final RemoteCallbackList<IOnPrimaryClipChangedListener> mPrimaryClipListeners = new RemoteCallbackList();
    private ClipData mPrimaryClip;
    private final HashSet<String> mActivePermissionOwners = new HashSet();

    public ClipboardService(Context context) {
        this.mContext = context;
        this.mAm = ActivityManagerNative.getDefault();
        this.mPm = context.getPackageManager();
        IBinder permOwner = null;
        try {
            permOwner = this.mAm.newUriPermissionOwner("clipboard");
        }
        catch (RemoteException e) {
            Slog.w((String)"clipboard", (String)"AM dead", (Throwable)e);
        }
        this.mPermissionOwner = permOwner;
    }

    public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
        try {
            return super.onTransact(code, data, reply, flags);
        }
        catch (RuntimeException e) {
            Slog.w((String)"clipboard", (String)"Exception: ", (Throwable)e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPrimaryClip(ClipData clip) {
        ClipboardService clipboardService = this;
        synchronized (clipboardService) {
            if (clip != null && clip.getItemCount() <= 0) {
                throw new IllegalArgumentException("No items");
            }
            this.checkDataOwnerLocked(clip, Binder.getCallingUid());
            this.clearActiveOwnersLocked();
            this.mPrimaryClip = clip;
            int n = this.mPrimaryClipListeners.beginBroadcast();
            for (int i = 0; i < n; ++i) {
                try {
                    ((IOnPrimaryClipChangedListener)this.mPrimaryClipListeners.getBroadcastItem(i)).dispatchPrimaryClipChanged();
                    continue;
                }
                catch (RemoteException e) {
                    // empty catch block
                }
            }
            this.mPrimaryClipListeners.finishBroadcast();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClipData getPrimaryClip(String pkg) {
        ClipboardService clipboardService = this;
        synchronized (clipboardService) {
            this.addActiveOwnerLocked(Binder.getCallingUid(), pkg);
            return this.mPrimaryClip;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClipDescription getPrimaryClipDescription() {
        ClipboardService clipboardService = this;
        synchronized (clipboardService) {
            return this.mPrimaryClip != null ? this.mPrimaryClip.getDescription() : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasPrimaryClip() {
        ClipboardService clipboardService = this;
        synchronized (clipboardService) {
            return this.mPrimaryClip != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPrimaryClipChangedListener(IOnPrimaryClipChangedListener listener) {
        ClipboardService clipboardService = this;
        synchronized (clipboardService) {
            this.mPrimaryClipListeners.register((IInterface)listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePrimaryClipChangedListener(IOnPrimaryClipChangedListener listener) {
        ClipboardService clipboardService = this;
        synchronized (clipboardService) {
            this.mPrimaryClipListeners.unregister((IInterface)listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasClipboardText() {
        ClipboardService clipboardService = this;
        synchronized (clipboardService) {
            if (this.mPrimaryClip != null) {
                // MONITOREXIT @DISABLED, blocks:[0, 1, 3] lbl5 : MonitorExitStatement: MONITOREXIT : var1_1
                CharSequence text = this.mPrimaryClip.getItemAt(0).getText();
                return text != null && text.length() > 0;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void checkUriOwnerLocked(Uri uri, int uid) {
        if (!"content".equals(uri.getScheme())) {
            return;
        }
        long ident = Binder.clearCallingIdentity();
        boolean allowed = false;
        try {
            try {
                this.mAm.checkGrantUriPermission(uid, null, uri, 1);
            }
            catch (RemoteException e) {
                Object var8_6 = null;
                Binder.restoreCallingIdentity((long)ident);
                return;
            }
            Object var8_5 = null;
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            Binder.restoreCallingIdentity((long)ident);
            throw throwable;
        }
        Binder.restoreCallingIdentity((long)ident);
    }

    private final void checkItemOwnerLocked(ClipData.Item item, int uid) {
        Intent intent;
        if (item.getUri() != null) {
            this.checkUriOwnerLocked(item.getUri(), uid);
        }
        if ((intent = item.getIntent()) != null && intent.getData() != null) {
            this.checkUriOwnerLocked(intent.getData(), uid);
        }
    }

    private final void checkDataOwnerLocked(ClipData data, int uid) {
        int N = data.getItemCount();
        for (int i = 0; i < N; ++i) {
            this.checkItemOwnerLocked(data.getItemAt(i), uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void grantUriLocked(Uri uri, String pkg) {
        long ident = Binder.clearCallingIdentity();
        try {
            try {
                this.mAm.grantUriPermissionFromOwner(this.mPermissionOwner, Process.myUid(), pkg, uri, 1);
            }
            catch (RemoteException e) {
                Object var7_5 = null;
                Binder.restoreCallingIdentity((long)ident);
                return;
            }
            Object var7_4 = null;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            Binder.restoreCallingIdentity((long)ident);
            throw throwable;
        }
        Binder.restoreCallingIdentity((long)ident);
    }

    private final void grantItemLocked(ClipData.Item item, String pkg) {
        Intent intent;
        if (item.getUri() != null) {
            this.grantUriLocked(item.getUri(), pkg);
        }
        if ((intent = item.getIntent()) != null && intent.getData() != null) {
            this.grantUriLocked(intent.getData(), pkg);
        }
    }

    private final void addActiveOwnerLocked(int uid, String pkg) {
        try {
            PackageInfo pi = this.mPm.getPackageInfo(pkg, 0);
            if (pi.applicationInfo.uid != uid) {
                throw new SecurityException("Calling uid " + uid + " does not own package " + pkg);
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new IllegalArgumentException("Unknown package " + pkg, e);
        }
        if (this.mPrimaryClip != null && !this.mActivePermissionOwners.contains(pkg)) {
            int N = this.mPrimaryClip.getItemCount();
            for (int i = 0; i < N; ++i) {
                this.grantItemLocked(this.mPrimaryClip.getItemAt(i), pkg);
            }
            this.mActivePermissionOwners.add(pkg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void revokeUriLocked(Uri uri) {
        long ident = Binder.clearCallingIdentity();
        try {
            try {
                this.mAm.revokeUriPermissionFromOwner(this.mPermissionOwner, uri, 3);
            }
            catch (RemoteException e) {
                Object var6_4 = null;
                Binder.restoreCallingIdentity((long)ident);
                return;
            }
            Object var6_3 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            Binder.restoreCallingIdentity((long)ident);
            throw throwable;
        }
        Binder.restoreCallingIdentity((long)ident);
    }

    private final void revokeItemLocked(ClipData.Item item) {
        Intent intent;
        if (item.getUri() != null) {
            this.revokeUriLocked(item.getUri());
        }
        if ((intent = item.getIntent()) != null && intent.getData() != null) {
            this.revokeUriLocked(intent.getData());
        }
    }

    private final void clearActiveOwnersLocked() {
        this.mActivePermissionOwners.clear();
        if (this.mPrimaryClip == null) {
            return;
        }
        int N = this.mPrimaryClip.getItemCount();
        for (int i = 0; i < N; ++i) {
            this.revokeItemLocked(this.mPrimaryClip.getItemAt(i));
        }
    }
}

