/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.bluetooth.BluetoothTetheringDataTracker;
import android.content.ContentResolver;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.Intent;
import android.content.res.Resources;
import android.database.ContentObserver;
import android.net.ConnectivityManager;
import android.net.DummyDataStateTracker;
import android.net.EthernetDataTracker;
import android.net.IConnectivityManager;
import android.net.INetworkManagementEventObserver;
import android.net.INetworkPolicyListener;
import android.net.INetworkPolicyManager;
import android.net.INetworkStatsService;
import android.net.LinkAddress;
import android.net.LinkProperties;
import android.net.MobileDataStateTracker;
import android.net.NetworkConfig;
import android.net.NetworkInfo;
import android.net.NetworkQuotaInfo;
import android.net.NetworkState;
import android.net.NetworkStateTracker;
import android.net.NetworkUtils;
import android.net.ProxyProperties;
import android.net.RouteInfo;
import android.net.wifi.WifiStateTracker;
import android.os.Binder;
import android.os.FileUtils;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.INetworkManagementService;
import android.os.Looper;
import android.os.Message;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.os.PowerManager;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemProperties;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.EventLog;
import android.util.Slog;
import android.util.SparseIntArray;
import com.android.internal.net.LegacyVpnInfo;
import com.android.internal.net.VpnConfig;
import com.android.server.am.BatteryStatsService;
import com.android.server.connectivity.Tethering;
import com.android.server.connectivity.Vpn;
import com.google.android.collect.Lists;
import com.google.android.collect.Sets;
import dalvik.system.DexClassLoader;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectivityService
extends IConnectivityManager.Stub {
    private static final boolean DBG = true;
    private static final boolean VDBG = false;
    private static final String TAG = "ConnectivityService";
    private static final boolean LOGD_RULES = false;
    private static final int RESTORE_DEFAULT_NETWORK_DELAY = 60000;
    private static final String NETWORK_RESTORE_DELAY_PROP_NAME = "android.telephony.apn-restore";
    private static final int MAX_HOSTROUTE_CYCLE_COUNT = 10;
    private Tethering mTethering;
    private boolean mTetheringConfigValid = false;
    private Vpn mVpn;
    private Object mRulesLock = new Object();
    private SparseIntArray mUidRules = new SparseIntArray();
    private HashSet<String> mMeteredIfaces = Sets.newHashSet();
    private NetworkStateTracker[] mNetTrackers;
    private LinkProperties[] mCurrentLinkProperties;
    private List[] mNetRequestersPids;
    private int[] mPriorityList;
    private Context mContext;
    private int mNetworkPreference;
    private int mActiveDefaultNetwork = -1;
    private int mDefaultInetCondition = 0;
    private int mDefaultInetConditionPublished = 0;
    private boolean mInetConditionChangeInFlight = false;
    private int mDefaultConnectionSequence = 0;
    private Object mDnsLock = new Object();
    private int mNumDnsEntries;
    private boolean mDnsOverridden = false;
    private boolean mTestMode;
    private static ConnectivityService sServiceInstance;
    private INetworkManagementService mNetd;
    private INetworkPolicyManager mPolicyManager;
    private static final int ENABLED = 1;
    private static final int DISABLED = 0;
    private static final boolean ADD = true;
    private static final boolean REMOVE = false;
    private static final boolean TO_DEFAULT_TABLE = true;
    private static final boolean TO_SECONDARY_TABLE = false;
    private static final int MIN_NETWORK_STATE_TRACKER_EVENT = 1;
    private static final int MAX_NETWORK_STATE_TRACKER_EVENT = 100;
    private static final int EVENT_RESTORE_DEFAULT_NETWORK = 101;
    private static final int EVENT_CHANGE_MOBILE_DATA_ENABLED = 102;
    private static final int EVENT_SET_NETWORK_PREFERENCE = 103;
    private static final int EVENT_INET_CONDITION_CHANGE = 104;
    private static final int EVENT_INET_CONDITION_HOLD_END = 105;
    private static final int EVENT_SET_MOBILE_DATA = 107;
    private static final int EVENT_CLEAR_NET_TRANSITION_WAKELOCK = 108;
    private static final int EVENT_APPLY_GLOBAL_HTTP_PROXY = 109;
    private static final int EVENT_SET_DEPENDENCY_MET = 110;
    private static final int EVENT_RESTORE_DNS = 111;
    private static final int EVENT_SEND_STICKY_BROADCAST_INTENT = 112;
    private static final int EVENT_SET_POLICY_DATA_ENABLE = 113;
    private Handler mHandler;
    private List<FeatureUser> mFeatureUsers;
    private boolean mSystemReady;
    private Intent mInitialBroadcast;
    private PowerManager.WakeLock mNetTransitionWakeLock;
    private String mNetTransitionWakeLockCausedBy = "";
    private int mNetTransitionWakeLockSerialNumber;
    private int mNetTransitionWakeLockTimeout;
    private InetAddress mDefaultDns;
    private Collection<RouteInfo> mAddedRoutes = new ArrayList<RouteInfo>();
    private static final int INET_CONDITION_LOG_MAX_SIZE = 15;
    private ArrayList mInetLog;
    private ProxyProperties mDefaultProxy = null;
    private Object mDefaultProxyLock = new Object();
    private boolean mDefaultProxyDisabled = false;
    private ProxyProperties mGlobalProxy = null;
    private final Object mGlobalProxyLock = new Object();
    private SettingsObserver mSettingsObserver;
    NetworkConfig[] mNetConfigs;
    int mNetworksDefined;
    RadioAttributes[] mRadioAttributes;
    List mProtectedNetworks;
    private INetworkPolicyListener mPolicyListener = new INetworkPolicyListener.Stub(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onUidRulesChanged(int uid, int uidRules) {
            ConnectivityService.this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_NETWORK_POLICY", ConnectivityService.TAG);
            Object object = ConnectivityService.this.mRulesLock;
            synchronized (object) {
                int oldRules = ConnectivityService.this.mUidRules.get(uid, 0);
                if (oldRules == uidRules) {
                    return;
                }
                ConnectivityService.this.mUidRules.put(uid, uidRules);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onMeteredIfacesChanged(String[] meteredIfaces) {
            ConnectivityService.this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_NETWORK_POLICY", ConnectivityService.TAG);
            Object object = ConnectivityService.this.mRulesLock;
            synchronized (object) {
                ConnectivityService.this.mMeteredIfaces.clear();
                for (String iface : meteredIfaces) {
                    ConnectivityService.this.mMeteredIfaces.add(iface);
                }
            }
        }
    };

    public ConnectivityService(Context context, INetworkManagementService netd, INetworkStatsService statsService, INetworkPolicyManager policyManager) {
        int[] protectedNetworks;
        String[] naStrings;
        String[] raStrings;
        String dns;
        String id;
        this.log("ConnectivityService starting up");
        HandlerThread handlerThread = new HandlerThread("ConnectivityServiceThread");
        handlerThread.start();
        this.mHandler = new MyHandler(handlerThread.getLooper());
        if (TextUtils.isEmpty((CharSequence)SystemProperties.get((String)"net.hostname")) && (id = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id")) != null && id.length() > 0) {
            String name = new String("android-").concat(id);
            SystemProperties.set((String)"net.hostname", (String)name);
        }
        if ((dns = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"default_dns_server")) == null || dns.length() == 0) {
            dns = context.getResources().getString(17039391);
        }
        try {
            this.mDefaultDns = NetworkUtils.numericToInetAddress((String)dns);
        }
        catch (IllegalArgumentException e) {
            this.loge("Error setting defaultDns using " + dns);
        }
        this.mContext = ConnectivityService.checkNotNull(context, "missing Context");
        this.mNetd = ConnectivityService.checkNotNull(netd, "missing INetworkManagementService");
        this.mPolicyManager = ConnectivityService.checkNotNull(policyManager, "missing INetworkPolicyManager");
        try {
            this.mPolicyManager.registerListener(this.mPolicyListener);
        }
        catch (RemoteException e) {
            this.loge("unable to register INetworkPolicyListener" + e.toString());
        }
        PowerManager powerManager = (PowerManager)context.getSystemService("power");
        this.mNetTransitionWakeLock = powerManager.newWakeLock(1, TAG);
        this.mNetTransitionWakeLockTimeout = this.mContext.getResources().getInteger(17694727);
        this.mNetTrackers = new NetworkStateTracker[14];
        this.mCurrentLinkProperties = new LinkProperties[14];
        this.mNetworkPreference = this.getPersistedNetworkPreference();
        this.mRadioAttributes = new RadioAttributes[14];
        this.mNetConfigs = new NetworkConfig[14];
        for (String raString : raStrings = context.getResources().getStringArray(17235989)) {
            RadioAttributes r = new RadioAttributes(raString);
            if (r.mType > 13) {
                this.loge("Error in radioAttributes - ignoring attempt to define type " + r.mType);
                continue;
            }
            if (this.mRadioAttributes[r.mType] != null) {
                this.loge("Error in radioAttributes - ignoring attempt to redefine type " + r.mType);
                continue;
            }
            this.mRadioAttributes[r.mType] = r;
        }
        for (String naString : naStrings = context.getResources().getStringArray(17235987)) {
            try {
                NetworkConfig n = new NetworkConfig(naString);
                if (n.type > 13) {
                    this.loge("Error in networkAttributes - ignoring attempt to define type " + n.type);
                    continue;
                }
                if (this.mNetConfigs[n.type] != null) {
                    this.loge("Error in networkAttributes - ignoring attempt to redefine type " + n.type);
                    continue;
                }
                if (this.mRadioAttributes[n.radio] == null) {
                    this.loge("Error in networkAttributes - ignoring attempt to use undefined radio " + n.radio + " in network type " + n.type);
                    continue;
                }
                this.mNetConfigs[n.type] = n;
                ++this.mNetworksDefined;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        this.mProtectedNetworks = new ArrayList();
        for (int p : protectedNetworks = context.getResources().getIntArray(17235988)) {
            if (this.mNetConfigs[p] != null && !this.mProtectedNetworks.contains(p)) {
                this.mProtectedNetworks.add(p);
                continue;
            }
            this.loge("Ignoring protectedNetwork " + p);
        }
        this.mPriorityList = new int[this.mNetworksDefined];
        int insertionPoint = this.mNetworksDefined - 1;
        int currentLowest = 0;
        int nextLowest = 0;
        while (insertionPoint > -1) {
            for (NetworkConfig na : this.mNetConfigs) {
                if (na == null || na.priority < currentLowest) continue;
                if (na.priority > currentLowest) {
                    if (na.priority >= nextLowest && nextLowest != 0) continue;
                    nextLowest = na.priority;
                    continue;
                }
                this.mPriorityList[insertionPoint--] = na.type;
            }
            currentLowest = nextLowest;
            nextLowest = 0;
        }
        this.mNetRequestersPids = new ArrayList[14];
        for (int i : this.mPriorityList) {
            this.mNetRequestersPids[i] = new ArrayList();
        }
        this.mFeatureUsers = new ArrayList<FeatureUser>();
        this.mNumDnsEntries = 0;
        this.mTestMode = SystemProperties.get((String)"cm.test.mode").equals("true") && SystemProperties.get((String)"ro.build.type").equals("eng");
        block22: for (int netType : this.mPriorityList) {
            switch (this.mNetConfigs[netType].radio) {
                case 1: {
                    this.mNetTrackers[netType] = new WifiStateTracker(netType, this.mNetConfigs[netType].name);
                    this.mNetTrackers[netType].startMonitoring(context, this.mHandler);
                    break;
                }
                case 0: {
                    this.mNetTrackers[netType] = new MobileDataStateTracker(netType, this.mNetConfigs[netType].name);
                    this.mNetTrackers[netType].startMonitoring(context, this.mHandler);
                    break;
                }
                case 8: {
                    this.mNetTrackers[netType] = new DummyDataStateTracker(netType, this.mNetConfigs[netType].name);
                    this.mNetTrackers[netType].startMonitoring(context, this.mHandler);
                    break;
                }
                case 7: {
                    this.mNetTrackers[netType] = BluetoothTetheringDataTracker.getInstance();
                    this.mNetTrackers[netType].startMonitoring(context, this.mHandler);
                    break;
                }
                case 6: {
                    this.mNetTrackers[netType] = this.makeWimaxStateTracker();
                    if (this.mNetTrackers[netType] == null) break;
                    this.mNetTrackers[netType].startMonitoring(context, this.mHandler);
                    break;
                }
                case 9: {
                    this.mNetTrackers[netType] = EthernetDataTracker.getInstance();
                    this.mNetTrackers[netType].startMonitoring(context, this.mHandler);
                    break;
                }
                default: {
                    this.loge("Trying to create a DataStateTracker for an unknown radio type " + this.mNetConfigs[netType].radio);
                    continue block22;
                }
            }
            this.mCurrentLinkProperties[netType] = null;
            if (this.mNetTrackers[netType] == null || !this.mNetConfigs[netType].isDefault()) continue;
            this.mNetTrackers[netType].reconnect();
        }
        IBinder b = ServiceManager.getService((String)"network_management");
        INetworkManagementService nmService = INetworkManagementService.Stub.asInterface((IBinder)b);
        this.mTethering = new Tethering(this.mContext, nmService, statsService, (IConnectivityManager)this, this.mHandler.getLooper());
        this.mTetheringConfigValid = (this.mTethering.getTetherableUsbRegexs().length != 0 || this.mTethering.getTetherableWifiRegexs().length != 0 || this.mTethering.getTetherableBluetoothRegexs().length != 0) && this.mTethering.getUpstreamIfaceTypes().length != 0;
        this.mVpn = new Vpn(this.mContext, new VpnCallback());
        try {
            nmService.registerObserver((INetworkManagementEventObserver)this.mTethering);
            nmService.registerObserver((INetworkManagementEventObserver)this.mVpn);
        }
        catch (RemoteException e) {
            this.loge("Error registering observer :" + (Object)((Object)e));
        }
        this.mInetLog = new ArrayList();
        this.mSettingsObserver = new SettingsObserver(this.mHandler, 109);
        this.mSettingsObserver.observe(this.mContext);
        this.loadGlobalProxy();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private NetworkStateTracker makeWimaxStateTracker() {
        Class wimaxStateTrackerClass = null;
        Class wimaxServiceClass = null;
        NetworkStateTracker wimaxStateTracker = null;
        boolean isWimaxEnabled = this.mContext.getResources().getBoolean(0x1110031);
        if (isWimaxEnabled) {
            try {
                String wimaxJarLocation = this.mContext.getResources().getString(17039396);
                String wimaxLibLocation = this.mContext.getResources().getString(17039397);
                String wimaxManagerClassName = this.mContext.getResources().getString(17039398);
                String wimaxServiceClassName = this.mContext.getResources().getString(17039399);
                String wimaxStateTrackerClassName = this.mContext.getResources().getString(17039400);
                this.log("wimaxJarLocation: " + wimaxJarLocation);
                DexClassLoader wimaxClassLoader = new DexClassLoader(wimaxJarLocation, new ContextWrapper(this.mContext).getCacheDir().getAbsolutePath(), wimaxLibLocation, ClassLoader.getSystemClassLoader());
                try {
                    Class wimaxManagerClass = wimaxClassLoader.loadClass(wimaxManagerClassName);
                    wimaxStateTrackerClass = wimaxClassLoader.loadClass(wimaxStateTrackerClassName);
                    wimaxServiceClass = wimaxClassLoader.loadClass(wimaxServiceClassName);
                }
                catch (ClassNotFoundException ex) {
                    this.loge("Exception finding Wimax classes: " + ex.toString());
                    return null;
                }
            }
            catch (Resources.NotFoundException ex) {
                this.loge("Wimax Resources does not exist!!! ");
                return null;
            }
            try {
                this.log("Starting Wimax Service... ");
                Constructor wmxStTrkrConst = wimaxStateTrackerClass.getConstructor(Context.class, Handler.class);
                wimaxStateTracker = (NetworkStateTracker)wmxStTrkrConst.newInstance(this.mContext, this.mHandler);
                Constructor wmxSrvConst = wimaxServiceClass.getDeclaredConstructor(Context.class, wimaxStateTrackerClass);
                wmxSrvConst.setAccessible(true);
                IBinder svcInvoker = (IBinder)wmxSrvConst.newInstance(this.mContext, wimaxStateTracker);
                wmxSrvConst.setAccessible(false);
                ServiceManager.addService((String)"WiMax", (IBinder)svcInvoker);
                return wimaxStateTracker;
            }
            catch (Exception ex) {
                this.loge("Exception creating Wimax classes: " + ex.toString());
                return null;
            }
        }
        this.loge("Wimax is not enabled or not added to the network attributes!!! ");
        return null;
    }

    public void setNetworkPreference(int preference) {
        this.enforceChangePermission();
        this.mHandler.sendMessage(this.mHandler.obtainMessage(103, preference, 0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNetworkPreference() {
        int preference;
        this.enforceAccessPermission();
        ConnectivityService connectivityService = this;
        synchronized (connectivityService) {
            preference = this.mNetworkPreference;
        }
        return preference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleSetNetworkPreference(int preference) {
        if (ConnectivityManager.isNetworkTypeValid((int)preference) && this.mNetConfigs[preference] != null && this.mNetConfigs[preference].isDefault() && this.mNetworkPreference != preference) {
            ContentResolver cr = this.mContext.getContentResolver();
            Settings.Secure.putInt((ContentResolver)cr, (String)"network_preference", (int)preference);
            ConnectivityService connectivityService = this;
            synchronized (connectivityService) {
                this.mNetworkPreference = preference;
            }
            this.enforcePreference();
        }
    }

    private int getConnectivityChangeDelay() {
        ContentResolver cr = this.mContext.getContentResolver();
        int defaultDelay = SystemProperties.getInt((String)"conn.connectivity_change_delay", (int)3000);
        return Settings.Secure.getInt((ContentResolver)cr, (String)"connectivity_change_delay", (int)defaultDelay);
    }

    private int getPersistedNetworkPreference() {
        ContentResolver cr = this.mContext.getContentResolver();
        int networkPrefSetting = Settings.Secure.getInt((ContentResolver)cr, (String)"network_preference", (int)-1);
        if (networkPrefSetting != -1) {
            return networkPrefSetting;
        }
        return 1;
    }

    private void enforcePreference() {
        if (this.mNetTrackers[this.mNetworkPreference].getNetworkInfo().isConnected()) {
            return;
        }
        if (!this.mNetTrackers[this.mNetworkPreference].isAvailable()) {
            return;
        }
        for (int t = 0; t <= 13; ++t) {
            if (t == this.mNetworkPreference || this.mNetTrackers[t] == null || !this.mNetTrackers[t].getNetworkInfo().isConnected()) continue;
            this.log("tearing down " + this.mNetTrackers[t].getNetworkInfo() + " in enforcePreference");
            this.teardown(this.mNetTrackers[t]);
        }
    }

    private boolean teardown(NetworkStateTracker netTracker) {
        if (netTracker.teardown()) {
            netTracker.setTeardownRequested(true);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isNetworkBlocked(NetworkStateTracker tracker, int uid) {
        int uidRules;
        boolean networkCostly;
        String iface = tracker.getLinkProperties().getInterfaceName();
        Object object = this.mRulesLock;
        synchronized (object) {
            networkCostly = this.mMeteredIfaces.contains(iface);
            uidRules = this.mUidRules.get(uid, 0);
        }
        return networkCostly && (uidRules & 1) != 0;
    }

    private NetworkInfo getFilteredNetworkInfo(NetworkStateTracker tracker, int uid) {
        NetworkInfo info = tracker.getNetworkInfo();
        if (this.isNetworkBlocked(tracker, uid)) {
            info = new NetworkInfo(info);
            info.setDetailedState(NetworkInfo.DetailedState.BLOCKED, null, null);
        }
        return info;
    }

    public NetworkInfo getActiveNetworkInfo() {
        this.enforceAccessPermission();
        int uid = Binder.getCallingUid();
        return this.getNetworkInfo(this.mActiveDefaultNetwork, uid);
    }

    public NetworkInfo getActiveNetworkInfoForUid(int uid) {
        this.enforceConnectivityInternalPermission();
        return this.getNetworkInfo(this.mActiveDefaultNetwork, uid);
    }

    public NetworkInfo getNetworkInfo(int networkType) {
        this.enforceAccessPermission();
        int uid = Binder.getCallingUid();
        return this.getNetworkInfo(networkType, uid);
    }

    private NetworkInfo getNetworkInfo(int networkType, int uid) {
        NetworkStateTracker tracker;
        NetworkInfo info = null;
        if (ConnectivityManager.isNetworkTypeValid((int)networkType) && (tracker = this.mNetTrackers[networkType]) != null) {
            info = this.getFilteredNetworkInfo(tracker, uid);
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NetworkInfo[] getAllNetworkInfo() {
        this.enforceAccessPermission();
        int uid = Binder.getCallingUid();
        ArrayList result = Lists.newArrayList();
        Object object = this.mRulesLock;
        synchronized (object) {
            for (NetworkStateTracker tracker : this.mNetTrackers) {
                if (tracker == null) continue;
                result.add(this.getFilteredNetworkInfo(tracker, uid));
            }
        }
        return result.toArray(new NetworkInfo[result.size()]);
    }

    public boolean isNetworkSupported(int networkType) {
        this.enforceAccessPermission();
        return ConnectivityManager.isNetworkTypeValid((int)networkType) && this.mNetTrackers[networkType] != null;
    }

    public LinkProperties getActiveLinkProperties() {
        return this.getLinkProperties(this.mActiveDefaultNetwork);
    }

    public LinkProperties getLinkProperties(int networkType) {
        NetworkStateTracker tracker;
        this.enforceAccessPermission();
        if (ConnectivityManager.isNetworkTypeValid((int)networkType) && (tracker = this.mNetTrackers[networkType]) != null) {
            return tracker.getLinkProperties();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NetworkState[] getAllNetworkState() {
        this.enforceAccessPermission();
        int uid = Binder.getCallingUid();
        ArrayList result = Lists.newArrayList();
        Object object = this.mRulesLock;
        synchronized (object) {
            for (NetworkStateTracker tracker : this.mNetTrackers) {
                if (tracker == null) continue;
                NetworkInfo info = this.getFilteredNetworkInfo(tracker, uid);
                result.add(new NetworkState(info, tracker.getLinkProperties(), tracker.getLinkCapabilities()));
            }
        }
        return result.toArray(new NetworkState[result.size()]);
    }

    private NetworkState getNetworkStateUnchecked(int networkType) {
        NetworkStateTracker tracker;
        if (ConnectivityManager.isNetworkTypeValid((int)networkType) && (tracker = this.mNetTrackers[networkType]) != null) {
            return new NetworkState(tracker.getNetworkInfo(), tracker.getLinkProperties(), tracker.getLinkCapabilities());
        }
        return null;
    }

    public NetworkQuotaInfo getActiveNetworkQuotaInfo() {
        this.enforceAccessPermission();
        NetworkState state = this.getNetworkStateUnchecked(this.mActiveDefaultNetwork);
        if (state != null) {
            try {
                return this.mPolicyManager.getNetworkQuotaInfo(state);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        return null;
    }

    public boolean setRadios(boolean turnOn) {
        boolean result = true;
        this.enforceChangePermission();
        for (NetworkStateTracker t : this.mNetTrackers) {
            if (t == null) continue;
            result = t.setRadio(turnOn) && result;
        }
        return result;
    }

    public boolean setRadio(int netType, boolean turnOn) {
        this.enforceChangePermission();
        if (!ConnectivityManager.isNetworkTypeValid((int)netType)) {
            return false;
        }
        NetworkStateTracker tracker = this.mNetTrackers[netType];
        return tracker != null && tracker.setRadio(turnOn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int startUsingNetworkFeature(int networkType, String feature, IBinder binder) {
        NetworkStateTracker network;
        this.enforceChangePermission();
        if (!ConnectivityManager.isNetworkTypeValid((int)networkType) || this.mNetConfigs[networkType] == null) {
            return 3;
        }
        FeatureUser f = new FeatureUser(networkType, feature, binder);
        int usedNetworkType = this.convertFeatureToNetworkType(networkType, feature);
        if (this.mProtectedNetworks.contains(usedNetworkType)) {
            this.enforceConnectivityInternalPermission();
        }
        if ((network = this.mNetTrackers[usedNetworkType]) != null) {
            Integer currentPid = new Integer(ConnectivityService.getCallingPid());
            if (usedNetworkType != networkType) {
                NetworkInfo ni = network.getNetworkInfo();
                if (!ni.isAvailable()) {
                    this.log("special network not available");
                    if (!TextUtils.equals((CharSequence)feature, (CharSequence)"enableDUNAlways")) {
                        return 2;
                    }
                }
                int restoreTimer = this.getRestoreDefaultNetworkDelay(usedNetworkType);
                ConnectivityService connectivityService = this;
                synchronized (connectivityService) {
                    boolean addToList = true;
                    if (restoreTimer < 0) {
                        for (FeatureUser u : this.mFeatureUsers) {
                            if (!u.isSameUser(f)) continue;
                            addToList = false;
                            break;
                        }
                    }
                    if (addToList) {
                        this.mFeatureUsers.add(f);
                    }
                    if (!this.mNetRequestersPids[usedNetworkType].contains(currentPid)) {
                        this.mNetRequestersPids[usedNetworkType].add(currentPid);
                    }
                }
                if (restoreTimer >= 0) {
                    this.mHandler.sendMessageDelayed(this.mHandler.obtainMessage(101, (Object)f), (long)restoreTimer);
                }
                if (ni.isConnectedOrConnecting() && !network.isTeardownRequested()) {
                    if (ni.isConnected()) {
                        this.handleDnsConfigurationChange(usedNetworkType);
                        return 0;
                    }
                    return 1;
                }
                this.log("startUsingNetworkFeature reconnecting to " + networkType + ": " + feature);
                network.reconnect();
                return 1;
            }
            ConnectivityService connectivityService = this;
            synchronized (connectivityService) {
                this.mFeatureUsers.add(f);
                if (!this.mNetRequestersPids[usedNetworkType].contains(currentPid)) {
                    this.mNetRequestersPids[usedNetworkType].add(currentPid);
                }
            }
            return -1;
        }
        return 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int stopUsingNetworkFeature(int networkType, String feature) {
        this.enforceChangePermission();
        int pid = ConnectivityService.getCallingPid();
        int uid = ConnectivityService.getCallingUid();
        FeatureUser u = null;
        boolean found = false;
        ConnectivityService connectivityService = this;
        synchronized (connectivityService) {
            for (FeatureUser x : this.mFeatureUsers) {
                if (!x.isSameUser(pid, uid, networkType, feature)) continue;
                u = x;
                found = true;
                break;
            }
        }
        if (found && u != null) {
            return this.stopUsingNetworkFeature(u, true);
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int stopUsingNetworkFeature(FeatureUser u, boolean ignoreDups) {
        int networkType = u.mNetworkType;
        String feature = u.mFeature;
        int pid = u.mPid;
        int uid = u.mUid;
        NetworkStateTracker tracker = null;
        boolean callTeardown = false;
        if (!ConnectivityManager.isNetworkTypeValid((int)networkType)) {
            this.log("stopUsingNetworkFeature: net " + networkType + ": " + feature + ", net is invalid");
            return -1;
        }
        ConnectivityService connectivityService = this;
        synchronized (connectivityService) {
            int usedNetworkType;
            if (!this.mFeatureUsers.contains(u)) {
                return 1;
            }
            u.unlinkDeathRecipient();
            this.mFeatureUsers.remove(this.mFeatureUsers.indexOf(u));
            if (!ignoreDups) {
                for (FeatureUser x : this.mFeatureUsers) {
                    if (!x.isSameUser(u)) continue;
                    return 1;
                }
            }
            if ((tracker = this.mNetTrackers[usedNetworkType = this.convertFeatureToNetworkType(networkType, feature)]) == null) {
                this.log("stopUsingNetworkFeature: net " + networkType + ": " + feature + " no known tracker for used net type " + usedNetworkType);
                return -1;
            }
            if (usedNetworkType != networkType) {
                Integer currentPid = new Integer(pid);
                this.mNetRequestersPids[usedNetworkType].remove(currentPid);
                this.reassessPidDns(pid, true);
                if (this.mNetRequestersPids[usedNetworkType].size() != 0) {
                    return 1;
                }
                callTeardown = true;
            } else {
                this.log("stopUsingNetworkFeature: net " + networkType + ": " + feature + " not a known feature - dropping");
            }
        }
        if (callTeardown) {
            this.log("stopUsingNetworkFeature: teardown net " + networkType + ": " + feature);
            tracker.teardown();
            return 1;
        }
        return -1;
    }

    public boolean requestRouteToHost(int networkType, int hostAddress) {
        InetAddress inetAddress = NetworkUtils.intToInetAddress((int)hostAddress);
        if (inetAddress == null) {
            return false;
        }
        return this.requestRouteToHostAddress(networkType, inetAddress.getAddress());
    }

    public boolean requestRouteToHostAddress(int networkType, byte[] hostAddress) {
        this.enforceChangePermission();
        if (this.mProtectedNetworks.contains(networkType)) {
            this.enforceConnectivityInternalPermission();
        }
        if (!ConnectivityManager.isNetworkTypeValid((int)networkType)) {
            return false;
        }
        NetworkStateTracker tracker = this.mNetTrackers[networkType];
        if (tracker == null || !tracker.getNetworkInfo().isConnected() || tracker.isTeardownRequested()) {
            return false;
        }
        try {
            InetAddress addr = InetAddress.getByAddress(hostAddress);
            LinkProperties lp = tracker.getLinkProperties();
            return this.addRouteToAddress(lp, addr);
        }
        catch (UnknownHostException e) {
            return false;
        }
    }

    private boolean addRoute(LinkProperties p, RouteInfo r, boolean toDefaultTable) {
        return this.modifyRoute(p.getInterfaceName(), p, r, 0, true, toDefaultTable);
    }

    private boolean removeRoute(LinkProperties p, RouteInfo r, boolean toDefaultTable) {
        return this.modifyRoute(p.getInterfaceName(), p, r, 0, false, toDefaultTable);
    }

    private boolean addRouteToAddress(LinkProperties lp, InetAddress addr) {
        return this.modifyRouteToAddress(lp, addr, true, true);
    }

    private boolean removeRouteToAddress(LinkProperties lp, InetAddress addr) {
        return this.modifyRouteToAddress(lp, addr, false, true);
    }

    private boolean modifyRouteToAddress(LinkProperties lp, InetAddress addr, boolean doAdd, boolean toDefaultTable) {
        RouteInfo bestRoute = RouteInfo.selectBestRoute((Collection)lp.getRoutes(), (InetAddress)addr);
        bestRoute = bestRoute == null ? RouteInfo.makeHostRoute((InetAddress)addr) : (bestRoute.getGateway().equals(addr) ? RouteInfo.makeHostRoute((InetAddress)addr) : RouteInfo.makeHostRoute((InetAddress)addr, (InetAddress)bestRoute.getGateway()));
        return this.modifyRoute(lp.getInterfaceName(), lp, bestRoute, 0, doAdd, toDefaultTable);
    }

    private boolean modifyRoute(String ifaceName, LinkProperties lp, RouteInfo r, int cycleCount, boolean doAdd, boolean toDefaultTable) {
        RouteInfo bestRoute;
        if (ifaceName == null || lp == null || r == null) {
            return false;
        }
        if (cycleCount > 10) {
            this.loge("Error modifying route - too much recursion");
            return false;
        }
        if (!r.isHostRoute() && (bestRoute = RouteInfo.selectBestRoute((Collection)lp.getRoutes(), (InetAddress)r.getGateway())) != null) {
            bestRoute = bestRoute.getGateway().equals(r.getGateway()) ? RouteInfo.makeHostRoute((InetAddress)r.getGateway()) : RouteInfo.makeHostRoute((InetAddress)r.getGateway(), (InetAddress)bestRoute.getGateway());
            this.modifyRoute(ifaceName, lp, bestRoute, cycleCount + 1, doAdd, toDefaultTable);
        }
        if (doAdd) {
            try {
                if (toDefaultTable) {
                    this.mAddedRoutes.add(r);
                    this.mNetd.addRoute(ifaceName, r);
                }
                this.mNetd.addSecondaryRoute(ifaceName, r);
            }
            catch (Exception e) {
                return false;
            }
        } else if (toDefaultTable) {
            this.mAddedRoutes.remove(r);
            if (!this.mAddedRoutes.contains(r)) {
                try {
                    this.mNetd.removeRoute(ifaceName, r);
                }
                catch (Exception e) {
                    return false;
                }
            }
        } else {
            try {
                this.mNetd.removeSecondaryRoute(ifaceName, r);
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    public boolean getMobileDataEnabled() {
        this.enforceAccessPermission();
        boolean retVal = Settings.Secure.getInt((ContentResolver)this.mContext.getContentResolver(), (String)"mobile_data", (int)1) == 1;
        return retVal;
    }

    public void setDataDependency(int networkType, boolean met) {
        this.enforceConnectivityInternalPermission();
        this.mHandler.sendMessage(this.mHandler.obtainMessage(110, met ? 1 : 0, networkType));
    }

    private void handleSetDependencyMet(int networkType, boolean met) {
        if (this.mNetTrackers[networkType] != null) {
            this.log("handleSetDependencyMet(" + networkType + ", " + met + ")");
            this.mNetTrackers[networkType].setDependencyMet(met);
        }
    }

    public void setMobileDataEnabled(boolean enabled) {
        this.enforceChangePermission();
        this.log("setMobileDataEnabled(" + enabled + ")");
        this.mHandler.sendMessage(this.mHandler.obtainMessage(107, enabled ? 1 : 0, 0));
    }

    private void handleSetMobileData(boolean enabled) {
        if (this.mNetTrackers[0] != null) {
            this.mNetTrackers[0].setUserDataEnable(enabled);
        }
    }

    public void setPolicyDataEnable(int networkType, boolean enabled) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_NETWORK_POLICY", TAG);
        this.mHandler.sendMessage(this.mHandler.obtainMessage(113, networkType, enabled ? 1 : 0));
    }

    private void handleSetPolicyDataEnable(int networkType, boolean enabled) {
        NetworkStateTracker tracker;
        if (ConnectivityManager.isNetworkTypeValid((int)networkType) && (tracker = this.mNetTrackers[networkType]) != null) {
            tracker.setPolicyDataEnable(enabled);
        }
    }

    private void enforceAccessPermission() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.ACCESS_NETWORK_STATE", TAG);
    }

    private void enforceChangePermission() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CHANGE_NETWORK_STATE", TAG);
    }

    private void enforceTetherChangePermission() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CHANGE_NETWORK_STATE", TAG);
    }

    private void enforceTetherAccessPermission() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.ACCESS_NETWORK_STATE", TAG);
    }

    private void enforceConnectivityInternalPermission() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
    }

    private void handleDisconnect(NetworkInfo info) {
        String oldIface;
        int prevNetType = info.getType();
        this.mNetTrackers[prevNetType].setTeardownRequested(false);
        if (!this.mNetConfigs[prevNetType].isDefault()) {
            List pids = this.mNetRequestersPids[prevNetType];
            for (int i = 0; i < pids.size(); ++i) {
                Integer pid = (Integer)pids.get(i);
                this.reassessPidDns(pid, false);
            }
        }
        Intent intent = new Intent("android.net.conn.CONNECTIVITY_CHANGE");
        intent.putExtra("networkInfo", (Parcelable)info);
        if (info.isFailover()) {
            intent.putExtra("isFailover", true);
            info.setFailover(false);
        }
        if (info.getReason() != null) {
            intent.putExtra("reason", info.getReason());
        }
        if (info.getExtraInfo() != null) {
            intent.putExtra("extraInfo", info.getExtraInfo());
        }
        if (this.mNetConfigs[prevNetType].isDefault()) {
            this.tryFailover(prevNetType);
            if (this.mActiveDefaultNetwork != -1) {
                NetworkInfo switchTo = this.mNetTrackers[this.mActiveDefaultNetwork].getNetworkInfo();
                intent.putExtra("otherNetwork", (Parcelable)switchTo);
            } else {
                this.mDefaultInetConditionPublished = 0;
                intent.putExtra("noConnectivity", true);
            }
        }
        intent.putExtra("inetCondition", this.mDefaultInetConditionPublished);
        boolean doReset = true;
        LinkProperties linkProperties = this.mNetTrackers[prevNetType].getLinkProperties();
        if (linkProperties != null && !TextUtils.isEmpty((CharSequence)(oldIface = linkProperties.getInterfaceName()))) {
            for (NetworkStateTracker networkStateTracker : this.mNetTrackers) {
                LinkProperties l;
                NetworkInfo networkInfo;
                if (networkStateTracker == null || !(networkInfo = networkStateTracker.getNetworkInfo()).isConnected() || networkInfo.getType() == prevNetType || (l = networkStateTracker.getLinkProperties()) == null || !oldIface.equals(l.getInterfaceName())) continue;
                doReset = false;
                break;
            }
        }
        this.handleConnectivityChange(prevNetType, doReset);
        Intent immediateIntent = new Intent(intent);
        immediateIntent.setAction("android.net.conn.CONNECTIVITY_CHANGE_IMMEDIATE");
        this.sendStickyBroadcast(immediateIntent);
        this.sendStickyBroadcastDelayed(intent, this.getConnectivityChangeDelay());
        if (this.mActiveDefaultNetwork != -1) {
            this.sendConnectedBroadcastDelayed(this.mNetTrackers[this.mActiveDefaultNetwork].getNetworkInfo(), this.getConnectivityChangeDelay());
        }
    }

    private void tryFailover(int prevNetType) {
        if (this.mNetConfigs[prevNetType].isDefault()) {
            if (this.mActiveDefaultNetwork == prevNetType) {
                this.mActiveDefaultNetwork = -1;
            }
            for (int checkType = 0; checkType <= 13; ++checkType) {
                if (checkType == prevNetType || this.mNetConfigs[checkType] == null || !this.mNetConfigs[checkType].isDefault() || this.mNetTrackers[checkType] == null) continue;
                NetworkStateTracker checkTracker = this.mNetTrackers[checkType];
                NetworkInfo checkInfo = checkTracker.getNetworkInfo();
                if (!checkInfo.isConnectedOrConnecting() || checkTracker.isTeardownRequested()) {
                    checkInfo.setFailover(true);
                    checkTracker.reconnect();
                }
                this.log("Attempting to switch to " + checkInfo.getTypeName());
            }
        }
    }

    private void sendConnectedBroadcast(NetworkInfo info) {
        this.sendGeneralBroadcast(info, "android.net.conn.CONNECTIVITY_CHANGE_IMMEDIATE");
        this.sendGeneralBroadcast(info, "android.net.conn.CONNECTIVITY_CHANGE");
    }

    private void sendConnectedBroadcastDelayed(NetworkInfo info, int delayMs) {
        this.sendGeneralBroadcast(info, "android.net.conn.CONNECTIVITY_CHANGE_IMMEDIATE");
        this.sendGeneralBroadcastDelayed(info, "android.net.conn.CONNECTIVITY_CHANGE", delayMs);
    }

    private void sendInetConditionBroadcast(NetworkInfo info) {
        this.sendGeneralBroadcast(info, "android.net.conn.INET_CONDITION_ACTION");
    }

    private Intent makeGeneralIntent(NetworkInfo info, String bcastType) {
        Intent intent = new Intent(bcastType);
        intent.putExtra("networkInfo", (Parcelable)info);
        if (info.isFailover()) {
            intent.putExtra("isFailover", true);
            info.setFailover(false);
        }
        if (info.getReason() != null) {
            intent.putExtra("reason", info.getReason());
        }
        if (info.getExtraInfo() != null) {
            intent.putExtra("extraInfo", info.getExtraInfo());
        }
        intent.putExtra("inetCondition", this.mDefaultInetConditionPublished);
        return intent;
    }

    private void sendGeneralBroadcast(NetworkInfo info, String bcastType) {
        this.sendStickyBroadcast(this.makeGeneralIntent(info, bcastType));
    }

    private void sendGeneralBroadcastDelayed(NetworkInfo info, String bcastType, int delayMs) {
        this.sendStickyBroadcastDelayed(this.makeGeneralIntent(info, bcastType), delayMs);
    }

    private void handleConnectionFailure(NetworkInfo info) {
        this.mNetTrackers[info.getType()].setTeardownRequested(false);
        String reason = info.getReason();
        String extraInfo = info.getExtraInfo();
        String reasonText = reason == null ? "." : " (" + reason + ").";
        this.loge("Attempt to connect to " + info.getTypeName() + " failed" + reasonText);
        Intent intent = new Intent("android.net.conn.CONNECTIVITY_CHANGE");
        intent.putExtra("networkInfo", (Parcelable)info);
        if (this.getActiveNetworkInfo() == null) {
            intent.putExtra("noConnectivity", true);
        }
        if (reason != null) {
            intent.putExtra("reason", reason);
        }
        if (extraInfo != null) {
            intent.putExtra("extraInfo", extraInfo);
        }
        if (info.isFailover()) {
            intent.putExtra("isFailover", true);
            info.setFailover(false);
        }
        if (this.mNetConfigs[info.getType()].isDefault()) {
            this.tryFailover(info.getType());
            if (this.mActiveDefaultNetwork != -1) {
                NetworkInfo switchTo = this.mNetTrackers[this.mActiveDefaultNetwork].getNetworkInfo();
                intent.putExtra("otherNetwork", (Parcelable)switchTo);
            } else {
                this.mDefaultInetConditionPublished = 0;
                intent.putExtra("noConnectivity", true);
            }
        }
        intent.putExtra("inetCondition", this.mDefaultInetConditionPublished);
        Intent immediateIntent = new Intent(intent);
        immediateIntent.setAction("android.net.conn.CONNECTIVITY_CHANGE_IMMEDIATE");
        this.sendStickyBroadcast(immediateIntent);
        this.sendStickyBroadcast(intent);
        if (this.mActiveDefaultNetwork != -1) {
            this.sendConnectedBroadcast(this.mNetTrackers[this.mActiveDefaultNetwork].getNetworkInfo());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendStickyBroadcast(Intent intent) {
        ConnectivityService connectivityService = this;
        synchronized (connectivityService) {
            if (!this.mSystemReady) {
                this.mInitialBroadcast = new Intent(intent);
            }
            intent.addFlags(0x10000000);
            this.mContext.sendStickyBroadcast(intent);
        }
    }

    private void sendStickyBroadcastDelayed(Intent intent, int delayMs) {
        if (delayMs <= 0) {
            this.sendStickyBroadcast(intent);
        } else {
            this.mHandler.sendMessageDelayed(this.mHandler.obtainMessage(112, (Object)intent), (long)delayMs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void systemReady() {
        ConnectivityService connectivityService = this;
        synchronized (connectivityService) {
            this.mSystemReady = true;
            if (this.mInitialBroadcast != null) {
                this.mContext.sendStickyBroadcast(this.mInitialBroadcast);
                this.mInitialBroadcast = null;
            }
        }
        this.mHandler.sendMessage(this.mHandler.obtainMessage(109));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleConnect(NetworkInfo info) {
        int type = info.getType();
        boolean isFailover = info.isFailover();
        NetworkStateTracker thisNet = this.mNetTrackers[type];
        if (this.mNetConfigs[type].isDefault()) {
            ConnectivityService otherNet;
            if (this.mActiveDefaultNetwork != -1 && this.mActiveDefaultNetwork != type) {
                if (type != this.mNetworkPreference && this.mNetConfigs[this.mActiveDefaultNetwork].priority > this.mNetConfigs[type].priority || this.mNetworkPreference == this.mActiveDefaultNetwork) {
                    this.teardown(thisNet);
                    return;
                }
                otherNet = this.mNetTrackers[this.mActiveDefaultNetwork];
                this.log("Policy requires " + otherNet.getNetworkInfo().getTypeName() + " teardown");
                if (!this.teardown((NetworkStateTracker)otherNet)) {
                    this.loge("Network declined teardown request");
                    this.teardown(thisNet);
                    return;
                }
            }
            otherNet = this;
            synchronized (otherNet) {
                if (this.mNetTransitionWakeLock.isHeld()) {
                    this.mHandler.sendMessageDelayed(this.mHandler.obtainMessage(108, this.mNetTransitionWakeLockSerialNumber, 0), 1000L);
                }
            }
            this.mActiveDefaultNetwork = type;
            this.mDefaultInetConditionPublished = 0;
            ++this.mDefaultConnectionSequence;
            this.mInetConditionChangeInFlight = false;
        }
        thisNet.setTeardownRequested(false);
        this.updateNetworkSettings(thisNet);
        this.handleConnectivityChange(type, false);
        this.sendConnectedBroadcastDelayed(info, this.getConnectivityChangeDelay());
        String iface = thisNet.getLinkProperties().getInterfaceName();
        if (iface != null) {
            try {
                BatteryStatsService.getService().noteNetworkInterfaceType(iface, type);
            }
            catch (RemoteException e) {
                // empty catch block
            }
        }
    }

    private void handleConnectivityChange(int netType, boolean doReset) {
        String iface;
        LinkProperties linkProperties;
        int resetMask = doReset ? 3 : 0;
        this.handleDnsConfigurationChange(netType);
        LinkProperties curLp = this.mCurrentLinkProperties[netType];
        LinkProperties newLp = null;
        if (this.mNetTrackers[netType].getNetworkInfo().isConnected()) {
            newLp = this.mNetTrackers[netType].getLinkProperties();
            if (curLp != null) {
                if (curLp.isIdenticalInterfaceName(newLp)) {
                    LinkProperties.CompareResult car = curLp.compareAddresses(newLp);
                    if (car.removed.size() != 0 || car.added.size() != 0) {
                        for (LinkAddress linkAddr : car.removed) {
                            if (linkAddr.getAddress() instanceof Inet4Address) {
                                resetMask |= 1;
                            }
                            if (!(linkAddr.getAddress() instanceof Inet6Address)) continue;
                            resetMask |= 2;
                        }
                        this.log("handleConnectivityChange: addresses changed linkProperty[" + netType + "]:" + " resetMask=" + resetMask + "\n   car=" + car);
                    } else {
                        this.log("handleConnectivityChange: address are the same reset per doReset linkProperty[" + netType + "]:" + " resetMask=" + resetMask);
                    }
                } else {
                    resetMask = 3;
                    this.log("handleConnectivityChange: interface not not equivalent reset both linkProperty[" + netType + "]:" + " resetMask=" + resetMask);
                }
            }
            if (this.mNetConfigs[netType].isDefault()) {
                this.handleApplyDefaultProxy(newLp.getHttpProxy());
            }
        }
        this.mCurrentLinkProperties[netType] = newLp;
        boolean resetDns = this.updateRoutes(newLp, curLp, this.mNetConfigs[netType].isDefault());
        if ((resetMask != 0 || resetDns) && (linkProperties = this.mNetTrackers[netType].getLinkProperties()) != null && !TextUtils.isEmpty((CharSequence)(iface = linkProperties.getInterfaceName()))) {
            if (resetMask != 0) {
                this.log("resetConnections(" + iface + ", " + resetMask + ")");
                NetworkUtils.resetConnections((String)iface, (int)resetMask);
                if ((resetMask & 1) != 0) {
                    this.mVpn.interfaceStatusChanged(iface, false);
                }
            }
            if (resetDns) {
                try {
                    this.mNetd.flushInterfaceDnsCache(iface);
                }
                catch (Exception e) {
                    this.loge("Exception resetting dns cache: " + e);
                }
            }
        }
        if (TextUtils.equals((CharSequence)this.mNetTrackers[netType].getNetworkInfo().getReason(), (CharSequence)"linkPropertiesChanged") && this.isTetheringSupported()) {
            this.mTethering.handleTetherIfaceChange();
        }
    }

    private boolean updateRoutes(LinkProperties newLp, LinkProperties curLp, boolean isLinkDefault) {
        boolean routesChanged;
        block14: {
            LinkProperties.CompareResult dnsDiff;
            block15: {
                Object routesToAdd = null;
                dnsDiff = new LinkProperties.CompareResult();
                LinkProperties.CompareResult routeDiff = new LinkProperties.CompareResult();
                if (curLp != null) {
                    routeDiff = curLp.compareRoutes(newLp);
                    dnsDiff = curLp.compareDnses(newLp);
                } else if (newLp != null) {
                    routeDiff.added = newLp.getRoutes();
                    dnsDiff.added = newLp.getDnses();
                }
                routesChanged = routeDiff.removed.size() != 0 || routeDiff.added.size() != 0;
                for (RouteInfo r : routeDiff.removed) {
                    if (isLinkDefault || !r.isDefaultRoute()) {
                        this.removeRoute(curLp, r, true);
                    }
                    if (isLinkDefault) continue;
                    this.removeRoute(curLp, r, false);
                }
                for (RouteInfo r : routeDiff.added) {
                    if (isLinkDefault || !r.isDefaultRoute()) {
                        this.addRoute(newLp, r, true);
                        continue;
                    }
                    this.addRoute(newLp, r, false);
                    String ifaceName = newLp.getInterfaceName();
                    if (TextUtils.isEmpty((CharSequence)ifaceName) || this.mAddedRoutes.contains(r)) continue;
                    try {
                        this.mNetd.removeRoute(ifaceName, r);
                    }
                    catch (Exception e) {}
                }
                if (isLinkDefault) break block14;
                if (!routesChanged) break block15;
                if (curLp != null) {
                    for (InetAddress oldDns : curLp.getDnses()) {
                        this.removeRouteToAddress(curLp, oldDns);
                    }
                }
                if (newLp == null) break block14;
                for (InetAddress newDns : newLp.getDnses()) {
                    this.addRouteToAddress(newLp, newDns);
                }
                break block14;
            }
            for (InetAddress oldDns : dnsDiff.removed) {
                this.removeRouteToAddress(curLp, oldDns);
            }
            for (InetAddress newDns : dnsDiff.added) {
                this.addRouteToAddress(newLp, newDns);
            }
        }
        return routesChanged;
    }

    public void updateNetworkSettings(NetworkStateTracker nt) {
        String key = nt.getTcpBufferSizesPropName();
        String bufferSizes = SystemProperties.get((String)key);
        if (bufferSizes.length() == 0) {
            key = "net.tcp.buffersize.default";
            bufferSizes = SystemProperties.get((String)key);
        }
        if (bufferSizes.length() != 0) {
            this.setBufferSize(bufferSizes);
        }
    }

    private void setBufferSize(String bufferSizes) {
        try {
            String[] values = bufferSizes.split(",");
            if (values.length == 6) {
                String prefix = "/sys/kernel/ipv4/tcp_";
                FileUtils.stringToFile((String)"/sys/kernel/ipv4/tcp_rmem_min", (String)values[0]);
                FileUtils.stringToFile((String)"/sys/kernel/ipv4/tcp_rmem_def", (String)values[1]);
                FileUtils.stringToFile((String)"/sys/kernel/ipv4/tcp_rmem_max", (String)values[2]);
                FileUtils.stringToFile((String)"/sys/kernel/ipv4/tcp_wmem_min", (String)values[3]);
                FileUtils.stringToFile((String)"/sys/kernel/ipv4/tcp_wmem_def", (String)values[4]);
                FileUtils.stringToFile((String)"/sys/kernel/ipv4/tcp_wmem_max", (String)values[5]);
            } else {
                this.loge("Invalid buffersize string: " + bufferSizes);
            }
        }
        catch (IOException e) {
            this.loge("Can't set tcp buffer sizes:" + e);
        }
    }

    private void reassessPidDns(int myPid, boolean doBump) {
        for (int i : this.mPriorityList) {
            LinkProperties p;
            NetworkStateTracker nt;
            if (this.mNetConfigs[i].isDefault() || !(nt = this.mNetTrackers[i]).getNetworkInfo().isConnected() || nt.isTeardownRequested() || (p = nt.getLinkProperties()) == null) continue;
            List pids = this.mNetRequestersPids[i];
            for (int j = 0; j < pids.size(); ++j) {
                Integer pid = (Integer)pids.get(j);
                if (pid != myPid) continue;
                Collection dnses = p.getDnses();
                this.writePidDns(dnses, myPid);
                if (doBump) {
                    this.bumpDns();
                }
                return;
            }
        }
        int i = 1;
        while (true) {
            String prop;
            if (SystemProperties.get((String)(prop = "net.dns" + i + "." + myPid)).length() == 0) {
                if (doBump) {
                    this.bumpDns();
                }
                return;
            }
            SystemProperties.set((String)prop, (String)"");
            ++i;
        }
    }

    private boolean writePidDns(Collection<InetAddress> dnses, int pid) {
        int j = 1;
        boolean changed = false;
        for (InetAddress dns : dnses) {
            String dnsString = dns.getHostAddress();
            if (!changed && dnsString.equals(SystemProperties.get((String)("net.dns" + j + "." + pid)))) continue;
            changed = true;
            SystemProperties.set((String)("net.dns" + j++ + "." + pid), (String)dns.getHostAddress());
        }
        return changed;
    }

    private void bumpDns() {
        String propVal = SystemProperties.get((String)"net.dnschange");
        int n = 0;
        if (propVal.length() != 0) {
            try {
                n = Integer.parseInt(propVal);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        SystemProperties.set((String)"net.dnschange", (String)("" + (n + 1)));
        Intent intent = new Intent("android.intent.action.CLEAR_DNS_CACHE");
        intent.addFlags(0x20000000);
        intent.addFlags(0x10000000);
        this.mContext.sendBroadcast(intent);
    }

    private boolean updateDns(String network, String iface, Collection<InetAddress> dnses, String domains) {
        boolean changed = false;
        int last = 0;
        if (dnses.size() == 0 && this.mDefaultDns != null) {
            ++last;
            String value = this.mDefaultDns.getHostAddress();
            if (!value.equals(SystemProperties.get((String)"net.dns1"))) {
                this.loge("no dns provided for " + network + " - using " + value);
                changed = true;
                SystemProperties.set((String)"net.dns1", (String)value);
            }
        } else {
            for (InetAddress dns : dnses) {
                String key = "net.dns" + ++last;
                String value = dns.getHostAddress();
                if (!changed && value.equals(SystemProperties.get((String)key))) continue;
                changed = true;
                SystemProperties.set((String)key, (String)value);
            }
        }
        for (int i = last + 1; i <= this.mNumDnsEntries; ++i) {
            String key = "net.dns" + i;
            changed = true;
            SystemProperties.set((String)key, (String)"");
        }
        this.mNumDnsEntries = last;
        if (changed) {
            try {
                this.mNetd.setDnsServersForInterface(iface, NetworkUtils.makeStrings(dnses));
                this.mNetd.setDefaultInterfaceForDns(iface);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (!domains.equals(SystemProperties.get((String)"net.dns.search"))) {
            SystemProperties.set((String)"net.dns.search", (String)domains);
            changed = true;
        }
        return changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleDnsConfigurationChange(int netType) {
        NetworkStateTracker nt = this.mNetTrackers[netType];
        if (nt != null && nt.getNetworkInfo().isConnected() && !nt.isTeardownRequested()) {
            LinkProperties p = nt.getLinkProperties();
            if (p == null) {
                return;
            }
            Collection dnses = p.getDnses();
            boolean changed = false;
            if (this.mNetConfigs[netType].isDefault()) {
                String network = nt.getNetworkInfo().getTypeName();
                Object object = this.mDnsLock;
                synchronized (object) {
                    if (!this.mDnsOverridden) {
                        changed = this.updateDns(network, p.getInterfaceName(), dnses, "");
                    }
                }
            }
            try {
                this.mNetd.setDnsServersForInterface(p.getInterfaceName(), NetworkUtils.makeStrings((Collection)dnses));
            }
            catch (Exception e) {
                // empty catch block
            }
            List pids = this.mNetRequestersPids[netType];
            for (int y = 0; y < pids.size(); ++y) {
                Integer pid = (Integer)pids.get(y);
                changed = this.writePidDns(dnses, pid);
            }
            if (changed) {
                this.bumpDns();
            }
        }
    }

    private int getRestoreDefaultNetworkDelay(int networkType) {
        String restoreDefaultNetworkDelayStr = SystemProperties.get((String)NETWORK_RESTORE_DELAY_PROP_NAME);
        if (restoreDefaultNetworkDelayStr != null && restoreDefaultNetworkDelayStr.length() != 0) {
            try {
                return Integer.valueOf(restoreDefaultNetworkDelayStr);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        int ret = 60000;
        if (networkType <= 13 && this.mNetConfigs[networkType] != null) {
            ret = this.mNetConfigs[networkType].restoreTime;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.DUMP") != 0) {
            pw.println("Permission Denial: can't dump ConnectivityService from from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid());
            return;
        }
        pw.println();
        for (NetworkStateTracker nst : this.mNetTrackers) {
            if (nst == null) continue;
            if (nst.getNetworkInfo().isConnected()) {
                pw.println("Active network: " + nst.getNetworkInfo().getTypeName());
            }
            pw.println(nst.getNetworkInfo());
            pw.println(nst);
            pw.println();
        }
        pw.println("Network Requester Pids:");
        for (int net : this.mPriorityList) {
            String pidString = net + ": ";
            for (Object pid : this.mNetRequestersPids[net]) {
                pidString = pidString + pid.toString() + ", ";
            }
            pw.println(pidString);
        }
        pw.println();
        pw.println("FeatureUsers:");
        for (FeatureUser requester : this.mFeatureUsers) {
            pw.println(((Object)requester).toString());
        }
        pw.println();
        ConnectivityService connectivityService = this;
        synchronized (connectivityService) {
            pw.println("NetworkTranstionWakeLock is currently " + (this.mNetTransitionWakeLock.isHeld() ? "" : "not ") + "held.");
            pw.println("It was last requested for " + this.mNetTransitionWakeLockCausedBy);
        }
        pw.println();
        this.mTethering.dump(fd, pw, args);
        if (this.mInetLog != null) {
            void var4_9;
            pw.println();
            pw.println("Inet condition reports:");
            boolean bl = false;
            while (var4_9 < this.mInetLog.size()) {
                pw.println(this.mInetLog.get((int)var4_9));
                ++var4_9;
            }
        }
    }

    public int tether(String iface) {
        this.enforceTetherChangePermission();
        if (this.isTetheringSupported()) {
            return this.mTethering.tether(iface);
        }
        return 3;
    }

    public int untether(String iface) {
        this.enforceTetherChangePermission();
        if (this.isTetheringSupported()) {
            return this.mTethering.untether(iface);
        }
        return 3;
    }

    public int getLastTetherError(String iface) {
        this.enforceTetherAccessPermission();
        if (this.isTetheringSupported()) {
            return this.mTethering.getLastTetherError(iface);
        }
        return 3;
    }

    public String[] getTetherableUsbRegexs() {
        this.enforceTetherAccessPermission();
        if (this.isTetheringSupported()) {
            return this.mTethering.getTetherableUsbRegexs();
        }
        return new String[0];
    }

    public String[] getTetherableWifiRegexs() {
        this.enforceTetherAccessPermission();
        if (this.isTetheringSupported()) {
            return this.mTethering.getTetherableWifiRegexs();
        }
        return new String[0];
    }

    public String[] getTetherableBluetoothRegexs() {
        this.enforceTetherAccessPermission();
        if (this.isTetheringSupported()) {
            return this.mTethering.getTetherableBluetoothRegexs();
        }
        return new String[0];
    }

    public int setUsbTethering(boolean enable) {
        this.enforceTetherAccessPermission();
        if (this.isTetheringSupported()) {
            return this.mTethering.setUsbTethering(enable);
        }
        return 3;
    }

    public String[] getTetherableIfaces() {
        this.enforceTetherAccessPermission();
        return this.mTethering.getTetherableIfaces();
    }

    public String[] getTetheredIfaces() {
        this.enforceTetherAccessPermission();
        return this.mTethering.getTetheredIfaces();
    }

    public String[] getTetheredIfacePairs() {
        this.enforceTetherAccessPermission();
        return this.mTethering.getTetheredIfacePairs();
    }

    public String[] getTetheringErroredIfaces() {
        this.enforceTetherAccessPermission();
        return this.mTethering.getErroredIfaces();
    }

    public boolean isTetheringSupported() {
        this.enforceTetherAccessPermission();
        int defaultVal = SystemProperties.get((String)"ro.tether.denied").equals("true") ? 0 : 1;
        boolean tetherEnabledInSettings = Settings.Secure.getInt((ContentResolver)this.mContext.getContentResolver(), (String)"tether_supported", (int)defaultVal) != 0;
        return tetherEnabledInSettings && this.mTetheringConfigValid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestNetworkTransitionWakelock(String forWhom) {
        this.enforceConnectivityInternalPermission();
        ConnectivityService connectivityService = this;
        synchronized (connectivityService) {
            if (this.mNetTransitionWakeLock.isHeld()) {
                return;
            }
            ++this.mNetTransitionWakeLockSerialNumber;
            this.mNetTransitionWakeLock.acquire();
            this.mNetTransitionWakeLockCausedBy = forWhom;
        }
        this.mHandler.sendMessageDelayed(this.mHandler.obtainMessage(108, this.mNetTransitionWakeLockSerialNumber, 0), (long)this.mNetTransitionWakeLockTimeout);
    }

    public void reportInetCondition(int networkType, int percentage) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.STATUS_BAR", TAG);
        int pid = ConnectivityService.getCallingPid();
        int uid = ConnectivityService.getCallingUid();
        String s = pid + "(" + uid + ") reports inet is " + (percentage > 50 ? "connected" : "disconnected") + " (" + percentage + ") on " + "network Type " + networkType + " at " + GregorianCalendar.getInstance().getTime();
        this.mInetLog.add(s);
        while (this.mInetLog.size() > 15) {
            this.mInetLog.remove(0);
        }
        this.mHandler.sendMessage(this.mHandler.obtainMessage(104, networkType, percentage));
    }

    private void handleInetConditionChange(int netType, int condition) {
        if (this.mActiveDefaultNetwork == -1) {
            this.log("handleInetConditionChange: no active default network - ignore");
            return;
        }
        if (this.mActiveDefaultNetwork != netType) {
            this.log("handleInetConditionChange: net=" + netType + " != default=" + this.mActiveDefaultNetwork + " - ignore");
            return;
        }
        this.mDefaultInetCondition = condition;
        if (!this.mInetConditionChangeInFlight) {
            int delay = this.mDefaultInetCondition > 50 ? Settings.Secure.getInt((ContentResolver)this.mContext.getContentResolver(), (String)"inet_condition_debounce_up_delay", (int)500) : Settings.Secure.getInt((ContentResolver)this.mContext.getContentResolver(), (String)"inet_condition_debounce_down_delay", (int)3000);
            this.mInetConditionChangeInFlight = true;
            this.mHandler.sendMessageDelayed(this.mHandler.obtainMessage(105, this.mActiveDefaultNetwork, this.mDefaultConnectionSequence), (long)delay);
        }
    }

    private void handleInetConditionHoldEnd(int netType, int sequence) {
        this.log("handleInetConditionHoldEnd: net=" + netType + ", condition=" + this.mDefaultInetCondition + ", published condition=" + this.mDefaultInetConditionPublished);
        this.mInetConditionChangeInFlight = false;
        if (this.mActiveDefaultNetwork == -1) {
            this.log("handleInetConditionHoldEnd: no active default network - ignoring");
            return;
        }
        if (this.mDefaultConnectionSequence != sequence) {
            this.log("handleInetConditionHoldEnd: event hold for obsolete network - ignoring");
            return;
        }
        NetworkInfo networkInfo = this.mNetTrackers[this.mActiveDefaultNetwork].getNetworkInfo();
        if (!networkInfo.isConnected()) {
            this.log("handleInetConditionHoldEnd: default network not connected - ignoring");
            return;
        }
        this.mDefaultInetConditionPublished = this.mDefaultInetCondition;
        this.sendInetConditionBroadcast(networkInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProxyProperties getProxy() {
        Object object = this.mDefaultProxyLock;
        synchronized (object) {
            return this.mDefaultProxyDisabled ? null : this.mDefaultProxy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGlobalProxy(ProxyProperties proxyProperties) {
        this.enforceChangePermission();
        Object object = this.mGlobalProxyLock;
        synchronized (object) {
            if (proxyProperties == this.mGlobalProxy) {
                return;
            }
            if (proxyProperties != null && proxyProperties.equals((Object)this.mGlobalProxy)) {
                return;
            }
            if (this.mGlobalProxy != null && this.mGlobalProxy.equals((Object)proxyProperties)) {
                return;
            }
            String host = "";
            int port = 0;
            String exclList = "";
            if (proxyProperties != null && !TextUtils.isEmpty((CharSequence)proxyProperties.getHost())) {
                this.mGlobalProxy = new ProxyProperties(proxyProperties);
                host = this.mGlobalProxy.getHost();
                port = this.mGlobalProxy.getPort();
                exclList = this.mGlobalProxy.getExclusionList();
            } else {
                this.mGlobalProxy = null;
            }
            ContentResolver res = this.mContext.getContentResolver();
            Settings.Secure.putString((ContentResolver)res, (String)"global_http_proxy_host", (String)host);
            Settings.Secure.putInt((ContentResolver)res, (String)"global_http_proxy_port", (int)port);
            Settings.Secure.putString((ContentResolver)res, (String)"global_http_proxy_exclusion_list", (String)exclList);
        }
        if (this.mGlobalProxy == null) {
            proxyProperties = this.mDefaultProxy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadGlobalProxy() {
        ContentResolver res = this.mContext.getContentResolver();
        String host = Settings.Secure.getString((ContentResolver)res, (String)"global_http_proxy_host");
        int port = Settings.Secure.getInt((ContentResolver)res, (String)"global_http_proxy_port", (int)0);
        String exclList = Settings.Secure.getString((ContentResolver)res, (String)"global_http_proxy_exclusion_list");
        if (!TextUtils.isEmpty((CharSequence)host)) {
            ProxyProperties proxyProperties = new ProxyProperties(host, port, exclList);
            Object object = this.mGlobalProxyLock;
            synchronized (object) {
                this.mGlobalProxy = proxyProperties;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProxyProperties getGlobalProxy() {
        Object object = this.mGlobalProxyLock;
        synchronized (object) {
            return this.mGlobalProxy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleApplyDefaultProxy(ProxyProperties proxy) {
        if (proxy != null && TextUtils.isEmpty((CharSequence)proxy.getHost())) {
            proxy = null;
        }
        Object object = this.mDefaultProxyLock;
        synchronized (object) {
            if (this.mDefaultProxy != null && this.mDefaultProxy.equals((Object)proxy)) {
                return;
            }
            if (this.mDefaultProxy == proxy) {
                return;
            }
            this.mDefaultProxy = proxy;
            if (!this.mDefaultProxyDisabled) {
                this.sendProxyBroadcast(proxy);
            }
        }
    }

    private void handleDeprecatedGlobalHttpProxy() {
        String proxy = Settings.Secure.getString((ContentResolver)this.mContext.getContentResolver(), (String)"http_proxy");
        if (!TextUtils.isEmpty((CharSequence)proxy)) {
            String[] data = proxy.split(":");
            String proxyHost = data[0];
            int proxyPort = 8080;
            if (data.length > 1) {
                try {
                    proxyPort = Integer.parseInt(data[1]);
                }
                catch (NumberFormatException e) {
                    return;
                }
            }
            ProxyProperties p = new ProxyProperties(data[0], proxyPort, "");
            this.setGlobalProxy(p);
        }
    }

    private void sendProxyBroadcast(ProxyProperties proxy) {
        if (proxy == null) {
            proxy = new ProxyProperties("", 0, "");
        }
        this.log("sending Proxy Broadcast for " + proxy);
        Intent intent = new Intent("android.intent.action.PROXY_CHANGE");
        intent.addFlags(0x30000000);
        intent.putExtra("proxy", (Parcelable)proxy);
        this.mContext.sendStickyBroadcast(intent);
    }

    private void log(String s) {
        Slog.d((String)TAG, (String)s);
    }

    private void loge(String s) {
        Slog.e((String)TAG, (String)s);
    }

    int convertFeatureToNetworkType(int networkType, String feature) {
        int usedNetworkType = networkType;
        if (networkType == 0) {
            if (TextUtils.equals((CharSequence)feature, (CharSequence)"enableMMS")) {
                usedNetworkType = 2;
            } else if (TextUtils.equals((CharSequence)feature, (CharSequence)"enableSUPL")) {
                usedNetworkType = 3;
            } else if (TextUtils.equals((CharSequence)feature, (CharSequence)"enableDUN") || TextUtils.equals((CharSequence)feature, (CharSequence)"enableDUNAlways")) {
                usedNetworkType = 4;
            } else if (TextUtils.equals((CharSequence)feature, (CharSequence)"enableHIPRI")) {
                usedNetworkType = 5;
            } else if (TextUtils.equals((CharSequence)feature, (CharSequence)"enableFOTA")) {
                usedNetworkType = 10;
            } else if (TextUtils.equals((CharSequence)feature, (CharSequence)"enableIMS")) {
                usedNetworkType = 11;
            } else if (TextUtils.equals((CharSequence)feature, (CharSequence)"enableCBS")) {
                usedNetworkType = 12;
            } else {
                Slog.e((String)TAG, (String)"Can't match any mobile netTracker!");
            }
        } else if (networkType == 1) {
            if (TextUtils.equals((CharSequence)feature, (CharSequence)"p2p")) {
                usedNetworkType = 13;
            } else {
                Slog.e((String)TAG, (String)"Can't match any wifi netTracker!");
            }
        } else {
            Slog.e((String)TAG, (String)"Unexpected network type");
        }
        return usedNetworkType;
    }

    private static <T> T checkNotNull(T value, String message) {
        if (value == null) {
            throw new NullPointerException(message);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public boolean protectVpn(ParcelFileDescriptor socket) {
        block10: {
            block9: {
                int type = this.mActiveDefaultNetwork;
                if (!ConnectivityManager.isNetworkTypeValid((int)type)) break block9;
                this.mVpn.protect(socket, this.mNetTrackers[type].getLinkProperties().getInterfaceName());
                boolean bl = true;
                Object var5_5 = null;
                try {
                    socket.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
                return bl;
            }
            Object var5_6 = null;
            try {
                socket.close();
            }
            catch (Exception e) {}
            break block10;
            {
                catch (Exception exception) {
                    Object var5_7 = null;
                    try {
                        socket.close();
                    }
                    catch (Exception e) {}
                }
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                try {
                    socket.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return false;
    }

    public boolean prepareVpn(String oldPackage, String newPackage) {
        return this.mVpn.prepare(oldPackage, newPackage);
    }

    public ParcelFileDescriptor establishVpn(VpnConfig config) {
        return this.mVpn.establish(config);
    }

    public void startLegacyVpn(VpnConfig config, String[] racoon, String[] mtpd) {
        this.mVpn.startLegacyVpn(config, racoon, mtpd);
    }

    public LegacyVpnInfo getLegacyVpnInfo() {
        return this.mVpn.getLegacyVpnInfo();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class VpnCallback {
        private VpnCallback() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void override(List<String> dnsServers, List<String> searchDomains) {
            if (dnsServers == null) {
                this.restore();
                return;
            }
            ArrayList<InetAddress> addresses = new ArrayList<InetAddress>();
            for (String address : dnsServers) {
                try {
                    addresses.add(InetAddress.parseNumericAddress((String)address));
                }
                catch (Exception e) {}
            }
            if (addresses.isEmpty()) {
                this.restore();
                return;
            }
            StringBuilder buffer = new StringBuilder();
            if (searchDomains != null) {
                for (String domain : searchDomains) {
                    buffer.append(domain).append(' ');
                }
            }
            String domains = buffer.toString().trim();
            boolean changed = false;
            Object object = ConnectivityService.this.mDnsLock;
            synchronized (object) {
                changed = ConnectivityService.this.updateDns("VPN", "VPN", addresses, domains);
                ConnectivityService.this.mDnsOverridden = true;
            }
            if (changed) {
                ConnectivityService.this.bumpDns();
            }
            object = ConnectivityService.this.mDefaultProxyLock;
            synchronized (object) {
                ConnectivityService.this.mDefaultProxyDisabled = true;
                if (ConnectivityService.this.mDefaultProxy != null) {
                    ConnectivityService.this.sendProxyBroadcast(null);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void restore() {
            Object object = ConnectivityService.this.mDnsLock;
            synchronized (object) {
                if (ConnectivityService.this.mDnsOverridden) {
                    ConnectivityService.this.mDnsOverridden = false;
                    ConnectivityService.this.mHandler.sendEmptyMessage(111);
                }
            }
            object = ConnectivityService.this.mDefaultProxyLock;
            synchronized (object) {
                ConnectivityService.this.mDefaultProxyDisabled = false;
                if (ConnectivityService.this.mDefaultProxy != null) {
                    ConnectivityService.this.sendProxyBroadcast(ConnectivityService.this.mDefaultProxy);
                }
            }
        }
    }

    private static class SettingsObserver
    extends ContentObserver {
        private int mWhat;
        private Handler mHandler;

        SettingsObserver(Handler handler, int what) {
            super(handler);
            this.mHandler = handler;
            this.mWhat = what;
        }

        void observe(Context context) {
            ContentResolver resolver = context.getContentResolver();
            resolver.registerContentObserver(Settings.Secure.getUriFor((String)"http_proxy"), false, (ContentObserver)this);
        }

        public void onChange(boolean selfChange) {
            this.mHandler.obtainMessage(this.mWhat).sendToTarget();
        }
    }

    private class MyHandler
    extends Handler {
        public MyHandler(Looper looper) {
            super(looper);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    NetworkInfo info = (NetworkInfo)msg.obj;
                    int type = info.getType();
                    NetworkInfo.State state = info.getState();
                    if (state == NetworkInfo.State.CONNECTED || state == NetworkInfo.State.DISCONNECTED) {
                        ConnectivityService.this.log("ConnectivityChange for " + info.getTypeName() + ": " + state + "/" + info.getDetailedState());
                    }
                    int eventLogParam = info.getType() & 7 | (info.getDetailedState().ordinal() & 0x3F) << 3 | info.getSubtype() << 9;
                    EventLog.writeEvent((int)50020, (int)eventLogParam);
                    if (info.getDetailedState() == NetworkInfo.DetailedState.FAILED) {
                        ConnectivityService.this.handleConnectionFailure(info);
                        break;
                    }
                    if (state == NetworkInfo.State.DISCONNECTED) {
                        ConnectivityService.this.handleDisconnect(info);
                        break;
                    }
                    if (state == NetworkInfo.State.SUSPENDED) {
                        ConnectivityService.this.handleDisconnect(info);
                        break;
                    }
                    if (state != NetworkInfo.State.CONNECTED) break;
                    ConnectivityService.this.handleConnect(info);
                    break;
                }
                case 3: {
                    NetworkInfo info = (NetworkInfo)msg.obj;
                    ConnectivityService.this.handleConnectivityChange(info.getType(), false);
                    break;
                }
                case 108: {
                    String causedBy = null;
                    ConnectivityService connectivityService = ConnectivityService.this;
                    synchronized (connectivityService) {
                        if (msg.arg1 == ConnectivityService.this.mNetTransitionWakeLockSerialNumber && ConnectivityService.this.mNetTransitionWakeLock.isHeld()) {
                            ConnectivityService.this.mNetTransitionWakeLock.release();
                            causedBy = ConnectivityService.this.mNetTransitionWakeLockCausedBy;
                        }
                    }
                    if (causedBy == null) break;
                    ConnectivityService.this.log("NetTransition Wakelock for " + causedBy + " released by timeout");
                    break;
                }
                case 101: {
                    FeatureUser u = (FeatureUser)msg.obj;
                    u.expire();
                    break;
                }
                case 104: {
                    int netType = msg.arg1;
                    int condition = msg.arg2;
                    ConnectivityService.this.handleInetConditionChange(netType, condition);
                    break;
                }
                case 105: {
                    int netType = msg.arg1;
                    int sequence = msg.arg2;
                    ConnectivityService.this.handleInetConditionHoldEnd(netType, sequence);
                    break;
                }
                case 103: {
                    int preference = msg.arg1;
                    ConnectivityService.this.handleSetNetworkPreference(preference);
                    break;
                }
                case 107: {
                    boolean enabled = msg.arg1 == 1;
                    ConnectivityService.this.handleSetMobileData(enabled);
                    break;
                }
                case 109: {
                    ConnectivityService.this.handleDeprecatedGlobalHttpProxy();
                    break;
                }
                case 110: {
                    boolean met = msg.arg1 == 1;
                    ConnectivityService.this.handleSetDependencyMet(msg.arg2, met);
                    break;
                }
                case 111: {
                    if (ConnectivityService.this.mActiveDefaultNetwork == -1) break;
                    ConnectivityService.this.handleDnsConfigurationChange(ConnectivityService.this.mActiveDefaultNetwork);
                    break;
                }
                case 112: {
                    Intent intent = (Intent)msg.obj;
                    ConnectivityService.this.sendStickyBroadcast(intent);
                    break;
                }
                case 113: {
                    int networkType = msg.arg1;
                    boolean enabled = msg.arg2 == 1;
                    ConnectivityService.this.handleSetPolicyDataEnable(networkType, enabled);
                }
            }
        }
    }

    private class FeatureUser
    implements IBinder.DeathRecipient {
        int mNetworkType;
        String mFeature;
        IBinder mBinder;
        int mPid;
        int mUid;
        long mCreateTime;

        FeatureUser(int type, String feature, IBinder binder) {
            this.mNetworkType = type;
            this.mFeature = feature;
            this.mBinder = binder;
            this.mPid = Binder.getCallingPid();
            this.mUid = Binder.getCallingUid();
            this.mCreateTime = System.currentTimeMillis();
            try {
                this.mBinder.linkToDeath((IBinder.DeathRecipient)this, 0);
            }
            catch (RemoteException e) {
                this.binderDied();
            }
        }

        void unlinkDeathRecipient() {
            this.mBinder.unlinkToDeath((IBinder.DeathRecipient)this, 0);
        }

        public void binderDied() {
            ConnectivityService.this.log("ConnectivityService FeatureUser binderDied(" + this.mNetworkType + ", " + this.mFeature + ", " + this.mBinder + "), created " + (System.currentTimeMillis() - this.mCreateTime) + " mSec ago");
            ConnectivityService.this.stopUsingNetworkFeature(this, false);
        }

        public void expire() {
            ConnectivityService.this.stopUsingNetworkFeature(this, false);
        }

        public boolean isSameUser(FeatureUser u) {
            if (u == null) {
                return false;
            }
            return this.isSameUser(u.mPid, u.mUid, u.mNetworkType, u.mFeature);
        }

        public boolean isSameUser(int pid, int uid, int networkType, String feature) {
            return this.mPid == pid && this.mUid == uid && this.mNetworkType == networkType && TextUtils.equals((CharSequence)this.mFeature, (CharSequence)feature);
        }

        public String toString() {
            return "FeatureUser(" + this.mNetworkType + "," + this.mFeature + "," + this.mPid + "," + this.mUid + "), created " + (System.currentTimeMillis() - this.mCreateTime) + " mSec ago";
        }
    }

    private static class RadioAttributes {
        public int mSimultaneity;
        public int mType;

        public RadioAttributes(String init) {
            String[] fragments = init.split(",");
            this.mType = Integer.parseInt(fragments[0]);
            this.mSimultaneity = Integer.parseInt(fragments[1]);
        }
    }
}

