/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.content.Context;
import android.location.Country;
import android.location.CountryListener;
import android.location.ICountryDetector;
import android.location.ICountryListener;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Process;
import android.os.RemoteException;
import android.util.Slog;
import com.android.server.location.ComprehensiveCountryDetector;
import java.util.HashMap;

public class CountryDetectorService
extends ICountryDetector.Stub
implements Runnable {
    private static final String TAG = "CountryDetectorService";
    private final HashMap<IBinder, Receiver> mReceivers = new HashMap();
    private final Context mContext;
    private ComprehensiveCountryDetector mCountryDetector;
    private boolean mSystemReady;
    private Handler mHandler;
    private CountryListener mLocationBasedDetectorListener;

    public CountryDetectorService(Context context) {
        this.mContext = context;
    }

    public Country detectCountry() throws RemoteException {
        if (!this.mSystemReady) {
            throw new RemoteException();
        }
        return this.mCountryDetector.detectCountry();
    }

    public void addCountryListener(ICountryListener listener) throws RemoteException {
        if (!this.mSystemReady) {
            throw new RemoteException();
        }
        this.addListener(listener);
    }

    public void removeCountryListener(ICountryListener listener) throws RemoteException {
        if (!this.mSystemReady) {
            throw new RemoteException();
        }
        this.removeListener(listener.asBinder());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addListener(ICountryListener listener) {
        HashMap<IBinder, Receiver> hashMap = this.mReceivers;
        synchronized (hashMap) {
            Receiver r = new Receiver(listener);
            try {
                listener.asBinder().linkToDeath((IBinder.DeathRecipient)r, 0);
                this.mReceivers.put(listener.asBinder(), r);
                if (this.mReceivers.size() == 1) {
                    Slog.d((String)TAG, (String)"The first listener is added");
                    this.setCountryListener(this.mLocationBasedDetectorListener);
                }
            }
            catch (RemoteException e) {
                Slog.e((String)TAG, (String)"linkToDeath failed:", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeListener(IBinder key) {
        HashMap<IBinder, Receiver> hashMap = this.mReceivers;
        synchronized (hashMap) {
            this.mReceivers.remove(key);
            if (this.mReceivers.isEmpty()) {
                this.setCountryListener(null);
                Slog.d((String)TAG, (String)"No listener is left");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyReceivers(Country country) {
        HashMap<IBinder, Receiver> hashMap = this.mReceivers;
        synchronized (hashMap) {
            for (Receiver receiver : this.mReceivers.values()) {
                try {
                    receiver.getListener().onCountryDetected(country);
                }
                catch (RemoteException e) {
                    Slog.e((String)TAG, (String)"notifyReceivers failed:", (Throwable)e);
                }
            }
        }
    }

    void systemReady() {
        Thread thread = new Thread((Runnable)this, TAG);
        thread.start();
    }

    private void initialize() {
        this.mCountryDetector = new ComprehensiveCountryDetector(this.mContext);
        this.mLocationBasedDetectorListener = new CountryListener(){

            public void onCountryDetected(final Country country) {
                CountryDetectorService.this.mHandler.post(new Runnable(){

                    public void run() {
                        CountryDetectorService.this.notifyReceivers(country);
                    }
                });
            }
        };
    }

    public void run() {
        Process.setThreadPriority((int)10);
        Looper.prepare();
        this.mHandler = new Handler();
        this.initialize();
        this.mSystemReady = true;
        Looper.loop();
    }

    protected void setCountryListener(final CountryListener listener) {
        this.mHandler.post(new Runnable(){

            public void run() {
                CountryDetectorService.this.mCountryDetector.setCountryListener(listener);
            }
        });
    }

    boolean isSystemReady() {
        return this.mSystemReady;
    }

    private final class Receiver
    implements IBinder.DeathRecipient {
        private final ICountryListener mListener;
        private final IBinder mKey;

        public Receiver(ICountryListener listener) {
            this.mListener = listener;
            this.mKey = listener.asBinder();
        }

        public void binderDied() {
            CountryDetectorService.this.removeListener(this.mKey);
        }

        public boolean equals(Object otherObj) {
            if (otherObj instanceof Receiver) {
                return this.mKey.equals(((Receiver)otherObj).mKey);
            }
            return false;
        }

        public int hashCode() {
            return this.mKey.hashCode();
        }

        public ICountryListener getListener() {
            return this.mListener;
        }
    }
}

